unit HashAlg_U;
// Description: Hash Algorithm Wrapper Base Class
// By Sarah Dean
// Email: sdean12@mailcity.com
// WWW:   http://www.fortunecity.com/skyscraper/true/882/
//
// -----------------------------------------------------------------------------
// Version history:
// 0.9.0 beta - ??th ????? 1999
//              Initial release


interface

uses
  Classes;

  // xxx - get rid of this
  const MAX_STRING_LEN = 1000;

type
//  THashArray = array [0..19] of byte;
  THashArray = array [0..39] of byte;

type
  THashAlg = class(TComponent)
  private
    { Private declarations }
  protected
    fDigestSize: integer;
  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy(); override;

    function  HashString(theString: string): THashArray; virtual; abstract;
    function  HashFile(filename: string; var digest: THashArray): boolean; virtual; abstract;

    function  HashToDisplay(theHash: THashArray): string; virtual;

    procedure ClearHash(var theHash: THashArray);
  published
    property DigestSize: integer read fDigestSize;
  end;


implementation

uses SysUtils; // needed for inttohex

constructor THashAlg.Create(AOwner: TComponent);
begin
  inherited;
  fDigestSize := 0;

end;

destructor THashAlg.Destroy();
begin
  inherited;

end;

function THashAlg.HashToDisplay(theHash: THashArray): string;
var
  i: integer;
  retVal: string;
begin
  retVal := '';
  for i:=0 to ((DigestSize div 8)-1) do
    begin
    retVal := retVal + inttohex(theHash[i], 2);
    end;

  Result := retVal;

end;

procedure THashAlg.ClearHash(var theHash: THashArray);
var
  i: integer;
begin
  for i:=0 to (sizeof(theHash)-1) do
    begin
    theHash[i] := 0;
    end;

end;

END.

