unit IteratorTestApp_U;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  SDUFileIterator_U, SDUDirIterator_U, ComCtrls;

type
  TIteratorTestApp_F = class(TForm)
    edStartDir: TEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    pbCreateDirIterator: TButton;
    pbDirIterator: TButton;
    pbFileIterator: TButton;
    pbCreateFileIterator: TButton;
    ckReverseFormat: TCheckBox;
    cbIncludeSubDirs: TCheckBox;
    pbClear: TButton;
    pbExit: TButton;
    pbBrowse: TButton;
    pbCount: TButton;
    SDUDirIterator1: TSDUDirIterator;
    SDUFileIterator1: TSDUFileIterator;
    RichEdit1: TRichEdit;
    procedure pbCreateDirIteratorClick(Sender: TObject);
    procedure pbDirIteratorClick(Sender: TObject);
    procedure pbCreateFileIteratorClick(Sender: TObject);
    procedure pbFileIteratorClick(Sender: TObject);
    procedure pbExitClick(Sender: TObject);
    procedure pbBrowseClick(Sender: TObject);
    procedure pbClearClick(Sender: TObject);
    procedure pbCountClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  IteratorTestApp_F: TIteratorTestApp_F;

implementation

{$R *.DFM}

uses FileCtrl;

procedure TIteratorTestApp_F.pbCreateDirIteratorClick(Sender: TObject);
begin
  SDUdiriterator1.Directory := edStartDir.text;
  SDUdiriterator1.ReverseFormat := ckReverseFormat.checked;
  SDUdiriterator1.Reset();

end;

procedure TIteratorTestApp_F.pbDirIteratorClick(Sender: TObject);
begin
  RichEdit1.lines.add(SDUdiriterator1.next());

end;

procedure TIteratorTestApp_F.pbCreateFileIteratorClick(Sender: TObject);
begin
  SDUfileiterator1.Directory := edStartDir.text;
  SDUfileiterator1.IncludeSubDirs := cbIncludeSubDirs.checked;
  SDUfileiterator1.Reset();

end;

procedure TIteratorTestApp_F.pbFileIteratorClick(Sender: TObject);
begin
  RichEdit1.lines.add(SDUfileiterator1.next());

end;

procedure TIteratorTestApp_F.pbExitClick(Sender: TObject);
begin
  Close();

end;

procedure TIteratorTestApp_F.pbBrowseClick(Sender: TObject);
var
  dir: string;
begin
  if SelectDirectory('Select starting directory', '', dir) then
    begin
    edStartDir.text := dir;
    end;

end;

procedure TIteratorTestApp_F.pbClearClick(Sender: TObject);
begin
  RichEdit1.lines.clear();

end;

procedure TIteratorTestApp_F.pbCountClick(Sender: TObject);
begin
  RichEdit1.lines.add(inttostr(SDUfileiterator1.Count()));

end;

END.

