unit Unit4;

interface


uses
Windows, Messages, SysUtils, Classes, Controls, Dialogs,
StdCtrls, ExtCtrls, shellapi, ComCtrls;



procedure Reboot();

implementation


function SetPrivilege(sPrivilegeName : string; bEnabled : boolean ): boolean;
var
  TPPrev,
  TP         : TTokenPrivileges;
  Token      : THandle;
  dwRetLen   : DWord;
begin
  Result := False;

  OpenProcessToken(
    GetCurrentProcess,
    TOKEN_ADJUST_PRIVILEGES
    or TOKEN_QUERY,
    Token );

  TP.PrivilegeCount := 1;
  if( LookupPrivilegeValue(
        Nil,
        PChar( sPrivilegeName ),
        TP.Privileges[ 0 ].LUID ) )then
  begin
    if( bEnabled )then
    begin
      TP.Privileges[ 0 ].Attributes  :=
        SE_PRIVILEGE_ENABLED;
    end else
    begin
      TP.Privileges[ 0 ].Attributes  :=
        0;
    end;

    dwRetLen := 0;
    Result := AdjustTokenPrivileges(
                Token,
                False,
                TP,
                SizeOf( TPPrev ),
                TPPrev,
                dwRetLen );
  end;

  CloseHandle( Token );
end;

//
//iFlags:
//
//  one of the following must be
//  specified
//
//   EWX_LOGOFF
//   EWX_REBOOT
//   EWX_SHUTDOWN
//
//  following attributes may be
//  combined with above flags
//
//   EWX_POWEROFF
//   EWX_FORCE    : terminate processes
//
function WinExit( iFlags : integer ) : boolean;
begin
  Result := True;
  if( SetPrivilege( 'SeShutdownPrivilege', True ) )then
  begin

    if( not ExitWindowsEx( iFlags, 0 ) )then
    begin
      // handle errors...
      Result := False;
    end;
    SetPrivilege( 'SeShutdownPrivilege', False )
  end else
  begin
    // handle errors...
    Result := False;
    end;
    end;

procedure Reboot();
begin
WinExit(EWX_Reboot);
end;

end.
 