﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pca-connector-ad/PcaConnectorAdRequest.h>
#include <aws/pca-connector-ad/PcaConnectorAd_EXPORTS.h>

#include <utility>

namespace Aws {
namespace PcaConnectorAd {
namespace Model {

/**
 */
class CreateServicePrincipalNameRequest : public PcaConnectorAdRequest {
 public:
  AWS_PCACONNECTORAD_API CreateServicePrincipalNameRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateServicePrincipalName"; }

  AWS_PCACONNECTORAD_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>Idempotency token.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  CreateServicePrincipalNameRequest& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) that was returned when you called <a
   * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>
   */
  inline const Aws::String& GetConnectorArn() const { return m_connectorArn; }
  inline bool ConnectorArnHasBeenSet() const { return m_connectorArnHasBeenSet; }
  template <typename ConnectorArnT = Aws::String>
  void SetConnectorArn(ConnectorArnT&& value) {
    m_connectorArnHasBeenSet = true;
    m_connectorArn = std::forward<ConnectorArnT>(value);
  }
  template <typename ConnectorArnT = Aws::String>
  CreateServicePrincipalNameRequest& WithConnectorArn(ConnectorArnT&& value) {
    SetConnectorArn(std::forward<ConnectorArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that was returned when you called <a
   * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>
   */
  inline const Aws::String& GetDirectoryRegistrationArn() const { return m_directoryRegistrationArn; }
  inline bool DirectoryRegistrationArnHasBeenSet() const { return m_directoryRegistrationArnHasBeenSet; }
  template <typename DirectoryRegistrationArnT = Aws::String>
  void SetDirectoryRegistrationArn(DirectoryRegistrationArnT&& value) {
    m_directoryRegistrationArnHasBeenSet = true;
    m_directoryRegistrationArn = std::forward<DirectoryRegistrationArnT>(value);
  }
  template <typename DirectoryRegistrationArnT = Aws::String>
  CreateServicePrincipalNameRequest& WithDirectoryRegistrationArn(DirectoryRegistrationArnT&& value) {
    SetDirectoryRegistrationArn(std::forward<DirectoryRegistrationArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clientToken{Aws::Utils::UUID::PseudoRandomUUID()};
  bool m_clientTokenHasBeenSet = true;

  Aws::String m_connectorArn;
  bool m_connectorArnHasBeenSet = false;

  Aws::String m_directoryRegistrationArn;
  bool m_directoryRegistrationArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace PcaConnectorAd
}  // namespace Aws
