/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.CSSVal;
import io.sf.carte.echosvg.css.engine.value.ColorFunction;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueModificationHandler;
import org.w3c.css.om.typed.CSSColorValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGICCColor;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public class CSSOMSVGColor
implements CSSVal,
CSSColorValue,
SVGICCColor,
SVGNumberList {
    protected ValueProvider valueProvider;
    protected ValueModificationHandler handler;

    public CSSOMSVGColor(ValueProvider vp) {
        this.valueProvider = vp;
    }

    public void setModificationHandler(ValueModificationHandler h) {
        this.handler = h;
    }

    public String getCssText() {
        return this.valueProvider.getValue().getCssText();
    }

    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "");
    }

    public String toString() {
        return this.getCssText();
    }

    public CSSValue.CssType getCssValueType() {
        return CSSValue.CssType.TYPED;
    }

    public CSSValue.Type getPrimitiveType() {
        return this.valueProvider.getValue().getPrimitiveType();
    }

    @Override
    public float getFloatValue() {
        return this.valueProvider.getValue().getFloatValue();
    }

    @Override
    public int getLength() {
        return this.valueProvider.getValue().getLength();
    }

    @Override
    public Value item(int index) {
        this.valueProvider.getValue().setModificationHandler(this.handler);
        return this.valueProvider.getValue().item(index);
    }

    @Override
    public String getIdentifierValue() throws DOMException {
        return this.valueProvider.getValue().getIdentifierValue();
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.valueProvider.getValue().getStringValue();
    }

    @Override
    public String getURIValue() throws DOMException {
        return this.valueProvider.getValue().getURIValue();
    }

    @Override
    public Value clone() {
        return this.valueProvider.getValue().clone();
    }

    public short getColorType() {
        Value value = this.valueProvider.getValue();
        switch (value.getCssValueType()) {
            case TYPED: {
                switch (value.getPrimitiveType()) {
                    case IDENT: {
                        if ("currentcolor".equalsIgnoreCase(value.getIdentifierValue())) {
                            return 3;
                        }
                        return 1;
                    }
                    case COLOR: {
                        ColorValue color = value.getColorValue();
                        switch (color.getCSSColorSpace()) {
                            case "rgb": {
                                return 1;
                            }
                        }
                        throw new IllegalStateException("Found unexpected color type:" + color.getCSSColorSpace());
                    }
                }
                throw new IllegalStateException("Found unexpected PrimitiveType:" + value.getPrimitiveType());
            }
            case LIST: {
                return 2;
            }
        }
        throw new IllegalStateException("Found unexpected CssValueType:" + value.getCssValueType());
    }

    public RGBColor getRGBColor() {
        throw new DOMException(9, "Legacy value API not supported.");
    }

    public ColorValue getCSSColorValue() {
        this.valueProvider.getValue().setModificationHandler(this.handler);
        return this.valueProvider.getValue().getColorValue();
    }

    public String getCSSColorSpace() {
        return this.getCSSColorValue().getCSSColorSpace();
    }

    public NumericValue getAlpha() {
        return this.getCSSColorValue().getAlpha();
    }

    public void setAlpha(double alpha) {
        this.getCSSColorValue().setAlpha(alpha);
    }

    public NumericValue getR() {
        return this.getRGBColorValue().getR();
    }

    RGBColorValue getRGBColorValue() {
        ColorValue color = this.getCSSColorValue();
        if ("rgb".equals(color.getCSSColorSpace())) {
            return (RGBColorValue)color;
        }
        throw new DOMException(15, "Not an RGB color.");
    }

    public NumericValue getG() {
        return this.getRGBColorValue().getG();
    }

    public NumericValue getB() {
        return this.getRGBColorValue().getB();
    }

    public void setRGBColor(String color) {
        throw new DOMException(7, "");
    }

    public SVGICCColor getICCColor() {
        return this;
    }

    public void setRGBColorICCColor(String rgb, String icc) {
        throw new DOMException(7, "");
    }

    public void setColor(short type, String rgb, String icc) {
        throw new DOMException(7, "");
    }

    public String getColorProfile() {
        return this.getCSSColorValue().getCSSColorSpace();
    }

    public void setColorProfile(String colorProfile) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumberList getColors() {
        return this;
    }

    public int getNumberOfItems() {
        ColorValue value = this.getCSSColorValue();
        if (!(value instanceof ColorFunction)) {
            throw new DOMException(15, "");
        }
        return ((ColorFunction)value).getChannels().getLength();
    }

    public void clear() throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber initialize(SVGNumber newItem) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber getItem(int index) throws DOMException {
        if (this.getColorType() != 2) {
            throw new DOMException(1, "");
        }
        int n = this.getNumberOfItems();
        if (index < 0 || index >= n) {
            throw new DOMException(1, "");
        }
        ColorValue value = this.getCSSColorValue();
        if (!(value instanceof ColorFunction)) {
            throw new DOMException(15, "");
        }
        float f = ((NumericValue)((ColorFunction)value).getChannels().item(index)).getFloatValue();
        ColorNumber result = new ColorNumber(f);
        return result;
    }

    public SVGNumber insertItemBefore(SVGNumber newItem, int index) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber replaceItem(SVGNumber newItem, int index) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber removeItem(int index) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber appendItem(SVGNumber newItem) throws DOMException {
        throw new DOMException(7, "");
    }

    public static interface ValueProvider {
        public Value getValue();
    }

    protected class ColorNumber
    implements SVGNumber {
        protected float value;

        public ColorNumber(float f) {
            this.value = f;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float f) {
            throw new DOMException(7, "");
        }
    }
}

