/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Arrays;
import java.util.List;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.AbstractConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.utils.StringUtil;

public class CibaConfig
extends AbstractConfig {
    public static final String CIBA_POLL_MODE = "poll";
    public static final String CIBA_PING_MODE = "ping";
    public static final String CIBA_PUSH_MODE = "push";
    public static final List<String> CIBA_SUPPORTED_MODES = Arrays.asList("poll", "ping");
    public static final String CIBA_BACKCHANNEL_TOKEN_DELIVERY_MODE = "cibaBackchannelTokenDeliveryMode";
    public static final String CIBA_EXPIRES_IN = "cibaExpiresIn";
    public static final String CIBA_INTERVAL = "cibaInterval";
    public static final String CIBA_AUTH_REQUESTED_USER_HINT = "cibaAuthRequestedUserHint";
    public static final String DEFAULT_CIBA_POLICY_TOKEN_DELIVERY_MODE = "poll";
    public static final int DEFAULT_CIBA_POLICY_EXPIRES_IN = 120;
    public static final int DEFAULT_CIBA_POLICY_INTERVAL = 5;
    public static final String DEFAULT_CIBA_POLICY_AUTH_REQUESTED_USER_HINT = "login_hint";
    private String backchannelTokenDeliveryMode;
    private int expiresIn;
    private int poolingInterval;
    private String authRequestedUserHint;
    public static final String OIDC_CIBA_GRANT_ENABLED = "oidc.ciba.grant.enabled";
    public static final String CIBA_BACKCHANNEL_TOKEN_DELIVERY_MODE_PER_CLIENT = "ciba.backchannel.token.delivery.mode";
    public static final String CIBA_BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT = "ciba.backchannel.client.notification.endpoint";
    public static final String CIBA_BACKCHANNEL_AUTH_REQUEST_SIGNING_ALG = "ciba.backchannel.auth.request.signing.alg";

    public CibaConfig(RealmModel realm) {
        this.backchannelTokenDeliveryMode = realm.getAttribute(CIBA_BACKCHANNEL_TOKEN_DELIVERY_MODE);
        if (this.backchannelTokenDeliveryMode == null) {
            this.backchannelTokenDeliveryMode = "poll";
        }
        this.expiresIn = realm.getAttribute(CIBA_EXPIRES_IN, 120);
        this.poolingInterval = realm.getAttribute(CIBA_INTERVAL, 5);
        this.authRequestedUserHint = realm.getAttribute(CIBA_AUTH_REQUESTED_USER_HINT);
        if (this.authRequestedUserHint == null) {
            this.authRequestedUserHint = DEFAULT_CIBA_POLICY_AUTH_REQUESTED_USER_HINT;
        }
        this.realmForWrite = () -> realm;
    }

    public String getBackchannelTokenDeliveryMode(ClientModel client) {
        String mode = client.getAttribute(CIBA_BACKCHANNEL_TOKEN_DELIVERY_MODE_PER_CLIENT);
        if (StringUtil.isBlank(mode)) {
            mode = this.getBackchannelTokenDeliveryMode();
        }
        return mode;
    }

    public String getBackchannelTokenDeliveryMode() {
        return this.backchannelTokenDeliveryMode;
    }

    public void setBackchannelTokenDeliveryMode(String mode) {
        if (StringUtil.isBlank(mode)) {
            mode = "poll";
        }
        this.backchannelTokenDeliveryMode = mode;
        this.persistRealmAttribute(CIBA_BACKCHANNEL_TOKEN_DELIVERY_MODE, mode);
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        if (expiresIn == null) {
            this.setExpiresIn((Integer)null);
        } else {
            this.setExpiresIn(Integer.parseInt(expiresIn));
        }
    }

    public void setExpiresIn(Integer expiresIn) {
        if (expiresIn == null) {
            expiresIn = 120;
        }
        this.expiresIn = expiresIn;
        this.persistRealmAttribute(CIBA_EXPIRES_IN, expiresIn);
    }

    public int getPoolingInterval() {
        return this.poolingInterval;
    }

    public void setPoolingInterval(String poolingInterval) {
        if (poolingInterval == null) {
            this.setPoolingInterval((Integer)null);
        } else {
            this.setPoolingInterval(Integer.parseInt(poolingInterval));
        }
    }

    public void setPoolingInterval(Integer interval) {
        if (interval == null) {
            interval = 5;
        }
        this.poolingInterval = interval;
        this.persistRealmAttribute(CIBA_INTERVAL, interval);
    }

    public String getAuthRequestedUserHint() {
        return this.authRequestedUserHint;
    }

    public void setAuthRequestedUserHint(String hint) {
        if (hint == null) {
            hint = DEFAULT_CIBA_POLICY_AUTH_REQUESTED_USER_HINT;
        }
        this.authRequestedUserHint = hint;
        this.persistRealmAttribute(CIBA_AUTH_REQUESTED_USER_HINT, hint);
    }

    public boolean isOIDCCIBAGrantEnabled(ClientModel client) {
        String enabled = client.getAttribute(OIDC_CIBA_GRANT_ENABLED);
        return Boolean.parseBoolean(enabled);
    }

    public Algorithm getBackchannelAuthRequestSigningAlg(ClientModel client) {
        String alg = client.getAttribute(CIBA_BACKCHANNEL_AUTH_REQUEST_SIGNING_ALG);
        return alg == null ? null : Enum.valueOf(Algorithm.class, alg);
    }

    public String getBackchannelClientNotificationEndpoint(ClientModel client) {
        return client.getAttribute(CIBA_BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT);
    }
}

