/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import mediathek.config.Config;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.dns.DnsSelector;
import mediathek.tool.http.ByteCounter;
import mediathek.tool.http.OkHttpProxyAuthenticator;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVHttpClient {
    private static final MVHttpClient ourInstance = new MVHttpClient();
    private final Logger logger;
    private final ByteCounter byteCounter;
    private final DnsSelector dnsSelector;
    private OkHttpClient httpClient;
    private static final long NETWORK_TIMEOUT = 10L;

    private MVHttpClient() {
        block6: {
            this.logger = LogManager.getLogger(MVHttpClient.class);
            this.byteCounter = new ByteCounter();
            this.dnsSelector = new DnsSelector();
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPort = System.getProperty("http.proxyPort");
            try {
                if (proxyHost != null && proxyPort != null && !proxyHost.isEmpty() && !proxyPort.isEmpty()) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
                    this.setupProxyClients(proxy);
                    this.logger.info("MVHttpClient: Proxy configured from environment variables: ({})", (Object)proxyHost);
                    break block6;
                }
                try {
                    Configuration config = ApplicationConfiguration.getConfiguration();
                    proxyHost = config.getString("http.proxy.hostname");
                    proxyPort = config.getString("http.proxy.port");
                    if (!proxyHost.isEmpty() && !proxyPort.isEmpty()) {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
                        this.setupProxyClients(proxy);
                        this.logger.info("MVHttpClient: Proxy configured from application config: ({})", (Object)proxyHost);
                        break block6;
                    }
                    this.setupNonProxyClients();
                }
                catch (NoSuchElementException e) {
                    this.setupNonProxyClients();
                }
            }
            catch (NumberFormatException ex) {
                this.setupNonProxyClients();
                this.logger.error("PROXY config failed. Creating non proxy config", (Throwable)ex);
            }
        }
    }

    public static MVHttpClient getInstance() {
        return ourInstance;
    }

    private OkHttpClient.Builder getDefaultClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (Config.isHttpTrafficDebuggingEnabled()) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)this.logger).trace(arg_0));
            HttpLoggingInterceptor.Level level = HttpLoggingInterceptor.Level.BASIC;
            try {
                String levelName = ApplicationConfiguration.getConfiguration().getString("application.debug.http_traffic_trace_level");
                level = HttpLoggingInterceptor.Level.valueOf((String)levelName);
            }
            catch (Exception ignored) {
                this.logger.error("Error reading http traffic debug trace level, using BASIC");
            }
            interceptor.level(level);
            builder.addInterceptor((Interceptor)interceptor);
            builder.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS));
        }
        builder.connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).socketFactory(this.byteCounter.socketFactory()).followRedirects(true).followSslRedirects(true).dns((Dns)this.dnsSelector);
        return builder;
    }

    public ByteCounter getByteCounter() {
        return this.byteCounter;
    }

    private void setupProxyClients(Proxy proxy) {
        OkHttpProxyAuthenticator prxManager = new OkHttpProxyAuthenticator();
        Authenticator proxyAuthenticator = prxManager.getProxyAuthenticator();
        OkHttpClient.Builder tmpBuilder = this.getDefaultClientBuilder().proxy(proxy);
        if (proxyAuthenticator != null) {
            tmpBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.httpClient = tmpBuilder.build();
    }

    private void setupNonProxyClients() {
        this.httpClient = this.getDefaultClientBuilder().build();
        this.logger.info("MVHttpClient: Proxy not configured");
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }
}

