/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.expression;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.Knowledge;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.Token;
import net.sourceforge.plantuml.tim.expression.TokenIterator;
import net.sourceforge.plantuml.tim.expression.TokenOperator;
import net.sourceforge.plantuml.tim.expression.TokenStack;
import net.sourceforge.plantuml.tim.expression.TokenType;

public class ReversePolishInterpretor {
    private final TValue result;
    private final boolean trace = false;

    public ReversePolishInterpretor(StringLocated location, TokenStack queue, Knowledge knowledge, TMemory memory, TContext context) throws EaterException {
        HashMap<String, TValue> named = new HashMap<String, TValue>();
        ArrayDeque<TValue> stack = new ArrayDeque<TValue>();
        TokenIterator it = queue.tokenIterator();
        while (it.hasMoreTokens()) {
            TValue v1;
            Token token = it.nextToken();
            if (token.getTokenType() == TokenType.NUMBER) {
                stack.addFirst(TValue.fromNumber(token));
                continue;
            }
            if (token.getTokenType() == TokenType.QUOTED_STRING) {
                stack.addFirst(TValue.fromString(token));
                continue;
            }
            if (token.getTokenType() == TokenType.JSON_DATA) {
                stack.addFirst(TValue.fromJson(token.getJson()));
                continue;
            }
            if (token.getTokenType() == TokenType.AFFECTATION) {
                TValue v2 = (TValue)stack.removeFirst();
                v1 = (TValue)stack.removeFirst();
                named.put(v1.toString(), v2);
                continue;
            }
            if (token.getTokenType() == TokenType.OPERATOR) {
                TValue v2 = (TValue)stack.removeFirst();
                v1 = (TValue)stack.removeFirst();
                TokenOperator op = token.getTokenOperator();
                if (op == null) {
                    throw new EaterException("bad op", location);
                }
                TValue tmp = op.operate(v1, v2);
                stack.addFirst(tmp);
                continue;
            }
            if (token.getTokenType() == TokenType.OPEN_PAREN_FUNC) {
                int nb = Integer.parseInt(token.getSurface()) - named.size();
                Token token2 = it.nextToken();
                if (token2.getTokenType() != TokenType.FUNCTION_NAME) {
                    throw new EaterException("rpn43", location);
                }
                TFunction function = knowledge.getFunction(new TFunctionSignature(token2.getSurface(), nb));
                if (function == null) {
                    throw new EaterException("Unknown built-in function " + token2.getSurface(), location);
                }
                if (!function.canCover(nb, Collections.emptySet())) {
                    throw new EaterException("Bad number of arguments for " + function.getSignature().getFunctionName(), location);
                }
                ArrayList<TValue> args = new ArrayList<TValue>();
                for (int i = 0; i < nb; ++i) {
                    args.add(0, (TValue)stack.removeFirst());
                }
                if (location == null) {
                    throw new EaterException("rpn44", location);
                }
                TValue r = function.executeReturnFunction(context, memory, location, args, named);
                named.clear();
                stack.addFirst(r);
                continue;
            }
            throw new EaterException("rpn41", location);
        }
        this.result = (TValue)stack.removeFirst();
    }

    public final TValue getResult() {
        return this.result;
    }
}

