/* GAIL - The GNOME Accessibility Implementation Library
 * Copyright 2001 Sun Microsystems Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "gailcanvastextfactory.h"
#include "gailcanvastext.h"

static void
gail_canvas_text_factory_class_init (GailCanvasTextFactoryClass *klass);

static AtkObject *
gail_canvas_text_factory_create_accessible (GObject *obj);

static AtkObjectFactoryClass    *parent_class = NULL;

GType
gail_canvas_text_factory_get_type ()
{
  static GType type = 0;

  if (!type) 
  {
    static const GTypeInfo tinfo =
    {
      sizeof (GailCanvasTextFactoryClass),
      (GBaseInitFunc) NULL, /* base init */
      (GBaseFinalizeFunc) NULL, /* base finalize */
      (GClassInitFunc) gail_canvas_text_factory_class_init, /* class init */
      (GClassFinalizeFunc) NULL, /* class finalize */
      NULL, /* class data */
      sizeof (GailCanvasTextFactory), /* instance size */
      0, /* nb preallocs */
      (GInstanceInitFunc) NULL, /* instance init */
      NULL /* value table */
    };
    type = g_type_register_static (
                           ATK_TYPE_OBJECT_FACTORY, 
                           "GailCanvasTextFactory" , &tinfo, 0);
  }

  return type;
}

static void 
gail_canvas_text_factory_class_init (GailCanvasTextFactoryClass *klass)
{
  AtkObjectFactoryClass *class = ATK_OBJECT_FACTORY_CLASS (klass);

  parent_class = g_type_class_ref (ATK_TYPE_OBJECT_FACTORY);

  class->create_accessible = gail_canvas_text_factory_create_accessible;
}

AtkObjectFactory* 
gail_canvas_text_factory_new ()
{
  GObject *factory;

  factory = g_object_new (GAIL_TYPE_CANVAS_TEXT_FACTORY, NULL);

  return ATK_OBJECT_FACTORY (factory);
} 

static AtkObject* 
gail_canvas_text_factory_create_accessible (GObject   *obj)
{
  GnomeCanvasItem *text;

  g_return_val_if_fail (GNOME_IS_CANVAS_ITEM (obj), NULL);
  text = GNOME_CANVAS_ITEM (obj);
  return gail_canvas_text_new (text);
}
