/* gca-diagnostics.c generated by valac 0.20.1, the Vala compiler
 * generated from gca-diagnostics.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gedit/gedit-view.h>
#include <gtksourceview/gtksource.h>
#include <cairo.h>
#include <gedit/gedit-document.h>
#include <float.h>
#include <math.h>


#define GCA_TYPE_REMOTE_SERVICE (gca_remote_service_get_type ())
#define GCA_REMOTE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_SERVICE, GcaRemoteService))
#define GCA_IS_REMOTE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_SERVICE))
#define GCA_REMOTE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_TYPE_REMOTE_SERVICE, GcaRemoteServiceIface))

typedef struct _GcaRemoteService GcaRemoteService;
typedef struct _GcaRemoteServiceIface GcaRemoteServiceIface;

#define GCA_TYPE_REMOTE_SERVICES (gca_remote_services_get_type ())

#define GCA_TYPE_VIEW (gca_view_get_type ())
#define GCA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_VIEW, GcaView))
#define GCA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_VIEW, GcaViewClass))
#define GCA_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_VIEW))
#define GCA_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_VIEW))
#define GCA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_VIEW, GcaViewClass))

typedef struct _GcaView GcaView;
typedef struct _GcaViewClass GcaViewClass;

#define GCA_TYPE_REMOTE_DOCUMENT (gca_remote_document_get_type ())
#define GCA_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocument))
#define GCA_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))
#define GCA_IS_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_IS_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_REMOTE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))

typedef struct _GcaRemoteDocument GcaRemoteDocument;
typedef struct _GcaRemoteDocumentClass GcaRemoteDocumentClass;

#define GCA_TYPE_DIAGNOSTIC_SERVICE (gca_diagnostic_service_get_type ())
#define GCA_DIAGNOSTIC_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticService))
#define GCA_DIAGNOSTIC_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServiceClass))
#define GCA_IS_DIAGNOSTIC_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE))
#define GCA_IS_DIAGNOSTIC_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_SERVICE))
#define GCA_DIAGNOSTIC_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServiceClass))

typedef struct _GcaDiagnosticService GcaDiagnosticService;
typedef struct _GcaDiagnosticServiceClass GcaDiagnosticServiceClass;
typedef struct _GcaDiagnosticServicePrivate GcaDiagnosticServicePrivate;

#define GCA_TYPE_DIAGNOSTICS (gca_diagnostics_get_type ())
#define GCA_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTICS, GcaDiagnostics))
#define GCA_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTICS, GcaDiagnosticsClass))
#define GCA_IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTICS))
#define GCA_IS_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTICS))
#define GCA_DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTICS, GcaDiagnosticsClass))

typedef struct _GcaDiagnostics GcaDiagnostics;
typedef struct _GcaDiagnosticsClass GcaDiagnosticsClass;

#define GCA_DBUS_TYPE_DIAGNOSTICS (gca_dbus_diagnostics_get_type ())
#define GCA_DBUS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_DIAGNOSTICS, GcaDBusDiagnostics))
#define GCA_DBUS_IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_DIAGNOSTICS))
#define GCA_DBUS_DIAGNOSTICS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_DIAGNOSTICS, GcaDBusDiagnosticsIface))

typedef struct _GcaDBusDiagnostics GcaDBusDiagnostics;
typedef struct _GcaDBusDiagnosticsIface GcaDBusDiagnosticsIface;

#define GCA_DBUS_TYPE_DIAGNOSTICS_PROXY (gca_dbus_diagnostics_proxy_get_type ())

#define GCA_DBUS_TYPE_DIAGNOSTIC (gca_dbus_diagnostic_get_type ())

#define GCA_DBUS_TYPE_FIXIT (gca_dbus_fixit_get_type ())

#define GCA_DBUS_TYPE_SOURCE_RANGE (gca_dbus_source_range_get_type ())

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;
typedef struct _GcaDBusSourceRange GcaDBusSourceRange;
typedef struct _GcaDBusFixit GcaDBusFixit;
typedef struct _GcaDBusDiagnostic GcaDBusDiagnostic;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gca_remote_document_unref0(var) ((var == NULL) ? NULL : (var = (gca_remote_document_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;

#define GCA_TYPE_DIAGNOSTIC (gca_diagnostic_get_type ())
#define GCA_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnostic))
#define GCA_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))
#define GCA_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC))
#define GCA_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC))
#define GCA_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))

typedef struct _GcaDiagnostic GcaDiagnostic;
typedef struct _GcaDiagnosticClass GcaDiagnosticClass;
typedef struct _GcaDiagnosticsPrivate GcaDiagnosticsPrivate;

#define GCA_TYPE_SOURCE_INDEX (gca_source_index_get_type ())
#define GCA_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SOURCE_INDEX, GcaSourceIndex))
#define GCA_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_SOURCE_INDEX, GcaSourceIndexClass))
#define GCA_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SOURCE_INDEX))
#define GCA_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_SOURCE_INDEX))
#define GCA_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_SOURCE_INDEX, GcaSourceIndexClass))

typedef struct _GcaSourceIndex GcaSourceIndex;
typedef struct _GcaSourceIndexClass GcaSourceIndexClass;

#define GCA_TYPE_DIAGNOSTIC_TAGS (gca_diagnostic_tags_get_type ())
#define GCA_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_TAGS, GcaDiagnosticTags))
#define GCA_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_TAGS, GcaDiagnosticTagsClass))
#define GCA_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_TAGS))
#define GCA_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_TAGS))
#define GCA_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_TAGS, GcaDiagnosticTagsClass))

typedef struct _GcaDiagnosticTags GcaDiagnosticTags;
typedef struct _GcaDiagnosticTagsClass GcaDiagnosticTagsClass;

#define GCA_TYPE_DIAGNOSTIC_MESSAGE (gca_diagnostic_message_get_type ())
#define GCA_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_MESSAGE, GcaDiagnosticMessage))
#define GCA_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_MESSAGE, GcaDiagnosticMessageClass))
#define GCA_IS_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_MESSAGE))
#define GCA_IS_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_MESSAGE))
#define GCA_DIAGNOSTIC_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_MESSAGE, GcaDiagnosticMessageClass))

typedef struct _GcaDiagnosticMessage GcaDiagnosticMessage;
typedef struct _GcaDiagnosticMessageClass GcaDiagnosticMessageClass;

#define GCA_TYPE_DOCUMENT (gca_document_get_type ())
#define GCA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DOCUMENT, GcaDocument))
#define GCA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DOCUMENT, GcaDocumentClass))
#define GCA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DOCUMENT))
#define GCA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DOCUMENT))
#define GCA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DOCUMENT, GcaDocumentClass))

typedef struct _GcaDocument GcaDocument;
typedef struct _GcaDocumentClass GcaDocumentClass;

#define GCA_TYPE_SOURCE_RANGE_SUPPORT (gca_source_range_support_get_type ())
#define GCA_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupport))
#define GCA_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT))
#define GCA_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupportIface))

typedef struct _GcaSourceRangeSupport GcaSourceRangeSupport;
typedef struct _GcaSourceRangeSupportIface GcaSourceRangeSupportIface;

#define GCA_TYPE_SOURCE_RANGE (gca_source_range_get_type ())

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;
typedef struct _GcaSourceRange GcaSourceRange;

#define GCA_TYPE_SCROLLBAR_MARKER (gca_scrollbar_marker_get_type ())
#define GCA_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarker))
#define GCA_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))
#define GCA_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))

typedef struct _GcaScrollbarMarker GcaScrollbarMarker;
typedef struct _GcaScrollbarMarkerClass GcaScrollbarMarkerClass;
#define _gca_scrollbar_marker_unref0(var) ((var == NULL) ? NULL : (var = (gca_scrollbar_marker_unref (var), NULL)))

#define GCA_TYPE_DIAGNOSTIC_COLORS (gca_diagnostic_colors_get_type ())
#define GCA_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColors))
#define GCA_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColorsClass))
#define GCA_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_COLORS))
#define GCA_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_COLORS))
#define GCA_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColorsClass))

typedef struct _GcaDiagnosticColors GcaDiagnosticColors;
typedef struct _GcaDiagnosticColorsClass GcaDiagnosticColorsClass;

#define GCA_SOURCE_INDEX_TYPE_ITERATOR (gca_source_index_iterator_get_type ())
#define GCA_SOURCE_INDEX_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_SOURCE_INDEX_TYPE_ITERATOR, GcaSourceIndexIterator))
#define GCA_SOURCE_INDEX_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_SOURCE_INDEX_TYPE_ITERATOR, GcaSourceIndexIteratorClass))
#define GCA_SOURCE_INDEX_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_SOURCE_INDEX_TYPE_ITERATOR))
#define GCA_SOURCE_INDEX_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_SOURCE_INDEX_TYPE_ITERATOR))
#define GCA_SOURCE_INDEX_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_SOURCE_INDEX_TYPE_ITERATOR, GcaSourceIndexIteratorClass))

typedef struct _GcaSourceIndexIterator GcaSourceIndexIterator;
typedef struct _GcaSourceIndexIteratorClass GcaSourceIndexIteratorClass;

#define GCA_DIAGNOSTIC_TYPE_SEVERITY (gca_diagnostic_severity_get_type ())
#define _gca_diagnostic_colors_unref0(var) ((var == NULL) ? NULL : (var = (gca_diagnostic_colors_unref (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

#define GCA_DIAGNOSTIC_TYPE_FIXIT (gca_diagnostic_fixit_get_type ())
typedef struct _GcaDiagnosticFixit GcaDiagnosticFixit;

typedef enum  {
	GCA_REMOTE_SERVICES_DIAGNOSTICS = 1 << 0,
	GCA_REMOTE_SERVICES_SEMANTIC_VALUES = 1 << 1,
	GCA_REMOTE_SERVICES_SYMBOLS = 1 << 2
} GcaRemoteServices;

struct _GcaRemoteServiceIface {
	GTypeInterface parent_iface;
	GcaRemoteServices (*services) (GcaRemoteService* self);
	void (*update) (GcaRemoteService* self, GcaView* view, GcaRemoteDocument* document);
	void (*destroy) (GcaRemoteService* self);
};

struct _GcaDiagnosticService {
	GObject parent_instance;
	GcaDiagnosticServicePrivate * priv;
};

struct _GcaDiagnosticServiceClass {
	GObjectClass parent_class;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusSourceRange {
	gint64 file;
	GcaDBusSourceLocation start;
	GcaDBusSourceLocation end;
};

struct _GcaDBusFixit {
	GcaDBusSourceRange location;
	gchar* replacement;
};

struct _GcaDBusDiagnostic {
	guint32 severity;
	GcaDBusFixit* fixits;
	gint fixits_length1;
	GcaDBusSourceRange* locations;
	gint locations_length1;
	gchar* message;
};

struct _GcaDBusDiagnosticsIface {
	GTypeInterface parent_iface;
	void (*diagnostics) (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GcaDBusDiagnostic* (*diagnostics_finish) (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _GcaDiagnosticServicePrivate {
	GcaDiagnostics* d_diagnostics;
	GcaDBusDiagnostics* d_proxy;
	char* d_path;
};

struct _Block4Data {
	int _ref_count_;
	GcaDiagnosticService * self;
	GcaRemoteDocument* document;
};

struct _Block5Data {
	int _ref_count_;
	GcaDiagnosticService * self;
	GcaDBusDiagnostics* proxy;
};

struct _GcaDiagnostics {
	GObject parent_instance;
	GcaDiagnosticsPrivate * priv;
};

struct _GcaDiagnosticsClass {
	GObjectClass parent_class;
};

struct _GcaDiagnosticsPrivate {
	GcaView* d_view;
	GcaSourceIndex* d_index;
	GcaDiagnosticTags* d_tags;
	GeeHashMap* d_diagnostics_at_end;
	GcaDiagnostic** d_cursor_diagnostics;
	gint d_cursor_diagnostics_length1;
	gint _d_cursor_diagnostics_size_;
	GcaDiagnosticMessage* d_cursor_diagnostic_message;
	guint d_last_marker_id;
};

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _GcaSourceRange {
	GcaSourceLocation start;
	GcaSourceLocation end;
};

struct _GcaSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcaSourceRange* (*get_ranges) (GcaSourceRangeSupport* self, int* result_length1);
};

typedef enum  {
	GCA_DIAGNOSTIC_SEVERITY_NONE,
	GCA_DIAGNOSTIC_SEVERITY_INFO,
	GCA_DIAGNOSTIC_SEVERITY_WARNING,
	GCA_DIAGNOSTIC_SEVERITY_DEPRECATED,
	GCA_DIAGNOSTIC_SEVERITY_ERROR,
	GCA_DIAGNOSTIC_SEVERITY_FATAL
} GcaDiagnosticSeverity;

struct _GcaDiagnosticFixit {
	GcaSourceRange range;
	gchar* replacement;
};


static gpointer gca_diagnostic_service_parent_class = NULL;
static GcaRemoteServiceIface* gca_diagnostic_service_gca_remote_service_parent_iface = NULL;
static gpointer gca_diagnostics_parent_class = NULL;

GType gca_remote_services_get_type (void) G_GNUC_CONST;
GType gca_view_get_type (void) G_GNUC_CONST;
gpointer gca_remote_document_ref (gpointer instance);
void gca_remote_document_unref (gpointer instance);
GParamSpec* gca_param_spec_remote_document (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_remote_document (GValue* value, gpointer v_object);
void gca_value_take_remote_document (GValue* value, gpointer v_object);
gpointer gca_value_get_remote_document (const GValue* value);
GType gca_remote_document_get_type (void) G_GNUC_CONST;
GType gca_remote_service_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_service_get_type (void) G_GNUC_CONST;
GType gca_diagnostics_get_type (void) G_GNUC_CONST;
GType gca_dbus_diagnostics_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_diagnostics_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_diagnostic_get_type (void) G_GNUC_CONST;
GType gca_dbus_fixit_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_range_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GcaDBusSourceRange* gca_dbus_source_range_dup (const GcaDBusSourceRange* self);
void gca_dbus_source_range_free (GcaDBusSourceRange* self);
GcaDBusFixit* gca_dbus_fixit_dup (const GcaDBusFixit* self);
void gca_dbus_fixit_free (GcaDBusFixit* self);
void gca_dbus_fixit_copy (const GcaDBusFixit* self, GcaDBusFixit* dest);
void gca_dbus_fixit_destroy (GcaDBusFixit* self);
GcaDBusDiagnostic* gca_dbus_diagnostic_dup (const GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_free (GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_copy (const GcaDBusDiagnostic* self, GcaDBusDiagnostic* dest);
void gca_dbus_diagnostic_destroy (GcaDBusDiagnostic* self);
GType gca_dbus_diagnostics_get_type (void) G_GNUC_CONST;
#define GCA_DIAGNOSTIC_SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServicePrivate))
enum  {
	GCA_DIAGNOSTIC_SERVICE_DUMMY_PROPERTY
};
static GcaRemoteServices gca_diagnostic_service_real_services (GcaRemoteService* base);
static void gca_diagnostic_service_real_update (GcaRemoteService* base, GcaView* view, GcaRemoteDocument* document);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
GcaDiagnostics* gca_diagnostics_new (GcaView* view);
GcaDiagnostics* gca_diagnostics_construct (GType object_type, GcaView* view);
const char* gca_remote_document_get_path (GcaRemoteDocument* self);
void gca_remote_document_get_proxy (GcaRemoteDocument* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GAsyncReadyCallback _callback_, gpointer _user_data_);
gpointer gca_remote_document_get_proxy_finish (GcaRemoteDocument* self, GAsyncResult* _res_, GError** error);
static void ___lambda13_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void gca_diagnostic_service_update_proxy (GcaDiagnosticService* self);
void gca_log_debug (const gchar* format, ...);
static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void gca_dbus_diagnostics_diagnostics (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaDBusDiagnostic* gca_dbus_diagnostics_diagnostics_finish (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void __lambda14_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
GType gca_diagnostic_get_type (void) G_GNUC_CONST;
void gca_diagnostics_update (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1);
static GcaDiagnostic** gca_diagnostic_service_transform (GcaDiagnosticService* self, GcaDBusDiagnostic* diagnostics, int diagnostics_length1, int* result_length1);
static void _vala_GcaDBusDiagnostic_array_free (GcaDBusDiagnostic* array, gint array_length);
static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GcaDiagnostic* gca_diagnostic_new_from_dbus (GcaDBusDiagnostic* diagnostic);
GcaDiagnostic* gca_diagnostic_construct_from_dbus (GType object_type, GcaDBusDiagnostic* diagnostic);
static void gca_diagnostic_service_real_destroy (GcaRemoteService* base);
void gca_diagnostics_destroy (GcaDiagnostics* self);
GcaDiagnosticService* gca_diagnostic_service_new (void);
GcaDiagnosticService* gca_diagnostic_service_construct (GType object_type);
static void gca_diagnostic_service_finalize (GObject* obj);
GType gca_source_index_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_message_get_type (void) G_GNUC_CONST;
#define GCA_DIAGNOSTICS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DIAGNOSTICS, GcaDiagnosticsPrivate))
enum  {
	GCA_DIAGNOSTICS_DUMMY_PROPERTY
};
GcaSourceIndex* gca_source_index_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
GcaSourceIndex* gca_source_index_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
GeditView* gca_view_get_view (GcaView* self);
GcaDiagnosticTags* gca_diagnostic_tags_new (GtkTextView* view);
GcaDiagnosticTags* gca_diagnostic_tags_construct (GType object_type, GtkTextView* view);
static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self);
static void gca_diagnostics_register_marks (GcaDiagnostics* self);
static gboolean gca_diagnostics_on_view_query_tooltip (GcaDiagnostics* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip);
static gboolean _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self);
static gboolean gca_diagnostics_on_view_draw (GcaDiagnostics* self, cairo_t* ctx);
static gboolean _gca_diagnostics_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
GType gca_document_get_type (void) G_GNUC_CONST;
GcaDocument* gca_view_get_document (GcaView* self);
GeditDocument* gca_document_get_document (GcaDocument* self);
static void gca_diagnostics_on_buffer_mark_set (GcaDiagnostics* self, GtkTextIter* location, GtkTextMark* mark);
static void _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void gca_diagnostics_on_cursor_moved (GcaDiagnostics* self);
static void _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self);
void gca_source_index_clear (GcaSourceIndex* self);
GType gca_source_range_get_type (void) G_GNUC_CONST;
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self);
void gca_source_range_free (GcaSourceRange* self);
GType gca_source_range_support_get_type (void) G_GNUC_CONST;
void gca_source_index_add (GcaSourceIndex* self, GcaSourceRangeSupport* range);
static void gca_diagnostics_update_scrollbar (GcaDiagnostics* self);
static void gca_diagnostics_update_marks (GcaDiagnostics* self);
gpointer gca_scrollbar_marker_ref (gpointer instance);
void gca_scrollbar_marker_unref (gpointer instance);
GParamSpec* gca_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gca_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gca_value_get_scrollbar_marker (const GValue* value);
GType gca_scrollbar_marker_get_type (void) G_GNUC_CONST;
GcaScrollbarMarker* gca_view_get_scrollbar_marker (GcaView* self);
void gca_scrollbar_marker_remove (GcaScrollbarMarker* self, guint id);
GtkScrollbar* gca_scrollbar_marker_get_scrollbar (GcaScrollbarMarker* self);
GcaDiagnosticColors* gca_diagnostic_colors_new (GtkStyleContext* context);
GcaDiagnosticColors* gca_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
gpointer gca_diagnostic_colors_ref (gpointer instance);
void gca_diagnostic_colors_unref (gpointer instance);
GParamSpec* gca_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gca_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gca_value_get_diagnostic_colors (const GValue* value);
GType gca_diagnostic_colors_get_type (void) G_GNUC_CONST;
void gca_diagnostic_colors_mix_in_widget (GcaDiagnosticColors* self, GtkWidget* widget);
guint gca_scrollbar_marker_new_merge_id (GcaScrollbarMarker* self);
GType gca_source_index_iterator_get_type (void) G_GNUC_CONST;
GcaSourceIndexIterator* gca_source_index_iterator (GcaSourceIndex* self);
gboolean gca_source_index_iterator_next (GcaSourceIndexIterator* self);
gpointer gca_source_index_iterator_get (GcaSourceIndexIterator* self);
GType gca_diagnostic_severity_get_type (void) G_GNUC_CONST;
GdkRGBA* gca_diagnostic_colors_get (GcaDiagnosticColors* self, GcaDiagnosticSeverity severity);
GcaDiagnosticSeverity gca_diagnostic_get_severity (GcaDiagnostic* self);
GcaSourceRange* gca_source_range_support_get_ranges (GcaSourceRangeSupport* self, int* result_length1);
void gca_scrollbar_marker_add_with_id (GcaScrollbarMarker* self, guint id, GcaSourceRange* range, GdkRGBA* color);
static gboolean gca_diagnostics_diagnostic_is_at_end (GcaDiagnostics* self, GcaSourceLocation* location);
static void gca_diagnostics_add_diagnostic_at_end (GcaDiagnostics* self, GcaSourceLocation* location, GdkRGBA* color);
static void gca_diagnostics_update_diagnostic_message (GcaDiagnostics* self);
GtkTextTag* gca_diagnostic_tags_get_error_tag (GcaDiagnosticTags* self);
GtkTextTag* gca_diagnostic_tags_get_warning_tag (GcaDiagnosticTags* self);
GtkTextTag* gca_diagnostic_tags_get_info_tag (GcaDiagnosticTags* self);
GtkTextTag* gca_diagnostic_tags_get_fixit_tag (GcaDiagnosticTags* self);
static void gca_diagnostics_remove_marks (GcaDiagnostics* self);
static void gca_diagnostics_mark_diagnostic (GcaDiagnostics* self, GcaDiagnostic* diagnostic);
static GcaDiagnosticSeverity* gca_diagnostics_mark_severities (GcaDiagnostics* self, int* result_length1);
gchar* gca_diagnostics_icon_name_for_severity (GcaDiagnosticSeverity severity);
static gchar* gca_diagnostics_on_diagnostic_tooltip (GcaDiagnostics* self, GtkSourceMark* mark);
static gchar* _gca_diagnostics_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* mark, gpointer self);
gchar* gca_diagnostics_mark_category_for_severity (GcaDiagnosticSeverity severity);
static void gca_diagnostics_unregister_marks (GcaDiagnostics* self);
const gchar* gca_diagnostics_get_info_mark_category (void);
const gchar* gca_diagnostics_get_warning_mark_category (void);
const gchar* gca_diagnostics_get_error_mark_category (void);
const gchar* gca_diagnostics_get_warning_icon_name (void);
const gchar* gca_diagnostics_get_error_icon_name (void);
const gchar* gca_diagnostics_get_info_icon_name (void);
static GcaDiagnostic** gca_diagnostics_sorted_on_severity (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1, int* result_length1);
static GcaDiagnostic** _vala_array_dup4 (GcaDiagnostic** self, int length);
static gint __lambda11_ (GcaDiagnostics* self, GcaDiagnostic* a, GcaDiagnostic* b);
static gint ___lambda11__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static GcaDiagnostic** gca_diagnostics_find_at (GcaDiagnostics* self, GcaSourceRange* range, int* result_length1);
gpointer* gca_source_index_find_at (GcaSourceIndex* self, GcaSourceRange* range, int* result_length1);
static GcaDiagnostic** gca_diagnostics_find_at_line (GcaDiagnostics* self, gint line, int* result_length1);
gpointer* gca_source_index_find_at_line (GcaSourceIndex* self, gint line, int* result_length1);
static void gca_diagnostics_mark_diagnostic_range (GcaDiagnostics* self, GcaDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end);
GtkTextTag* gca_diagnostic_tags_get (GcaDiagnosticTags* self, GcaDiagnosticSeverity severity);
gboolean gca_source_range_get_iters (GcaSourceRange *self, GtkTextBuffer* buffer, GtkTextIter* start, GtkTextIter* end);
GType gca_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcaDiagnosticFixit* gca_diagnostic_fixit_dup (const GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_free (GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_copy (const GcaDiagnosticFixit* self, GcaDiagnosticFixit* dest);
void gca_diagnostic_fixit_destroy (GcaDiagnosticFixit* self);
GcaDiagnosticFixit* gca_diagnostic_get_fixits (GcaDiagnostic* self, int* result_length1);
static gboolean gca_diagnostics_same_diagnostics (GcaDiagnostics* self, GcaDiagnostic** first, int first_length1, GcaDiagnostic** second, int second_length1);
void gca_source_range_from_iter (GtkTextIter* iter, GcaSourceRange* result);
GcaDiagnosticMessage* gca_diagnostic_message_new (GtkSourceView* view, GcaDiagnostic** diagnostics, int diagnostics_length1);
GcaDiagnosticMessage* gca_diagnostic_message_construct (GType object_type, GtkSourceView* view, GcaDiagnostic** diagnostics, int diagnostics_length1);
static void __lambda12_ (GcaDiagnostics* self);
static void ___lambda12__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static GcaDiagnostic** _vala_array_dup5 (GcaDiagnostic** self, int length);
static gchar* gca_diagnostics_format_diagnostics (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1);
gchar* gca_diagnostic_to_markup (GcaDiagnostic* self, gboolean include_severity);
static void gca_diagnostics_finalize (GObject* obj);
static void _vala_gca_diagnostics_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GcaRemoteServices gca_diagnostic_service_real_services (GcaRemoteService* base) {
	GcaDiagnosticService * self;
	GcaRemoteServices result = 0;
#line 29 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = (GcaDiagnosticService*) base;
#line 31 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = GCA_REMOTE_SERVICES_DIAGNOSTICS;
#line 31 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 541 "gca-diagnostics.c"
}


static gpointer _gca_remote_document_ref0 (gpointer self) {
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return self ? gca_remote_document_ref (self) : NULL;
#line 548 "gca-diagnostics.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return _data4_;
#line 557 "gca-diagnostics.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 566 "gca-diagnostics.c"
		GcaDiagnosticService * self;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		self = _data4_->self;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_gca_remote_document_unref0 (_data4_->document);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (self);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		g_slice_free (Block4Data, _data4_);
#line 576 "gca-diagnostics.c"
	}
}


static void ___lambda13_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	GcaDiagnosticService * self;
	GError * _inner_error_ = NULL;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = _data4_->self;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (res != NULL);
#line 588 "gca-diagnostics.c"
	{
		GcaRemoteDocument* _tmp0_;
		GAsyncResult* _tmp1_;
		gpointer _tmp2_ = NULL;
		GcaDBusDiagnostics* _tmp3_;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp0_ = _data4_->document;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp1_ = res;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp2_ = gca_remote_document_get_proxy_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp3_ = (GcaDBusDiagnostics*) _tmp2_;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (_inner_error_ != NULL) {
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 606 "gca-diagnostics.c"
				goto __catch11_g_io_error;
			}
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			g_clear_error (&_inner_error_);
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return;
#line 615 "gca-diagnostics.c"
		}
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (self->priv->d_proxy);
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		self->priv->d_proxy = _tmp3_;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gca_diagnostic_service_update_proxy (self);
#line 623 "gca-diagnostics.c"
	}
	goto __finally11;
	__catch11_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		e = _inner_error_;
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_inner_error_ = NULL;
#line 57 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp4_ = e;
#line 57 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp5_ = _tmp4_->message;
#line 57 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gca_log_debug ("gca-diagnostics.vala:57: Failed to get diagnostics proxy: %s", _tmp5_);
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_error_free0 (e);
#line 643 "gca-diagnostics.c"
	}
	__finally11:
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_inner_error_ != NULL) {
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		g_clear_error (&_inner_error_);
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return;
#line 654 "gca-diagnostics.c"
	}
}


static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	___lambda13_ (self, source_object, res);
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	block4_data_unref (self);
#line 664 "gca-diagnostics.c"
}


static void gca_diagnostic_service_real_update (GcaRemoteService* base, GcaView* view, GcaRemoteDocument* document) {
	GcaDiagnosticService * self;
	Block4Data* _data4_;
	GcaRemoteDocument* _tmp0_;
	GcaRemoteDocument* _tmp1_;
	GcaDiagnostics* _tmp2_;
	const char* _tmp5_;
	GcaRemoteDocument* _tmp6_;
	const char* _tmp7_;
	const char* _tmp8_;
	GcaDBusDiagnostics* _tmp9_;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = (GcaDiagnosticService*) base;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (view != NULL);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (document != NULL);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data4_->_ref_count_ = 1;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data4_->self = g_object_ref (self);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = document;
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = _gca_remote_document_ref0 (_tmp0_);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_gca_remote_document_unref0 (_data4_->document);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data4_->document = _tmp1_;
#line 36 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = self->priv->d_diagnostics;
#line 36 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp2_ == NULL) {
#line 703 "gca-diagnostics.c"
		GcaView* _tmp3_;
		GcaDiagnostics* _tmp4_;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp3_ = view;
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp4_ = gca_diagnostics_new (_tmp3_);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (self->priv->d_diagnostics);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		self->priv->d_diagnostics = _tmp4_;
#line 714 "gca-diagnostics.c"
	}
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = self->priv->d_path;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = _data4_->document;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = gca_remote_document_get_path (_tmp6_);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = _tmp7_;
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (g_strcmp0 (_tmp5_, _tmp8_) != 0) {
#line 43 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (self->priv->d_proxy);
#line 43 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		self->priv->d_proxy = NULL;
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_free0 (self->priv->d_path);
#line 44 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		self->priv->d_path = NULL;
#line 734 "gca-diagnostics.c"
	}
#line 47 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = self->priv->d_proxy;
#line 47 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp9_ == NULL) {
#line 740 "gca-diagnostics.c"
		GcaRemoteDocument* _tmp10_;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp10_ = _data4_->document;
#line 49 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gca_remote_document_get_proxy (_tmp10_, GCA_DBUS_TYPE_DIAGNOSTICS, (GBoxedCopyFunc) g_object_ref, g_object_unref, ____lambda13__gasync_ready_callback, block4_data_ref (_data4_));
#line 746 "gca-diagnostics.c"
	} else {
#line 63 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gca_diagnostic_service_update_proxy (self);
#line 750 "gca-diagnostics.c"
	}
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	block4_data_unref (_data4_);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data4_ = NULL;
#line 756 "gca-diagnostics.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return _data5_;
#line 765 "gca-diagnostics.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 774 "gca-diagnostics.c"
		GcaDiagnosticService * self;
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		self = _data5_->self;
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (_data5_->proxy);
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (self);
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		g_slice_free (Block5Data, _data5_);
#line 784 "gca-diagnostics.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 69 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return self ? g_object_ref (self) : NULL;
#line 792 "gca-diagnostics.c"
}


static void _vala_GcaDBusDiagnostic_array_free (GcaDBusDiagnostic* array, gint array_length) {
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (array != NULL) {
#line 799 "gca-diagnostics.c"
		int i;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			gca_dbus_diagnostic_destroy (&array[i]);
#line 805 "gca-diagnostics.c"
		}
	}
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_free (array);
#line 810 "gca-diagnostics.c"
}


static void __lambda14_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	GcaDiagnosticService * self;
	GError * _inner_error_ = NULL;
#line 71 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = _data5_->self;
#line 71 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (res != NULL);
#line 821 "gca-diagnostics.c"
	{
		GAsyncResult* _tmp0_;
		gint _tmp1_ = 0;
		GcaDBusDiagnostic* _tmp2_ = NULL;
		GcaDBusDiagnostic* ret;
		gint ret_length1;
		gint _ret_size_;
		GcaDBusDiagnostics* _tmp3_;
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp0_ = res;
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp2_ = gca_dbus_diagnostics_diagnostics_finish (_data5_->proxy, _tmp0_, &_tmp1_, &_inner_error_);
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		ret = _tmp2_;
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		ret_length1 = _tmp1_;
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_ret_size_ = ret_length1;
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (_inner_error_ != NULL) {
#line 842 "gca-diagnostics.c"
			goto __catch12_g_error;
		}
#line 76 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp3_ = self->priv->d_proxy;
#line 76 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (_data5_->proxy == _tmp3_) {
#line 849 "gca-diagnostics.c"
			GcaDiagnostics* _tmp4_;
			gint _tmp5_ = 0;
			GcaDiagnostic** _tmp6_ = NULL;
			GcaDiagnostic** _tmp7_;
			gint _tmp7__length1;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp4_ = self->priv->d_diagnostics;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp6_ = gca_diagnostic_service_transform (self, ret, ret_length1, &_tmp5_);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp7_ = _tmp6_;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp7__length1 = _tmp5_;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			gca_diagnostics_update (_tmp4_, _tmp7_, _tmp5_);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_object_unref), NULL);
#line 867 "gca-diagnostics.c"
		}
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		ret = (_vala_GcaDBusDiagnostic_array_free (ret, ret_length1), NULL);
#line 871 "gca-diagnostics.c"
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		e = _inner_error_;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_inner_error_ = NULL;
#line 83 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp8_ = e;
#line 83 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp9_ = _tmp8_->message;
#line 83 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gca_log_debug ("gca-diagnostics.vala:83: Failed to call diagnostics: %s", _tmp9_);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_error_free0 (e);
#line 891 "gca-diagnostics.c"
	}
	__finally12:
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_inner_error_ != NULL) {
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		g_clear_error (&_inner_error_);
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return;
#line 902 "gca-diagnostics.c"
	}
}


static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 71 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	__lambda14_ (self, source_object, res);
#line 71 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	block5_data_unref (self);
#line 912 "gca-diagnostics.c"
}


static void gca_diagnostic_service_update_proxy (GcaDiagnosticService* self) {
	Block5Data* _data5_;
	GcaDBusDiagnostics* _tmp0_;
	GcaDBusDiagnostics* _tmp1_;
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data5_->_ref_count_ = 1;
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data5_->self = g_object_ref (self);
#line 69 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_proxy;
#line 69 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 69 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data5_->proxy = _tmp1_;
#line 71 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_dbus_diagnostics_diagnostics (_data5_->proxy, ___lambda14__gasync_ready_callback, block5_data_ref (_data5_));
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	block5_data_unref (_data5_);
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_data5_ = NULL;
#line 940 "gca-diagnostics.c"
}


static GcaDiagnostic** gca_diagnostic_service_transform (GcaDiagnosticService* self, GcaDBusDiagnostic* diagnostics, int diagnostics_length1, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GcaDBusDiagnostic* _tmp0_;
	gint _tmp0__length1;
	GcaDiagnostic** _tmp1_ = NULL;
	GcaDiagnostic** ret;
	gint ret_length1;
	gint _ret_size_;
	GcaDiagnostic** _tmp14_;
	gint _tmp14__length1;
#line 88 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = diagnostics;
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0__length1 = diagnostics_length1;
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = g_new0 (GcaDiagnostic*, _tmp0__length1 + 1);
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	ret = _tmp1_;
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	ret_length1 = _tmp0__length1;
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_ret_size_ = ret_length1;
#line 968 "gca-diagnostics.c"
	{
		gint i;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		i = 0;
#line 973 "gca-diagnostics.c"
		{
			gboolean _tmp2_;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp2_ = TRUE;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			while (TRUE) {
#line 980 "gca-diagnostics.c"
				gboolean _tmp3_;
				gint _tmp5_;
				GcaDiagnostic** _tmp6_;
				gint _tmp6__length1;
				GcaDiagnostic** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				GcaDBusDiagnostic* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				GcaDBusDiagnostic _tmp11_;
				GcaDiagnostic* _tmp12_;
				GcaDiagnostic* _tmp13_;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp3_ = _tmp2_;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!_tmp3_) {
#line 998 "gca-diagnostics.c"
					gint _tmp4_;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp4_ = i;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					i = _tmp4_ + 1;
#line 1004 "gca-diagnostics.c"
				}
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp2_ = FALSE;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp5_ = i;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp6_ = ret;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp6__length1 = ret_length1;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!(_tmp5_ < _tmp6__length1)) {
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					break;
#line 1018 "gca-diagnostics.c"
				}
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7_ = ret;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7__length1 = ret_length1;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp8_ = i;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp9_ = diagnostics;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp9__length1 = diagnostics_length1;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp10_ = i;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp11_ = _tmp9_[_tmp10_];
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp12_ = gca_diagnostic_new_from_dbus (&_tmp11_);
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_object_unref0 (_tmp7_[_tmp8_]);
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7_[_tmp8_] = _tmp12_;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13_ = _tmp7_[_tmp8_];
#line 1042 "gca-diagnostics.c"
			}
		}
	}
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = ret;
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14__length1 = ret_length1;
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (result_length1) {
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		*result_length1 = _tmp14__length1;
#line 1054 "gca-diagnostics.c"
	}
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp14_;
#line 97 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 1060 "gca-diagnostics.c"
}


static void gca_diagnostic_service_real_destroy (GcaRemoteService* base) {
	GcaDiagnosticService * self;
	GcaDiagnostics* _tmp0_;
#line 100 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = (GcaDiagnosticService*) base;
#line 102 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_diagnostics;
#line 102 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp0_ != NULL) {
#line 1073 "gca-diagnostics.c"
		GcaDiagnostics* _tmp1_;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp1_ = self->priv->d_diagnostics;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gca_diagnostics_destroy (_tmp1_);
#line 105 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (self->priv->d_diagnostics);
#line 105 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		self->priv->d_diagnostics = NULL;
#line 1083 "gca-diagnostics.c"
	}
}


GcaDiagnosticService* gca_diagnostic_service_construct (GType object_type) {
	GcaDiagnosticService * self = NULL;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = (GcaDiagnosticService*) g_object_new (object_type, NULL);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return self;
#line 1094 "gca-diagnostics.c"
}


GcaDiagnosticService* gca_diagnostic_service_new (void) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return gca_diagnostic_service_construct (GCA_TYPE_DIAGNOSTIC_SERVICE);
#line 1101 "gca-diagnostics.c"
}


static void gca_diagnostic_service_class_init (GcaDiagnosticServiceClass * klass) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostic_service_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_type_class_add_private (klass, sizeof (GcaDiagnosticServicePrivate));
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	G_OBJECT_CLASS (klass)->finalize = gca_diagnostic_service_finalize;
#line 1112 "gca-diagnostics.c"
}


static void gca_diagnostic_service_gca_remote_service_interface_init (GcaRemoteServiceIface * iface) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostic_service_gca_remote_service_parent_iface = g_type_interface_peek_parent (iface);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	iface->services = (GcaRemoteServices (*)(GcaRemoteService*)) gca_diagnostic_service_real_services;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	iface->update = (void (*)(GcaRemoteService*, GcaView*, GcaRemoteDocument*)) gca_diagnostic_service_real_update;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	iface->destroy = (void (*)(GcaRemoteService*)) gca_diagnostic_service_real_destroy;
#line 1125 "gca-diagnostics.c"
}


static void gca_diagnostic_service_instance_init (GcaDiagnosticService * self) {
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv = GCA_DIAGNOSTIC_SERVICE_GET_PRIVATE (self);
#line 1132 "gca-diagnostics.c"
}


static void gca_diagnostic_service_finalize (GObject* obj) {
	GcaDiagnosticService * self;
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticService);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_diagnostics);
#line 26 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_proxy);
#line 27 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_free0 (self->priv->d_path);
#line 23 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	G_OBJECT_CLASS (gca_diagnostic_service_parent_class)->finalize (obj);
#line 1148 "gca-diagnostics.c"
}


GType gca_diagnostic_service_get_type (void) {
	static volatile gsize gca_diagnostic_service_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDiagnosticServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_diagnostic_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDiagnosticService), 0, (GInstanceInitFunc) gca_diagnostic_service_instance_init, NULL };
		static const GInterfaceInfo gca_remote_service_info = { (GInterfaceInitFunc) gca_diagnostic_service_gca_remote_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gca_diagnostic_service_type_id;
		gca_diagnostic_service_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDiagnosticService", &g_define_type_info, 0);
		g_type_add_interface_static (gca_diagnostic_service_type_id, GCA_TYPE_REMOTE_SERVICE, &gca_remote_service_info);
		g_once_init_leave (&gca_diagnostic_service_type_id__volatile, gca_diagnostic_service_type_id);
	}
	return gca_diagnostic_service_type_id__volatile;
}


static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self) {
	GdkRGBA* dup;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	dup = g_new0 (GdkRGBA, 1);
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	memcpy (dup, self, sizeof (GdkRGBA));
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return dup;
#line 1174 "gca-diagnostics.c"
}


static gboolean _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self) {
	gboolean result;
	result = gca_diagnostics_on_view_query_tooltip (self, x, y, keyboard_tooltip, tooltip);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 1183 "gca-diagnostics.c"
}


static gboolean _gca_diagnostics_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gca_diagnostics_on_view_draw (self, cr);
#line 165 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 1192 "gca-diagnostics.c"
}


static void _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
#line 168 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_on_buffer_mark_set (self, location, mark);
#line 1199 "gca-diagnostics.c"
}


static void _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self) {
#line 169 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_on_cursor_moved (self);
#line 1206 "gca-diagnostics.c"
}


GcaDiagnostics* gca_diagnostics_construct (GType object_type, GcaView* view) {
	GcaDiagnostics * self = NULL;
	GcaView* _tmp0_;
	GcaView* _tmp1_;
	GcaSourceIndex* _tmp2_;
	GcaView* _tmp3_;
	GeditView* _tmp4_;
	GeditView* _tmp5_;
	GcaDiagnosticTags* _tmp6_;
	GeeHashMap* _tmp7_;
	GcaView* _tmp8_;
	GeditView* _tmp9_;
	GeditView* _tmp10_;
	GeditView* _tmp11_;
	GeditView* v;
	GcaView* _tmp12_;
	GcaDocument* _tmp13_;
	GcaDocument* _tmp14_;
	GeditDocument* _tmp15_;
	GeditDocument* _tmp16_;
	GeditDocument* _tmp17_;
	GeditDocument* doc;
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (view != NULL, NULL);
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = (GcaDiagnostics*) g_object_new (object_type, NULL);
#line 153 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = view;
#line 153 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 153 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_view);
#line 153 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_view = _tmp1_;
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = gca_source_index_new (GCA_TYPE_DIAGNOSTIC, (GBoxedCopyFunc) g_object_ref, g_object_unref);
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_index);
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_index = _tmp2_;
#line 156 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = self->priv->d_view;
#line 156 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = gca_view_get_view (_tmp3_);
#line 156 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _tmp4_;
#line 156 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = gca_diagnostic_tags_new ((GtkTextView*) _tmp5_);
#line 156 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_tags);
#line 156 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_tags = _tmp6_;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = gee_hash_map_new (GTK_TYPE_TEXT_MARK, (GBoxedCopyFunc) g_object_ref, g_object_unref, gdk_rgba_get_type (), (GBoxedCopyFunc) _gdk_rgba_dup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_diagnostics_at_end);
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_diagnostics_at_end = _tmp7_;
#line 159 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_register_marks (self);
#line 161 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = self->priv->d_view;
#line 161 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = gca_view_get_view (_tmp8_);
#line 161 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = _tmp9_;
#line 161 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 161 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	v = _tmp11_;
#line 163 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_source_view_set_show_line_marks ((GtkSourceView*) v, TRUE);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_connect_object ((GtkWidget*) v, "query-tooltip", (GCallback) _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip, self, 0);
#line 165 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_connect_object ((GtkWidget*) v, "draw", (GCallback) _gca_diagnostics_on_view_draw_gtk_widget_draw, self, 0);
#line 167 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = self->priv->d_view;
#line 167 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = gca_view_get_document (_tmp12_);
#line 167 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = _tmp13_;
#line 167 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = gca_document_get_document (_tmp14_);
#line 167 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = _tmp15_;
#line 167 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 167 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	doc = _tmp17_;
#line 168 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_connect_object ((GtkTextBuffer*) doc, "mark-set", (GCallback) _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set, self, 0);
#line 169 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_connect_object (doc, "cursor-moved", (GCallback) _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved, self, 0);
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (doc);
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (v);
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return self;
#line 1310 "gca-diagnostics.c"
}


GcaDiagnostics* gca_diagnostics_new (GcaView* view) {
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return gca_diagnostics_construct (GCA_TYPE_DIAGNOSTICS, view);
#line 1317 "gca-diagnostics.c"
}


void gca_diagnostics_update (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1) {
	GcaSourceIndex* _tmp0_;
	GcaDiagnostic** _tmp1_;
	gint _tmp1__length1;
#line 172 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_index;
#line 174 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_source_index_clear (_tmp0_);
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = diagnostics;
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1__length1 = diagnostics_length1;
#line 1335 "gca-diagnostics.c"
	{
		GcaDiagnostic** d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		d_collection = _tmp1_;
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		d_collection_length1 = _tmp1__length1;
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		for (d_it = 0; d_it < _tmp1__length1; d_it = d_it + 1) {
#line 1347 "gca-diagnostics.c"
			GcaDiagnostic* _tmp2_;
			GcaDiagnostic* d = NULL;
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp2_ = _g_object_ref0 (d_collection[d_it]);
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			d = _tmp2_;
#line 1354 "gca-diagnostics.c"
			{
				GcaSourceIndex* _tmp3_;
				GcaDiagnostic* _tmp4_;
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp3_ = self->priv->d_index;
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp4_ = d;
#line 178 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				gca_source_index_add (_tmp3_, (GcaSourceRangeSupport*) _tmp4_);
#line 176 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_object_unref0 (d);
#line 1366 "gca-diagnostics.c"
			}
		}
	}
#line 181 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_update_scrollbar (self);
#line 182 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_update_marks (self);
#line 1374 "gca-diagnostics.c"
}


static gpointer _gca_scrollbar_marker_ref0 (gpointer self) {
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return self ? gca_scrollbar_marker_ref (self) : NULL;
#line 1381 "gca-diagnostics.c"
}


static void gca_diagnostics_update_scrollbar (GcaDiagnostics* self) {
	GcaView* _tmp0_;
	GcaScrollbarMarker* _tmp1_;
	GcaScrollbarMarker* _tmp2_;
	GcaScrollbarMarker* _tmp3_;
	GcaScrollbarMarker* sm;
	GcaScrollbarMarker* _tmp4_;
	GcaScrollbarMarker* _tmp5_;
	guint _tmp6_;
	GcaScrollbarMarker* _tmp7_;
	GtkScrollbar* _tmp8_;
	GtkScrollbar* _tmp9_;
	GtkStyleContext* _tmp10_ = NULL;
	GcaDiagnosticColors* _tmp11_;
	GcaDiagnosticColors* colors;
	GcaScrollbarMarker* _tmp12_;
	GtkScrollbar* _tmp13_;
	GtkScrollbar* _tmp14_;
	GtkStyleContext* _tmp15_ = NULL;
	GcaDiagnosticColors* _tmp16_;
	GcaDiagnosticColors* mixed;
	GcaDiagnosticColors* _tmp17_;
	GcaView* _tmp18_;
	GeditView* _tmp19_;
	GeditView* _tmp20_;
	GeeHashMap* _tmp21_;
	GeeMapIterator* _tmp22_ = NULL;
	GeeMapIterator* it;
	GcaView* _tmp23_;
	GeditView* _tmp24_;
	GeditView* _tmp25_;
	GtkTextBuffer* _tmp26_;
	GtkTextBuffer* _tmp27_;
	GtkTextBuffer* _tmp28_;
	GtkTextBuffer* buf;
	GeeHashMap* _tmp35_;
	GcaScrollbarMarker* _tmp36_;
	guint _tmp37_ = 0U;
#line 185 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_view_get_scrollbar_marker (_tmp0_);
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = _gca_scrollbar_marker_ref0 (_tmp2_);
#line 187 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	sm = _tmp3_;
#line 189 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = sm;
#line 189 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp4_ == NULL) {
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_gca_scrollbar_marker_unref0 (sm);
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return;
#line 1443 "gca-diagnostics.c"
	}
#line 194 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = sm;
#line 194 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = self->priv->d_last_marker_id;
#line 194 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_scrollbar_marker_remove (_tmp5_, _tmp6_);
#line 196 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = sm;
#line 196 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = gca_scrollbar_marker_get_scrollbar (_tmp7_);
#line 196 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = _tmp8_;
#line 196 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
#line 196 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = gca_diagnostic_colors_new (_tmp10_);
#line 196 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	colors = _tmp11_;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = sm;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = gca_scrollbar_marker_get_scrollbar (_tmp12_);
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = _tmp13_;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = gca_diagnostic_colors_new (_tmp15_);
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	mixed = _tmp16_;
#line 199 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = mixed;
#line 199 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = self->priv->d_view;
#line 199 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp19_ = gca_view_get_view (_tmp18_);
#line 199 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp20_ = _tmp19_;
#line 199 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostic_colors_mix_in_widget (_tmp17_, (GtkWidget*) _tmp20_);
#line 201 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp21_ = self->priv->d_diagnostics_at_end;
#line 201 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp22_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp21_);
#line 201 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	it = _tmp22_;
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp23_ = self->priv->d_view;
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp24_ = gca_view_get_view (_tmp23_);
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp25_ = _tmp24_;
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp26_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp25_);
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp27_ = _tmp26_;
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	buf = _tmp28_;
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	while (TRUE) {
#line 1507 "gca-diagnostics.c"
		GeeMapIterator* _tmp29_;
		gboolean _tmp30_ = FALSE;
		GtkTextBuffer* _tmp31_;
		GeeMapIterator* _tmp32_;
		gpointer _tmp33_ = NULL;
		GtkTextMark* _tmp34_;
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp29_ = it;
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp30_ = gee_map_iterator_next (_tmp29_);
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (!_tmp30_) {
#line 205 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			break;
#line 1522 "gca-diagnostics.c"
		}
#line 207 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp31_ = buf;
#line 207 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp32_ = it;
#line 207 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp33_ = gee_map_iterator_get_key (_tmp32_);
#line 207 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp34_ = (GtkTextMark*) _tmp33_;
#line 207 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_buffer_delete_mark (_tmp31_, _tmp34_);
#line 207 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (_tmp34_);
#line 1536 "gca-diagnostics.c"
	}
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp35_ = self->priv->d_diagnostics_at_end;
#line 210 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp35_);
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp36_ = sm;
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp37_ = gca_scrollbar_marker_new_merge_id (_tmp36_);
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_last_marker_id = _tmp37_;
#line 1548 "gca-diagnostics.c"
	{
		GcaSourceIndex* _tmp38_;
		GcaSourceIndexIterator* _tmp39_ = NULL;
		GcaSourceIndexIterator* _d_it;
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp38_ = self->priv->d_index;
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp39_ = gca_source_index_iterator (_tmp38_);
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_d_it = _tmp39_;
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		while (TRUE) {
#line 1561 "gca-diagnostics.c"
			GcaSourceIndexIterator* _tmp40_;
			gboolean _tmp41_ = FALSE;
			GcaSourceIndexIterator* _tmp42_;
			gpointer _tmp43_ = NULL;
			GcaDiagnostic* d;
			GcaDiagnosticColors* _tmp44_;
			GcaDiagnostic* _tmp45_;
			GcaDiagnosticSeverity _tmp46_;
			GcaDiagnosticSeverity _tmp47_;
			GdkRGBA* _tmp48_ = NULL;
			GdkRGBA* _tmp49_;
			GdkRGBA _tmp50_;
			GdkRGBA color;
			GcaDiagnosticColors* _tmp51_;
			GcaDiagnostic* _tmp52_;
			GcaDiagnosticSeverity _tmp53_;
			GcaDiagnosticSeverity _tmp54_;
			GdkRGBA* _tmp55_ = NULL;
			GdkRGBA* _tmp56_;
			GdkRGBA _tmp57_;
			GdkRGBA mix;
			GcaDiagnostic* _tmp58_;
			GcaSourceRange* _tmp59_;
			gint _tmp59__length1;
			GcaSourceRange* _tmp60_;
			gint _tmp60__length1;
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp40_ = _d_it;
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp41_ = gca_source_index_iterator_next (_tmp40_);
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			if (!_tmp41_) {
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				break;
#line 1596 "gca-diagnostics.c"
			}
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp42_ = _d_it;
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp43_ = gca_source_index_iterator_get (_tmp42_);
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			d = (GcaDiagnostic*) _tmp43_;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp44_ = colors;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp45_ = d;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp46_ = gca_diagnostic_get_severity (_tmp45_);
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp47_ = _tmp46_;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp48_ = gca_diagnostic_colors_get (_tmp44_, _tmp47_);
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp49_ = _tmp48_;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp50_ = *_tmp49_;
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_g_free0 (_tmp49_);
#line 216 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			color = _tmp50_;
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp51_ = mixed;
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp52_ = d;
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp53_ = gca_diagnostic_get_severity (_tmp52_);
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp54_ = _tmp53_;
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp55_ = gca_diagnostic_colors_get (_tmp51_, _tmp54_);
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp56_ = _tmp55_;
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp57_ = *_tmp56_;
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_g_free0 (_tmp56_);
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			mix = _tmp57_;
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp58_ = d;
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp59_ = gca_source_range_support_get_ranges ((GcaSourceRangeSupport*) _tmp58_, &_tmp59__length1);
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp60_ = _tmp59_;
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp60__length1 = _tmp59__length1;
#line 1648 "gca-diagnostics.c"
			{
				GcaSourceRange* range_collection = NULL;
				gint range_collection_length1 = 0;
				gint _range_collection_size_ = 0;
				gint range_it = 0;
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				range_collection = _tmp60_;
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				range_collection_length1 = _tmp60__length1;
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				for (range_it = 0; range_it < _tmp60__length1; range_it = range_it + 1) {
#line 1660 "gca-diagnostics.c"
					GcaSourceRange range = {0};
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					range = range_collection[range_it];
#line 1664 "gca-diagnostics.c"
					{
						GcaScrollbarMarker* _tmp61_;
						guint _tmp62_;
						GcaSourceRange _tmp63_;
						GdkRGBA _tmp64_;
						gboolean _tmp65_ = FALSE;
						GcaSourceRange _tmp66_;
						GcaSourceLocation _tmp67_;
						gint _tmp68_;
						GcaSourceRange _tmp69_;
						GcaSourceLocation _tmp70_;
						gint _tmp71_;
						gboolean _tmp78_;
#line 221 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp61_ = sm;
#line 221 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp62_ = self->priv->d_last_marker_id;
#line 221 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp63_ = range;
#line 221 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp64_ = color;
#line 221 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						gca_scrollbar_marker_add_with_id (_tmp61_, _tmp62_, &_tmp63_, &_tmp64_);
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp66_ = range;
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp67_ = _tmp66_.start;
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp68_ = _tmp67_.line;
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp69_ = range;
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp70_ = _tmp69_.end;
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp71_ = _tmp70_.line;
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						if (_tmp68_ == _tmp71_) {
#line 1702 "gca-diagnostics.c"
							GcaSourceRange _tmp72_;
							GcaSourceLocation _tmp73_;
							gint _tmp74_;
							GcaSourceRange _tmp75_;
							GcaSourceLocation _tmp76_;
							gint _tmp77_;
#line 224 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp72_ = range;
#line 224 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp73_ = _tmp72_.start;
#line 224 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp74_ = _tmp73_.column;
#line 224 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp75_ = range;
#line 224 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp76_ = _tmp75_.end;
#line 224 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp77_ = _tmp76_.column;
#line 224 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp65_ = _tmp74_ == _tmp77_;
#line 1723 "gca-diagnostics.c"
						} else {
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp65_ = FALSE;
#line 1727 "gca-diagnostics.c"
						}
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						_tmp78_ = _tmp65_;
#line 223 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						if (_tmp78_) {
#line 1733 "gca-diagnostics.c"
							GcaSourceRange _tmp79_;
							GcaSourceLocation _tmp80_;
							gboolean _tmp81_ = FALSE;
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp79_ = range;
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp80_ = _tmp79_.start;
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							_tmp81_ = gca_diagnostics_diagnostic_is_at_end (self, &_tmp80_);
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
							if (_tmp81_) {
#line 1745 "gca-diagnostics.c"
								GcaSourceRange _tmp82_;
								GcaSourceLocation _tmp83_;
								GdkRGBA _tmp84_;
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
								_tmp82_ = range;
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
								_tmp83_ = _tmp82_.start;
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
								_tmp84_ = mix;
#line 228 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
								gca_diagnostics_add_diagnostic_at_end (self, &_tmp83_, &_tmp84_);
#line 1757 "gca-diagnostics.c"
							}
						}
					}
				}
#line 219 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				range_collection = (g_free (range_collection), NULL);
#line 1764 "gca-diagnostics.c"
			}
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_g_object_unref0 (d);
#line 1768 "gca-diagnostics.c"
		}
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (_d_it);
#line 1772 "gca-diagnostics.c"
	}
#line 234 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_update_diagnostic_message (self);
#line 185 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (buf);
#line 185 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (it);
#line 185 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_gca_diagnostic_colors_unref0 (mixed);
#line 185 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_gca_diagnostic_colors_unref0 (colors);
#line 185 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_gca_scrollbar_marker_unref0 (sm);
#line 1786 "gca-diagnostics.c"
}


static void gca_diagnostics_update_marks (GcaDiagnostics* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcaView* _tmp0_;
	GeditView* _tmp1_;
	GeditView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* buf;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextBuffer* _tmp9_;
	GcaDiagnosticTags* _tmp10_;
	GtkTextTag* _tmp11_;
	GtkTextTag* _tmp12_;
	GtkTextIter _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextBuffer* _tmp15_;
	GcaDiagnosticTags* _tmp16_;
	GtkTextTag* _tmp17_;
	GtkTextTag* _tmp18_;
	GtkTextIter _tmp19_;
	GtkTextIter _tmp20_;
	GtkTextBuffer* _tmp21_;
	GcaDiagnosticTags* _tmp22_;
	GtkTextTag* _tmp23_;
	GtkTextTag* _tmp24_;
	GtkTextIter _tmp25_;
	GtkTextIter _tmp26_;
	GtkTextBuffer* _tmp27_;
	GcaDiagnosticTags* _tmp28_;
	GtkTextTag* _tmp29_;
	GtkTextTag* _tmp30_;
	GtkTextIter _tmp31_;
	GtkTextIter _tmp32_;
#line 237 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_view_get_view (_tmp0_);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _tmp3_;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	buf = _tmp5_;
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = buf;
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_get_bounds (_tmp6_, &_tmp7_, &_tmp8_);
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	start = _tmp7_;
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	end = _tmp8_;
#line 246 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = buf;
#line 246 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = self->priv->d_tags;
#line 246 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = gca_diagnostic_tags_get_error_tag (_tmp10_);
#line 246 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = _tmp11_;
#line 246 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = start;
#line 246 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = end;
#line 246 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_remove_tag (_tmp9_, _tmp12_, &_tmp13_, &_tmp14_);
#line 247 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = buf;
#line 247 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = self->priv->d_tags;
#line 247 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = gca_diagnostic_tags_get_warning_tag (_tmp16_);
#line 247 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = _tmp17_;
#line 247 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp19_ = start;
#line 247 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp20_ = end;
#line 247 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_remove_tag (_tmp15_, _tmp18_, &_tmp19_, &_tmp20_);
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp21_ = buf;
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp22_ = self->priv->d_tags;
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp23_ = gca_diagnostic_tags_get_info_tag (_tmp22_);
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp24_ = _tmp23_;
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp25_ = start;
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp26_ = end;
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_remove_tag (_tmp21_, _tmp24_, &_tmp25_, &_tmp26_);
#line 249 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp27_ = buf;
#line 249 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp28_ = self->priv->d_tags;
#line 249 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp29_ = gca_diagnostic_tags_get_fixit_tag (_tmp28_);
#line 249 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp30_ = _tmp29_;
#line 249 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp31_ = start;
#line 249 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp32_ = end;
#line 249 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_remove_tag (_tmp27_, _tmp30_, &_tmp31_, &_tmp32_);
#line 251 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_remove_marks (self);
#line 1909 "gca-diagnostics.c"
	{
		GcaSourceIndex* _tmp33_;
		GcaSourceIndexIterator* _tmp34_ = NULL;
		GcaSourceIndexIterator* _d_it;
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp33_ = self->priv->d_index;
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp34_ = gca_source_index_iterator (_tmp33_);
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_d_it = _tmp34_;
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		while (TRUE) {
#line 1922 "gca-diagnostics.c"
			GcaSourceIndexIterator* _tmp35_;
			gboolean _tmp36_ = FALSE;
			GcaSourceIndexIterator* _tmp37_;
			gpointer _tmp38_ = NULL;
			GcaDiagnostic* d;
			GcaDiagnostic* _tmp39_;
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp35_ = _d_it;
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp36_ = gca_source_index_iterator_next (_tmp35_);
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			if (!_tmp36_) {
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				break;
#line 1937 "gca-diagnostics.c"
			}
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp37_ = _d_it;
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp38_ = gca_source_index_iterator_get (_tmp37_);
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			d = (GcaDiagnostic*) _tmp38_;
#line 255 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp39_ = d;
#line 255 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			gca_diagnostics_mark_diagnostic (self, _tmp39_);
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_g_object_unref0 (d);
#line 1951 "gca-diagnostics.c"
		}
#line 253 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (_d_it);
#line 1955 "gca-diagnostics.c"
	}
#line 237 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (buf);
#line 1959 "gca-diagnostics.c"
}


static GcaDiagnosticSeverity* gca_diagnostics_mark_severities (GcaDiagnostics* self, int* result_length1) {
	GcaDiagnosticSeverity* result = NULL;
	GcaDiagnosticSeverity* _tmp0_ = NULL;
	GcaDiagnosticSeverity* _tmp1_;
	gint _tmp1__length1;
#line 259 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = g_new0 (GcaDiagnosticSeverity, 3);
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_[0] = GCA_DIAGNOSTIC_SEVERITY_ERROR;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_[1] = GCA_DIAGNOSTIC_SEVERITY_WARNING;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_[2] = GCA_DIAGNOSTIC_SEVERITY_INFO;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = _tmp0_;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1__length1 = 3;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (result_length1) {
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		*result_length1 = _tmp1__length1;
#line 1986 "gca-diagnostics.c"
	}
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp1_;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 1992 "gca-diagnostics.c"
}


static gchar* _gca_diagnostics_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* mark, gpointer self) {
	gchar* result;
	result = gca_diagnostics_on_diagnostic_tooltip (self, mark);
#line 275 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 2001 "gca-diagnostics.c"
}


static void gca_diagnostics_register_marks (GcaDiagnostics* self) {
	gint _tmp0_ = 0;
	GcaDiagnosticSeverity* _tmp1_ = NULL;
#line 268 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_diagnostics_mark_severities (self, &_tmp0_);
#line 2012 "gca-diagnostics.c"
	{
		GcaDiagnosticSeverity* sev_collection = NULL;
		gint sev_collection_length1 = 0;
		gint _sev_collection_size_ = 0;
		gint sev_it = 0;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		sev_collection = _tmp1_;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		sev_collection_length1 = _tmp0_;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		for (sev_it = 0; sev_it < _tmp0_; sev_it = sev_it + 1) {
#line 2024 "gca-diagnostics.c"
			GcaDiagnosticSeverity sev = 0;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			sev = sev_collection[sev_it];
#line 2028 "gca-diagnostics.c"
			{
				GtkSourceMarkAttributes* _tmp2_;
				GtkSourceMarkAttributes* attr;
				GtkSourceMarkAttributes* _tmp3_;
				GcaDiagnosticSeverity _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				GThemedIcon* _tmp7_;
				GThemedIcon* _tmp8_;
				GtkSourceMarkAttributes* _tmp9_;
				GcaView* _tmp10_;
				GeditView* _tmp11_;
				GeditView* _tmp12_;
				GcaDiagnosticSeverity _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				GtkSourceMarkAttributes* _tmp16_;
#line 272 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp2_ = gtk_source_mark_attributes_new ();
#line 272 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				attr = _tmp2_;
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp3_ = attr;
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp4_ = sev;
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp5_ = gca_diagnostics_icon_name_for_severity (_tmp4_);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp6_ = _tmp5_;
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks (_tmp6_);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp8_ = _tmp7_;
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				gtk_source_mark_attributes_set_gicon (_tmp3_, (GIcon*) _tmp8_);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_object_unref0 (_tmp8_);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_free0 (_tmp6_);
#line 275 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp9_ = attr;
#line 275 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				g_signal_connect_object (_tmp9_, "query-tooltip-markup", (GCallback) _gca_diagnostics_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp10_ = self->priv->d_view;
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp11_ = gca_view_get_view (_tmp10_);
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp12_ = _tmp11_;
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13_ = sev;
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp14_ = gca_diagnostics_mark_category_for_severity (_tmp13_);
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp15_ = _tmp14_;
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp16_ = attr;
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				gtk_source_view_set_mark_attributes ((GtkSourceView*) _tmp12_, _tmp15_, _tmp16_, 0);
#line 277 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_free0 (_tmp15_);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_object_unref0 (attr);
#line 2092 "gca-diagnostics.c"
			}
		}
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		sev_collection = (g_free (sev_collection), NULL);
#line 2097 "gca-diagnostics.c"
	}
}


static void gca_diagnostics_unregister_marks (GcaDiagnostics* self) {
	gint _tmp0_ = 0;
	GcaDiagnosticSeverity* _tmp1_ = NULL;
#line 281 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_diagnostics_mark_severities (self, &_tmp0_);
#line 2109 "gca-diagnostics.c"
	{
		GcaDiagnosticSeverity* sev_collection = NULL;
		gint sev_collection_length1 = 0;
		gint _sev_collection_size_ = 0;
		gint sev_it = 0;
#line 283 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		sev_collection = _tmp1_;
#line 283 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		sev_collection_length1 = _tmp0_;
#line 283 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		for (sev_it = 0; sev_it < _tmp0_; sev_it = sev_it + 1) {
#line 2121 "gca-diagnostics.c"
			GcaDiagnosticSeverity sev = 0;
#line 283 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			sev = sev_collection[sev_it];
#line 2125 "gca-diagnostics.c"
			{
				GtkSourceMarkAttributes* _tmp2_;
				GtkSourceMarkAttributes* attr;
				GcaView* _tmp3_;
				GeditView* _tmp4_;
				GeditView* _tmp5_;
				GcaDiagnosticSeverity _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				GtkSourceMarkAttributes* _tmp9_;
#line 285 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp2_ = gtk_source_mark_attributes_new ();
#line 285 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				attr = _tmp2_;
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp3_ = self->priv->d_view;
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp4_ = gca_view_get_view (_tmp3_);
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp5_ = _tmp4_;
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp6_ = sev;
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7_ = gca_diagnostics_mark_category_for_severity (_tmp6_);
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp8_ = _tmp7_;
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp9_ = attr;
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				gtk_source_view_set_mark_attributes ((GtkSourceView*) _tmp5_, _tmp8_, _tmp9_, 0);
#line 286 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_free0 (_tmp8_);
#line 283 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_object_unref0 (attr);
#line 2160 "gca-diagnostics.c"
			}
		}
#line 283 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		sev_collection = (g_free (sev_collection), NULL);
#line 2165 "gca-diagnostics.c"
	}
}


void gca_diagnostics_destroy (GcaDiagnostics* self) {
	GcaView* _tmp0_;
	GcaView* _tmp1_;
	GeditView* _tmp2_;
	GeditView* _tmp3_;
	GeditView* _tmp4_;
	GeditView* view;
	GeditView* _tmp5_;
	GeditView* _tmp6_;
	guint _tmp7_ = 0U;
	GeditView* _tmp8_;
	guint _tmp9_ = 0U;
	GcaView* _tmp10_;
	GcaDocument* _tmp11_;
	GcaDocument* _tmp12_;
	GeditDocument* _tmp13_;
	GeditDocument* _tmp14_;
	GeditDocument* _tmp15_;
	GeditDocument* doc;
	GeditDocument* _tmp16_;
	guint _tmp17_ = 0U;
	GeditDocument* _tmp18_;
	guint _tmp19_ = 0U;
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 292 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 292 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp0_ == NULL) {
#line 294 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return;
#line 2201 "gca-diagnostics.c"
	}
#line 297 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_remove_marks (self);
#line 298 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_unregister_marks (self);
#line 300 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = self->priv->d_view;
#line 300 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = gca_view_get_view (_tmp1_);
#line 300 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = _tmp2_;
#line 300 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 300 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	view = _tmp4_;
#line 301 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = view;
#line 301 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_source_view_set_show_line_marks ((GtkSourceView*) _tmp5_, FALSE);
#line 302 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = view;
#line 302 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_parse_name ("query-tooltip", GTK_TYPE_WIDGET, &_tmp7_, NULL, FALSE);
#line 302 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip, self);
#line 303 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = view;
#line 303 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_parse_name ("draw", GTK_TYPE_WIDGET, &_tmp9_, NULL, FALSE);
#line 303 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gca_diagnostics_on_view_draw_gtk_widget_draw, self);
#line 305 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = self->priv->d_view;
#line 305 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = gca_view_get_document (_tmp10_);
#line 305 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = _tmp11_;
#line 305 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = gca_document_get_document (_tmp12_);
#line 305 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = _tmp13_;
#line 305 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 305 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	doc = _tmp15_;
#line 306 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = doc;
#line 306 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_parse_name ("mark-set", GTK_TYPE_TEXT_BUFFER, &_tmp17_, NULL, FALSE);
#line 306 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set, self);
#line 307 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = doc;
#line 307 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_parse_name ("cursor-moved", gedit_document_get_type (), &_tmp19_, NULL, FALSE);
#line 307 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved, self);
#line 309 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_view);
#line 309 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_view = NULL;
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (doc);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (view);
#line 2267 "gca-diagnostics.c"
}


static void gca_diagnostics_remove_marks (GcaDiagnostics* self) {
	GcaView* _tmp0_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcaView* _tmp1_;
	GcaDocument* _tmp2_;
	GcaDocument* _tmp3_;
	GeditDocument* _tmp4_;
	GeditDocument* _tmp5_;
	GeditDocument* _tmp6_;
	GeditDocument* buf;
	GeditDocument* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	GeditDocument* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextIter _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GeditDocument* _tmp15_;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter _tmp17_ = {0};
	GeditDocument* _tmp18_;
	GtkTextIter _tmp19_;
	GtkTextIter _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GeditDocument* _tmp23_;
	GtkTextIter _tmp24_ = {0};
	GtkTextIter _tmp25_ = {0};
	GeditDocument* _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextIter _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
#line 312 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 314 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp0_ == NULL) {
#line 316 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return;
#line 2314 "gca-diagnostics.c"
	}
#line 322 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = self->priv->d_view;
#line 322 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = gca_view_get_document (_tmp1_);
#line 322 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = _tmp2_;
#line 322 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = gca_document_get_document (_tmp3_);
#line 322 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _tmp4_;
#line 322 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 322 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	buf = _tmp6_;
#line 324 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = buf;
#line 324 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp7_, &_tmp8_, &_tmp9_);
#line 324 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	start = _tmp8_;
#line 324 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	end = _tmp9_;
#line 325 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = buf;
#line 325 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = start;
#line 325 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = end;
#line 325 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = gca_diagnostics_get_info_mark_category ();
#line 325 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = _tmp13_;
#line 325 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp10_, &_tmp11_, &_tmp12_, _tmp14_);
#line 327 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = buf;
#line 327 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp15_, &_tmp16_, &_tmp17_);
#line 327 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	start = _tmp16_;
#line 327 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	end = _tmp17_;
#line 328 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = buf;
#line 328 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp19_ = start;
#line 328 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp20_ = end;
#line 328 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp21_ = gca_diagnostics_get_warning_mark_category ();
#line 328 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp22_ = _tmp21_;
#line 328 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp18_, &_tmp19_, &_tmp20_, _tmp22_);
#line 330 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp23_ = buf;
#line 330 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
#line 330 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	start = _tmp24_;
#line 330 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	end = _tmp25_;
#line 331 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp26_ = buf;
#line 331 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp27_ = start;
#line 331 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp28_ = end;
#line 331 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp29_ = gca_diagnostics_get_error_mark_category ();
#line 331 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp30_ = _tmp29_;
#line 331 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp26_, &_tmp27_, &_tmp28_, _tmp30_);
#line 312 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (buf);
#line 2392 "gca-diagnostics.c"
}


gchar* gca_diagnostics_mark_category_for_severity (GcaDiagnosticSeverity severity) {
	gchar* result = NULL;
	GcaDiagnosticSeverity _tmp0_;
#line 336 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = severity;
#line 336 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	switch (_tmp0_) {
#line 336 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_WARNING:
#line 336 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_DEPRECATED:
#line 2407 "gca-diagnostics.c"
		{
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 340 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp1_ = gca_diagnostics_get_warning_mark_category ();
#line 340 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp2_ = _tmp1_;
#line 340 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 340 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = _tmp3_;
#line 340 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2422 "gca-diagnostics.c"
		}
#line 336 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_ERROR:
#line 336 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_FATAL:
#line 2428 "gca-diagnostics.c"
		{
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 343 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp4_ = gca_diagnostics_get_error_mark_category ();
#line 343 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp5_ = _tmp4_;
#line 343 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 343 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = _tmp6_;
#line 343 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2443 "gca-diagnostics.c"
		}
#line 336 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_INFO:
#line 2447 "gca-diagnostics.c"
		{
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
#line 345 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp7_ = gca_diagnostics_get_info_mark_category ();
#line 345 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp8_ = _tmp7_;
#line 345 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 345 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = _tmp9_;
#line 345 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2462 "gca-diagnostics.c"
		}
		default:
		{
#line 347 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = NULL;
#line 347 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2470 "gca-diagnostics.c"
		}
	}
}


gchar* gca_diagnostics_icon_name_for_severity (GcaDiagnosticSeverity severity) {
	gchar* result = NULL;
	GcaDiagnosticSeverity _tmp0_;
#line 353 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = severity;
#line 353 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	switch (_tmp0_) {
#line 353 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_WARNING:
#line 353 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_DEPRECATED:
#line 2487 "gca-diagnostics.c"
		{
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 357 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp1_ = gca_diagnostics_get_warning_icon_name ();
#line 357 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp2_ = _tmp1_;
#line 357 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 357 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = _tmp3_;
#line 357 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2502 "gca-diagnostics.c"
		}
#line 353 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_ERROR:
#line 353 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_FATAL:
#line 2508 "gca-diagnostics.c"
		{
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 360 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp4_ = gca_diagnostics_get_error_icon_name ();
#line 360 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp5_ = _tmp4_;
#line 360 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 360 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = _tmp6_;
#line 360 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2523 "gca-diagnostics.c"
		}
#line 353 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		case GCA_DIAGNOSTIC_SEVERITY_INFO:
#line 2527 "gca-diagnostics.c"
		{
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
#line 362 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp7_ = gca_diagnostics_get_info_icon_name ();
#line 362 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp8_ = _tmp7_;
#line 362 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 362 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = _tmp9_;
#line 362 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2542 "gca-diagnostics.c"
		}
		default:
		{
#line 364 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			result = NULL;
#line 364 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			return result;
#line 2550 "gca-diagnostics.c"
		}
	}
}


static GcaDiagnostic** _vala_array_dup4 (GcaDiagnostic** self, int length) {
	GcaDiagnostic** result;
	int i;
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = g_new0 (GcaDiagnostic*, length + 1);
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	for (i = 0; i < length; i++) {
#line 2563 "gca-diagnostics.c"
		GcaDiagnostic* _tmp0_;
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result[i] = _tmp0_;
#line 2569 "gca-diagnostics.c"
	}
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 2573 "gca-diagnostics.c"
}


static gint __lambda11_ (GcaDiagnostics* self, GcaDiagnostic* a, GcaDiagnostic* b) {
	gint result = 0;
	GcaDiagnostic* _tmp0_;
	GcaDiagnosticSeverity _tmp1_;
	GcaDiagnosticSeverity _tmp2_;
	GcaDiagnostic* _tmp3_;
	GcaDiagnosticSeverity _tmp4_;
	GcaDiagnosticSeverity _tmp5_;
	gint _tmp6_ = 0;
	GcaDiagnostic* _tmp7_;
	GcaDiagnosticSeverity _tmp8_;
	GcaDiagnosticSeverity _tmp9_;
	GcaDiagnostic* _tmp10_;
	GcaDiagnosticSeverity _tmp11_;
	GcaDiagnosticSeverity _tmp12_;
	gint _tmp13_;
#line 372 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 372 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 373 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = a;
#line 373 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_diagnostic_get_severity (_tmp0_);
#line 373 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 373 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = b;
#line 373 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = gca_diagnostic_get_severity (_tmp3_);
#line 373 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _tmp4_;
#line 373 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp2_ == _tmp5_) {
#line 375 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = 0;
#line 375 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 2615 "gca-diagnostics.c"
	}
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = a;
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = gca_diagnostic_get_severity (_tmp7_);
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = _tmp8_;
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = b;
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = gca_diagnostic_get_severity (_tmp10_);
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = _tmp11_;
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp9_ < _tmp12_) {
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp6_ = -1;
#line 2633 "gca-diagnostics.c"
	} else {
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp6_ = 1;
#line 2637 "gca-diagnostics.c"
	}
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = _tmp6_;
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp13_;
#line 379 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 2645 "gca-diagnostics.c"
}


static gint ___lambda11__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda11_ (self, a, b);
#line 372 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 2654 "gca-diagnostics.c"
}


static GcaDiagnostic** gca_diagnostics_sorted_on_severity (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GcaDiagnostic** _tmp0_;
	gint _tmp0__length1;
	GcaDiagnostic** _tmp1_;
	gint _tmp1__length1;
	GeeArrayList* _tmp2_;
	GeeArrayList* lst;
	gint _tmp3_ = 0;
	gpointer* _tmp4_ = NULL;
	GcaDiagnostic** _tmp5_;
	gint _tmp5__length1;
#line 368 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = diagnostics;
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0__length1 = diagnostics_length1;
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1__length1 = _tmp0__length1;
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = gee_array_list_new_wrap (GCA_TYPE_DIAGNOSTIC, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp1_, _tmp1__length1, NULL, NULL, NULL);
#line 370 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	lst = _tmp2_;
#line 372 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gee_list_sort ((GeeList*) lst, ___lambda11__gcompare_data_func, g_object_ref (self), g_object_unref);
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = gee_collection_to_array ((GeeCollection*) lst, &_tmp3_);
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _tmp4_;
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5__length1 = _tmp3_;
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (result_length1) {
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		*result_length1 = _tmp5__length1;
#line 2696 "gca-diagnostics.c"
	}
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp5_;
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (lst);
#line 382 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 2704 "gca-diagnostics.c"
}


static GcaDiagnostic** gca_diagnostics_find_at (GcaDiagnostics* self, GcaSourceRange* range, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GcaSourceIndex* _tmp0_;
	GcaSourceRange _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_ = NULL;
	GcaDiagnostic** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	GcaDiagnostic** _tmp6_ = NULL;
	GcaDiagnostic** _tmp7_;
	gint _tmp7__length1;
	GcaDiagnostic** _tmp8_;
	gint _tmp8__length1;
#line 385 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 385 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (range != NULL, NULL);
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_index;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = *range;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gca_source_index_find_at (_tmp0_, &_tmp1_, &_tmp2_);
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _tmp3_;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4__length1 = _tmp2_;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = gca_diagnostics_sorted_on_severity (self, _tmp4_, _tmp2_, &_tmp5_);
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = _tmp6_;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7__length1 = _tmp5_;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = _tmp7_;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8__length1 = _tmp7__length1;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (result_length1) {
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		*result_length1 = _tmp8__length1;
#line 2752 "gca-diagnostics.c"
	}
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp8_;
#line 387 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 2758 "gca-diagnostics.c"
}


static GcaDiagnostic** gca_diagnostics_find_at_line (GcaDiagnostics* self, gint line, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GcaSourceIndex* _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_ = NULL;
	GcaDiagnostic** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	GcaDiagnostic** _tmp6_ = NULL;
	GcaDiagnostic** _tmp7_;
	gint _tmp7__length1;
	GcaDiagnostic** _tmp8_;
	gint _tmp8__length1;
#line 390 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_index;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = line;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gca_source_index_find_at_line (_tmp0_, _tmp1_, &_tmp2_);
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _tmp3_;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4__length1 = _tmp2_;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = gca_diagnostics_sorted_on_severity (self, _tmp4_, _tmp2_, &_tmp5_);
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = _tmp6_;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7__length1 = _tmp5_;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = _tmp7_;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8__length1 = _tmp7__length1;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (result_length1) {
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		*result_length1 = _tmp8__length1;
#line 2804 "gca-diagnostics.c"
	}
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp8_;
#line 392 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 2810 "gca-diagnostics.c"
}


static void gca_diagnostics_mark_diagnostic_range (GcaDiagnostics* self, GcaDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end) {
	GcaDiagnosticTags* _tmp0_;
	GcaDiagnostic* _tmp1_;
	GcaDiagnosticSeverity _tmp2_;
	GcaDiagnosticSeverity _tmp3_;
	GtkTextTag* _tmp4_ = NULL;
	GtkTextTag* tag;
	GcaDiagnostic* _tmp5_;
	GcaDiagnosticSeverity _tmp6_;
	GcaDiagnosticSeverity _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* category;
	GcaView* _tmp9_;
	GcaDocument* _tmp10_;
	GcaDocument* _tmp11_;
	GeditDocument* _tmp12_;
	GeditDocument* _tmp13_;
	GeditDocument* _tmp14_;
	GeditDocument* doc;
	GeditDocument* _tmp15_;
	GtkTextTag* _tmp16_;
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_;
	GtkTextIter _tmp19_;
	GtkTextIter m;
	gboolean _tmp20_ = FALSE;
#line 395 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 395 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (diagnostic != NULL);
#line 395 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (start != NULL);
#line 395 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (end != NULL);
#line 399 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_tags;
#line 399 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = diagnostic;
#line 399 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = gca_diagnostic_get_severity (_tmp1_);
#line 399 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = _tmp2_;
#line 399 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = gca_diagnostic_tags_get (_tmp0_, _tmp3_);
#line 399 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	tag = _tmp4_;
#line 400 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = diagnostic;
#line 400 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = gca_diagnostic_get_severity (_tmp5_);
#line 400 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = _tmp6_;
#line 400 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = gca_diagnostics_mark_category_for_severity (_tmp7_);
#line 400 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	category = _tmp8_;
#line 402 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = self->priv->d_view;
#line 402 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = gca_view_get_document (_tmp9_);
#line 402 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = _tmp10_;
#line 402 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = gca_document_get_document (_tmp11_);
#line 402 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = _tmp12_;
#line 402 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 402 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	doc = _tmp14_;
#line 404 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = doc;
#line 404 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = tag;
#line 404 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = *start;
#line 404 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = *end;
#line 404 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp15_, _tmp16_, &_tmp17_, &_tmp18_);
#line 406 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp19_ = *start;
#line 406 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	m = _tmp19_;
#line 408 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp20_ = gtk_text_iter_starts_line (&m);
#line 408 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (!_tmp20_) {
#line 410 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_iter_set_line_offset (&m, 0);
#line 2904 "gca-diagnostics.c"
	}
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	while (TRUE) {
#line 2908 "gca-diagnostics.c"
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		gboolean _tmp25_;
		gboolean alreadyhas;
		GeditDocument* _tmp26_;
		GtkTextIter _tmp27_;
		const gchar* _tmp28_;
		GSList* _tmp29_ = NULL;
		gboolean _tmp33_;
		gboolean _tmp42_ = FALSE;
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp22_ = category;
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (_tmp22_ != NULL) {
#line 2923 "gca-diagnostics.c"
			GtkTextIter _tmp23_;
			gint _tmp24_ = 0;
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp23_ = *end;
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp24_ = gtk_text_iter_compare (&m, &_tmp23_);
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp21_ = _tmp24_ <= 0;
#line 2932 "gca-diagnostics.c"
		} else {
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp21_ = FALSE;
#line 2936 "gca-diagnostics.c"
		}
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp25_ = _tmp21_;
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (!_tmp25_) {
#line 413 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			break;
#line 2944 "gca-diagnostics.c"
		}
#line 415 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		alreadyhas = FALSE;
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp26_ = doc;
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp27_ = m;
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp28_ = category;
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp29_ = gtk_source_buffer_get_source_marks_at_iter ((GtkSourceBuffer*) _tmp26_, &_tmp27_, _tmp28_);
#line 2956 "gca-diagnostics.c"
		{
			GSList* mark_collection = NULL;
			GSList* mark_it = NULL;
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			mark_collection = _tmp29_;
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			for (mark_it = mark_collection; mark_it != NULL; mark_it = mark_it->next) {
#line 2964 "gca-diagnostics.c"
				GtkSourceMark* mark = NULL;
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				mark = (GtkSourceMark*) mark_it->data;
#line 2968 "gca-diagnostics.c"
				{
					GtkSourceMark* _tmp30_;
					gconstpointer _tmp31_ = NULL;
					GcaDiagnostic* _tmp32_;
#line 419 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp30_ = mark;
#line 419 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp31_ = g_object_get_data ((GObject*) _tmp30_, "Gca.Document.MarkDiagnostic");
#line 419 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp32_ = diagnostic;
#line 419 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					if (((GcaDiagnostic*) _tmp31_) == _tmp32_) {
#line 421 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						alreadyhas = TRUE;
#line 422 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
						break;
#line 2985 "gca-diagnostics.c"
					}
				}
			}
#line 417 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_g_slist_free0 (mark_collection);
#line 2991 "gca-diagnostics.c"
		}
#line 426 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp33_ = alreadyhas;
#line 426 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (!_tmp33_) {
#line 2997 "gca-diagnostics.c"
			GeditDocument* _tmp34_;
			const gchar* _tmp35_;
			GtkTextIter _tmp36_;
			GtkSourceMark* _tmp37_ = NULL;
			GtkSourceMark* _tmp38_;
			GtkSourceMark* mark;
			GtkSourceMark* _tmp39_;
			GcaDiagnostic* _tmp40_;
			GcaDiagnostic* _tmp41_;
#line 428 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp34_ = doc;
#line 428 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp35_ = category;
#line 428 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp36_ = m;
#line 428 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp37_ = gtk_source_buffer_create_source_mark ((GtkSourceBuffer*) _tmp34_, NULL, _tmp35_, &_tmp36_);
#line 428 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp38_ = _g_object_ref0 (_tmp37_);
#line 428 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			mark = _tmp38_;
#line 430 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp39_ = mark;
#line 430 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp40_ = diagnostic;
#line 430 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp41_ = _g_object_ref0 (_tmp40_);
#line 430 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			g_object_set_data_full ((GObject*) _tmp39_, "Gca.Document.MarkDiagnostic", _tmp41_, g_object_unref);
#line 426 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_g_object_unref0 (mark);
#line 3029 "gca-diagnostics.c"
		}
#line 433 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp42_ = gtk_text_iter_forward_line (&m);
#line 433 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (!_tmp42_) {
#line 435 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			break;
#line 3037 "gca-diagnostics.c"
		}
	}
#line 395 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (doc);
#line 395 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_free0 (category);
#line 395 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (tag);
#line 3046 "gca-diagnostics.c"
}


static void gca_diagnostics_mark_diagnostic (GcaDiagnostics* self, GcaDiagnostic* diagnostic) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcaView* _tmp0_;
	GcaDocument* _tmp1_;
	GcaDocument* _tmp2_;
	GeditDocument* _tmp3_;
	GeditDocument* _tmp4_;
	GeditDocument* _tmp5_;
	GeditDocument* doc;
#line 440 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 440 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (diagnostic != NULL);
#line 445 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 445 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_view_get_document (_tmp0_);
#line 445 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 445 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gca_document_get_document (_tmp2_);
#line 445 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _tmp3_;
#line 445 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 445 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	doc = _tmp5_;
#line 3078 "gca-diagnostics.c"
	{
		guint i;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		i = (guint) 0;
#line 3083 "gca-diagnostics.c"
		{
			gboolean _tmp6_;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp6_ = TRUE;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			while (TRUE) {
#line 3090 "gca-diagnostics.c"
				gboolean _tmp7_;
				guint _tmp9_;
				GcaDiagnostic* _tmp10_;
				GcaSourceRange* _tmp11_;
				gint _tmp11__length1;
				GcaSourceRange* _tmp12_;
				gint _tmp12__length1;
				GcaSourceRange* _tmp13_;
				gint _tmp13__length1;
				gboolean _tmp14_;
				GcaDiagnostic* _tmp15_;
				GcaSourceRange* _tmp16_;
				gint _tmp16__length1;
				GcaSourceRange* _tmp17_;
				gint _tmp17__length1;
				GcaSourceRange* _tmp18_;
				gint _tmp18__length1;
				guint _tmp19_;
				GeditDocument* _tmp20_;
				GtkTextIter _tmp21_ = {0};
				GtkTextIter _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_;
				GcaDiagnostic* _tmp25_;
				GtkTextIter _tmp26_;
				GtkTextIter _tmp27_;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7_ = _tmp6_;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!_tmp7_) {
#line 3121 "gca-diagnostics.c"
					guint _tmp8_;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp8_ = i;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					i = _tmp8_ + 1;
#line 3127 "gca-diagnostics.c"
				}
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp6_ = FALSE;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp9_ = i;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp10_ = diagnostic;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp11_ = gca_source_range_support_get_ranges ((GcaSourceRangeSupport*) _tmp10_, &_tmp11__length1);
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp12_ = _tmp11_;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp12__length1 = _tmp11__length1;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13_ = _tmp12_;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13__length1 = _tmp12__length1;
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp14_ = !(_tmp9_ < ((guint) _tmp12__length1));
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13_ = (g_free (_tmp13_), NULL);
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (_tmp14_) {
#line 447 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					break;
#line 3153 "gca-diagnostics.c"
				}
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp15_ = diagnostic;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp16_ = gca_source_range_support_get_ranges ((GcaSourceRangeSupport*) _tmp15_, &_tmp16__length1);
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp17_ = _tmp16_;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp17__length1 = _tmp16__length1;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp18_ = _tmp17_;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp18__length1 = _tmp17__length1;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp19_ = i;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp20_ = doc;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp23_ = gca_source_range_get_iters (&_tmp18_[_tmp19_], (GtkTextBuffer*) _tmp20_, &_tmp21_, &_tmp22_);
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				start = _tmp21_;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				end = _tmp22_;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp24_ = !_tmp23_;
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp18_ = (g_free (_tmp18_), NULL);
#line 449 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (_tmp24_) {
#line 451 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					continue;
#line 3185 "gca-diagnostics.c"
				}
#line 454 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp25_ = diagnostic;
#line 454 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp26_ = start;
#line 454 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp27_ = end;
#line 454 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				gca_diagnostics_mark_diagnostic_range (self, _tmp25_, &_tmp26_, &_tmp27_);
#line 3195 "gca-diagnostics.c"
			}
		}
	}
	{
		guint i;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		i = (guint) 0;
#line 3203 "gca-diagnostics.c"
		{
			gboolean _tmp28_;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp28_ = TRUE;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			while (TRUE) {
#line 3210 "gca-diagnostics.c"
				gboolean _tmp29_;
				guint _tmp31_;
				GcaDiagnostic* _tmp32_;
				GcaDiagnosticFixit* _tmp33_;
				gint _tmp33__length1;
				GcaDiagnosticFixit* _tmp34_;
				gint _tmp34__length1;
				GcaDiagnostic* _tmp35_;
				GcaDiagnosticFixit* _tmp36_;
				gint _tmp36__length1;
				GcaDiagnosticFixit* _tmp37_;
				gint _tmp37__length1;
				guint _tmp38_;
				GcaDiagnosticFixit _tmp39_;
				GcaSourceRange _tmp40_;
				GcaSourceRange r;
				GeditDocument* _tmp41_;
				GtkTextIter _tmp42_ = {0};
				GtkTextIter _tmp43_ = {0};
				gboolean _tmp44_ = FALSE;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp29_ = _tmp28_;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!_tmp29_) {
#line 3235 "gca-diagnostics.c"
					guint _tmp30_;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp30_ = i;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					i = _tmp30_ + 1;
#line 3241 "gca-diagnostics.c"
				}
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp28_ = FALSE;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp31_ = i;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp32_ = diagnostic;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp33_ = gca_diagnostic_get_fixits (_tmp32_, &_tmp33__length1);
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp34_ = _tmp33_;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp34__length1 = _tmp33__length1;
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!(_tmp31_ < ((guint) _tmp34__length1))) {
#line 457 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					break;
#line 3259 "gca-diagnostics.c"
				}
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp35_ = diagnostic;
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp36_ = gca_diagnostic_get_fixits (_tmp35_, &_tmp36__length1);
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp37_ = _tmp36_;
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp37__length1 = _tmp36__length1;
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp38_ = i;
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp39_ = _tmp37_[_tmp38_];
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp40_ = _tmp39_.range;
#line 459 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				r = _tmp40_;
#line 461 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp41_ = doc;
#line 461 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp44_ = gca_source_range_get_iters (&r, (GtkTextBuffer*) _tmp41_, &_tmp42_, &_tmp43_);
#line 461 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				start = _tmp42_;
#line 461 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				end = _tmp43_;
#line 461 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (_tmp44_) {
#line 3287 "gca-diagnostics.c"
					GeditDocument* _tmp45_;
					GcaDiagnosticTags* _tmp46_;
					GtkTextTag* _tmp47_;
					GtkTextTag* _tmp48_;
					GtkTextIter _tmp49_;
					GtkTextIter _tmp50_;
#line 463 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp45_ = doc;
#line 463 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp46_ = self->priv->d_tags;
#line 463 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp47_ = gca_diagnostic_tags_get_fixit_tag (_tmp46_);
#line 463 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp48_ = _tmp47_;
#line 463 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp49_ = start;
#line 463 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp50_ = end;
#line 463 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp45_, _tmp48_, &_tmp49_, &_tmp50_);
#line 3308 "gca-diagnostics.c"
				}
			}
		}
	}
#line 440 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (doc);
#line 3315 "gca-diagnostics.c"
}


static gboolean gca_diagnostics_diagnostic_is_at_end (GcaDiagnostics* self, GcaSourceLocation* location) {
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	GcaView* _tmp0_;
	GeditView* _tmp1_;
	GeditView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GcaSourceLocation _tmp5_;
	gint _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GcaSourceLocation _tmp8_;
	gint _tmp9_;
	gint _tmp10_ = 0;
	GcaSourceLocation _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_ = FALSE;
#line 468 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 468 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (location != NULL, FALSE);
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_view_get_view (_tmp0_);
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _tmp3_;
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = *location;
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = _tmp5_.line;
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_get_iter_at_line (_tmp4_, &_tmp7_, _tmp6_ - 1);
#line 472 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	iter = _tmp7_;
#line 473 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = *location;
#line 473 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = _tmp8_.column;
#line 473 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_iter_forward_chars (&iter, _tmp9_ - 1);
#line 475 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = gtk_text_iter_get_line (&iter);
#line 475 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = *location;
#line 475 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = _tmp11_.line;
#line 475 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp10_ != (_tmp12_ - 1)) {
#line 477 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = FALSE;
#line 477 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 3376 "gca-diagnostics.c"
	}
#line 480 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = gtk_text_iter_ends_line (&iter);
#line 480 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp13_;
#line 480 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 3384 "gca-diagnostics.c"
}


static void gca_diagnostics_add_diagnostic_at_end (GcaDiagnostics* self, GcaSourceLocation* location, GdkRGBA* color) {
	GtkTextIter iter = {0};
	GcaView* _tmp0_;
	GeditView* _tmp1_;
	GeditView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GcaSourceLocation _tmp5_;
	gint _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GcaView* _tmp8_;
	GeditView* _tmp9_;
	GeditView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextIter _tmp13_;
	GtkTextMark* _tmp14_ = NULL;
	GtkTextMark* _tmp15_;
	GtkTextMark* mark;
	GeeHashMap* _tmp16_;
	GdkRGBA _tmp17_;
#line 483 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 483 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (location != NULL);
#line 483 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (color != NULL);
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_view_get_view (_tmp0_);
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _tmp3_;
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = *location;
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = _tmp5_.line;
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_get_iter_at_line (_tmp4_, &_tmp7_, _tmp6_ - 1);
#line 488 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	iter = _tmp7_;
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = self->priv->d_view;
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = gca_view_get_view (_tmp8_);
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = _tmp9_;
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp10_);
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = _tmp11_;
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = iter;
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = gtk_text_buffer_create_mark (_tmp12_, NULL, &_tmp13_, FALSE);
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 490 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	mark = _tmp15_;
#line 491 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = self->priv->d_diagnostics_at_end;
#line 491 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = *color;
#line 491 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, mark, &_tmp17_);
#line 483 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (mark);
#line 3459 "gca-diagnostics.c"
}


static gboolean gca_diagnostics_on_view_draw (GcaDiagnostics* self, cairo_t* ctx) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GcaView* _tmp3_;
	GeditView* _tmp4_;
	GeditView* _tmp5_;
	GeditView* _tmp6_;
	GeditView* view;
	GeditView* _tmp7_;
	GdkWindow* _tmp8_ = NULL;
	GdkWindow* _tmp9_;
	GdkWindow* window;
	cairo_t* _tmp10_;
	GdkWindow* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GeeHashMap* _tmp13_;
	GeeMapIterator* _tmp14_ = NULL;
	GeeMapIterator* it;
	cairo_t* _tmp15_;
	GeditView* _tmp16_;
	GdkWindow* _tmp17_;
	GdkRectangle rect = {0};
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditView* _tmp18_;
	GdkRectangle _tmp19_ = {0};
	GeditView* _tmp20_;
	GdkRectangle _tmp21_;
	gint _tmp22_;
	GtkTextIter _tmp23_ = {0};
	GeditView* _tmp24_;
	GdkRectangle _tmp25_;
	gint _tmp26_;
	GdkRectangle _tmp27_;
	gint _tmp28_;
	GtkTextIter _tmp29_ = {0};
	GdkWindow* _tmp30_;
	gint _tmp31_ = 0;
	gint window_width;
	GeditView* _tmp32_;
	GtkTextBuffer* _tmp33_;
	GtkTextBuffer* _tmp34_;
	GtkTextBuffer* _tmp35_;
	GtkTextBuffer* buf;
#line 494 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 494 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 496 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_diagnostics_at_end;
#line 496 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
#line 496 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 496 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp2_ == 0) {
#line 498 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = FALSE;
#line 498 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 3525 "gca-diagnostics.c"
	}
#line 501 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = self->priv->d_view;
#line 501 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = gca_view_get_view (_tmp3_);
#line 501 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _tmp4_;
#line 501 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 501 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	view = _tmp6_;
#line 503 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = view;
#line 503 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = gtk_text_view_get_window ((GtkTextView*) _tmp7_, GTK_TEXT_WINDOW_TEXT);
#line 503 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 503 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	window = _tmp9_;
#line 505 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = ctx;
#line 505 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = window;
#line 505 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = gtk_cairo_should_draw_window (_tmp10_, _tmp11_);
#line 505 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (!_tmp12_) {
#line 507 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = FALSE;
#line 507 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (window);
#line 507 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (view);
#line 507 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 3561 "gca-diagnostics.c"
	}
#line 510 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = self->priv->d_diagnostics_at_end;
#line 510 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp13_);
#line 510 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	it = _tmp14_;
#line 512 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = ctx;
#line 512 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = view;
#line 512 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = window;
#line 512 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_cairo_transform_to_window (_tmp15_, (GtkWidget*) _tmp16_, _tmp17_);
#line 517 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = view;
#line 517 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_view_get_visible_rect ((GtkTextView*) _tmp18_, &_tmp19_);
#line 517 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	rect = _tmp19_;
#line 518 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp20_ = view;
#line 518 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp21_ = rect;
#line 518 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp22_ = _tmp21_.y;
#line 518 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_view_get_line_at_y ((GtkTextView*) _tmp20_, &_tmp23_, _tmp22_, NULL);
#line 518 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	start = _tmp23_;
#line 519 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_iter_backward_line (&start);
#line 521 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp24_ = view;
#line 521 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp25_ = rect;
#line 521 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp26_ = _tmp25_.y;
#line 521 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp27_ = rect;
#line 521 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp28_ = _tmp27_.height;
#line 521 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_view_get_line_at_y ((GtkTextView*) _tmp24_, &_tmp29_, _tmp26_ + _tmp28_, NULL);
#line 521 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	end = _tmp29_;
#line 522 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_iter_forward_line (&end);
#line 524 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp30_ = window;
#line 524 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp31_ = gdk_window_get_width (_tmp30_);
#line 524 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	window_width = _tmp31_;
#line 526 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp32_ = view;
#line 526 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp33_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp32_);
#line 526 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp34_ = _tmp33_;
#line 526 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp35_ = _g_object_ref0 (_tmp34_);
#line 526 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	buf = _tmp35_;
#line 528 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	while (TRUE) {
#line 3629 "gca-diagnostics.c"
		GeeMapIterator* _tmp36_;
		gboolean _tmp37_ = FALSE;
		GtkTextIter iter = {0};
		GtkTextBuffer* _tmp38_;
		GeeMapIterator* _tmp39_;
		gpointer _tmp40_ = NULL;
		GtkTextMark* _tmp41_;
		GtkTextIter _tmp42_ = {0};
		gboolean _tmp43_ = FALSE;
		GtkTextIter _tmp44_;
		GtkTextIter _tmp45_;
		gboolean _tmp46_ = FALSE;
		gboolean _tmp49_;
		gboolean _tmp50_ = FALSE;
		gint y = 0;
		gint height = 0;
		gint wy = 0;
		gint wx = 0;
		GdkRectangle irect = {0};
		GeditView* _tmp52_;
		GtkTextIter _tmp53_;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		GeditView* _tmp56_;
		GtkTextIter _tmp57_;
		GdkRectangle _tmp58_ = {0};
		GeditView* _tmp59_;
		GdkRectangle _tmp60_;
		gint _tmp61_;
		GdkRectangle _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		cairo_t* _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		cairo_t* _tmp73_;
		GeeMapIterator* _tmp74_;
		gpointer _tmp75_ = NULL;
		GdkRGBA* _tmp76_;
		GdkRGBA _tmp77_;
		cairo_t* _tmp78_;
#line 528 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp36_ = it;
#line 528 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp37_ = gee_map_iterator_next (_tmp36_);
#line 528 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (!_tmp37_) {
#line 528 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			break;
#line 3684 "gca-diagnostics.c"
		}
#line 532 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp38_ = buf;
#line 532 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp39_ = it;
#line 532 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp40_ = gee_map_iterator_get_key (_tmp39_);
#line 532 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp41_ = (GtkTextMark*) _tmp40_;
#line 532 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_buffer_get_iter_at_mark (_tmp38_, &_tmp42_, _tmp41_);
#line 532 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		iter = _tmp42_;
#line 532 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (_tmp41_);
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp44_ = start;
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp45_ = end;
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp46_ = gtk_text_iter_in_range (&iter, &_tmp44_, &_tmp45_);
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (!_tmp46_) {
#line 3708 "gca-diagnostics.c"
			GtkTextIter _tmp47_;
			gboolean _tmp48_ = FALSE;
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp47_ = end;
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp48_ = gtk_text_iter_equal (&iter, &_tmp47_);
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp43_ = !_tmp48_;
#line 3717 "gca-diagnostics.c"
		} else {
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp43_ = FALSE;
#line 3721 "gca-diagnostics.c"
		}
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp49_ = _tmp43_;
#line 534 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (_tmp49_) {
#line 536 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			continue;
#line 3729 "gca-diagnostics.c"
		}
#line 539 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp50_ = gtk_text_iter_ends_line (&iter);
#line 539 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		if (!_tmp50_) {
#line 3735 "gca-diagnostics.c"
			gboolean _tmp51_ = FALSE;
#line 541 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp51_ = gtk_text_iter_forward_visible_line (&iter);
#line 541 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			if (_tmp51_) {
#line 543 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				gtk_text_iter_backward_char (&iter);
#line 3743 "gca-diagnostics.c"
			}
		}
#line 555 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp52_ = view;
#line 555 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp53_ = iter;
#line 555 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_view_get_line_yrange ((GtkTextView*) _tmp52_, &_tmp53_, &_tmp54_, &_tmp55_);
#line 555 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		y = _tmp54_;
#line 555 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		height = _tmp55_;
#line 556 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp56_ = view;
#line 556 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp57_ = iter;
#line 556 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_view_get_iter_location ((GtkTextView*) _tmp56_, &_tmp57_, &_tmp58_);
#line 556 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		irect = _tmp58_;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp59_ = view;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp60_ = irect;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp61_ = _tmp60_.x;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp62_ = irect;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp63_ = _tmp62_.width;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp64_ = y;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_view_buffer_to_window_coords ((GtkTextView*) _tmp59_, GTK_TEXT_WINDOW_TEXT, _tmp61_ + _tmp63_, _tmp64_, &_tmp65_, &_tmp66_);
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		wx = _tmp65_;
#line 558 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		wy = _tmp66_;
#line 564 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp67_ = ctx;
#line 564 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp68_ = wx;
#line 564 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp69_ = wy;
#line 564 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp70_ = window_width;
#line 564 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp71_ = wx;
#line 564 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp72_ = height;
#line 564 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		cairo_rectangle (_tmp67_, (gdouble) _tmp68_, (gdouble) _tmp69_, (gdouble) (_tmp70_ - _tmp71_), (gdouble) _tmp72_);
#line 569 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp73_ = ctx;
#line 569 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp74_ = it;
#line 569 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp75_ = gee_map_iterator_get_value (_tmp74_);
#line 569 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp76_ = (GdkRGBA*) _tmp75_;
#line 569 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp77_ = *_tmp76_;
#line 569 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gdk_cairo_set_source_rgba (_tmp73_, &_tmp77_);
#line 569 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_free0 (_tmp76_);
#line 570 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp78_ = ctx;
#line 570 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		cairo_fill (_tmp78_);
#line 3814 "gca-diagnostics.c"
	}
#line 573 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = FALSE;
#line 573 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (buf);
#line 573 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (it);
#line 573 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (window);
#line 573 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (view);
#line 573 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 3828 "gca-diagnostics.c"
}


static void gca_diagnostics_on_buffer_mark_set (GcaDiagnostics* self, GtkTextIter* location, GtkTextMark* mark) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	GtkTextMark* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_;
#line 576 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 576 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (location != NULL);
#line 576 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (mark != NULL);
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = self->priv->d_diagnostics_at_end;
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = mark;
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp3_) {
#line 3852 "gca-diagnostics.c"
		gboolean _tmp4_ = FALSE;
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp4_ = gtk_text_iter_starts_line (location);
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp0_ = !_tmp4_;
#line 3858 "gca-diagnostics.c"
	} else {
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp0_ = FALSE;
#line 3862 "gca-diagnostics.c"
	}
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _tmp0_;
#line 578 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp5_) {
#line 3868 "gca-diagnostics.c"
		GcaView* _tmp6_;
		GeditView* _tmp7_;
		GeditView* _tmp8_;
		GtkTextBuffer* _tmp9_;
		GtkTextBuffer* _tmp10_;
		GtkTextMark* _tmp11_;
		GtkTextIter _tmp12_;
#line 580 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_iter_set_line_offset (location, 0);
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp6_ = self->priv->d_view;
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp7_ = gca_view_get_view (_tmp6_);
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp8_ = _tmp7_;
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp8_);
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp10_ = _tmp9_;
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp11_ = mark;
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp12_ = *location;
#line 581 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_buffer_move_mark (_tmp10_, _tmp11_, &_tmp12_);
#line 3894 "gca-diagnostics.c"
	}
}


static gboolean gca_diagnostics_same_diagnostics (GcaDiagnostics* self, GcaDiagnostic** first, int first_length1, GcaDiagnostic** second, int second_length1) {
	gboolean result = FALSE;
	GcaDiagnostic** _tmp0_;
	gint _tmp0__length1;
	GcaDiagnostic** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_ = FALSE;
	GcaDiagnostic** _tmp3_;
	gint _tmp3__length1;
	gboolean _tmp5_;
	GcaDiagnostic** _tmp6_;
	gint _tmp6__length1;
	GcaDiagnostic** _tmp7_;
	gint _tmp7__length1;
#line 585 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 587 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = first;
#line 587 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0__length1 = first_length1;
#line 587 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = second;
#line 587 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1__length1 = second_length1;
#line 587 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp0_ == _tmp1_) {
#line 589 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = TRUE;
#line 589 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 3929 "gca-diagnostics.c"
	}
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = first;
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3__length1 = first_length1;
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp3_ == NULL) {
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp2_ = TRUE;
#line 3939 "gca-diagnostics.c"
	} else {
		GcaDiagnostic** _tmp4_;
		gint _tmp4__length1;
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp4_ = second;
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp4__length1 = second_length1;
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp2_ = _tmp4_ == NULL;
#line 3949 "gca-diagnostics.c"
	}
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _tmp2_;
#line 592 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp5_) {
#line 594 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = FALSE;
#line 594 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 3959 "gca-diagnostics.c"
	}
#line 597 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = first;
#line 597 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6__length1 = first_length1;
#line 597 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = second;
#line 597 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7__length1 = second_length1;
#line 597 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp6__length1 != _tmp7__length1) {
#line 599 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = FALSE;
#line 599 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 3975 "gca-diagnostics.c"
	}
	{
		gint i;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		i = 0;
#line 3981 "gca-diagnostics.c"
		{
			gboolean _tmp8_;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp8_ = TRUE;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			while (TRUE) {
#line 3988 "gca-diagnostics.c"
				gboolean _tmp9_;
				gint _tmp11_;
				GcaDiagnostic** _tmp12_;
				gint _tmp12__length1;
				GcaDiagnostic** _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				GcaDiagnostic* _tmp15_;
				GcaDiagnostic** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				GcaDiagnostic* _tmp18_;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp9_ = _tmp8_;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!_tmp9_) {
#line 4005 "gca-diagnostics.c"
					gint _tmp10_;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp10_ = i;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					i = _tmp10_ + 1;
#line 4011 "gca-diagnostics.c"
				}
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp8_ = FALSE;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp11_ = i;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp12_ = first;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp12__length1 = first_length1;
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!(_tmp11_ < _tmp12__length1)) {
#line 602 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					break;
#line 4025 "gca-diagnostics.c"
				}
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13_ = first;
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13__length1 = first_length1;
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp14_ = i;
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp15_ = _tmp13_[_tmp14_];
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp16_ = second;
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp16__length1 = second_length1;
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp17_ = i;
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp18_ = _tmp16_[_tmp17_];
#line 604 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (_tmp15_ != _tmp18_) {
#line 606 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					result = FALSE;
#line 606 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					return result;
#line 4049 "gca-diagnostics.c"
				}
			}
		}
	}
#line 610 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = TRUE;
#line 610 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4058 "gca-diagnostics.c"
}


static void __lambda12_ (GcaDiagnostics* self) {
#line 637 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_cursor_diagnostic_message);
#line 637 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_cursor_diagnostic_message = NULL;
#line 4067 "gca-diagnostics.c"
}


static void ___lambda12__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 636 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	__lambda12_ (self);
#line 4074 "gca-diagnostics.c"
}


static GcaDiagnostic** _vala_array_dup5 (GcaDiagnostic** self, int length) {
	GcaDiagnostic** result;
	int i;
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = g_new0 (GcaDiagnostic*, length + 1);
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	for (i = 0; i < length; i++) {
#line 4085 "gca-diagnostics.c"
		GcaDiagnostic* _tmp0_;
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result[i] = _tmp0_;
#line 4091 "gca-diagnostics.c"
	}
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4095 "gca-diagnostics.c"
}


static void gca_diagnostics_update_diagnostic_message (GcaDiagnostics* self) {
	GtkTextIter iter = {0};
	GcaView* _tmp0_;
	GeditView* _tmp1_;
	GeditView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* buf;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextMark* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_;
	GcaSourceRange _tmp11_ = {0};
	GcaSourceRange range;
	GcaSourceRange _tmp12_;
	gint _tmp13_ = 0;
	GcaDiagnostic** _tmp14_ = NULL;
	GcaDiagnostic** diagnostics;
	gint diagnostics_length1;
	gint _diagnostics_size_;
	GcaDiagnostic** _tmp15_;
	gint _tmp15__length1;
	GcaDiagnostic** _tmp16_;
	gint _tmp16__length1;
	gboolean _tmp17_ = FALSE;
	GcaDiagnosticMessage* _tmp18_;
	GcaView* _tmp20_;
	GeditView* _tmp21_;
	GeditView* _tmp22_;
	GcaDiagnostic** _tmp23_;
	gint _tmp23__length1;
	GcaDiagnosticMessage* _tmp24_;
	GcaDiagnosticMessage* _tmp25_;
	GcaDiagnosticMessage* _tmp26_;
	GcaDiagnostic** _tmp27_;
	gint _tmp27__length1;
	GcaDiagnostic** _tmp28_;
	gint _tmp28__length1;
#line 613 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 617 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 617 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_view_get_view (_tmp0_);
#line 617 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 617 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
#line 617 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = _tmp3_;
#line 617 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 617 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	buf = _tmp5_;
#line 619 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp6_ = buf;
#line 619 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = buf;
#line 619 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = gtk_text_buffer_get_insert (_tmp7_);
#line 619 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_buffer_get_iter_at_mark (_tmp6_, &_tmp9_, _tmp8_);
#line 619 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	iter = _tmp9_;
#line 621 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = iter;
#line 621 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_source_range_from_iter (&_tmp10_, &_tmp11_);
#line 621 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	range = _tmp11_;
#line 622 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp12_ = range;
#line 622 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp14_ = gca_diagnostics_find_at (self, &_tmp12_, &_tmp13_);
#line 622 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	diagnostics = _tmp14_;
#line 622 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	diagnostics_length1 = _tmp13_;
#line 622 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_diagnostics_size_ = diagnostics_length1;
#line 624 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = diagnostics;
#line 624 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15__length1 = diagnostics_length1;
#line 624 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = self->priv->d_cursor_diagnostics;
#line 624 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16__length1 = self->priv->d_cursor_diagnostics_length1;
#line 624 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = gca_diagnostics_same_diagnostics (self, _tmp15_, _tmp15__length1, _tmp16_, _tmp16__length1);
#line 624 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp17_) {
#line 626 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
#line 626 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (buf);
#line 626 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return;
#line 4199 "gca-diagnostics.c"
	}
#line 629 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = self->priv->d_cursor_diagnostic_message;
#line 629 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp18_ != NULL) {
#line 4205 "gca-diagnostics.c"
		GcaDiagnosticMessage* _tmp19_;
#line 631 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp19_ = self->priv->d_cursor_diagnostic_message;
#line 631 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp19_);
#line 4211 "gca-diagnostics.c"
	}
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp20_ = self->priv->d_view;
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp21_ = gca_view_get_view (_tmp20_);
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp22_ = _tmp21_;
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp23_ = diagnostics;
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp23__length1 = diagnostics_length1;
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp24_ = gca_diagnostic_message_new ((GtkSourceView*) _tmp22_, _tmp23_, _tmp23__length1);
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_object_ref_sink (_tmp24_);
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_cursor_diagnostic_message);
#line 634 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_cursor_diagnostic_message = _tmp24_;
#line 636 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp25_ = self->priv->d_cursor_diagnostic_message;
#line 636 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_signal_connect_object ((GtkWidget*) _tmp25_, "destroy", (GCallback) ___lambda12__gtk_widget_destroy, self, 0);
#line 640 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp26_ = self->priv->d_cursor_diagnostic_message;
#line 640 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_widget_show ((GtkWidget*) _tmp26_);
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp27_ = diagnostics;
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp27__length1 = diagnostics_length1;
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup5 (_tmp27_, _tmp27__length1) : ((gpointer) _tmp27_);
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp28__length1 = _tmp27__length1;
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_cursor_diagnostics = (_vala_array_free (self->priv->d_cursor_diagnostics, self->priv->d_cursor_diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_cursor_diagnostics = _tmp28_;
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_cursor_diagnostics_length1 = _tmp28__length1;
#line 641 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->_d_cursor_diagnostics_size_ = self->priv->d_cursor_diagnostics_length1;
#line 613 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
#line 613 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (buf);
#line 4259 "gca-diagnostics.c"
}


static void gca_diagnostics_on_cursor_moved (GcaDiagnostics* self) {
#line 644 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_if_fail (self != NULL);
#line 646 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_update_diagnostic_message (self);
#line 4268 "gca-diagnostics.c"
}


static gchar* gca_diagnostics_format_diagnostics (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1) {
	gchar* result = NULL;
	GcaDiagnostic** _tmp0_;
	gint _tmp0__length1;
	GcaDiagnostic** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_ = NULL;
	gchar** markup;
	gint markup_length1;
	gint _markup_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_ = NULL;
#line 650 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 652 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = diagnostics;
#line 652 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0__length1 = diagnostics_length1;
#line 652 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp0__length1 == 0) {
#line 654 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = NULL;
#line 654 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 4297 "gca-diagnostics.c"
	}
#line 657 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = diagnostics;
#line 657 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1__length1 = diagnostics_length1;
#line 657 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = g_new0 (gchar*, _tmp1__length1 + 1);
#line 657 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	markup = _tmp2_;
#line 657 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	markup_length1 = _tmp1__length1;
#line 657 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_markup_size_ = markup_length1;
#line 4311 "gca-diagnostics.c"
	{
		gint i;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		i = 0;
#line 4316 "gca-diagnostics.c"
		{
			gboolean _tmp3_;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			_tmp3_ = TRUE;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
			while (TRUE) {
#line 4323 "gca-diagnostics.c"
				gboolean _tmp4_;
				gint _tmp6_;
				GcaDiagnostic** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				GcaDiagnostic** _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				GcaDiagnostic* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp4_ = _tmp3_;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!_tmp4_) {
#line 4341 "gca-diagnostics.c"
					gint _tmp5_;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					_tmp5_ = i;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					i = _tmp5_ + 1;
#line 4347 "gca-diagnostics.c"
				}
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp3_ = FALSE;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp6_ = i;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7_ = diagnostics;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp7__length1 = diagnostics_length1;
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				if (!(_tmp6_ < _tmp7__length1)) {
#line 659 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
					break;
#line 4361 "gca-diagnostics.c"
				}
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp8_ = markup;
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp8__length1 = markup_length1;
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp9_ = i;
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp10_ = diagnostics;
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp10__length1 = diagnostics_length1;
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp11_ = i;
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp13_ = gca_diagnostic_to_markup (_tmp12_, FALSE);
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_g_free0 (_tmp8_[_tmp9_]);
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp8_[_tmp9_] = _tmp13_;
#line 661 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
				_tmp14_ = _tmp8_[_tmp9_];
#line 4385 "gca-diagnostics.c"
			}
		}
	}
#line 664 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = markup;
#line 664 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15__length1 = markup_length1;
#line 664 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp16_ = g_strjoinv ("\n", _tmp15_);
#line 664 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = _tmp16_;
#line 664 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	markup = (_vala_array_free (markup, markup_length1, (GDestroyNotify) g_free), NULL);
#line 664 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4401 "gca-diagnostics.c"
}


static gchar* gca_diagnostics_on_diagnostic_tooltip (GcaDiagnostics* self, GtkSourceMark* mark) {
	gchar* result = NULL;
	GtkTextIter iter = {0};
	GtkSourceMark* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	GcaDiagnostic* _tmp2_;
	GcaDiagnostic* diagnostic;
	GcaDiagnostic* _tmp3_;
#line 667 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 667 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (mark != NULL, NULL);
#line 671 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = mark;
#line 671 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "Gca.Document.MarkDiagnostic");
#line 671 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _g_object_ref0 ((GcaDiagnostic*) _tmp1_);
#line 671 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	diagnostic = _tmp2_;
#line 673 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = diagnostic;
#line 673 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp3_ == NULL) {
#line 4429 "gca-diagnostics.c"
		GcaView* _tmp4_;
		GcaDocument* _tmp5_;
		GcaDocument* _tmp6_;
		GeditDocument* _tmp7_;
		GeditDocument* _tmp8_;
		GtkSourceMark* _tmp9_;
		GtkTextIter _tmp10_ = {0};
		gint _tmp11_ = 0;
		gint line;
		gint _tmp12_;
		gint _tmp13_ = 0;
		GcaDiagnostic** _tmp14_ = NULL;
		GcaDiagnostic** _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp4_ = self->priv->d_view;
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp5_ = gca_view_get_document (_tmp4_);
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp6_ = _tmp5_;
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp7_ = gca_document_get_document (_tmp6_);
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp8_ = _tmp7_;
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp9_ = mark;
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp8_, &_tmp10_, (GtkTextMark*) _tmp9_);
#line 675 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		iter = _tmp10_;
#line 676 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp11_ = gtk_text_iter_get_line (&iter);
#line 676 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		line = _tmp11_ + 1;
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp12_ = line;
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp14_ = gca_diagnostics_find_at_line (self, _tmp12_, &_tmp13_);
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp15_ = _tmp14_;
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp15__length1 = _tmp13_;
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp16_ = gca_diagnostics_format_diagnostics (self, _tmp15_, _tmp13_);
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp17_ = _tmp16_;
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_object_unref), NULL);
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = _tmp17_;
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (diagnostic);
#line 678 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 4486 "gca-diagnostics.c"
	} else {
		GcaDiagnostic* _tmp18_;
		gchar* _tmp19_ = NULL;
#line 682 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp18_ = diagnostic;
#line 682 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_tmp19_ = gca_diagnostic_to_markup (_tmp18_, FALSE);
#line 682 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = _tmp19_;
#line 682 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_object_unref0 (diagnostic);
#line 682 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 4500 "gca-diagnostics.c"
	}
#line 667 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (diagnostic);
#line 4504 "gca-diagnostics.c"
}


static gboolean gca_diagnostics_on_view_query_tooltip (GcaDiagnostics* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	gint bx = 0;
	gint by = 0;
	GcaView* _tmp0_;
	GeditView* _tmp1_;
	GeditView* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTextIter iter = {0};
	GcaView* _tmp7_;
	GeditView* _tmp8_;
	GeditView* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GtkTextIter _tmp12_ = {0};
	GtkTextIter _tmp13_;
	GcaSourceRange _tmp14_ = {0};
	GcaSourceRange range;
	GcaSourceRange _tmp15_;
	gint _tmp16_ = 0;
	GcaDiagnostic** _tmp17_ = NULL;
	GcaDiagnostic** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* s;
	const gchar* _tmp21_;
	GtkTooltip* _tmp22_;
	const gchar* _tmp23_;
#line 686 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 686 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_return_val_if_fail (tooltip != NULL, FALSE);
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp0_ = self->priv->d_view;
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp1_ = gca_view_get_view (_tmp0_);
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp2_ = _tmp1_;
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp3_ = x;
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp4_ = y;
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) _tmp2_, GTK_TEXT_WINDOW_WIDGET, _tmp3_, _tmp4_, &_tmp5_, &_tmp6_);
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	bx = _tmp5_;
#line 694 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	by = _tmp6_;
#line 702 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp7_ = self->priv->d_view;
#line 702 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp8_ = gca_view_get_view (_tmp7_);
#line 702 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp9_ = _tmp8_;
#line 702 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp10_ = bx;
#line 702 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp11_ = by;
#line 702 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_text_view_get_iter_at_location ((GtkTextView*) _tmp9_, &_tmp12_, _tmp10_, _tmp11_);
#line 702 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	iter = _tmp12_;
#line 704 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp13_ = iter;
#line 704 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_source_range_from_iter (&_tmp13_, &_tmp14_);
#line 704 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	range = _tmp14_;
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp15_ = range;
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp17_ = gca_diagnostics_find_at (self, &_tmp15_, &_tmp16_);
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = _tmp17_;
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18__length1 = _tmp16_;
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp19_ = gca_diagnostics_format_diagnostics (self, _tmp18_, _tmp16_);
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp20_ = _tmp19_;
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_object_unref), NULL);
#line 706 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	s = _tmp20_;
#line 708 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp21_ = s;
#line 708 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	if (_tmp21_ == NULL) {
#line 710 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		result = FALSE;
#line 710 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		_g_free0 (s);
#line 710 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		return result;
#line 4606 "gca-diagnostics.c"
	}
#line 713 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp22_ = tooltip;
#line 713 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_tmp23_ = s;
#line 713 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gtk_tooltip_set_markup (_tmp22_, _tmp23_);
#line 714 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = TRUE;
#line 714 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_free0 (s);
#line 714 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4620 "gca-diagnostics.c"
}


const gchar* gca_diagnostics_get_error_mark_category (void) {
	const gchar* result;
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = "Gca.Document.ErrorCategory";
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4630 "gca-diagnostics.c"
}


const gchar* gca_diagnostics_get_error_icon_name (void) {
	const gchar* result;
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = "dialog-error-symbolic";
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4640 "gca-diagnostics.c"
}


const gchar* gca_diagnostics_get_warning_mark_category (void) {
	const gchar* result;
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = "Gca.Document.WarningCategory";
#line 133 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4650 "gca-diagnostics.c"
}


const gchar* gca_diagnostics_get_warning_icon_name (void) {
	const gchar* result;
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = "dialog-warning-symbolic";
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4660 "gca-diagnostics.c"
}


const gchar* gca_diagnostics_get_info_mark_category (void) {
	const gchar* result;
#line 143 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = "Gca.Document.InfoCategory";
#line 143 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4670 "gca-diagnostics.c"
}


const gchar* gca_diagnostics_get_info_icon_name (void) {
	const gchar* result;
#line 148 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	result = "dialog-information-symbolic";
#line 148 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	return result;
#line 4680 "gca-diagnostics.c"
}


static void gca_diagnostics_class_init (GcaDiagnosticsClass * klass) {
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	gca_diagnostics_parent_class = g_type_class_peek_parent (klass);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	g_type_class_add_private (klass, sizeof (GcaDiagnosticsPrivate));
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_diagnostics_get_property;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	G_OBJECT_CLASS (klass)->finalize = gca_diagnostics_finalize;
#line 4693 "gca-diagnostics.c"
}


static void gca_diagnostics_instance_init (GcaDiagnostics * self) {
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv = GCA_DIAGNOSTICS_GET_PRIVATE (self);
#line 4700 "gca-diagnostics.c"
}


static void gca_diagnostics_finalize (GObject* obj) {
	GcaDiagnostics * self;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DIAGNOSTICS, GcaDiagnostics);
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_view);
#line 113 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_index);
#line 114 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_tags);
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_diagnostics_at_end);
#line 117 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	self->priv->d_cursor_diagnostics = (_vala_array_free (self->priv->d_cursor_diagnostics, self->priv->d_cursor_diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	_g_object_unref0 (self->priv->d_cursor_diagnostic_message);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	G_OBJECT_CLASS (gca_diagnostics_parent_class)->finalize (obj);
#line 4722 "gca-diagnostics.c"
}


GType gca_diagnostics_get_type (void) {
	static volatile gsize gca_diagnostics_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDiagnosticsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_diagnostics_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDiagnostics), 0, (GInstanceInitFunc) gca_diagnostics_instance_init, NULL };
		GType gca_diagnostics_type_id;
		gca_diagnostics_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDiagnostics", &g_define_type_info, 0);
		g_once_init_leave (&gca_diagnostics_type_id__volatile, gca_diagnostics_type_id);
	}
	return gca_diagnostics_type_id__volatile;
}


static void _vala_gca_diagnostics_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaDiagnostics * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_TYPE_DIAGNOSTICS, GcaDiagnostics);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
	switch (property_id) {
#line 4743 "gca-diagnostics.c"
		default:
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-diagnostics.vala"
		break;
#line 4749 "gca-diagnostics.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



