/* gca-backend.c generated by valac 0.28.0.11-bbdd, the Vala compiler
 * generated from gca-backend.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define GCA_TYPE_BACKEND (gca_backend_get_type ())
#define GCA_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_BACKEND, GcaBackend))
#define GCA_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_BACKEND, GcaBackendClass))
#define GCA_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_BACKEND))
#define GCA_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_BACKEND))
#define GCA_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_BACKEND, GcaBackendClass))

typedef struct _GcaBackend GcaBackend;
typedef struct _GcaBackendClass GcaBackendClass;
typedef struct _GcaBackendPrivate GcaBackendPrivate;

#define GCA_TYPE_VIEW (gca_view_get_type ())
#define GCA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_VIEW, GcaView))
#define GCA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_VIEW, GcaViewClass))
#define GCA_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_VIEW))
#define GCA_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_VIEW))
#define GCA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_VIEW, GcaViewClass))

typedef struct _GcaView GcaView;
typedef struct _GcaViewClass GcaViewClass;

#define GCA_DBUS_TYPE_SERVICE (gca_dbus_service_get_type ())
#define GCA_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_SERVICE, GcaDBusService))
#define GCA_DBUS_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_SERVICE))
#define GCA_DBUS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_SERVICE, GcaDBusServiceIface))

typedef struct _GcaDBusService GcaDBusService;
typedef struct _GcaDBusServiceIface GcaDBusServiceIface;

#define GCA_DBUS_TYPE_SERVICE_PROXY (gca_dbus_service_proxy_get_type ())

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;

#define GCA_DBUS_TYPE_PROJECT (gca_dbus_project_get_type ())
#define GCA_DBUS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_PROJECT, GcaDBusProject))
#define GCA_DBUS_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_PROJECT))
#define GCA_DBUS_PROJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_PROJECT, GcaDBusProjectIface))

typedef struct _GcaDBusProject GcaDBusProject;
typedef struct _GcaDBusProjectIface GcaDBusProjectIface;

#define GCA_DBUS_TYPE_PROJECT_PROXY (gca_dbus_project_proxy_get_type ())

#define GCA_DBUS_TYPE_OPEN_DOCUMENT (gca_dbus_open_document_get_type ())
typedef struct _GcaDBusOpenDocument GcaDBusOpenDocument;

#define GCA_DBUS_TYPE_REMOTE_DOCUMENT (gca_dbus_remote_document_get_type ())
typedef struct _GcaDBusRemoteDocument GcaDBusRemoteDocument;

#define GCA_TYPE_REMOTE_SERVICES (gca_remote_services_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GcaBackendCreateData GcaBackendCreateData;

#define GCA_DBUS_TYPE_INTROSPECTABLE (gca_dbus_introspectable_get_type ())
#define GCA_DBUS_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_INTROSPECTABLE, GcaDBusIntrospectable))
#define GCA_DBUS_IS_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_INTROSPECTABLE))
#define GCA_DBUS_INTROSPECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_INTROSPECTABLE, GcaDBusIntrospectableIface))

typedef struct _GcaDBusIntrospectable GcaDBusIntrospectable;
typedef struct _GcaDBusIntrospectableIface GcaDBusIntrospectableIface;

#define GCA_DBUS_TYPE_INTROSPECTABLE_PROXY (gca_dbus_introspectable_proxy_get_type ())
#define _g_dbus_interface_info_unref0(var) ((var == NULL) ? NULL : (var = (g_dbus_interface_info_unref (var), NULL)))
#define _g_dbus_node_info_unref0(var) ((var == NULL) ? NULL : (var = (g_dbus_node_info_unref (var), NULL)))
typedef struct _GcaBackendGetRemoteServicesData GcaBackendGetRemoteServicesData;
typedef struct _GcaBackendGetProjectData GcaBackendGetProjectData;

#define GCA_TYPE_DOCUMENT (gca_document_get_type ())
#define GCA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DOCUMENT, GcaDocument))
#define GCA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DOCUMENT, GcaDocumentClass))
#define GCA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DOCUMENT))
#define GCA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DOCUMENT))
#define GCA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DOCUMENT, GcaDocumentClass))

typedef struct _GcaDocument GcaDocument;
typedef struct _GcaDocumentClass GcaDocumentClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GcaBackendUnsavedDocumentData GcaBackendUnsavedDocumentData;
typedef struct _GcaBackendOpenDocumentsData GcaBackendOpenDocumentsData;
typedef struct _Block2Data Block2Data;

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;

#define GCA_TYPE_REMOTE_DOCUMENT (gca_remote_document_get_type ())
#define GCA_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocument))
#define GCA_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))
#define GCA_IS_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_IS_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_REMOTE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))

typedef struct _GcaRemoteDocument GcaRemoteDocument;
typedef struct _GcaRemoteDocumentClass GcaRemoteDocumentClass;
#define _gca_remote_document_unref0(var) ((var == NULL) ? NULL : (var = (gca_remote_document_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _GcaBackend {
	GObject parent_instance;
	GcaBackendPrivate * priv;
};

struct _GcaBackendClass {
	GObjectClass parent_class;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusServiceIface {
	GTypeInterface parent_iface;
	void (*parse) (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*parse_finish) (GcaDBusService* self, GAsyncResult* _res_, GError** error);
	void (*dispose) (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*dispose_finish) (GcaDBusService* self, GAsyncResult* _res_, GError** error);
};

struct _GcaDBusOpenDocument {
	gchar* path;
	gchar* data_path;
};

struct _GcaDBusRemoteDocument {
	gchar* path;
	char* remote_path;
};

struct _GcaDBusProjectIface {
	GTypeInterface parent_iface;
	void (*parse_all) (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GcaDBusRemoteDocument* (*parse_all_finish) (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

typedef enum  {
	GCA_REMOTE_SERVICES_DIAGNOSTICS = 1 << 0,
	GCA_REMOTE_SERVICES_SEMANTIC_VALUES = 1 << 1,
	GCA_REMOTE_SERVICES_SYMBOLS = 1 << 2
} GcaRemoteServices;

struct _GcaBackendPrivate {
	GeeArrayList* d_views;
	GRecMutex __lock_d_views;
	GeeHashMap* d_paths;
	gchar* d_name;
	GcaDBusService* d_service;
	GcaDBusProject* d_project;
	GcaRemoteServices d_supported_services;
};

struct _GcaBackendCreateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* language;
	GcaBackend* result;
	gchar* name;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* path;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GcaDBusProject* project;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GcaDBusProject* _tmp6_;
	GcaRemoteServices services;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GcaRemoteServices _tmp9_;
	GcaDBusService* service;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GcaDBusService* _tmp12_;
	const gchar* _tmp13_;
	GcaDBusService* _tmp14_;
	GcaDBusProject* _tmp15_;
	GcaRemoteServices _tmp16_;
	GcaBackend* _tmp17_;
	GError * _inner_error_;
};

struct _GcaDBusIntrospectableIface {
	GTypeInterface parent_iface;
	void (*Introspect) (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*Introspect_finish) (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error);
};

struct _GcaBackendGetRemoteServicesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* name;
	gchar* path;
	GcaRemoteServices result;
	GcaRemoteServices ret;
	GcaDBusIntrospectable* intro;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GcaDBusIntrospectable* _tmp4_;
	GcaDBusIntrospectable* _tmp5_;
	gchar* xml;
	GcaDBusIntrospectable* _tmp6_;
	gchar* _tmp7_;
	GDBusNodeInfo* node;
	const gchar* _tmp8_;
	GDBusNodeInfo* _tmp9_;
	GDBusNodeInfo* _tmp10_;
	GDBusInterfaceInfo** _tmp11_;
	gint _tmp11__length1;
	GDBusInterfaceInfo** iface_collection;
	gint iface_collection_length1;
	gint _iface_collection_size_;
	gint iface_it;
	GDBusInterfaceInfo* _tmp12_;
	GDBusInterfaceInfo* iface;
	GcaRemoteServices _tmp13_;
	GDBusInterfaceInfo* _tmp14_;
	const gchar* _tmp15_;
	GcaRemoteServices _tmp16_;
	GError * _inner_error_;
};

struct _GcaBackendGetProjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* name;
	gchar* path;
	GcaDBusProject* result;
	GcaDBusIntrospectable* intro;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GcaDBusIntrospectable* _tmp2_;
	gchar* xml;
	GcaDBusIntrospectable* _tmp3_;
	gchar* _tmp4_;
	GDBusNodeInfo* serviceintro;
	const gchar* _tmp5_;
	GDBusNodeInfo* _tmp6_;
	GcaDBusProject* project;
	GDBusNodeInfo* _tmp7_;
	GDBusInterfaceInfo* _tmp8_;
	GcaDBusProject* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GcaDBusProject* _tmp12_;
	GcaDBusProject* _tmp13_;
	GError * _inner_error_;
};

struct _GcaBackendUnsavedDocumentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GcaBackend* self;
	GcaView* v;
	gchar* result;
	GcaDocument* doc;
	GcaView* _tmp0_;
	GcaDocument* _tmp1_;
	GcaDocument* _tmp2_;
	GcaDocument* _tmp3_;
	GcaDocument* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	GcaDocument* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError * _inner_error_;
};

struct _GcaBackendOpenDocumentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GcaBackend* self;
	GcaView* primary;
	GcaDBusOpenDocument* result;
	gint result_length1;
	GcaView** views;
	gint views_length1;
	gint _views_size_;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	GeeArrayList* _tmp4_;
	GcaDBusOpenDocument* ret;
	GcaView** _tmp5_;
	gint _tmp5__length1;
	GcaDBusOpenDocument* _tmp6_;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp7_;
	GcaView** _tmp8_;
	gint _tmp8__length1;
	GcaView** v_collection;
	gint v_collection_length1;
	gint _v_collection_size_;
	gint v_it;
	GcaView* _tmp9_;
	GcaView* v;
	GcaDocument* doc;
	GcaView* _tmp10_;
	GcaDocument* _tmp11_;
	GcaDocument* _tmp12_;
	GcaDocument* _tmp13_;
	GcaDocument* _tmp14_;
	gchar* dp;
	GcaView* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GcaDBusOpenDocument* _tmp20_;
	gint _tmp20__length1;
	GcaDocument* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GcaDBusOpenDocument _tmp25_;
	GcaDBusOpenDocument* _tmp26_;
	gint _tmp26__length1;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	GcaBackend* self;
	GcaView* view;
};

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _Block3Data {
	int _ref_count_;
	GcaBackend* self;
	GcaView* view;
};


static gpointer gca_backend_parent_class = NULL;

GType gca_backend_get_type (void) G_GNUC_CONST;
GType gca_view_get_type (void) G_GNUC_CONST;
GType gca_dbus_service_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GType gca_dbus_service_get_type (void) G_GNUC_CONST;
GType gca_dbus_project_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_project_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_open_document_get_type (void) G_GNUC_CONST;
GcaDBusOpenDocument* gca_dbus_open_document_dup (const GcaDBusOpenDocument* self);
void gca_dbus_open_document_free (GcaDBusOpenDocument* self);
void gca_dbus_open_document_copy (const GcaDBusOpenDocument* self, GcaDBusOpenDocument* dest);
void gca_dbus_open_document_destroy (GcaDBusOpenDocument* self);
GType gca_dbus_remote_document_get_type (void) G_GNUC_CONST;
GcaDBusRemoteDocument* gca_dbus_remote_document_dup (const GcaDBusRemoteDocument* self);
void gca_dbus_remote_document_free (GcaDBusRemoteDocument* self);
void gca_dbus_remote_document_copy (const GcaDBusRemoteDocument* self, GcaDBusRemoteDocument* dest);
void gca_dbus_remote_document_destroy (GcaDBusRemoteDocument* self);
GType gca_dbus_project_get_type (void) G_GNUC_CONST;
GType gca_remote_services_get_type (void) G_GNUC_CONST;
#define GCA_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_BACKEND, GcaBackendPrivate))
enum  {
	GCA_BACKEND_DUMMY_PROPERTY
};
static void gca_backend_create_data_free (gpointer _data);
void gca_backend_create (const gchar* language, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaBackend* gca_backend_create_finish (GAsyncResult* _res_, GError** error);
static gboolean gca_backend_create_co (GcaBackendCreateData* _data_);
static void gca_backend_get_project (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaDBusProject* gca_backend_get_project_finish (GAsyncResult* _res_, GError** error);
static void gca_backend_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gca_backend_get_remote_services (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaRemoteServices gca_backend_get_remote_services_finish (GAsyncResult* _res_, GError** error);
static GcaBackend* gca_backend_new (const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services);
static GcaBackend* gca_backend_construct (GType object_type, const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services);
static void gca_backend_get_remote_services_data_free (gpointer _data);
static gboolean gca_backend_get_remote_services_co (GcaBackendGetRemoteServicesData* _data_);
GType gca_dbus_introspectable_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_introspectable_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_introspectable_get_type (void) G_GNUC_CONST;
static void gca_backend_get_remote_services_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void gca_dbus_introspectable_Introspect (GcaDBusIntrospectable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* gca_dbus_introspectable_Introspect_finish (GcaDBusIntrospectable* self, GAsyncResult* _res_, GError** error);
GcaRemoteServices gca_remote_services_parse (const gchar* s);
static void gca_backend_get_project_data_free (gpointer _data);
static gboolean gca_backend_get_project_co (GcaBackendGetProjectData* _data_);
static void gca_backend_get_project_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean gca_backend_supports (GcaBackend* self, GcaRemoteServices services);
void gca_backend_register (GcaBackend* self, GcaView* view);
GType gca_document_get_type (void) G_GNUC_CONST;
GcaDocument* gca_view_get_document (GcaView* self);
gchar* gca_document_get_path (GcaDocument* self);
static void gca_backend_on_view_changed (GcaBackend* self, GcaView* view);
static void _gca_backend_on_view_changed_gca_view_changed (GcaView* _sender, gpointer self);
static void gca_backend_on_view_path_changed (GcaBackend* self, GcaView* view, const gchar* prevpath);
static void _gca_backend_on_view_path_changed_gca_view_path_changed (GcaView* _sender, const gchar* prevpath, gpointer self);
static void gca_backend_dispose (GcaBackend* self, const gchar* path);
void gca_dbus_service_dispose (GcaDBusService* self, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gca_dbus_service_dispose_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
static void __lambda8_ (GcaBackend* self, GObject* obj, GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void gca_backend_unregister (GcaBackend* self, GcaView* view);
static void gca_backend_unsaved_document_data_free (gpointer _data);
static void gca_backend_unsaved_document (GcaBackend* self, GcaView* v, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* gca_backend_unsaved_document_finish (GcaBackend* self, GAsyncResult* _res_);
static gboolean gca_backend_unsaved_document_co (GcaBackendUnsavedDocumentData* _data_);
gboolean gca_document_get_is_modified (GcaDocument* self);
void gca_document_unsaved_data_path (GcaDocument* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* gca_document_unsaved_data_path_finish (GcaDocument* self, GAsyncResult* _res_, GError** error);
static void gca_backend_unsaved_document_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void gca_log_debug (const gchar* format, ...);
static void _vala_GcaDBusOpenDocument_array_free (GcaDBusOpenDocument* array, gint array_length);
static void gca_backend_open_documents_data_free (gpointer _data);
static void gca_backend_open_documents (GcaBackend* self, GcaView* primary, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GcaDBusOpenDocument* gca_backend_open_documents_finish (GcaBackend* self, GAsyncResult* _res_, int* result_length1);
static gboolean gca_backend_open_documents_co (GcaBackendOpenDocumentsData* _data_);
static void gca_backend_open_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add1 (GcaDBusOpenDocument** array, int* length, int* size, const GcaDBusOpenDocument* value);
static void gca_backend_parse_single (GcaBackend* self, GcaView* view);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
void gca_document_get_cursor (GcaDocument* self, GcaSourceLocation* result);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
void gca_dbus_service_parse (GcaDBusService* self, const gchar* path, const gchar* data_path, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* gca_dbus_service_parse_finish (GcaDBusService* self, GAsyncResult* _res_, GError** error);
static void __lambda7_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
gpointer gca_remote_document_ref (gpointer instance);
void gca_remote_document_unref (gpointer instance);
GParamSpec* gca_param_spec_remote_document (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_remote_document (GValue* value, gpointer v_object);
void gca_value_take_remote_document (GValue* value, gpointer v_object);
gpointer gca_value_get_remote_document (const GValue* value);
GType gca_remote_document_get_type (void) G_GNUC_CONST;
void gca_view_update (GcaView* self, GcaRemoteDocument* doc);
GcaRemoteDocument* gca_remote_document_new (const gchar* service, const char* path);
GcaRemoteDocument* gca_remote_document_construct (GType object_type, const gchar* service, const char* path);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gca_backend_parse_project (GcaBackend* self, GcaView* view);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda4_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
void gca_dbus_project_parse_all (GcaDBusProject* self, const gchar* path, GcaDBusOpenDocument* documents, int documents_length1, GcaDBusSourceLocation* cursor, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaDBusRemoteDocument* gca_dbus_project_parse_all_finish (GcaDBusProject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void __lambda5_ (GcaBackend* self, GObject* obj, GAsyncResult* res);
static void _vala_GcaDBusRemoteDocument_array_free (GcaDBusRemoteDocument* array, gint array_length);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gca_backend_parse (GcaBackend* self, GcaView* view);
static void gca_backend_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void gca_backend_create_data_free (gpointer _data) {
	GcaBackendCreateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->language);
	_g_object_unref0 (_data_->result);
	g_slice_free (GcaBackendCreateData, _data_);
}


void gca_backend_create (const gchar* language, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendCreateData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_data_ = g_slice_new0 (GcaBackendCreateData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gca_backend_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_create_data_free);
	_tmp0_ = language;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->language);
	_data_->language = _tmp1_;
	gca_backend_create_co (_data_);
}


GcaBackend* gca_backend_create_finish (GAsyncResult* _res_, GError** error) {
	GcaBackend* result;
	GcaBackendCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void gca_backend_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendCreateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gca_backend_create_co (_data_);
}


static gboolean gca_backend_create_co (GcaBackendCreateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->language;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strconcat ("org.gnome.CodeAssist.v1.", _data_->_tmp0_, NULL);
	_data_->name = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->language;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_strconcat ("/org/gnome/CodeAssist/v1/", _data_->_tmp2_, NULL);
	_data_->path = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->name;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->path;
	_data_->_state_ = 1;
	gca_backend_get_project (_data_->_tmp4_, _data_->_tmp5_, gca_backend_create_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = gca_backend_get_project_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->project = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->path);
		_g_free0 (_data_->name);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->name;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->path;
	_data_->_state_ = 2;
	gca_backend_get_remote_services (_data_->_tmp7_, _data_->_tmp8_, gca_backend_create_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp9_ = 0;
	_data_->_tmp9_ = gca_backend_get_remote_services_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->services = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->project);
		_g_free0 (_data_->path);
		_g_free0 (_data_->name);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->name;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->path;
	_data_->_state_ = 3;
	g_async_initable_new_async (GCA_DBUS_TYPE_SERVICE_PROXY, 0, NULL, gca_backend_create_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp10_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp11_, "g-interface-name", "org.gnome.CodeAssist.v1.Service", "g-interface-info", g_type_get_qdata (GCA_DBUS_TYPE_SERVICE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	return FALSE;
	_state_3:
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
	_data_->service = (GcaDBusService*) _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->project);
		_g_free0 (_data_->path);
		_g_free0 (_data_->name);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->name;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->service;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->project;
	_data_->_tmp16_ = 0;
	_data_->_tmp16_ = _data_->services;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = gca_backend_new (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_);
	_data_->result = _data_->_tmp17_;
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->project);
	_g_free0 (_data_->path);
	_g_free0 (_data_->name);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->project);
	_g_free0 (_data_->path);
	_g_free0 (_data_->name);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gca_backend_get_remote_services_data_free (gpointer _data) {
	GcaBackendGetRemoteServicesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_free0 (_data_->path);
	g_slice_free (GcaBackendGetRemoteServicesData, _data_);
}


static void gca_backend_get_remote_services (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendGetRemoteServicesData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_data_ = g_slice_new0 (GcaBackendGetRemoteServicesData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gca_backend_get_remote_services);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_get_remote_services_data_free);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->name);
	_data_->name = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->path);
	_data_->path = _tmp3_;
	gca_backend_get_remote_services_co (_data_);
}


static GcaRemoteServices gca_backend_get_remote_services_finish (GAsyncResult* _res_, GError** error) {
	GcaRemoteServices result;
	GcaBackendGetRemoteServicesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void gca_backend_get_remote_services_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendGetRemoteServicesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gca_backend_get_remote_services_co (_data_);
}


static gpointer _g_dbus_interface_info_ref0 (gpointer self) {
	return self ? g_dbus_interface_info_ref (self) : NULL;
}


static gboolean gca_backend_get_remote_services_co (GcaBackendGetRemoteServicesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->ret = 0;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->name;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->path;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strconcat (_data_->_tmp1_, "/document", NULL);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	g_async_initable_new_async (GCA_DBUS_TYPE_INTROSPECTABLE_PROXY, 0, NULL, gca_backend_get_remote_services_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp3_, "g-interface-name", "org.freedesktop.DBus.Introspectable", "g-interface-info", g_type_get_qdata (GCA_DBUS_TYPE_INTROSPECTABLE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = (GcaDBusIntrospectable*) _data_->_tmp4_;
	_g_free0 (_data_->_tmp3_);
	_data_->intro = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->intro;
	_data_->_state_ = 2;
	gca_dbus_introspectable_Introspect (_data_->_tmp6_, gca_backend_get_remote_services_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = gca_dbus_introspectable_Introspect_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
	_data_->xml = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->intro);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->xml;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_dbus_node_info_new_for_xml (_data_->_tmp8_, &_data_->_inner_error_);
	_data_->node = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->xml);
		_g_object_unref0 (_data_->intro);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->node;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11__length1 = 0;
	_data_->_tmp11_ = _data_->_tmp10_->interfaces;
	_data_->_tmp11__length1 = _vala_array_length (_data_->_tmp10_->interfaces);
	{
		_data_->iface_collection_length1 = 0;
		_data_->_iface_collection_size_ = 0;
		_data_->iface_collection = _data_->_tmp11_;
		_data_->iface_collection_length1 = _data_->_tmp11__length1;
		for (_data_->iface_it = 0; _data_->iface_it < _data_->_tmp11__length1; _data_->iface_it = _data_->iface_it + 1) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _g_dbus_interface_info_ref0 (_data_->iface_collection[_data_->iface_it]);
			_data_->iface = _data_->_tmp12_;
			{
				_data_->_tmp13_ = 0;
				_data_->_tmp13_ = _data_->ret;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _data_->iface;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _data_->_tmp14_->name;
				_data_->_tmp16_ = 0;
				_data_->_tmp16_ = gca_remote_services_parse (_data_->_tmp15_);
				_data_->ret = _data_->_tmp13_ | _data_->_tmp16_;
				_g_dbus_interface_info_unref0 (_data_->iface);
			}
		}
	}
	_data_->result = _data_->ret;
	_g_dbus_node_info_unref0 (_data_->node);
	_g_free0 (_data_->xml);
	_g_object_unref0 (_data_->intro);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_dbus_node_info_unref0 (_data_->node);
	_g_free0 (_data_->xml);
	_g_object_unref0 (_data_->intro);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gca_backend_get_project_data_free (gpointer _data) {
	GcaBackendGetProjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->result);
	g_slice_free (GcaBackendGetProjectData, _data_);
}


static void gca_backend_get_project (const gchar* name, const gchar* path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendGetProjectData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_data_ = g_slice_new0 (GcaBackendGetProjectData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gca_backend_get_project);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_get_project_data_free);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->name);
	_data_->name = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->path);
	_data_->path = _tmp3_;
	gca_backend_get_project_co (_data_);
}


static GcaDBusProject* gca_backend_get_project_finish (GAsyncResult* _res_, GError** error) {
	GcaDBusProject* result;
	GcaBackendGetProjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void gca_backend_get_project_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendGetProjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gca_backend_get_project_co (_data_);
}


static gboolean gca_backend_get_project_co (GcaBackendGetProjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->name;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->path;
	_data_->_state_ = 1;
	g_async_initable_new_async (GCA_DBUS_TYPE_INTROSPECTABLE_PROXY, 0, NULL, gca_backend_get_project_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp1_, "g-interface-name", "org.freedesktop.DBus.Introspectable", "g-interface-info", g_type_get_qdata (GCA_DBUS_TYPE_INTROSPECTABLE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
	_data_->intro = (GcaDBusIntrospectable*) _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->intro;
	_data_->_state_ = 2;
	gca_dbus_introspectable_Introspect (_data_->_tmp3_, gca_backend_get_project_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = gca_dbus_introspectable_Introspect_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
	_data_->xml = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->intro);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->xml;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_dbus_node_info_new_for_xml (_data_->_tmp5_, &_data_->_inner_error_);
	_data_->serviceintro = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->xml);
		_g_object_unref0 (_data_->intro);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->project = NULL;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->serviceintro;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_dbus_node_info_lookup_interface (_data_->_tmp7_, "org.gnome.CodeAssist.v1.Project");
	if (_data_->_tmp8_ != NULL) {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->name;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->path;
		_data_->_state_ = 3;
		g_async_initable_new_async (GCA_DBUS_TYPE_PROJECT_PROXY, 0, NULL, gca_backend_get_project_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp10_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp11_, "g-interface-name", "org.gnome.CodeAssist.v1.Project", "g-interface-info", g_type_get_qdata (GCA_DBUS_TYPE_PROJECT, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_3:
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = (GcaDBusProject*) _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->project);
			_g_dbus_node_info_unref0 (_data_->serviceintro);
			_g_free0 (_data_->xml);
			_g_object_unref0 (_data_->intro);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_g_object_unref0 (_data_->project);
		_data_->project = _data_->_tmp13_;
		_g_object_unref0 (_data_->_tmp9_);
	}
	_data_->result = _data_->project;
	_g_dbus_node_info_unref0 (_data_->serviceintro);
	_g_free0 (_data_->xml);
	_g_object_unref0 (_data_->intro);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->project);
	_g_dbus_node_info_unref0 (_data_->serviceintro);
	_g_free0 (_data_->xml);
	_g_object_unref0 (_data_->intro);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GcaBackend* gca_backend_construct (GType object_type, const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services) {
	GcaBackend * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GcaDBusService* _tmp2_ = NULL;
	GcaDBusService* _tmp3_ = NULL;
	GcaDBusProject* _tmp4_ = NULL;
	GcaDBusProject* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	GcaRemoteServices _tmp8_ = 0;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (service != NULL, NULL);
	self = (GcaBackend*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->d_name);
	self->priv->d_name = _tmp1_;
	_tmp2_ = service;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->d_service);
	self->priv->d_service = _tmp3_;
	_tmp4_ = project;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->d_project);
	self->priv->d_project = _tmp5_;
	_tmp6_ = gee_array_list_new (GCA_TYPE_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_views);
	self->priv->d_views = _tmp6_;
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GCA_TYPE_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_paths);
	self->priv->d_paths = _tmp7_;
	_tmp8_ = services;
	self->priv->d_supported_services = _tmp8_;
	return self;
}


static GcaBackend* gca_backend_new (const gchar* name, GcaDBusService* service, GcaDBusProject* project, GcaRemoteServices services) {
	return gca_backend_construct (GCA_TYPE_BACKEND, name, service, project, services);
}


gboolean gca_backend_supports (GcaBackend* self, GcaRemoteServices services) {
	gboolean result = FALSE;
	GcaRemoteServices _tmp0_ = 0;
	GcaRemoteServices _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_supported_services;
	_tmp1_ = services;
	result = (_tmp0_ & _tmp1_) != 0;
	return result;
}


static void _gca_backend_on_view_changed_gca_view_changed (GcaView* _sender, gpointer self) {
	gca_backend_on_view_changed ((GcaBackend*) self, _sender);
}


static void _gca_backend_on_view_path_changed_gca_view_path_changed (GcaView* _sender, const gchar* prevpath, gpointer self) {
	gca_backend_on_view_path_changed ((GcaBackend*) self, _sender, prevpath);
}


void gca_backend_register (GcaBackend* self, GcaView* view) {
	GeeHashMap* _tmp4_ = NULL;
	GcaView* _tmp5_ = NULL;
	GcaDocument* _tmp6_ = NULL;
	GcaDocument* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GcaView* _tmp11_ = NULL;
	GcaView* _tmp12_ = NULL;
	GcaView* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	{
		GeeArrayList* _tmp0_ = NULL;
		_tmp0_ = self->priv->d_views;
		g_rec_mutex_lock (&self->priv->__lock_d_views);
		{
			GeeArrayList* _tmp1_ = NULL;
			GcaView* _tmp2_ = NULL;
			_tmp1_ = self->priv->d_views;
			_tmp2_ = view;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
		}
		__finally6:
		{
			GeeArrayList* _tmp3_ = NULL;
			_tmp3_ = self->priv->d_views;
			g_rec_mutex_unlock (&self->priv->__lock_d_views);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = self->priv->d_paths;
	_tmp5_ = view;
	_tmp6_ = gca_view_get_document (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gca_document_get_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = view;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp10_, _tmp11_);
	_g_free0 (_tmp10_);
	_tmp12_ = view;
	g_signal_connect_object (_tmp12_, "changed", (GCallback) _gca_backend_on_view_changed_gca_view_changed, self, 0);
	_tmp13_ = view;
	g_signal_connect_object (_tmp13_, "path-changed", (GCallback) _gca_backend_on_view_path_changed_gca_view_path_changed, self, 0);
}


static void __lambda8_ (GcaBackend* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GcaDBusService* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = self->priv->d_service;
		_tmp1_ = res;
		gca_dbus_service_dispose_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda8_ ((GcaBackend*) self, source_object, res);
	g_object_unref (self);
}


static void gca_backend_dispose (GcaBackend* self, const gchar* path) {
	GcaDBusService* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->d_service;
	_tmp1_ = path;
	gca_dbus_service_dispose (_tmp0_, _tmp1_, ___lambda8__gasync_ready_callback, g_object_ref (self));
}


void gca_backend_unregister (GcaBackend* self, GcaView* view) {
	GcaView* _tmp0_ = NULL;
	GcaDocument* _tmp1_ = NULL;
	GcaDocument* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GcaView* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GcaView* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	GeeHashMap* _tmp14_ = NULL;
	GcaView* _tmp15_ = NULL;
	GcaDocument* _tmp16_ = NULL;
	GcaDocument* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = view;
	_tmp1_ = gca_view_get_document (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gca_document_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gca_backend_dispose (self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = view;
	g_signal_parse_name ("changed", GCA_TYPE_VIEW, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gca_backend_on_view_changed_gca_view_changed, self);
	_tmp8_ = view;
	g_signal_parse_name ("path-changed", GCA_TYPE_VIEW, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gca_backend_on_view_path_changed_gca_view_path_changed, self);
	{
		GeeArrayList* _tmp10_ = NULL;
		_tmp10_ = self->priv->d_views;
		g_rec_mutex_lock (&self->priv->__lock_d_views);
		{
			GeeArrayList* _tmp11_ = NULL;
			GcaView* _tmp12_ = NULL;
			_tmp11_ = self->priv->d_views;
			_tmp12_ = view;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp11_, _tmp12_);
		}
		__finally8:
		{
			GeeArrayList* _tmp13_ = NULL;
			_tmp13_ = self->priv->d_views;
			g_rec_mutex_unlock (&self->priv->__lock_d_views);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = self->priv->d_paths;
	_tmp15_ = view;
	_tmp16_ = gca_view_get_document (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = gca_document_get_path (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp14_, _tmp20_, NULL);
	_g_free0 (_tmp20_);
}


static void gca_backend_on_view_path_changed (GcaBackend* self, GcaView* view, const gchar* prevpath) {
	const gchar* _tmp0_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	GcaView* _tmp5_ = NULL;
	GcaDocument* _tmp6_ = NULL;
	GcaDocument* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GcaView* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = prevpath;
	if (_tmp0_ != NULL) {
		GeeHashMap* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = self->priv->d_paths;
		_tmp2_ = prevpath;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp2_, NULL);
		_tmp3_ = prevpath;
		gca_backend_dispose (self, _tmp3_);
	}
	_tmp4_ = self->priv->d_paths;
	_tmp5_ = view;
	_tmp6_ = gca_view_get_document (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gca_document_get_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = view;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp10_, _tmp11_);
	_g_free0 (_tmp10_);
}


static void gca_backend_unsaved_document_data_free (gpointer _data) {
	GcaBackendUnsavedDocumentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->v);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GcaBackendUnsavedDocumentData, _data_);
}


static void gca_backend_unsaved_document (GcaBackend* self, GcaView* v, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendUnsavedDocumentData* _data_;
	GcaBackend* _tmp0_ = NULL;
	GcaView* _tmp1_ = NULL;
	GcaView* _tmp2_ = NULL;
	_data_ = g_slice_new0 (GcaBackendUnsavedDocumentData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gca_backend_unsaved_document);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_unsaved_document_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = v;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->v);
	_data_->v = _tmp2_;
	gca_backend_unsaved_document_co (_data_);
}


static gchar* gca_backend_unsaved_document_finish (GcaBackend* self, GAsyncResult* _res_) {
	gchar* result;
	GcaBackendUnsavedDocumentData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void gca_backend_unsaved_document_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendUnsavedDocumentData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gca_backend_unsaved_document_co (_data_);
}


static gboolean gca_backend_unsaved_document_co (GcaBackendUnsavedDocumentData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->v;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = gca_view_get_document (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->doc = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->doc;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = gca_document_get_is_modified (_data_->_tmp4_);
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = _data_->_tmp5_;
	if (_data_->_tmp6_) {
		{
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->doc;
			_data_->_state_ = 1;
			gca_document_unsaved_data_path (_data_->_tmp8_, gca_backend_unsaved_document_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = gca_document_unsaved_data_path_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp7_ = _data_->_tmp9_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch9_g_error;
			}
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->_tmp7_;
			_data_->_tmp7_ = NULL;
			_data_->result = _data_->_tmp10_;
			_g_free0 (_data_->_tmp7_);
			_g_object_unref0 (_data_->doc);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally9;
		__catch9_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->e;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			gca_log_debug ("gca-backend.vala:156: Failed to get unsaved document: %s", _data_->_tmp12_);
			_g_error_free0 (_data_->e);
		}
		__finally9:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->doc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = NULL;
	_g_object_unref0 (_data_->doc);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->doc);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_GcaDBusOpenDocument_array_free (GcaDBusOpenDocument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gca_dbus_open_document_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void gca_backend_open_documents_data_free (gpointer _data) {
	GcaBackendOpenDocumentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->primary);
	_data_->result = (_vala_GcaDBusOpenDocument_array_free (_data_->result, _data_->result_length1), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (GcaBackendOpenDocumentsData, _data_);
}


static void gca_backend_open_documents (GcaBackend* self, GcaView* primary, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaBackendOpenDocumentsData* _data_;
	GcaBackend* _tmp0_ = NULL;
	GcaView* _tmp1_ = NULL;
	GcaView* _tmp2_ = NULL;
	_data_ = g_slice_new0 (GcaBackendOpenDocumentsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gca_backend_open_documents);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_backend_open_documents_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = primary;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->primary);
	_data_->primary = _tmp2_;
	gca_backend_open_documents_co (_data_);
}


static GcaDBusOpenDocument* gca_backend_open_documents_finish (GcaBackend* self, GAsyncResult* _res_, int* result_length1) {
	GcaDBusOpenDocument* result;
	GcaBackendOpenDocumentsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void gca_backend_open_documents_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaBackendOpenDocumentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gca_backend_open_documents_co (_data_);
}


static void _vala_array_add1 (GcaDBusOpenDocument** array, int* length, int* size, const GcaDBusOpenDocument* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GcaDBusOpenDocument, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gboolean gca_backend_open_documents_co (GcaBackendOpenDocumentsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->views_length1 = 0;
	_data_->_views_size_ = 0;
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->self->priv->d_views;
		g_rec_mutex_lock (&_data_->self->priv->__lock_d_views);
		{
			_data_->_tmp1_ = NULL;
			_data_->_tmp1_ = _data_->self->priv->d_views;
			_data_->_tmp2_ = 0;
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp1_, &_data_->_tmp2_);
			_data_->views = (_vala_array_free (_data_->views, _data_->views_length1, (GDestroyNotify) g_object_unref), NULL);
			_data_->views = _data_->_tmp3_;
			_data_->views_length1 = _data_->_tmp2_;
			_data_->_views_size_ = _data_->views_length1;
		}
		__finally10:
		{
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = _data_->self->priv->d_views;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_d_views);
		}
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_data_->views = (_vala_array_free (_data_->views, _data_->views_length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5__length1 = 0;
	_data_->_tmp5_ = _data_->views;
	_data_->_tmp5__length1 = _data_->views_length1;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_new0 (GcaDBusOpenDocument, _data_->_tmp5__length1);
	_data_->ret_length1 = 0;
	_data_->_ret_size_ = 0;
	_data_->ret = _data_->_tmp6_;
	_data_->ret_length1 = _data_->_tmp5__length1;
	_data_->_ret_size_ = _data_->ret_length1;
	_data_->ret_length1 = 0;
	_data_->_tmp7_ = 0;
	_data_->_tmp7_ = _data_->ret_length1;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8__length1 = 0;
	_data_->_tmp8_ = _data_->views;
	_data_->_tmp8__length1 = _data_->views_length1;
	{
		_data_->v_collection_length1 = 0;
		_data_->_v_collection_size_ = 0;
		_data_->v_collection = _data_->_tmp8_;
		_data_->v_collection_length1 = _data_->_tmp8__length1;
		for (_data_->v_it = 0; _data_->v_it < _data_->_tmp8__length1; _data_->v_it = _data_->v_it + 1) {
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _g_object_ref0 (_data_->v_collection[_data_->v_it]);
			_data_->v = _data_->_tmp9_;
			{
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->v;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = gca_view_get_document (_data_->_tmp10_);
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->_tmp11_;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
				_data_->doc = _data_->_tmp13_;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _data_->doc;
				if (_data_->_tmp14_ == NULL) {
					_g_object_unref0 (_data_->doc);
					_g_object_unref0 (_data_->v);
					continue;
				}
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _data_->v;
				_data_->_state_ = 1;
				gca_backend_unsaved_document (_data_->self, _data_->_tmp15_, gca_backend_open_documents_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = gca_backend_unsaved_document_finish (_data_->self, _data_->_res_);
				_data_->dp = _data_->_tmp16_;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _data_->dp;
				if (_data_->_tmp18_ == NULL) {
					_data_->_tmp17_ = "";
				} else {
					_data_->_tmp19_ = NULL;
					_data_->_tmp19_ = _data_->dp;
					_data_->_tmp17_ = _data_->_tmp19_;
				}
				_data_->_tmp20_ = NULL;
				_data_->_tmp20__length1 = 0;
				_data_->_tmp20_ = _data_->ret;
				_data_->_tmp20__length1 = _data_->ret_length1;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = _data_->doc;
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = gca_document_get_path (_data_->_tmp21_);
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _data_->_tmp22_;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = g_strdup (_data_->_tmp17_);
				memset (&_data_->_tmp25_, 0, sizeof (GcaDBusOpenDocument));
				memset (&_data_->_tmp25_, 0, sizeof (GcaDBusOpenDocument));
				_g_free0 (_data_->_tmp25_.path);
				_data_->_tmp25_.path = _data_->_tmp23_;
				_g_free0 (_data_->_tmp25_.data_path);
				_data_->_tmp25_.data_path = _data_->_tmp24_;
				_vala_array_add1 (&_data_->ret, &_data_->ret_length1, &_data_->_ret_size_, &_data_->_tmp25_);
				_g_free0 (_data_->dp);
				_g_object_unref0 (_data_->doc);
				_g_object_unref0 (_data_->v);
			}
		}
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26__length1 = 0;
	_data_->_tmp26_ = _data_->ret;
	_data_->_tmp26__length1 = _data_->ret_length1;
	_data_->result_length1 = _data_->_tmp26__length1;
	_data_->result = _data_->_tmp26_;
	_data_->views = (_vala_array_free (_data_->views, _data_->views_length1, (GDestroyNotify) g_object_unref), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->ret = (_vala_GcaDBusOpenDocument_array_free (_data_->ret, _data_->ret_length1), NULL);
	_data_->views = (_vala_array_free (_data_->views, _data_->views_length1, (GDestroyNotify) g_object_unref), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GcaBackend* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->view);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static void __lambda7_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	GcaBackend* self;
	char* ret = NULL;
	GcaView* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const char* _tmp9_ = NULL;
	GcaRemoteDocument* _tmp10_ = NULL;
	GcaRemoteDocument* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		char* _tmp0_ = NULL;
		GcaDBusService* _tmp1_ = NULL;
		GAsyncResult* _tmp2_ = NULL;
		char* _tmp3_ = NULL;
		char* _tmp4_ = NULL;
		_tmp1_ = self->priv->d_service;
		_tmp2_ = res;
		_tmp3_ = gca_dbus_service_parse_finish (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (ret);
		ret = _tmp4_;
		_g_free0 (_tmp0_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		gca_log_debug ("gca-backend.vala:232: Failed to parse: %s", _tmp6_);
		_g_error_free0 (e);
		_g_free0 (ret);
		return;
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (ret);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = _data2_->view;
	_tmp8_ = self->priv->d_name;
	_tmp9_ = ret;
	_tmp10_ = gca_remote_document_new (_tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	gca_view_update (_tmp7_, _tmp11_);
	_gca_remote_document_unref0 (_tmp11_);
	_g_free0 (ret);
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda7_ (self, source_object, res);
	block2_data_unref (self);
}


static void __lambda6_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	GcaBackend* self;
	gchar* data_path = NULL;
	GAsyncResult* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GcaDocument* doc = NULL;
	GcaView* _tmp2_ = NULL;
	GcaDocument* _tmp3_ = NULL;
	GcaDocument* _tmp4_ = NULL;
	GcaDocument* _tmp5_ = NULL;
	GcaDocument* _tmp6_ = NULL;
	gchar* path = NULL;
	GcaDocument* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GcaSourceLocation cursor = {0};
	GcaDocument* _tmp10_ = NULL;
	GcaSourceLocation _tmp11_ = {0};
	GcaSourceLocation _tmp12_ = {0};
	GHashTable* options = NULL;
	GHashFunc _tmp13_ = NULL;
	GEqualFunc _tmp14_ = NULL;
	GHashTable* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GcaDBusSourceLocation dbuscurs = {0};
	GcaSourceLocation _tmp19_ = {0};
	gint _tmp20_ = 0;
	GcaSourceLocation _tmp21_ = {0};
	gint _tmp22_ = 0;
	GcaDBusSourceLocation _tmp23_ = {0};
	GcaDBusService* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GcaDBusSourceLocation _tmp27_ = {0};
	GHashTable* _tmp28_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = gca_backend_unsaved_document_finish (self, _tmp0_);
	data_path = _tmp1_;
	_tmp2_ = _data2_->view;
	_tmp3_ = gca_view_get_document (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	doc = _tmp5_;
	_tmp6_ = doc;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (doc);
		_g_free0 (data_path);
		return;
	}
	_tmp7_ = doc;
	_tmp8_ = gca_document_get_path (_tmp7_);
	_tmp9_ = _tmp8_;
	path = _tmp9_;
	_tmp10_ = doc;
	gca_document_get_cursor (_tmp10_, &_tmp11_);
	_tmp12_ = _tmp11_;
	cursor = _tmp12_;
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_variant_unref0_);
	options = _tmp15_;
	_tmp16_ = data_path;
	if (_tmp16_ == NULL) {
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp17_ = path;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (data_path);
		data_path = _tmp18_;
	}
	_tmp19_ = cursor;
	_tmp20_ = _tmp19_.line;
	_tmp21_ = cursor;
	_tmp22_ = _tmp21_.column;
	memset (&_tmp23_, 0, sizeof (GcaDBusSourceLocation));
	_tmp23_.line = (gint64) _tmp20_;
	_tmp23_.column = (gint64) _tmp22_;
	dbuscurs = _tmp23_;
	_tmp24_ = self->priv->d_service;
	_tmp25_ = path;
	_tmp26_ = data_path;
	_tmp27_ = dbuscurs;
	_tmp28_ = options;
	gca_dbus_service_parse (_tmp24_, _tmp25_, _tmp26_, &_tmp27_, _tmp28_, ___lambda7__gasync_ready_callback, block2_data_ref (_data2_));
	_g_hash_table_unref0 (options);
	_g_free0 (path);
	_g_object_unref0 (doc);
	_g_free0 (data_path);
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda6_ (self, source_object, res);
	block2_data_unref (self);
}


static void gca_backend_parse_single (GcaBackend* self, GcaView* view) {
	Block2Data* _data2_;
	GcaView* _tmp0_ = NULL;
	GcaView* _tmp1_ = NULL;
	GcaView* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->view);
	_data2_->view = _tmp1_;
	_tmp2_ = _data2_->view;
	gca_backend_unsaved_document (self, _tmp2_, ___lambda6__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GcaBackend* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->view);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _vala_GcaDBusRemoteDocument_array_free (GcaDBusRemoteDocument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gca_dbus_remote_document_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void __lambda5_ (GcaBackend* self, GObject* obj, GAsyncResult* res) {
	GcaDBusRemoteDocument* ret = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GcaDBusRemoteDocument* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GcaDBusRemoteDocument* _tmp0_ = NULL;
		GcaDBusProject* _tmp1_ = NULL;
		GAsyncResult* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GcaDBusRemoteDocument* _tmp4_ = NULL;
		gint _tmp0__length1 = 0;
		gint __tmp0__size_ = 0;
		GcaDBusRemoteDocument* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp1_ = self->priv->d_project;
		_tmp2_ = res;
		_tmp4_ = gca_dbus_project_parse_all_finish (_tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
		_tmp0_ = _tmp4_;
		_tmp0__length1 = _tmp3_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp5__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
		ret = _tmp5_;
		ret_length1 = _tmp5__length1;
		_ret_size_ = ret_length1;
		_tmp0_ = (_vala_GcaDBusRemoteDocument_array_free (_tmp0_, _tmp0__length1), NULL);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		gca_log_debug ("gca-backend.vala:272: Failed to parse: %s", _tmp7_);
		_g_error_free0 (e);
		ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
		return;
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = ret;
	_tmp8__length1 = ret_length1;
	{
		GcaDBusRemoteDocument* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp8_;
		d_collection_length1 = _tmp8__length1;
		for (d_it = 0; d_it < _tmp8__length1; d_it = d_it + 1) {
			GcaDBusRemoteDocument _tmp9_ = {0};
			GcaDBusRemoteDocument d = {0};
			gca_dbus_remote_document_copy (&d_collection[d_it], &_tmp9_);
			d = _tmp9_;
			{
				GeeHashMap* _tmp10_ = NULL;
				GcaDBusRemoteDocument _tmp11_ = {0};
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				_tmp10_ = self->priv->d_paths;
				_tmp11_ = d;
				_tmp12_ = _tmp11_.path;
				_tmp13_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp12_);
				if (_tmp13_) {
					GcaView* vw = NULL;
					GeeHashMap* _tmp14_ = NULL;
					GcaDBusRemoteDocument _tmp15_ = {0};
					const gchar* _tmp16_ = NULL;
					gpointer _tmp17_ = NULL;
					GcaView* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					GcaDBusRemoteDocument _tmp20_ = {0};
					const char* _tmp21_ = NULL;
					GcaRemoteDocument* _tmp22_ = NULL;
					GcaRemoteDocument* _tmp23_ = NULL;
					_tmp14_ = self->priv->d_paths;
					_tmp15_ = d;
					_tmp16_ = _tmp15_.path;
					_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp16_);
					vw = (GcaView*) _tmp17_;
					_tmp18_ = vw;
					_tmp19_ = self->priv->d_name;
					_tmp20_ = d;
					_tmp21_ = _tmp20_.remote_path;
					_tmp22_ = gca_remote_document_new (_tmp19_, _tmp21_);
					_tmp23_ = _tmp22_;
					gca_view_update (_tmp18_, _tmp23_);
					_gca_remote_document_unref0 (_tmp23_);
					_g_object_unref0 (vw);
				}
				gca_dbus_remote_document_destroy (&d);
			}
		}
	}
	ret = (_vala_GcaDBusRemoteDocument_array_free (ret, ret_length1), NULL);
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda5_ ((GcaBackend*) self, source_object, res);
	g_object_unref (self);
}


static void __lambda4_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	GcaBackend* self;
	GcaDBusOpenDocument* docs = NULL;
	GAsyncResult* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GcaDBusOpenDocument* _tmp2_ = NULL;
	gint docs_length1 = 0;
	gint _docs_size_ = 0;
	GcaDocument* doc = NULL;
	GcaView* _tmp3_ = NULL;
	GcaDocument* _tmp4_ = NULL;
	GcaDocument* _tmp5_ = NULL;
	GcaDocument* _tmp6_ = NULL;
	GcaDocument* _tmp7_ = NULL;
	gchar* path = NULL;
	GcaDocument* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GcaSourceLocation cursor = {0};
	GcaDocument* _tmp11_ = NULL;
	GcaSourceLocation _tmp12_ = {0};
	GcaSourceLocation _tmp13_ = {0};
	GHashTable* options = NULL;
	GHashFunc _tmp14_ = NULL;
	GEqualFunc _tmp15_ = NULL;
	GHashTable* _tmp16_ = NULL;
	GcaDBusSourceLocation dbuscurs = {0};
	GcaSourceLocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	GcaSourceLocation _tmp19_ = {0};
	gint _tmp20_ = 0;
	GcaDBusSourceLocation _tmp21_ = {0};
	GcaDBusProject* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GcaDBusOpenDocument* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	GcaDBusSourceLocation _tmp25_ = {0};
	GHashTable* _tmp26_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp2_ = gca_backend_open_documents_finish (self, _tmp0_, &_tmp1_);
	docs = _tmp2_;
	docs_length1 = _tmp1_;
	_docs_size_ = docs_length1;
	_tmp3_ = _data3_->view;
	_tmp4_ = gca_view_get_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	doc = _tmp6_;
	_tmp7_ = doc;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (doc);
		docs = (_vala_GcaDBusOpenDocument_array_free (docs, docs_length1), NULL);
		return;
	}
	_tmp8_ = doc;
	_tmp9_ = gca_document_get_path (_tmp8_);
	_tmp10_ = _tmp9_;
	path = _tmp10_;
	_tmp11_ = doc;
	gca_document_get_cursor (_tmp11_, &_tmp12_);
	_tmp13_ = _tmp12_;
	cursor = _tmp13_;
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, _g_free0_, _g_variant_unref0_);
	options = _tmp16_;
	_tmp17_ = cursor;
	_tmp18_ = _tmp17_.line;
	_tmp19_ = cursor;
	_tmp20_ = _tmp19_.column;
	memset (&_tmp21_, 0, sizeof (GcaDBusSourceLocation));
	_tmp21_.line = (gint64) _tmp18_;
	_tmp21_.column = (gint64) _tmp20_;
	dbuscurs = _tmp21_;
	_tmp22_ = self->priv->d_project;
	_tmp23_ = path;
	_tmp24_ = docs;
	_tmp24__length1 = docs_length1;
	_tmp25_ = dbuscurs;
	_tmp26_ = options;
	gca_dbus_project_parse_all (_tmp22_, _tmp23_, _tmp24_, _tmp24__length1, &_tmp25_, _tmp26_, ___lambda5__gasync_ready_callback, g_object_ref (self));
	_g_hash_table_unref0 (options);
	_g_free0 (path);
	_g_object_unref0 (doc);
	docs = (_vala_GcaDBusOpenDocument_array_free (docs, docs_length1), NULL);
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda4_ (self, source_object, res);
	block3_data_unref (self);
}


static void gca_backend_parse_project (GcaBackend* self, GcaView* view) {
	Block3Data* _data3_;
	GcaView* _tmp0_ = NULL;
	GcaView* _tmp1_ = NULL;
	GcaView* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->view);
	_data3_->view = _tmp1_;
	_tmp2_ = _data3_->view;
	gca_backend_open_documents (self, _tmp2_, ___lambda4__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void gca_backend_parse (GcaBackend* self, GcaView* view) {
	GcaDBusProject* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = self->priv->d_project;
	if (_tmp0_ != NULL) {
		GcaView* _tmp1_ = NULL;
		_tmp1_ = view;
		gca_backend_parse_project (self, _tmp1_);
	} else {
		GcaView* _tmp2_ = NULL;
		_tmp2_ = view;
		gca_backend_parse_single (self, _tmp2_);
	}
}


static void gca_backend_on_view_changed (GcaBackend* self, GcaView* view) {
	GcaView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = view;
	gca_backend_parse (self, _tmp0_);
}


static void gca_backend_class_init (GcaBackendClass * klass) {
	gca_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcaBackendPrivate));
	G_OBJECT_CLASS (klass)->finalize = gca_backend_finalize;
}


static void gca_backend_instance_init (GcaBackend * self) {
	self->priv = GCA_BACKEND_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_d_views);
}


static void gca_backend_finalize (GObject* obj) {
	GcaBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_BACKEND, GcaBackend);
	g_rec_mutex_clear (&self->priv->__lock_d_views);
	_g_object_unref0 (self->priv->d_views);
	_g_object_unref0 (self->priv->d_paths);
	_g_free0 (self->priv->d_name);
	_g_object_unref0 (self->priv->d_service);
	_g_object_unref0 (self->priv->d_project);
	G_OBJECT_CLASS (gca_backend_parent_class)->finalize (obj);
}


GType gca_backend_get_type (void) {
	static volatile gsize gca_backend_type_id__volatile = 0;
	if (g_once_init_enter (&gca_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaBackend), 0, (GInstanceInitFunc) gca_backend_instance_init, NULL };
		GType gca_backend_type_id;
		gca_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaBackend", &g_define_type_info, 0);
		g_once_init_leave (&gca_backend_type_id__volatile, gca_backend_type_id);
	}
	return gca_backend_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



