/* gtk-gridboard-themes.h :
 *
 * Copyright (C) 2005 by Callum McKenzie
 *
 * Time-stamp: <2006-02-15 18:52:07 callum>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more details see the file COPYING.
 *
 */


#ifndef GTK_GRIDBOARD_THEMES_H
#define GTK_GRIDBOARD_THEMES_H

#include <gtk/gtk.h>
#include <cairo.h>

typedef void GtkGridboardThemeBGFunc (cairo_t *, gdouble, gdouble);
typedef void GtkGridboardThemePieceFunc (cairo_t *, gdouble, gdouble, gdouble);
typedef void GtkGridboardThemeHiliteFunc (cairo_t *, gdouble, gdouble);
typedef void GtkGridboardThemeGridFunc (cairo_t *, gdouble, gdouble);

typedef struct _GtkGridBoardTheme {
  gchar *name;
  GtkGridboardThemeBGFunc *draw_bg;
  GtkGridboardThemePieceFunc *draw_piece;
  GtkGridboardThemeHiliteFunc *draw_hilight;
  GtkGridboardThemeGridFunc *draw_grid;
} GtkGridBoardTheme;

extern GtkGridBoardTheme gtk_gridboard_themes[];

#endif /* GTK_GRIDBOARD_THEMES_H */
