/* chess-pgn.c generated by valac 0.11.6, the Vala compiler
 * generated from chess-pgn.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;
typedef struct _PGNGamePrivate PGNGamePrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecPGNGame ParamSpecPGNGame;

#define TYPE_STATE (state_get_type ())

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;
#define __g_list_free__pgn_game_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__pgn_game_unref0_ (var), NULL)))
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
typedef struct _ParamSpecPGN ParamSpecPGN;

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()
struct _PGNGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GTypeClass parent_class;
	void (*finalize) (PGNGame *self);
};

struct _ParamSpecPGNGame {
	GParamSpec parent_instance;
};

typedef enum  {
	STATE_IDLE,
	STATE_LINE_COMMENT,
	STATE_BRACE_COMMENT,
	STATE_TAG_START,
	STATE_TAG_NAME,
	STATE_PRE_TAG_VALUE,
	STATE_TAG_VALUE,
	STATE_POST_TAG_VALUE,
	STATE_SYMBOL,
	STATE_NAG,
	STATE_ERROR
} State;

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _ParamSpecPGN {
	GParamSpec parent_instance;
};


static gpointer pgn_game_parent_class = NULL;
extern gchar* pgn_game_RESULT_IN_PROGRESS;
gchar* pgn_game_RESULT_IN_PROGRESS = NULL;
extern gchar* pgn_game_RESULT_DRAW;
gchar* pgn_game_RESULT_DRAW = NULL;
extern gchar* pgn_game_RESULT_WHITE;
gchar* pgn_game_RESULT_WHITE = NULL;
extern gchar* pgn_game_RESULT_BLACK;
gchar* pgn_game_RESULT_BLACK = NULL;
extern gchar* pgn_game_TERMINATE_ABANDONED;
gchar* pgn_game_TERMINATE_ABANDONED = NULL;
extern gchar* pgn_game_TERMINATE_ADJUDICATION;
gchar* pgn_game_TERMINATE_ADJUDICATION = NULL;
extern gchar* pgn_game_TERMINATE_DEATH;
gchar* pgn_game_TERMINATE_DEATH = NULL;
extern gchar* pgn_game_TERMINATE_EMERGENCY;
gchar* pgn_game_TERMINATE_EMERGENCY = NULL;
extern gchar* pgn_game_TERMINATE_NORMAL;
gchar* pgn_game_TERMINATE_NORMAL = NULL;
extern gchar* pgn_game_TERMINATE_RULES_INFRACTION;
gchar* pgn_game_TERMINATE_RULES_INFRACTION = NULL;
extern gchar* pgn_game_TERMINATE_TIME_FORFEIT;
gchar* pgn_game_TERMINATE_TIME_FORFEIT = NULL;
extern gchar* pgn_game_TERMINATE_UNTERMINATED;
gchar* pgn_game_TERMINATE_UNTERMINATED = NULL;
static gpointer pgn_parent_class = NULL;

gint str_index (const gchar* name);
gint compare_tag (const gchar* name0, const gchar* name1);
GQuark pgn_error_quark (void);
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
enum  {
	PGN_GAME_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
PGNGame* pgn_game_new (void);
PGNGame* pgn_game_construct (GType object_type);
void pgn_game_write (PGNGame* self, GFile* file, GError** error);
const gchar* pgn_game_get_result (PGNGame* self);
const gchar* pgn_game_get_event (PGNGame* self);
void pgn_game_set_event (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_site (PGNGame* self);
void pgn_game_set_site (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_date (PGNGame* self);
void pgn_game_set_date (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_time (PGNGame* self);
void pgn_game_set_time (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_round (PGNGame* self);
void pgn_game_set_round (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white (PGNGame* self);
void pgn_game_set_white (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black (PGNGame* self);
void pgn_game_set_black (PGNGame* self, const gchar* value);
void pgn_game_set_result (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_annotator (PGNGame* self);
void pgn_game_set_annotator (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_time_control (PGNGame* self);
void pgn_game_set_time_control (PGNGame* self, const gchar* value);
gboolean pgn_game_get_set_up (PGNGame* self);
void pgn_game_set_set_up (PGNGame* self, gboolean value);
const gchar* pgn_game_get_fen (PGNGame* self);
void pgn_game_set_fen (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_termination (PGNGame* self);
void pgn_game_set_termination (PGNGame* self, const gchar* value);
static void pgn_game_finalize (PGNGame* obj);
GType state_get_type (void) G_GNUC_CONST;
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
enum  {
	PGN_DUMMY_PROPERTY
};
static void _pgn_game_unref0_ (gpointer var);
static void _g_list_free__pgn_game_unref0_ (GList* self);
PGN* pgn_new (void);
PGN* pgn_construct (GType object_type);
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
static void pgn_finalize (PGN* obj);


gint str_index (const gchar* name) {
	gint result = 0;
	g_return_val_if_fail (name != NULL, 0);
	if (g_strcmp0 (name, "Event") == 0) {
		result = 0;
		return result;
	} else {
		if (g_strcmp0 (name, "Site") == 0) {
			result = 1;
			return result;
		} else {
			if (g_strcmp0 (name, "Date") == 0) {
				result = 2;
				return result;
			} else {
				if (g_strcmp0 (name, "Round") == 0) {
					result = 3;
					return result;
				} else {
					if (g_strcmp0 (name, "White") == 0) {
						result = 4;
						return result;
					} else {
						if (g_strcmp0 (name, "Black") == 0) {
							result = 5;
							return result;
						} else {
							if (g_strcmp0 (name, "Result") == 0) {
								result = 6;
								return result;
							} else {
								result = 7;
								return result;
							}
						}
					}
				}
			}
		}
	}
}


gint compare_tag (const gchar* name0, const gchar* name1) {
	gint result = 0;
	gint _tmp0_;
	gint str_index0;
	gint _tmp1_;
	gint str_index1;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (name0 != NULL, 0);
	g_return_val_if_fail (name1 != NULL, 0);
	_tmp0_ = str_index (name0);
	str_index0 = _tmp0_;
	_tmp1_ = str_index (name1);
	str_index1 = _tmp1_;
	if (str_index0 == 7) {
		_tmp2_ = str_index1 == 7;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = g_strcmp0 (name0, name1);
		result = _tmp3_;
		return result;
	} else {
		result = str_index0 - str_index1;
		return result;
	}
}


GQuark pgn_error_quark (void) {
	return g_quark_from_static_string ("pgn_error-quark");
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


PGNGame* pgn_game_construct (GType object_type) {
	PGNGame* self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	self = (PGNGame*) g_type_create_instance (object_type);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	_tmp1_ = _tmp0_;
	_g_hash_table_unref0 (self->tags);
	self->tags = _tmp1_;
	_tmp2_ = g_strdup ("Event");
	_tmp3_ = g_strdup ("?");
	g_hash_table_insert (self->tags, _tmp2_, _tmp3_);
	_tmp4_ = g_strdup ("Site");
	_tmp5_ = g_strdup ("?");
	g_hash_table_insert (self->tags, _tmp4_, _tmp5_);
	_tmp6_ = g_strdup ("Date");
	_tmp7_ = g_strdup ("????.??.??");
	g_hash_table_insert (self->tags, _tmp6_, _tmp7_);
	_tmp8_ = g_strdup ("Round");
	_tmp9_ = g_strdup ("?");
	g_hash_table_insert (self->tags, _tmp8_, _tmp9_);
	_tmp10_ = g_strdup ("White");
	_tmp11_ = g_strdup ("?");
	g_hash_table_insert (self->tags, _tmp10_, _tmp11_);
	_tmp12_ = g_strdup ("Black");
	_tmp13_ = g_strdup ("?");
	g_hash_table_insert (self->tags, _tmp12_, _tmp13_);
	_tmp14_ = g_strdup ("Result");
	_tmp15_ = g_strdup (pgn_game_RESULT_IN_PROGRESS);
	g_hash_table_insert (self->tags, _tmp14_, _tmp15_);
	return self;
}


PGNGame* pgn_game_new (void) {
	return pgn_game_construct (TYPE_PGN_GAME);
}


void pgn_game_write (PGNGame* self, GFile* file, GError** error) {
	GString* _tmp0_ = NULL;
	GString* data;
	GList* _tmp1_ = NULL;
	GList* keys;
	gint i;
	const gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_string_new ("");
	data = _tmp0_;
	_tmp1_ = g_hash_table_get_keys (self->tags);
	keys = _tmp1_;
	keys = g_list_sort (keys, (GCompareFunc) compare_tag);
	{
		GList* key_collection;
		GList* key_it;
		key_collection = keys;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key;
			key = (const gchar*) key_it->data;
			{
				gconstpointer _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				_tmp2_ = g_hash_table_lookup (self->tags, key);
				_tmp3_ = g_strdup_printf ("[%s \"%s\"]\n", key, (const gchar*) _tmp2_);
				_tmp4_ = _tmp3_;
				g_string_append (data, _tmp4_);
				_g_free0 (_tmp4_);
			}
		}
	}
	g_string_append (data, "\n");
	i = 0;
	{
		GList* move_collection;
		GList* move_it;
		move_collection = self->moves;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp5_;
			gchar* move;
			_tmp5_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp5_;
			{
				if ((i % 2) == 0) {
					gchar* _tmp6_ = NULL;
					gchar* _tmp7_;
					_tmp6_ = g_strdup_printf ("%d. ", (i / 2) + 1);
					_tmp7_ = _tmp6_;
					g_string_append (data, _tmp7_);
					_g_free0 (_tmp7_);
				}
				g_string_append (data, move);
				g_string_append (data, " ");
				i++;
				_g_free0 (move);
			}
		}
	}
	_tmp8_ = pgn_game_get_result (self);
	g_string_append (data, _tmp8_);
	g_string_append (data, "\n");
	g_file_replace_contents (file, data->str, (gsize) data->len, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_list_free0 (keys);
		_g_string_free0 (data);
		return;
	}
	_g_list_free0 (keys);
	_g_string_free0 (data);
}


const gchar* pgn_game_get_event (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Event");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_event (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Event");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_site (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Site");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_site (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Site");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_date (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Date");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_date (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Date");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_time (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Time");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_time (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Time");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_round (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Round");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_round (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Round");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_white (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "White");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_white (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("White");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_black (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Black");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_black (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Black");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_result (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Result");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_result (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Result");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_annotator (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Annotator");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_annotator (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Annotator");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_time_control (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "TimeControl");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_time_control (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("TimeControl");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


gboolean pgn_game_get_set_up (PGNGame* self) {
	gboolean result;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* v;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_hash_table_lookup (self->tags, "SetUp");
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	v = _tmp1_;
	if (v != NULL) {
		_tmp3_ = g_strcmp0 (v, "1") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (v);
	return result;
}


void pgn_game_set_set_up (PGNGame* self, gboolean value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = "1";
	} else {
		_tmp0_ = "0";
	}
	_tmp1_ = g_strdup ("SetUp");
	_tmp2_ = g_strdup (_tmp0_);
	g_hash_table_insert (self->tags, _tmp1_, _tmp2_);
}


const gchar* pgn_game_get_fen (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "FEN");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_fen (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("FEN");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


const gchar* pgn_game_get_termination (PGNGame* self) {
	const gchar* result;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->tags, "Termination");
	result = (const gchar*) _tmp0_;
	return result;
}


void pgn_game_set_termination (PGNGame* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Termination");
	_tmp1_ = g_strdup (value);
	g_hash_table_insert (self->tags, _tmp0_, _tmp1_);
}


static void value_pgn_game_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pgn_game_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pgn_game_unref (value->data[0].v_pointer);
	}
}


static void value_pgn_game_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pgn_game_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pgn_game_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pgn_game_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PGNGame* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pgn_game_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pgn_game_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PGNGame** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pgn_game_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPGNGame* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PGN_GAME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pgn_game (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN_GAME), NULL);
	return value->data[0].v_pointer;
}


void value_set_pgn_game (GValue* value, gpointer v_object) {
	PGNGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pgn_game_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_game_unref (old);
	}
}


void value_take_pgn_game (GValue* value, gpointer v_object) {
	PGNGame* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN_GAME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN_GAME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_game_unref (old);
	}
}


static void pgn_game_class_init (PGNGameClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	pgn_game_parent_class = g_type_class_peek_parent (klass);
	PGN_GAME_CLASS (klass)->finalize = pgn_game_finalize;
	_tmp0_ = g_strdup ("*");
	pgn_game_RESULT_IN_PROGRESS = _tmp0_;
	_tmp1_ = g_strdup ("1/2-1/2");
	pgn_game_RESULT_DRAW = _tmp1_;
	_tmp2_ = g_strdup ("1-0");
	pgn_game_RESULT_WHITE = _tmp2_;
	_tmp3_ = g_strdup ("0-1");
	pgn_game_RESULT_BLACK = _tmp3_;
	_tmp4_ = g_strdup ("abandoned");
	pgn_game_TERMINATE_ABANDONED = _tmp4_;
	_tmp5_ = g_strdup ("adjudication");
	pgn_game_TERMINATE_ADJUDICATION = _tmp5_;
	_tmp6_ = g_strdup ("death");
	pgn_game_TERMINATE_DEATH = _tmp6_;
	_tmp7_ = g_strdup ("emergency");
	pgn_game_TERMINATE_EMERGENCY = _tmp7_;
	_tmp8_ = g_strdup ("normal");
	pgn_game_TERMINATE_NORMAL = _tmp8_;
	_tmp9_ = g_strdup ("rules infraction");
	pgn_game_TERMINATE_RULES_INFRACTION = _tmp9_;
	_tmp10_ = g_strdup ("time forfeit");
	pgn_game_TERMINATE_TIME_FORFEIT = _tmp10_;
	_tmp11_ = g_strdup ("unterminated");
	pgn_game_TERMINATE_UNTERMINATED = _tmp11_;
}


static void pgn_game_instance_init (PGNGame * self) {
	self->ref_count = 1;
}


static void pgn_game_finalize (PGNGame* obj) {
	PGNGame * self;
	self = PGN_GAME (obj);
	_g_hash_table_unref0 (self->tags);
	__g_list_free__g_free0_0 (self->moves);
}


GType pgn_game_get_type (void) {
	static volatile gsize pgn_game_type_id__volatile = 0;
	if (g_once_init_enter (&pgn_game_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pgn_game_init, value_pgn_game_free_value, value_pgn_game_copy_value, value_pgn_game_peek_pointer, "p", value_pgn_game_collect_value, "p", value_pgn_game_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PGNGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pgn_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PGNGame), 0, (GInstanceInitFunc) pgn_game_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pgn_game_type_id;
		pgn_game_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PGNGame", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pgn_game_type_id__volatile, pgn_game_type_id);
	}
	return pgn_game_type_id__volatile;
}


gpointer pgn_game_ref (gpointer instance) {
	PGNGame* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pgn_game_unref (gpointer instance) {
	PGNGame* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PGN_GAME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType state_get_type (void) {
	static volatile gsize state_type_id__volatile = 0;
	if (g_once_init_enter (&state_type_id__volatile)) {
		static const GEnumValue values[] = {{STATE_IDLE, "STATE_IDLE", "idle"}, {STATE_LINE_COMMENT, "STATE_LINE_COMMENT", "line-comment"}, {STATE_BRACE_COMMENT, "STATE_BRACE_COMMENT", "brace-comment"}, {STATE_TAG_START, "STATE_TAG_START", "tag-start"}, {STATE_TAG_NAME, "STATE_TAG_NAME", "tag-name"}, {STATE_PRE_TAG_VALUE, "STATE_PRE_TAG_VALUE", "pre-tag-value"}, {STATE_TAG_VALUE, "STATE_TAG_VALUE", "tag-value"}, {STATE_POST_TAG_VALUE, "STATE_POST_TAG_VALUE", "post-tag-value"}, {STATE_SYMBOL, "STATE_SYMBOL", "symbol"}, {STATE_NAG, "STATE_NAG", "nag"}, {STATE_ERROR, "STATE_ERROR", "error"}, {0, NULL, NULL}};
		GType state_type_id;
		state_type_id = g_enum_register_static ("State", values);
		g_once_init_leave (&state_type_id__volatile, state_type_id);
	}
	return state_type_id__volatile;
}


static void _pgn_game_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL));
}


static void _g_list_free__pgn_game_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _pgn_game_unref0_, NULL);
	g_list_free (self);
}


PGN* pgn_construct (GType object_type) {
	PGN* self = NULL;
	self = (PGN*) g_type_create_instance (object_type);
	return self;
}


PGN* pgn_new (void) {
	return pgn_construct (TYPE_PGN);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error) {
	PGN* self = NULL;
	gchar* contents = NULL;
	gsize n_read = 0UL;
	gchar* _tmp0_ = NULL;
	gsize _tmp1_;
	State state;
	PGNGame* _tmp2_ = NULL;
	PGNGame* game;
	gboolean in_escape;
	gsize token_start;
	gsize line_offset;
	gchar* _tmp3_;
	gchar* tag_name;
	GString* _tmp4_ = NULL;
	GString* tag_value;
	gint line;
	gboolean have_tags;
	gint rav_level;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (PGN*) g_type_create_instance (object_type);
	g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp0_;
	n_read = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_pgn_unref0 (self);
		return NULL;
	}
	state = STATE_IDLE;
	_tmp2_ = pgn_game_new ();
	game = _tmp2_;
	in_escape = FALSE;
	token_start = (gsize) 0;
	line_offset = (gsize) 0;
	_tmp3_ = g_strdup ("");
	tag_name = _tmp3_;
	_tmp4_ = g_string_new ("");
	tag_value = _tmp4_;
	line = 1;
	have_tags = FALSE;
	rav_level = 0;
	{
		gsize offset;
		offset = (gsize) 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gchar _tmp7_;
				gunichar c;
				if (!_tmp5_) {
					offset++;
				}
				_tmp5_ = FALSE;
				_tmp6_ = strlen (contents);
				if (!(offset < _tmp6_)) {
					break;
				}
				_tmp7_ = string_get (contents, (glong) offset);
				c = (gunichar) _tmp7_;
				if (c == '\n') {
					line++;
					line_offset = offset + 1;
				}
				switch (state) {
					case STATE_IDLE:
					{
						gboolean _tmp8_;
						_tmp8_ = g_unichar_isspace (c);
						if (_tmp8_) {
						} else {
							if (c == ';') {
								state = STATE_LINE_COMMENT;
							} else {
								if (c == '{') {
									state = STATE_BRACE_COMMENT;
								} else {
									if (c == '[') {
										have_tags = TRUE;
										state = STATE_TAG_START;
									} else {
										gboolean _tmp9_ = FALSE;
										if (have_tags) {
											_tmp9_ = c == '*';
										} else {
											_tmp9_ = FALSE;
										}
										if (_tmp9_) {
											if (rav_level == 0) {
												PGNGame* _tmp10_;
												PGNGame* _tmp11_ = NULL;
												PGNGame* _tmp12_;
												pgn_game_set_result (game, pgn_game_RESULT_IN_PROGRESS);
												_tmp10_ = _pgn_game_ref0 (game);
												self->games = g_list_append (self->games, _tmp10_);
												_tmp11_ = pgn_game_new ();
												_tmp12_ = _tmp11_;
												_pgn_game_unref0 (game);
												game = _tmp12_;
												have_tags = FALSE;
											}
											state = STATE_IDLE;
										} else {
											gboolean _tmp13_ = FALSE;
											if (have_tags) {
												_tmp13_ = c == '.';
											} else {
												_tmp13_ = FALSE;
											}
											if (_tmp13_) {
												continue;
											} else {
												gboolean _tmp14_ = FALSE;
												if (have_tags) {
													gboolean _tmp15_;
													_tmp15_ = g_unichar_isalnum (c);
													_tmp14_ = _tmp15_;
												} else {
													_tmp14_ = FALSE;
												}
												if (_tmp14_) {
													token_start = offset;
													state = STATE_SYMBOL;
												} else {
													gboolean _tmp16_ = FALSE;
													if (have_tags) {
														_tmp16_ = c == '$';
													} else {
														_tmp16_ = FALSE;
													}
													if (_tmp16_) {
														token_start = offset + 1;
														state = STATE_NAG;
													} else {
														gboolean _tmp17_ = FALSE;
														if (have_tags) {
															_tmp17_ = c == '(';
														} else {
															_tmp17_ = FALSE;
														}
														if (_tmp17_) {
															rav_level++;
															continue;
														} else {
															gboolean _tmp18_ = FALSE;
															if (have_tags) {
																_tmp18_ = c == ')';
															} else {
																_tmp18_ = FALSE;
															}
															if (_tmp18_) {
																if (rav_level == 0) {
																	state = STATE_ERROR;
																} else {
																	rav_level--;
																}
															} else {
																state = STATE_ERROR;
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						break;
					}
					case STATE_LINE_COMMENT:
					{
						if (c == '\n') {
							state = STATE_IDLE;
						}
						break;
					}
					case STATE_BRACE_COMMENT:
					{
						if (c == '}') {
							state = STATE_IDLE;
						}
						break;
					}
					case STATE_TAG_START:
					{
						gboolean _tmp19_;
						_tmp19_ = g_unichar_isspace (c);
						if (_tmp19_) {
							continue;
						} else {
							gboolean _tmp20_;
							_tmp20_ = g_unichar_isalnum (c);
							if (_tmp20_) {
								token_start = offset;
								state = STATE_TAG_NAME;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_TAG_NAME:
					{
						gboolean _tmp21_;
						_tmp21_ = g_unichar_isspace (c);
						if (_tmp21_) {
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_;
							_tmp22_ = string_slice (contents, (glong) token_start, (glong) offset);
							_tmp23_ = _tmp22_;
							_g_free0 (tag_name);
							tag_name = _tmp23_;
							state = STATE_PRE_TAG_VALUE;
						} else {
							gboolean _tmp24_ = FALSE;
							gboolean _tmp25_ = FALSE;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_;
							_tmp30_ = g_unichar_isalnum (c);
							if (_tmp30_) {
								_tmp29_ = TRUE;
							} else {
								_tmp29_ = c == '_';
							}
							if (_tmp29_) {
								_tmp28_ = TRUE;
							} else {
								_tmp28_ = c == '+';
							}
							if (_tmp28_) {
								_tmp27_ = TRUE;
							} else {
								_tmp27_ = c == '#';
							}
							if (_tmp27_) {
								_tmp26_ = TRUE;
							} else {
								_tmp26_ = c == '=';
							}
							if (_tmp26_) {
								_tmp25_ = TRUE;
							} else {
								_tmp25_ = c == ':';
							}
							if (_tmp25_) {
								_tmp24_ = TRUE;
							} else {
								_tmp24_ = c == '-';
							}
							if (_tmp24_) {
								continue;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_PRE_TAG_VALUE:
					{
						gboolean _tmp31_;
						_tmp31_ = g_unichar_isspace (c);
						if (_tmp31_) {
							continue;
						} else {
							if (c == '"') {
								state = STATE_TAG_VALUE;
								g_string_erase (tag_value, (gssize) 0, (gssize) (-1));
								in_escape = FALSE;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_TAG_VALUE:
					{
						gboolean _tmp32_ = FALSE;
						if (c == '\\') {
							_tmp32_ = !in_escape;
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							in_escape = TRUE;
						} else {
							gboolean _tmp33_ = FALSE;
							if (c == '"') {
								_tmp33_ = !in_escape;
							} else {
								_tmp33_ = FALSE;
							}
							if (_tmp33_) {
								state = STATE_POST_TAG_VALUE;
							} else {
								gboolean _tmp34_;
								_tmp34_ = g_unichar_isprint (c);
								if (_tmp34_) {
									g_string_append_unichar (tag_value, c);
									in_escape = FALSE;
								} else {
									state = STATE_ERROR;
								}
							}
						}
						break;
					}
					case STATE_POST_TAG_VALUE:
					{
						gboolean _tmp35_;
						_tmp35_ = g_unichar_isspace (c);
						if (_tmp35_) {
							continue;
						} else {
							if (c == ']') {
								gchar* _tmp36_;
								gchar* _tmp37_;
								_tmp36_ = g_strdup (tag_name);
								_tmp37_ = g_strdup (tag_value->str);
								g_hash_table_insert (game->tags, _tmp36_, _tmp37_);
								state = STATE_IDLE;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_SYMBOL:
					{
						gboolean _tmp38_ = FALSE;
						gboolean _tmp39_ = FALSE;
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
						gboolean _tmp42_ = FALSE;
						gboolean _tmp43_ = FALSE;
						gboolean _tmp44_ = FALSE;
						gboolean _tmp45_;
						_tmp45_ = g_unichar_isalnum (c);
						if (_tmp45_) {
							_tmp44_ = TRUE;
						} else {
							_tmp44_ = c == '_';
						}
						if (_tmp44_) {
							_tmp43_ = TRUE;
						} else {
							_tmp43_ = c == '+';
						}
						if (_tmp43_) {
							_tmp42_ = TRUE;
						} else {
							_tmp42_ = c == '#';
						}
						if (_tmp42_) {
							_tmp41_ = TRUE;
						} else {
							_tmp41_ = c == '=';
						}
						if (_tmp41_) {
							_tmp40_ = TRUE;
						} else {
							_tmp40_ = c == ':';
						}
						if (_tmp40_) {
							_tmp39_ = TRUE;
						} else {
							_tmp39_ = c == '-';
						}
						if (_tmp39_) {
							_tmp38_ = TRUE;
						} else {
							_tmp38_ = c == '/';
						}
						if (_tmp38_) {
							continue;
						} else {
							gchar* _tmp46_ = NULL;
							gchar* symbol;
							gboolean is_number;
							gboolean _tmp51_ = FALSE;
							gboolean _tmp52_ = FALSE;
							_tmp46_ = string_slice (contents, (glong) token_start, (glong) offset);
							symbol = _tmp46_;
							is_number = TRUE;
							{
								gint i;
								i = 0;
								{
									gboolean _tmp47_;
									_tmp47_ = TRUE;
									while (TRUE) {
										gint _tmp48_;
										gchar _tmp49_;
										gboolean _tmp50_;
										if (!_tmp47_) {
											i++;
										}
										_tmp47_ = FALSE;
										_tmp48_ = strlen (symbol);
										if (!(i < _tmp48_)) {
											break;
										}
										_tmp49_ = string_get (symbol, (glong) i);
										_tmp50_ = g_ascii_isdigit (_tmp49_);
										if (!_tmp50_) {
											is_number = FALSE;
										}
									}
								}
							}
							if (g_strcmp0 (symbol, pgn_game_RESULT_DRAW) == 0) {
								_tmp52_ = TRUE;
							} else {
								_tmp52_ = g_strcmp0 (symbol, pgn_game_RESULT_WHITE) == 0;
							}
							if (_tmp52_) {
								_tmp51_ = TRUE;
							} else {
								_tmp51_ = g_strcmp0 (symbol, pgn_game_RESULT_BLACK) == 0;
							}
							if (_tmp51_) {
								if (rav_level == 0) {
									PGNGame* _tmp53_;
									PGNGame* _tmp54_ = NULL;
									PGNGame* _tmp55_;
									pgn_game_set_result (game, symbol);
									_tmp53_ = _pgn_game_ref0 (game);
									self->games = g_list_append (self->games, _tmp53_);
									_tmp54_ = pgn_game_new ();
									_tmp55_ = _tmp54_;
									_pgn_game_unref0 (game);
									game = _tmp55_;
									have_tags = FALSE;
								}
							} else {
								if (!is_number) {
									if (rav_level == 0) {
										gchar* _tmp56_;
										_tmp56_ = g_strdup (symbol);
										game->moves = g_list_append (game->moves, _tmp56_);
									}
								}
							}
							state = STATE_IDLE;
							offset--;
							_g_free0 (symbol);
						}
						break;
					}
					case STATE_NAG:
					{
						gboolean _tmp57_;
						_tmp57_ = g_unichar_isdigit (c);
						if (_tmp57_) {
							continue;
						} else {
							state = STATE_IDLE;
							offset--;
						}
						break;
					}
					case STATE_ERROR:
					{
						gsize char_offset;
						gchar* _tmp58_ = NULL;
						gchar* filename;
						gchar* _tmp61_ = NULL;
						gchar* _tmp62_;
						char_offset = (offset - line_offset) - 1;
						_tmp58_ = g_file_get_path (file);
						filename = _tmp58_;
						if (filename == NULL) {
							gchar* _tmp59_ = NULL;
							gchar* _tmp60_;
							_tmp59_ = g_file_get_uri (file);
							_tmp60_ = _tmp59_;
							_g_free0 (filename);
							filename = _tmp60_;
						}
						fprintf (stderr, "%s:%d.%d: error: Unexpected character\n", filename, line, (gint) (char_offset + 1));
						_tmp61_ = string_slice (contents, (glong) line_offset, (glong) offset);
						_tmp62_ = _tmp61_;
						fprintf (stderr, "%s\n", _tmp62_);
						_g_free0 (_tmp62_);
						{
							gint i;
							i = 0;
							{
								gboolean _tmp63_;
								_tmp63_ = TRUE;
								while (TRUE) {
									if (!_tmp63_) {
										i++;
									}
									_tmp63_ = FALSE;
									if (!(i < char_offset)) {
										break;
									}
									fprintf (stderr, " ");
								}
							}
						}
						fprintf (stderr, "^\n");
						_g_free0 (filename);
						_g_string_free0 (tag_value);
						_g_free0 (tag_name);
						_pgn_game_unref0 (game);
						_g_free0 (contents);
						return self;
					}
					default:
					break;
				}
			}
		}
	}
	if (self->games == NULL) {
		GError* _tmp64_ = NULL;
		_tmp64_ = g_error_new_literal (PGN_ERROR, PGN_ERROR_LOAD_ERROR, "No games in PGN file");
		_inner_error_ = _tmp64_;
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (tag_value);
		_g_free0 (tag_name);
		_pgn_game_unref0 (game);
		_g_free0 (contents);
		_pgn_unref0 (self);
		return NULL;
	}
	_g_string_free0 (tag_value);
	_g_free0 (tag_name);
	_pgn_game_unref0 (game);
	_g_free0 (contents);
	return self;
}


PGN* pgn_new_from_file (GFile* file, GError** error) {
	return pgn_construct_from_file (TYPE_PGN, file, error);
}


static void value_pgn_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pgn_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pgn_unref (value->data[0].v_pointer);
	}
}


static void value_pgn_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pgn_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pgn_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pgn_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PGN* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pgn_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pgn_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PGN** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pgn_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPGN* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PGN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pgn (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN), NULL);
	return value->data[0].v_pointer;
}


void value_set_pgn (GValue* value, gpointer v_object) {
	PGN* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pgn_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_unref (old);
	}
}


void value_take_pgn (GValue* value, gpointer v_object) {
	PGN* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PGN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PGN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pgn_unref (old);
	}
}


static void pgn_class_init (PGNClass * klass) {
	pgn_parent_class = g_type_class_peek_parent (klass);
	PGN_CLASS (klass)->finalize = pgn_finalize;
}


static void pgn_instance_init (PGN * self) {
	self->ref_count = 1;
}


static void pgn_finalize (PGN* obj) {
	PGN * self;
	self = PGN (obj);
	__g_list_free__pgn_game_unref0_0 (self->games);
}


GType pgn_get_type (void) {
	static volatile gsize pgn_type_id__volatile = 0;
	if (g_once_init_enter (&pgn_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pgn_init, value_pgn_free_value, value_pgn_copy_value, value_pgn_peek_pointer, "p", value_pgn_collect_value, "p", value_pgn_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PGNClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pgn_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PGN), 0, (GInstanceInitFunc) pgn_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pgn_type_id;
		pgn_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PGN", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pgn_type_id__volatile, pgn_type_id);
	}
	return pgn_type_id__volatile;
}


gpointer pgn_ref (gpointer instance) {
	PGN* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pgn_unref (gpointer instance) {
	PGN* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PGN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



