/* test-chess-pgn.c generated by valac 0.12.0, the Vala compiler
 * generated from test-chess-pgn.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GL_CHESS (gl_chess_get_type ())
#define GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GL_CHESS, GlChess))
#define GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GL_CHESS, GlChessClass))
#define IS_GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GL_CHESS))
#define IS_GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GL_CHESS))
#define GL_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GL_CHESS, GlChessClass))

typedef struct _GlChess GlChess;
typedef struct _GlChessClass GlChessClass;
typedef struct _GlChessPrivate GlChessPrivate;

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PGNPrivate PGNPrivate;

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;
typedef struct _PGNGamePrivate PGNGamePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
typedef struct _ParamSpecGlChess ParamSpecGlChess;

struct _GlChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GlChessPrivate * priv;
};

struct _GlChessClass {
	GTypeClass parent_class;
	void (*finalize) (GlChess *self);
};

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()
struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _PGNGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GTypeClass parent_class;
	void (*finalize) (PGNGame *self);
};

struct _ParamSpecGlChess {
	GParamSpec parent_instance;
};


static gpointer gl_chess_parent_class = NULL;
static gint gl_chess_test_count;
static gint gl_chess_test_count = 0;
static gint gl_chess_failure_count;
static gint gl_chess_failure_count = 0;

gpointer gl_chess_ref (gpointer instance);
void gl_chess_unref (gpointer instance);
GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gl_chess (GValue* value, gpointer v_object);
void value_take_gl_chess (GValue* value, gpointer v_object);
gpointer value_get_gl_chess (const GValue* value);
GType gl_chess_get_type (void) G_GNUC_CONST;
enum  {
	GL_CHESS_DUMMY_PROPERTY
};
static void gl_chess_test_pgn_file (const gchar* data, const gchar* moves);
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
GQuark pgn_error_quark (void);
PGN* pgn_new_from_string (const gchar* data, GError** error);
PGN* pgn_construct_from_string (GType object_type, const gchar* data, GError** error);
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
gint gl_chess_main (gchar** args, int args_length1);
GlChess* gl_chess_new (void);
GlChess* gl_chess_construct (GType object_type);
static void gl_chess_finalize (GlChess* obj);


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void gl_chess_test_pgn_file (const gchar* data, const gchar* moves) {
	PGN* file = NULL;
	PGN* _tmp0_ = NULL;
	PGN* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	PGNGame* _tmp3_;
	PGNGame* game;
	gchar* _tmp4_;
	gchar* move_string;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (data != NULL);
	g_return_if_fail (moves != NULL);
	gl_chess_test_count++;
	_tmp0_ = pgn_new_from_string (data, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == PGN_ERROR) {
			goto __catch1_pgn_error;
		}
		_pgn_unref0 (file);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_pgn_unref0 (file);
	file = _tmp1_;
	goto __finally1;
	__catch1_pgn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%d. FAIL %s\n", gl_chess_test_count, e->message);
		gl_chess_failure_count++;
		_g_error_free0 (e);
		_pgn_unref0 (file);
		return;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_pgn_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = g_list_nth_data (file->games, (guint) 0);
	_tmp3_ = _pgn_game_ref0 ((PGNGame*) _tmp2_);
	game = _tmp3_;
	_tmp4_ = g_strdup ("");
	move_string = _tmp4_;
	{
		GList* move_collection;
		GList* move_it;
		move_collection = game->moves;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp5_;
			gchar* move;
			_tmp5_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp5_;
			{
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = g_strdup_printf ("%s ", move);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (move_string, _tmp7_, NULL);
				_g_free0 (move_string);
				move_string = _tmp8_;
				_g_free0 (_tmp7_);
				_g_free0 (move);
			}
		}
	}
	_tmp9_ = string_strip (move_string);
	_g_free0 (move_string);
	move_string = _tmp9_;
	if (g_strcmp0 (move_string, moves) == 0) {
		fprintf (stderr, "%d. PASS\n", gl_chess_test_count);
	} else {
		gl_chess_failure_count++;
		fprintf (stderr, "%d. FAIL got moves '%s', expected '%s'\n", gl_chess_test_count, move_string, moves);
	}
	_g_free0 (move_string);
	_pgn_game_unref0 (game);
	_pgn_unref0 (file);
}


gint gl_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	gl_chess_test_pgn_file ("[Event \"?\"]\n" "[Site \"?\"]\n" "[Date \"????.??.??\"]\n" "[Round \"?\"]\n" "[White \"\"]\n" "[Black \"\"]\n" "[Result \"*\"]\n" "\n" "1. *\n", "");
	gl_chess_test_pgn_file ("1. e1 *\n", "e1");
	gl_chess_test_pgn_file ("e1 *\n", "e1");
	gl_chess_test_pgn_file ("e1\n", "e1");
	gl_chess_test_pgn_file ("e1", "e1");
	gl_chess_test_pgn_file ("[Event \"?\"]\r" "\r" "1. d4 *\r", "d4");
	gl_chess_test_pgn_file ("; Line comment 1\n" "[Event \"?\"]\n" "; Line comment 2\n" "\n" "1. e4 {First Move} e5 {Multi\n" "line\n" "comment} 2. Nc3 {More comments} * {Comment about game end}\n", "e4 e5 Nc3");
	gl_chess_test_pgn_file (";Title: Yahoo! Chess Game\n" ";White: roovis\n" ";Black: ladyjones96\n" ";Date: Fri Oct 19 12:51:54 GMT 2007\n" "\n" "1. e2-e4 e7-e5\n", "e2-e4 e7-e5");
	gl_chess_test_pgn_file ("1.Ra8+ (1.Bxd6+ Kb7 2.Rc7+ Kb8 (2...Kb6 3.Ra6#) 3.Rd7+ Kc8 4.Rc1# (4.R" \
"a8#))", "Ra8+");
	gl_chess_test_pgn_file ("e4 e5 $1 Nc3 $2", "e4 e5 Nc3");
	fprintf (stdout, "%d/%d tests successful\n", gl_chess_test_count - gl_chess_failure_count, gl_chess_test_count);
	result = gl_chess_failure_count;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gl_chess_main (argv, argc);
}


GlChess* gl_chess_construct (GType object_type) {
	GlChess* self = NULL;
	self = (GlChess*) g_type_create_instance (object_type);
	return self;
}


GlChess* gl_chess_new (void) {
	return gl_chess_construct (TYPE_GL_CHESS);
}


static void value_gl_chess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_gl_chess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gl_chess_unref (value->data[0].v_pointer);
	}
}


static void value_gl_chess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gl_chess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_gl_chess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_gl_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GlChess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gl_chess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_gl_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GlChess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gl_chess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGlChess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GL_CHESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_gl_chess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gl_chess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


void value_take_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gl_chess_unref (old);
	}
}


static void gl_chess_class_init (GlChessClass * klass) {
	gl_chess_parent_class = g_type_class_peek_parent (klass);
	GL_CHESS_CLASS (klass)->finalize = gl_chess_finalize;
}


static void gl_chess_instance_init (GlChess * self) {
	self->ref_count = 1;
}


static void gl_chess_finalize (GlChess* obj) {
	GlChess * self;
	self = GL_CHESS (obj);
}


GType gl_chess_get_type (void) {
	static volatile gsize gl_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gl_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gl_chess_init, value_gl_chess_free_value, value_gl_chess_copy_value, value_gl_chess_peek_pointer, "p", value_gl_chess_collect_value, "p", value_gl_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GlChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gl_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlChess), 0, (GInstanceInitFunc) gl_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gl_chess_type_id;
		gl_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GlChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gl_chess_type_id__volatile, gl_chess_type_id);
	}
	return gl_chess_type_id__volatile;
}


gpointer gl_chess_ref (gpointer instance) {
	GlChess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gl_chess_unref (gpointer instance) {
	GlChess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GL_CHESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



