/* chess-view-3d.c generated by valac 0.13.3, the Vala compiler
 * generated from chess-view-3d.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <gdk/gdk.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <float.h>
#include <math.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <cairo.h>
#include <GL/glu.h>
#include <stdlib.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW3_D (chess_view3_d_get_type ())
#define CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW3_D, ChessView3D))
#define CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW3_D, ChessView3DClass))
#define IS_CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW3_D))
#define IS_CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW3_D))
#define CHESS_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW3_D, ChessView3DClass))

typedef struct _ChessView3D ChessView3D;
typedef struct _ChessView3DClass ChessView3DClass;
typedef struct _ChessView3DPrivate ChessView3DPrivate;

#define TYPE_TDS_MODEL (tds_model_get_type ())
#define TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TDS_MODEL, TDSModel))
#define TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TDS_MODEL, TDSModelClass))
#define IS_TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TDS_MODEL))
#define IS_TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TDS_MODEL))
#define TDS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TDS_MODEL, TDSModelClass))

typedef struct _TDSModel TDSModel;
typedef struct _TDSModelClass TDSModelClass;
#define _tds_model_unref0(var) ((var == NULL) ? NULL : (var = (tds_model_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _XFree0(var) ((var == NULL) ? NULL : (var = (XFree (var), NULL)))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView3D {
	ChessView parent_instance;
	ChessView3DPrivate * priv;
};

struct _ChessView3DClass {
	ChessViewClass parent_class;
};

struct _ChessView3DPrivate {
	GLXContext context;
	void* display;
	GLXDrawable drawable;
	gint border;
	gint square_size;
	TDSModel* pawn_model;
	TDSModel* knight_model;
	TDSModel* bishop_model;
	TDSModel* rook_model;
	TDSModel* queen_model;
	TDSModel* king_model;
	GLfloat* board_vertices;
	gint board_vertices_length1;
	gint _board_vertices_size_;
	GLfloat* board_normals;
	gint board_normals_length1;
	gint _board_normals_size_;
	GLushort* board_quads;
	gint board_quads_length1;
	gint _board_quads_size_;
	GLfloat SQUARE_WIDTH;
	GLfloat BOARD_DEPTH;
	GLfloat BOARD_BORDER;
	GLfloat BOARD_CHAMFER;
	GLfloat BOARD_INNER_WIDTH;
	GLfloat BOARD_OUTER_WIDTH;
	GLfloat OFFSET;
	GLfloat white_piece_color[4];
	GLfloat white_piece_specular[4];
	GLfloat black_piece_color[4];
	GLfloat black_piece_specular[4];
	GLuint _board_texture;
	GLuint _numbering_texture;
	GLuint _piece_texture;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_view3_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view3_d_get_type (void) G_GNUC_CONST;
gpointer tds_model_ref (gpointer instance);
void tds_model_unref (gpointer instance);
GParamSpec* param_spec_tds_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tds_model (GValue* value, gpointer v_object);
void value_take_tds_model (GValue* value, gpointer v_object);
gpointer value_get_tds_model (const GValue* value);
GType tds_model_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW3_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW3_D, ChessView3DPrivate))
enum  {
	CHESS_VIEW3_D_DUMMY_PROPERTY
};
ChessView3D* chess_view3_d_new (void);
ChessView3D* chess_view3_d_construct (GType object_type);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static void chess_view3_d_realize_cb (ChessView3D* self);
static void _chess_view3_d_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void chess_view3_d_unrealize_cb (ChessView3D* self);
static void _chess_view3_d_unrealize_cb_gtk_widget_unrealize (GtkWidget* _sender, gpointer self);
TDSModel* tds_model_new (GFile* file, GError** error);
TDSModel* tds_model_construct (GType object_type, GFile* file, GError** error);
static void chess_view3_d_create_board (ChessView3D* self);
static gboolean chess_view3_d_start_gl (ChessView3D* self);
static gboolean _context_equal (const GLXContext* s1, const GLXContext* s2);
static gboolean chess_view3_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view3_d_accFrustum (ChessView3D* self, GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus);
static void chess_view3_d_accPerspective (ChessView3D* self, GLfloat fovy, GLfloat aspect, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus);
static gboolean chess_view3_d_real_draw (GtkWidget* base, cairo_t* c);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
static void chess_view3_d_transform_camera (ChessView3D* self);
gdouble chess_scene_get_board_angle (ChessScene* self);
static void chess_view3_d_draw_board (ChessView3D* self);
static void chess_view3_d_draw_numbering (ChessView3D* self);
static void chess_view3_d_draw_pieces (ChessView3D* self);
static GLuint chess_view3_d_get_board_texture (ChessView3D* self);
static GLuint chess_view3_d_get_numbering_texture (ChessView3D* self);
static void chess_view3_d_draw_label (ChessView3D* self, GLfloat x, GLfloat z, GLfloat width, gint cell);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
static GLuint chess_view3_d_get_piece_texture (ChessView3D* self);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
static void chess_view3_d_render_piece (ChessView3D* self, ChessPiece* piece, GLfloat alpha);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
void tds_model_render (TDSModel* self);
static gboolean chess_view3_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static GLuint chess_view3_d_load_texture (ChessView3D* self, const gchar* filename);
static GLuint chess_view3_d_make_numbering_texture (ChessView3D* self);
static void chess_view3_d_draw_centered_text (ChessView3D* self, cairo_t* c, gdouble x, gdouble y, gdouble scale, const gchar* text);
static void chess_view3_d_finalize (GObject* obj);
static void _vala_chess_view3_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _chess_view3_d_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	chess_view3_d_realize_cb (self);
}


static void _chess_view3_d_unrealize_cb_gtk_widget_unrealize (GtkWidget* _sender, gpointer self) {
	chess_view3_d_unrealize_cb (self);
}


ChessView3D* chess_view3_d_construct (GType object_type) {
	ChessView3D * self = NULL;
	GLfloat _tmp0_;
	GLfloat _tmp1_;
	GLfloat _tmp2_;
	GLfloat _tmp3_;
	GLfloat _tmp4_[4] = {0};
	GLfloat _tmp5_[4] = {0};
	GLfloat _tmp6_[4] = {0};
	GLfloat _tmp7_[4] = {0};
	GError * _inner_error_ = NULL;
	self = (ChessView3D*) chess_view_construct (object_type);
	self->priv->SQUARE_WIDTH = (GLfloat) 10.0f;
	self->priv->BOARD_DEPTH = (GLfloat) 3.0f;
	self->priv->BOARD_BORDER = (GLfloat) 5.0f;
	self->priv->BOARD_CHAMFER = (GLfloat) 2.0f;
	_tmp0_ = self->priv->SQUARE_WIDTH;
	self->priv->BOARD_INNER_WIDTH = _tmp0_ * 8.0f;
	_tmp1_ = self->priv->BOARD_INNER_WIDTH;
	_tmp2_ = self->priv->BOARD_BORDER;
	self->priv->BOARD_OUTER_WIDTH = _tmp1_ + (_tmp2_ * 2.0f);
	_tmp3_ = self->priv->BOARD_OUTER_WIDTH;
	self->priv->OFFSET = _tmp3_ * 0.5f;
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) _chess_view3_d_realize_cb_gtk_widget_realize, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unrealize", (GCallback) _chess_view3_d_unrealize_cb_gtk_widget_unrealize, self, 0);
	_tmp4_[0] = (GLfloat) (0.95f * 0.7f);
	_tmp4_[1] = (GLfloat) (0.81f * 0.7f);
	_tmp4_[2] = (GLfloat) (0.64f * 0.7f);
	_tmp4_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->white_piece_color, _tmp4_, 4 * sizeof (GLfloat));
	_tmp5_[0] = (GLfloat) 0.95f;
	_tmp5_[1] = (GLfloat) 0.81f;
	_tmp5_[2] = (GLfloat) 0.64f;
	_tmp5_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->white_piece_specular, _tmp5_, 4 * sizeof (GLfloat));
	_tmp6_[0] = (GLfloat) (0.62f * 0.7f);
	_tmp6_[1] = (GLfloat) (0.45f * 0.7f);
	_tmp6_[2] = (GLfloat) (0.28f * 0.7f);
	_tmp6_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->black_piece_color, _tmp6_, 4 * sizeof (GLfloat));
	_tmp7_[0] = (GLfloat) 0.62f;
	_tmp7_[1] = (GLfloat) 0.45f;
	_tmp7_[2] = (GLfloat) 0.28f;
	_tmp7_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->black_piece_specular, _tmp7_, 4 * sizeof (GLfloat));
	gtk_widget_set_double_buffered ((GtkWidget*) self, FALSE);
	{
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_;
		TDSModel* _tmp12_;
		TDSModel* _tmp13_;
		TDSModel* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_;
		TDSModel* _tmp19_;
		TDSModel* _tmp20_;
		TDSModel* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GFile* _tmp24_ = NULL;
		GFile* _tmp25_;
		TDSModel* _tmp26_;
		TDSModel* _tmp27_;
		TDSModel* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GFile* _tmp31_ = NULL;
		GFile* _tmp32_;
		TDSModel* _tmp33_;
		TDSModel* _tmp34_;
		TDSModel* _tmp35_;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		GFile* _tmp38_ = NULL;
		GFile* _tmp39_;
		TDSModel* _tmp40_;
		TDSModel* _tmp41_;
		TDSModel* _tmp42_;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		GFile* _tmp45_ = NULL;
		GFile* _tmp46_;
		TDSModel* _tmp47_;
		TDSModel* _tmp48_;
		TDSModel* _tmp49_;
		_tmp8_ = g_build_filename (PKGDATADIR, "pieces", "3d", "pawn.3ds", NULL, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = tds_model_new (_tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_g_free0 (_tmp9_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tds_model_unref0 (self->priv->pawn_model);
		self->priv->pawn_model = _tmp14_;
		_tmp15_ = g_build_filename (PKGDATADIR, "pieces", "3d", "knight.3ds", NULL, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_file_new_for_path (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = tds_model_new (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_g_free0 (_tmp16_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tds_model_unref0 (self->priv->knight_model);
		self->priv->knight_model = _tmp21_;
		_tmp22_ = g_build_filename (PKGDATADIR, "pieces", "3d", "bishop.3ds", NULL, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_file_new_for_path (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = tds_model_new (_tmp25_, &_inner_error_);
		_tmp27_ = _tmp26_;
		_g_object_unref0 (_tmp25_);
		_g_free0 (_tmp23_);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tds_model_unref0 (self->priv->bishop_model);
		self->priv->bishop_model = _tmp28_;
		_tmp29_ = g_build_filename (PKGDATADIR, "pieces", "3d", "rook.3ds", NULL, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_file_new_for_path (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = tds_model_new (_tmp32_, &_inner_error_);
		_tmp34_ = _tmp33_;
		_g_object_unref0 (_tmp32_);
		_g_free0 (_tmp30_);
		_tmp35_ = _tmp34_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tds_model_unref0 (self->priv->rook_model);
		self->priv->rook_model = _tmp35_;
		_tmp36_ = g_build_filename (PKGDATADIR, "pieces", "3d", "queen.3ds", NULL, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_file_new_for_path (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = tds_model_new (_tmp39_, &_inner_error_);
		_tmp41_ = _tmp40_;
		_g_object_unref0 (_tmp39_);
		_g_free0 (_tmp37_);
		_tmp42_ = _tmp41_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tds_model_unref0 (self->priv->queen_model);
		self->priv->queen_model = _tmp42_;
		_tmp43_ = g_build_filename (PKGDATADIR, "pieces", "3d", "king.3ds", NULL, NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_file_new_for_path (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = tds_model_new (_tmp46_, &_inner_error_);
		_tmp48_ = _tmp47_;
		_g_object_unref0 (_tmp46_);
		_g_free0 (_tmp44_);
		_tmp49_ = _tmp48_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tds_model_unref0 (self->priv->king_model);
		self->priv->king_model = _tmp49_;
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	chess_view3_d_create_board (self);
	return self;
}


ChessView3D* chess_view3_d_new (void) {
	return chess_view3_d_construct (TYPE_CHESS_VIEW3_D);
}


static gboolean _context_equal (const GLXContext* s1, const GLXContext* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean chess_view3_d_start_gl (ChessView3D* self) {
	gboolean result = FALSE;
	GLXContext null_context;
	GLXContext _tmp0_;
	GLXContext _tmp1_;
	void* _tmp2_;
	GLXDrawable _tmp3_;
	GLXContext _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	null_context = (GLXContext) NULL;
	_tmp0_ = self->priv->context;
	_tmp1_ = null_context;
	if (_context_equal (&_tmp0_, &_tmp1_) == TRUE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->display;
	_tmp3_ = self->priv->drawable;
	_tmp4_ = self->priv->context;
	_tmp5_ = glXMakeCurrent (_tmp2_, _tmp3_, _tmp4_);
	result = _tmp5_;
	return result;
}


static void chess_view3_d_create_board (ChessView3D* self) {
	gfloat a;
	GLfloat _tmp0_;
	GLfloat b;
	GLfloat _tmp1_;
	GLfloat c;
	GLfloat _tmp2_;
	GLfloat d;
	GLfloat _tmp3_;
	GLfloat _tmp4_;
	GLfloat e;
	GLfloat _tmp5_;
	GLfloat f;
	gfloat l;
	GLfloat _tmp6_;
	GLfloat k;
	GLfloat _tmp7_;
	GLfloat j;
	GLfloat _tmp8_;
	GLfloat i;
	GLfloat _tmp9_;
	GLfloat _tmp10_;
	GLfloat h;
	GLfloat _tmp11_;
	GLfloat g;
	GLfloat _tmp12_;
	GLfloat _tmp13_;
	GLfloat _tmp14_;
	GLfloat _tmp15_;
	GLfloat _tmp16_;
	GLfloat _tmp17_;
	GLfloat _tmp18_;
	GLfloat _tmp19_;
	GLfloat* _tmp20_ = NULL;
	GLfloat* _tmp21_ = NULL;
	GLushort* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	a = 0.0f;
	_tmp0_ = self->priv->BOARD_CHAMFER;
	b = _tmp0_;
	_tmp1_ = self->priv->BOARD_BORDER;
	c = _tmp1_;
	_tmp2_ = self->priv->SQUARE_WIDTH;
	d = c + (_tmp2_ * 8.0f);
	_tmp3_ = self->priv->BOARD_BORDER;
	_tmp4_ = self->priv->BOARD_CHAMFER;
	e = (d + _tmp3_) - _tmp4_;
	_tmp5_ = self->priv->BOARD_BORDER;
	f = d + _tmp5_;
	l = 0.0f;
	_tmp6_ = self->priv->BOARD_CHAMFER;
	k = -_tmp6_;
	_tmp7_ = self->priv->BOARD_BORDER;
	j = -_tmp7_;
	_tmp8_ = self->priv->SQUARE_WIDTH;
	i = j - (_tmp8_ * 8.0f);
	_tmp9_ = self->priv->BOARD_BORDER;
	_tmp10_ = self->priv->BOARD_CHAMFER;
	h = (i - _tmp9_) + _tmp10_;
	_tmp11_ = self->priv->BOARD_BORDER;
	g = i - _tmp11_;
	_tmp12_ = self->priv->BOARD_CHAMFER;
	_tmp13_ = self->priv->BOARD_CHAMFER;
	_tmp14_ = self->priv->BOARD_CHAMFER;
	_tmp15_ = self->priv->BOARD_CHAMFER;
	_tmp16_ = self->priv->BOARD_DEPTH;
	_tmp17_ = self->priv->BOARD_DEPTH;
	_tmp18_ = self->priv->BOARD_DEPTH;
	_tmp19_ = self->priv->BOARD_DEPTH;
	_tmp20_ = g_new0 (GLfloat, 48);
	_tmp20_[0] = c;
	_tmp20_[1] = (GLfloat) 0.0f;
	_tmp20_[2] = i;
	_tmp20_[3] = d;
	_tmp20_[4] = (GLfloat) 0.0f;
	_tmp20_[5] = i;
	_tmp20_[6] = d;
	_tmp20_[7] = (GLfloat) 0.0f;
	_tmp20_[8] = j;
	_tmp20_[9] = c;
	_tmp20_[10] = (GLfloat) 0.0f;
	_tmp20_[11] = j;
	_tmp20_[12] = b;
	_tmp20_[13] = (GLfloat) 0.0f;
	_tmp20_[14] = h;
	_tmp20_[15] = e;
	_tmp20_[16] = (GLfloat) 0.0f;
	_tmp20_[17] = h;
	_tmp20_[18] = e;
	_tmp20_[19] = (GLfloat) 0.0f;
	_tmp20_[20] = k;
	_tmp20_[21] = b;
	_tmp20_[22] = (GLfloat) 0.0f;
	_tmp20_[23] = k;
	_tmp20_[24] = (GLfloat) a;
	_tmp20_[25] = -_tmp12_;
	_tmp20_[26] = g;
	_tmp20_[27] = f;
	_tmp20_[28] = -_tmp13_;
	_tmp20_[29] = g;
	_tmp20_[30] = f;
	_tmp20_[31] = -_tmp14_;
	_tmp20_[32] = (GLfloat) l;
	_tmp20_[33] = (GLfloat) a;
	_tmp20_[34] = -_tmp15_;
	_tmp20_[35] = (GLfloat) l;
	_tmp20_[36] = (GLfloat) a;
	_tmp20_[37] = -_tmp16_;
	_tmp20_[38] = g;
	_tmp20_[39] = f;
	_tmp20_[40] = -_tmp17_;
	_tmp20_[41] = g;
	_tmp20_[42] = f;
	_tmp20_[43] = -_tmp18_;
	_tmp20_[44] = (GLfloat) l;
	_tmp20_[45] = (GLfloat) a;
	_tmp20_[46] = -_tmp19_;
	_tmp20_[47] = (GLfloat) l;
	self->priv->board_vertices = (g_free (self->priv->board_vertices), NULL);
	self->priv->board_vertices = _tmp20_;
	self->priv->board_vertices_length1 = 48;
	self->priv->_board_vertices_size_ = self->priv->board_vertices_length1;
	_tmp21_ = g_new0 (GLfloat, 27);
	_tmp21_[0] = (GLfloat) 0.0f;
	_tmp21_[1] = (GLfloat) 1.0f;
	_tmp21_[2] = (GLfloat) 0.0f;
	_tmp21_[3] = (GLfloat) 0.0f;
	_tmp21_[4] = (GLfloat) 0.0f;
	_tmp21_[5] = (GLfloat) (-1.0f);
	_tmp21_[6] = (GLfloat) 1.0f;
	_tmp21_[7] = (GLfloat) 0.0f;
	_tmp21_[8] = (GLfloat) 0.0f;
	_tmp21_[9] = (GLfloat) 0.0f;
	_tmp21_[10] = (GLfloat) 0.0f;
	_tmp21_[11] = (GLfloat) 1.0f;
	_tmp21_[12] = (GLfloat) (-1.0f);
	_tmp21_[13] = (GLfloat) 0.0f;
	_tmp21_[14] = (GLfloat) 0.0f;
	_tmp21_[15] = (GLfloat) 0.0f;
	_tmp21_[16] = (GLfloat) 0.707f;
	_tmp21_[17] = (GLfloat) (-0.707f);
	_tmp21_[18] = (GLfloat) 0.707f;
	_tmp21_[19] = (GLfloat) 0.707f;
	_tmp21_[20] = (GLfloat) 0.0f;
	_tmp21_[21] = (GLfloat) 0.0f;
	_tmp21_[22] = (GLfloat) 0.707f;
	_tmp21_[23] = (GLfloat) 0.707f;
	_tmp21_[24] = (GLfloat) (-0.707f);
	_tmp21_[25] = (GLfloat) 0.707f;
	_tmp21_[26] = (GLfloat) 0.0f;
	self->priv->board_normals = (g_free (self->priv->board_normals), NULL);
	self->priv->board_normals = _tmp21_;
	self->priv->board_normals_length1 = 27;
	self->priv->_board_normals_size_ = self->priv->board_normals_length1;
	_tmp22_ = g_new0 (GLushort, 60);
	_tmp22_[0] = (GLushort) 0;
	_tmp22_[1] = (GLushort) 1;
	_tmp22_[2] = (GLushort) 5;
	_tmp22_[3] = (GLushort) 4;
	_tmp22_[4] = (GLushort) 0;
	_tmp22_[5] = (GLushort) 1;
	_tmp22_[6] = (GLushort) 2;
	_tmp22_[7] = (GLushort) 6;
	_tmp22_[8] = (GLushort) 5;
	_tmp22_[9] = (GLushort) 0;
	_tmp22_[10] = (GLushort) 2;
	_tmp22_[11] = (GLushort) 3;
	_tmp22_[12] = (GLushort) 7;
	_tmp22_[13] = (GLushort) 6;
	_tmp22_[14] = (GLushort) 0;
	_tmp22_[15] = (GLushort) 3;
	_tmp22_[16] = (GLushort) 0;
	_tmp22_[17] = (GLushort) 4;
	_tmp22_[18] = (GLushort) 7;
	_tmp22_[19] = (GLushort) 0;
	_tmp22_[20] = (GLushort) 4;
	_tmp22_[21] = (GLushort) 5;
	_tmp22_[22] = (GLushort) 9;
	_tmp22_[23] = (GLushort) 8;
	_tmp22_[24] = (GLushort) 5;
	_tmp22_[25] = (GLushort) 5;
	_tmp22_[26] = (GLushort) 6;
	_tmp22_[27] = (GLushort) 10;
	_tmp22_[28] = (GLushort) 9;
	_tmp22_[29] = (GLushort) 6;
	_tmp22_[30] = (GLushort) 6;
	_tmp22_[31] = (GLushort) 7;
	_tmp22_[32] = (GLushort) 11;
	_tmp22_[33] = (GLushort) 10;
	_tmp22_[34] = (GLushort) 7;
	_tmp22_[35] = (GLushort) 7;
	_tmp22_[36] = (GLushort) 4;
	_tmp22_[37] = (GLushort) 8;
	_tmp22_[38] = (GLushort) 11;
	_tmp22_[39] = (GLushort) 8;
	_tmp22_[40] = (GLushort) 8;
	_tmp22_[41] = (GLushort) 9;
	_tmp22_[42] = (GLushort) 13;
	_tmp22_[43] = (GLushort) 12;
	_tmp22_[44] = (GLushort) 1;
	_tmp22_[45] = (GLushort) 9;
	_tmp22_[46] = (GLushort) 10;
	_tmp22_[47] = (GLushort) 14;
	_tmp22_[48] = (GLushort) 13;
	_tmp22_[49] = (GLushort) 2;
	_tmp22_[50] = (GLushort) 10;
	_tmp22_[51] = (GLushort) 11;
	_tmp22_[52] = (GLushort) 15;
	_tmp22_[53] = (GLushort) 14;
	_tmp22_[54] = (GLushort) 3;
	_tmp22_[55] = (GLushort) 11;
	_tmp22_[56] = (GLushort) 8;
	_tmp22_[57] = (GLushort) 12;
	_tmp22_[58] = (GLushort) 15;
	_tmp22_[59] = (GLushort) 4;
	self->priv->board_quads = (g_free (self->priv->board_quads), NULL);
	self->priv->board_quads = _tmp22_;
	self->priv->board_quads_length1 = 60;
	self->priv->_board_quads_size_ = self->priv->board_quads_length1;
}


static void chess_view3_d_realize_cb (ChessView3D* self) {
	gint* _tmp0_ = NULL;
	gint* attributes;
	gint attributes_length1;
	gint _attributes_size_;
	GdkWindow* _tmp1_ = NULL;
	Window _tmp2_ = 0;
	GdkWindow* _tmp3_ = NULL;
	GdkDisplay* _tmp4_ = NULL;
	Display* _tmp5_ = NULL;
	GdkScreen* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint screen;
	void* _tmp8_;
	gint _tmp9_;
	gint* _tmp10_;
	gint _tmp10__length1;
	XVisualInfo* _tmp11_ = NULL;
	XVisualInfo* visual;
	XVisualInfo* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gint, 17);
	_tmp0_[0] = GLX_RGBA;
	_tmp0_[1] = GLX_RED_SIZE;
	_tmp0_[2] = 1;
	_tmp0_[3] = GLX_GREEN_SIZE;
	_tmp0_[4] = 1;
	_tmp0_[5] = GLX_BLUE_SIZE;
	_tmp0_[6] = 1;
	_tmp0_[7] = GLX_DOUBLEBUFFER;
	_tmp0_[8] = GLX_DEPTH_SIZE;
	_tmp0_[9] = 1;
	_tmp0_[10] = GLX_ACCUM_RED_SIZE;
	_tmp0_[11] = 1;
	_tmp0_[12] = GLX_ACCUM_GREEN_SIZE;
	_tmp0_[13] = 1;
	_tmp0_[14] = GLX_ACCUM_BLUE_SIZE;
	_tmp0_[15] = 1;
	_tmp0_[16] = 0;
	attributes = _tmp0_;
	attributes_length1 = 17;
	_attributes_size_ = attributes_length1;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_x11_window_get_xid (_tmp1_);
	self->priv->drawable = (GLXDrawable) _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp4_ = gdk_window_get_display (_tmp3_);
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
	self->priv->display = _tmp5_;
	_tmp6_ = gtk_widget_get_screen ((GtkWidget*) self);
	_tmp7_ = gdk_x11_screen_get_screen_number (_tmp6_);
	screen = _tmp7_;
	_tmp8_ = self->priv->display;
	_tmp9_ = screen;
	_tmp10_ = attributes;
	_tmp10__length1 = attributes_length1;
	_tmp11_ = glXChooseVisual (_tmp8_, _tmp9_, _tmp10_);
	visual = _tmp11_;
	_tmp12_ = visual;
	if (_tmp12_ == NULL) {
		void* _tmp13_;
		gint _tmp14_;
		_tmp13_ = self->priv->display;
		_tmp14_ = screen;
		g_warning ("chess-view-3d.vala:167: Failed to get GLX visual on display %p, screen" \
" %d", _tmp13_, _tmp14_);
	} else {
		void* _tmp15_;
		XVisualInfo* _tmp16_;
		GLXContext _tmp17_;
		GLXContext null_context;
		GLXContext _tmp18_;
		GLXContext _tmp19_;
		_tmp15_ = self->priv->display;
		_tmp16_ = visual;
		_tmp17_ = glXCreateContext (_tmp15_, _tmp16_, NULL, TRUE);
		self->priv->context = _tmp17_;
		null_context = (GLXContext) NULL;
		_tmp18_ = self->priv->context;
		_tmp19_ = null_context;
		if (_context_equal (&_tmp18_, &_tmp19_) == TRUE) {
			g_warning ("chess-view-3d.vala:173: Failed to create GLX context");
		}
	}
	_XFree0 (visual);
	attributes = (g_free (attributes), NULL);
}


static void chess_view3_d_unrealize_cb (ChessView3D* self) {
	GLXContext null_context;
	GLXContext _tmp0_;
	GLXContext _tmp1_;
	GLXDrawable _tmp2_;
	GLXDrawable _tmp3_;
	void* _tmp5_;
	GLXContext _tmp6_;
	g_return_if_fail (self != NULL);
	null_context = (GLXContext) NULL;
	_tmp0_ = self->priv->context;
	_tmp1_ = null_context;
	if (_context_equal (&_tmp0_, &_tmp1_) == TRUE) {
		return;
	}
	_tmp2_ = self->priv->drawable;
	_tmp3_ = glXGetCurrentDrawable ();
	if (_tmp2_ == _tmp3_) {
		void* _tmp4_;
		glXWaitGL ();
		_tmp4_ = self->priv->display;
		glXMakeCurrent (_tmp4_, (GLXDrawable) None, (GLXContext) NULL);
	}
	_tmp5_ = self->priv->display;
	_tmp6_ = self->priv->context;
	glXDestroyContext (_tmp5_, _tmp6_);
}


static gboolean chess_view3_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView3D * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint short_edge;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_ = 0.0;
	gboolean _tmp6_ = FALSE;
	self = (ChessView3D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	short_edge = _tmp2_;
	_tmp3_ = short_edge;
	_tmp4_ = self->priv->border;
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
	self->priv->square_size = (gint) _tmp5_;
	_tmp6_ = chess_view3_d_start_gl (self);
	if (_tmp6_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp8_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		glViewport ((GLint) 0, (GLint) 0, (GLsizei) _tmp7_, (GLsizei) _tmp8_);
	}
	result = TRUE;
	return result;
}


static void chess_view3_d_accFrustum (ChessView3D* self, GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus) {
	GLfloat _tmp0_;
	GLfloat _tmp1_;
	GLfloat xwsize;
	GLfloat _tmp2_;
	GLfloat _tmp3_;
	GLfloat ywsize;
	GLfloat _tmp4_;
	gint _tmp5_ = 0;
	GLfloat _tmp6_;
	GLfloat _tmp7_;
	GLfloat _tmp8_;
	GLfloat dx;
	GLfloat _tmp9_;
	gint _tmp10_ = 0;
	GLfloat _tmp11_;
	GLfloat _tmp12_;
	GLfloat _tmp13_;
	GLfloat dy;
	GLfloat _tmp14_;
	GLfloat _tmp15_;
	GLfloat _tmp16_;
	GLfloat _tmp17_;
	GLfloat _tmp18_;
	GLfloat _tmp19_;
	GLfloat _tmp20_;
	GLfloat _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = right;
	_tmp1_ = left;
	xwsize = _tmp0_ - _tmp1_;
	_tmp2_ = top;
	_tmp3_ = bottom;
	ywsize = _tmp2_ - _tmp3_;
	_tmp4_ = pixdx;
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp6_ = eyedx;
	_tmp7_ = near;
	_tmp8_ = focus;
	dx = -(((_tmp4_ * xwsize) / _tmp5_) + ((_tmp6_ * _tmp7_) / _tmp8_));
	_tmp9_ = pixdy;
	_tmp10_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp11_ = eyedy;
	_tmp12_ = near;
	_tmp13_ = focus;
	dy = -(((_tmp9_ * ywsize) / _tmp10_) + ((_tmp11_ * _tmp12_) / _tmp13_));
	_tmp14_ = left;
	_tmp15_ = right;
	_tmp16_ = bottom;
	_tmp17_ = top;
	_tmp18_ = near;
	_tmp19_ = far;
	glFrustum ((GLdouble) (_tmp14_ + dx), (GLdouble) (_tmp15_ + dx), (GLdouble) (_tmp16_ + dy), (GLdouble) (_tmp17_ + dy), (GLdouble) _tmp18_, (GLdouble) _tmp19_);
	_tmp20_ = eyedx;
	_tmp21_ = eyedy;
	glTranslatef (-_tmp20_, -_tmp21_, (GLfloat) 0.0f);
}


static void chess_view3_d_accPerspective (ChessView3D* self, GLfloat fovy, GLfloat aspect, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus) {
	GLfloat _tmp0_;
	GLfloat fov2;
	GLfloat _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GLfloat top;
	GLfloat bottom;
	GLfloat _tmp4_;
	GLfloat right;
	GLfloat left;
	GLfloat _tmp5_;
	GLfloat _tmp6_;
	GLfloat _tmp7_;
	GLfloat _tmp8_;
	GLfloat _tmp9_;
	GLfloat _tmp10_;
	GLfloat _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fovy;
	fov2 = ((_tmp0_ * ((GLfloat) G_PI)) / 180.0f) / 2.0f;
	_tmp1_ = near;
	_tmp2_ = cos ((gdouble) fov2);
	_tmp3_ = sin ((gdouble) fov2);
	top = _tmp1_ / (((GLfloat) _tmp2_) / ((GLfloat) _tmp3_));
	bottom = -top;
	_tmp4_ = aspect;
	right = top * _tmp4_;
	left = -right;
	_tmp5_ = near;
	_tmp6_ = far;
	_tmp7_ = pixdx;
	_tmp8_ = pixdy;
	_tmp9_ = eyedx;
	_tmp10_ = eyedy;
	_tmp11_ = focus;
	chess_view3_d_accFrustum (self, left, right, bottom, top, _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
}


static gboolean chess_view3_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView3D * self;
	gboolean result = FALSE;
	GLfloat* _tmp0_ = NULL;
	GLfloat* jitters;
	gint jitters_length1;
	gint _jitters_size_;
	gboolean _tmp1_ = FALSE;
	gint n_passes;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ChessScene* _tmp49_;
	ChessScene* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	void* _tmp53_;
	GLXDrawable _tmp54_;
	self = (ChessView3D*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = g_new0 (GLfloat, 6);
	_tmp0_[0] = (GLfloat) 0.0033922635f;
	_tmp0_[1] = (GLfloat) 0.3317967229f;
	_tmp0_[2] = (GLfloat) 0.2806016275f;
	_tmp0_[3] = (GLfloat) (-0.2495619123f);
	_tmp0_[4] = (GLfloat) (-0.273817106f);
	_tmp0_[5] = (GLfloat) (-0.086844639f);
	jitters = _tmp0_;
	jitters_length1 = 6;
	_jitters_size_ = jitters_length1;
	_tmp1_ = chess_view3_d_start_gl (self);
	if (!_tmp1_) {
		result = TRUE;
		jitters = (g_free (jitters), NULL);
		return result;
	}
	n_passes = 1;
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_show_3d_smooth (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		glClear ((GLbitfield) GL_ACCUM_BUFFER_BIT);
		n_passes = 3;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gint _tmp9_;
				gint _tmp10_;
				GtkStyle* _tmp11_;
				GtkStyle* _tmp12_;
				GdkColor* _tmp13_;
				gint _tmp13__length1;
				GtkStateType _tmp14_ = 0;
				GdkColor _tmp15_;
				GdkColor bg;
				GdkColor _tmp16_;
				guint16 _tmp17_;
				GdkColor _tmp18_;
				guint16 _tmp19_;
				GdkColor _tmp20_;
				guint16 _tmp21_;
				ChessScene* _tmp22_;
				ChessScene* _tmp23_;
				gboolean _tmp24_;
				gboolean _tmp25_;
				GLfloat* _tmp36_ = NULL;
				GLfloat* pos;
				gint pos_length1;
				gint _pos_size_;
				GLfloat* _tmp37_;
				gint _tmp37__length1;
				ChessScene* _tmp38_;
				ChessScene* _tmp39_;
				gdouble _tmp40_;
				gdouble _tmp41_;
				GLfloat _tmp42_;
				GLfloat _tmp43_;
				ChessScene* _tmp44_;
				ChessScene* _tmp45_;
				gboolean _tmp46_;
				gboolean _tmp47_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = n_passes;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp12_->bg;
				_tmp13__length1 = -1;
				_tmp14_ = gtk_widget_get_state ((GtkWidget*) self);
				_tmp15_ = _tmp13_[_tmp14_];
				bg = _tmp15_;
				_tmp16_ = bg;
				_tmp17_ = _tmp16_.red;
				_tmp18_ = bg;
				_tmp19_ = _tmp18_.green;
				_tmp20_ = bg;
				_tmp21_ = _tmp20_.blue;
				glClearColor ((GLclampf) (_tmp17_ / 65535.0f), (GLclampf) (_tmp19_ / 65535.0f), (GLclampf) (_tmp21_ / 65535.0f), (GLclampf) 1.0f);
				glClear ((GLbitfield) (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT));
				glEnable (GL_DEPTH_TEST);
				glMatrixMode (GL_PROJECTION);
				glLoadIdentity ();
				_tmp22_ = chess_view_get_scene ((ChessView*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = chess_scene_get_show_3d_smooth (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_) {
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					GLfloat* _tmp28_;
					gint _tmp28__length1;
					gint _tmp29_;
					GLfloat _tmp30_;
					GLfloat* _tmp31_;
					gint _tmp31__length1;
					gint _tmp32_;
					GLfloat _tmp33_;
					_tmp26_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
					_tmp27_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
					_tmp28_ = jitters;
					_tmp28__length1 = jitters_length1;
					_tmp29_ = i;
					_tmp30_ = _tmp28_[_tmp29_ * 2];
					_tmp31_ = jitters;
					_tmp31__length1 = jitters_length1;
					_tmp32_ = i;
					_tmp33_ = _tmp31_[(_tmp32_ * 2) + 1];
					chess_view3_d_accPerspective (self, (GLfloat) 60.0f, (GLfloat) (((gfloat) _tmp26_) / _tmp27_), (GLfloat) 0.1f, (GLfloat) 1000, _tmp30_, _tmp33_, (GLfloat) 0, (GLfloat) 0, (GLfloat) 1);
				} else {
					gint _tmp34_ = 0;
					gint _tmp35_ = 0;
					_tmp34_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
					_tmp35_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
					gluPerspective ((GLdouble) 60.0f, (GLdouble) (((gfloat) _tmp34_) / _tmp35_), (GLdouble) 0.1f, (GLdouble) 1000);
				}
				glMatrixMode (GL_MODELVIEW);
				chess_view3_d_transform_camera (self);
				_tmp36_ = g_new0 (GLfloat, 4);
				_tmp36_[0] = (GLfloat) 100.0f;
				_tmp36_[1] = (GLfloat) 100.0f;
				_tmp36_[2] = (GLfloat) 100.0f;
				_tmp36_[3] = (GLfloat) 1.0f;
				pos = _tmp36_;
				pos_length1 = 4;
				_pos_size_ = pos_length1;
				_tmp37_ = pos;
				_tmp37__length1 = pos_length1;
				glLightfv (GL_LIGHT0, GL_POSITION, _tmp37_);
				glEnable (GL_LIGHTING);
				glEnable (GL_LIGHT0);
				glPushMatrix ();
				_tmp38_ = chess_view_get_scene ((ChessView*) self);
				_tmp39_ = _tmp38_;
				_tmp40_ = chess_scene_get_board_angle (_tmp39_);
				_tmp41_ = _tmp40_;
				glRotatef ((GLfloat) _tmp41_, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
				_tmp42_ = self->priv->OFFSET;
				_tmp43_ = self->priv->OFFSET;
				glTranslatef (-_tmp42_, (GLfloat) 0.0f, _tmp43_);
				chess_view3_d_draw_board (self);
				chess_view3_d_draw_numbering (self);
				chess_view3_d_draw_pieces (self);
				glPopMatrix ();
				_tmp44_ = chess_view_get_scene ((ChessView*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = chess_scene_get_show_3d_smooth (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp47_) {
					gint _tmp48_;
					_tmp48_ = n_passes;
					glAccum (GL_ACCUM, (GLfloat) (1.0f / _tmp48_));
				}
				pos = (g_free (pos), NULL);
			}
		}
	}
	_tmp49_ = chess_view_get_scene ((ChessView*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = chess_scene_get_show_3d_smooth (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_) {
		glAccum (GL_RETURN, (GLfloat) 1);
	}
	_tmp53_ = self->priv->display;
	_tmp54_ = self->priv->drawable;
	glXSwapBuffers (_tmp53_, _tmp54_);
	result = TRUE;
	jitters = (g_free (jitters), NULL);
	return result;
}


static void chess_view3_d_draw_board (ChessView3D* self) {
	GLuint _tmp65_;
	GLuint _tmp66_;
	g_return_if_fail (self != NULL);
	glEnable (GL_COLOR_MATERIAL);
	glColor3f ((GLfloat) (0x2e / 255.f), (GLfloat) (0x34 / 255.f), (GLfloat) (0x36 / 255.f));
	glBegin (GL_QUADS);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GLushort* _tmp4_;
				gint _tmp4__length1;
				GLushort* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				GLushort _tmp7_;
				gint j;
				GLfloat* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				GLfloat _tmp10_;
				GLfloat* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				GLfloat _tmp13_;
				GLfloat* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				GLfloat _tmp16_;
				GLushort* _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				GLushort _tmp19_;
				GLfloat* _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				GLfloat _tmp22_;
				GLfloat* _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				GLfloat _tmp25_;
				GLfloat* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				GLfloat _tmp28_;
				GLushort* _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				GLushort _tmp31_;
				GLfloat* _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_;
				GLfloat _tmp34_;
				GLfloat* _tmp35_;
				gint _tmp35__length1;
				gint _tmp36_;
				GLfloat _tmp37_;
				GLfloat* _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				GLfloat _tmp40_;
				GLushort* _tmp41_;
				gint _tmp41__length1;
				gint _tmp42_;
				GLushort _tmp43_;
				GLfloat* _tmp44_;
				gint _tmp44__length1;
				gint _tmp45_;
				GLfloat _tmp46_;
				GLfloat* _tmp47_;
				gint _tmp47__length1;
				gint _tmp48_;
				GLfloat _tmp49_;
				GLfloat* _tmp50_;
				gint _tmp50__length1;
				gint _tmp51_;
				GLfloat _tmp52_;
				GLushort* _tmp53_;
				gint _tmp53__length1;
				gint _tmp54_;
				GLushort _tmp55_;
				GLfloat* _tmp56_;
				gint _tmp56__length1;
				gint _tmp57_;
				GLfloat _tmp58_;
				GLfloat* _tmp59_;
				gint _tmp59__length1;
				gint _tmp60_;
				GLfloat _tmp61_;
				GLfloat* _tmp62_;
				gint _tmp62__length1;
				gint _tmp63_;
				GLfloat _tmp64_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 5;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->board_quads;
				_tmp4__length1 = self->priv->board_quads_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->priv->board_quads;
				_tmp5__length1 = self->priv->board_quads_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_ + 4];
				j = _tmp7_ * 3;
				_tmp8_ = self->priv->board_normals;
				_tmp8__length1 = self->priv->board_normals_length1;
				_tmp9_ = j;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = self->priv->board_normals;
				_tmp11__length1 = self->priv->board_normals_length1;
				_tmp12_ = j;
				_tmp13_ = _tmp11_[_tmp12_ + 1];
				_tmp14_ = self->priv->board_normals;
				_tmp14__length1 = self->priv->board_normals_length1;
				_tmp15_ = j;
				_tmp16_ = _tmp14_[_tmp15_ + 2];
				glNormal3f (_tmp10_, _tmp13_, _tmp16_);
				_tmp17_ = self->priv->board_quads;
				_tmp17__length1 = self->priv->board_quads_length1;
				_tmp18_ = i;
				_tmp19_ = _tmp17_[_tmp18_];
				j = _tmp19_ * 3;
				_tmp20_ = self->priv->board_vertices;
				_tmp20__length1 = self->priv->board_vertices_length1;
				_tmp21_ = j;
				_tmp22_ = _tmp20_[_tmp21_];
				_tmp23_ = self->priv->board_vertices;
				_tmp23__length1 = self->priv->board_vertices_length1;
				_tmp24_ = j;
				_tmp25_ = _tmp23_[_tmp24_ + 1];
				_tmp26_ = self->priv->board_vertices;
				_tmp26__length1 = self->priv->board_vertices_length1;
				_tmp27_ = j;
				_tmp28_ = _tmp26_[_tmp27_ + 2];
				glVertex3f (_tmp22_, _tmp25_, _tmp28_);
				_tmp29_ = self->priv->board_quads;
				_tmp29__length1 = self->priv->board_quads_length1;
				_tmp30_ = i;
				_tmp31_ = _tmp29_[_tmp30_ + 1];
				j = _tmp31_ * 3;
				_tmp32_ = self->priv->board_vertices;
				_tmp32__length1 = self->priv->board_vertices_length1;
				_tmp33_ = j;
				_tmp34_ = _tmp32_[_tmp33_];
				_tmp35_ = self->priv->board_vertices;
				_tmp35__length1 = self->priv->board_vertices_length1;
				_tmp36_ = j;
				_tmp37_ = _tmp35_[_tmp36_ + 1];
				_tmp38_ = self->priv->board_vertices;
				_tmp38__length1 = self->priv->board_vertices_length1;
				_tmp39_ = j;
				_tmp40_ = _tmp38_[_tmp39_ + 2];
				glVertex3f (_tmp34_, _tmp37_, _tmp40_);
				_tmp41_ = self->priv->board_quads;
				_tmp41__length1 = self->priv->board_quads_length1;
				_tmp42_ = i;
				_tmp43_ = _tmp41_[_tmp42_ + 2];
				j = _tmp43_ * 3;
				_tmp44_ = self->priv->board_vertices;
				_tmp44__length1 = self->priv->board_vertices_length1;
				_tmp45_ = j;
				_tmp46_ = _tmp44_[_tmp45_];
				_tmp47_ = self->priv->board_vertices;
				_tmp47__length1 = self->priv->board_vertices_length1;
				_tmp48_ = j;
				_tmp49_ = _tmp47_[_tmp48_ + 1];
				_tmp50_ = self->priv->board_vertices;
				_tmp50__length1 = self->priv->board_vertices_length1;
				_tmp51_ = j;
				_tmp52_ = _tmp50_[_tmp51_ + 2];
				glVertex3f (_tmp46_, _tmp49_, _tmp52_);
				_tmp53_ = self->priv->board_quads;
				_tmp53__length1 = self->priv->board_quads_length1;
				_tmp54_ = i;
				_tmp55_ = _tmp53_[_tmp54_ + 3];
				j = _tmp55_ * 3;
				_tmp56_ = self->priv->board_vertices;
				_tmp56__length1 = self->priv->board_vertices_length1;
				_tmp57_ = j;
				_tmp58_ = _tmp56_[_tmp57_];
				_tmp59_ = self->priv->board_vertices;
				_tmp59__length1 = self->priv->board_vertices_length1;
				_tmp60_ = j;
				_tmp61_ = _tmp59_[_tmp60_ + 1];
				_tmp62_ = self->priv->board_vertices;
				_tmp62__length1 = self->priv->board_vertices_length1;
				_tmp63_ = j;
				_tmp64_ = _tmp62_[_tmp63_ + 2];
				glVertex3f (_tmp58_, _tmp61_, _tmp64_);
			}
		}
	}
	glEnd ();
	glEnable (GL_TEXTURE_2D);
	_tmp65_ = chess_view3_d_get_board_texture (self);
	_tmp66_ = _tmp65_;
	glBindTexture (GL_TEXTURE_2D, _tmp66_);
	glNormal3f ((GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp67_;
			_tmp67_ = TRUE;
			while (TRUE) {
				gboolean _tmp68_;
				gint _tmp70_;
				_tmp68_ = _tmp67_;
				if (!_tmp68_) {
					gint _tmp69_;
					_tmp69_ = rank;
					rank = _tmp69_ + 1;
				}
				_tmp67_ = FALSE;
				_tmp70_ = rank;
				if (!(_tmp70_ < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp71_;
						_tmp71_ = TRUE;
						while (TRUE) {
							gboolean _tmp72_;
							gint _tmp74_;
							gint _tmp75_;
							gint _tmp76_;
							GLfloat _tmp77_;
							gint _tmp78_;
							GLfloat _tmp79_;
							GLfloat x0;
							GLfloat _tmp80_;
							GLfloat _tmp81_;
							GLfloat x1;
							GLfloat _tmp82_;
							gint _tmp83_;
							GLfloat _tmp84_;
							GLfloat z0;
							GLfloat _tmp85_;
							GLfloat _tmp86_;
							GLfloat z1;
							GLfloat _tmp87_;
							GLfloat _tmp88_;
							GLfloat _tmp89_;
							GLfloat _tmp90_;
							GLfloat _tmp91_;
							GLfloat _tmp92_;
							GLfloat _tmp93_;
							GLfloat _tmp94_;
							_tmp72_ = _tmp71_;
							if (!_tmp72_) {
								gint _tmp73_;
								_tmp73_ = file;
								file = _tmp73_ + 1;
							}
							_tmp71_ = FALSE;
							_tmp74_ = file;
							if (!(_tmp74_ < 8)) {
								break;
							}
							_tmp75_ = file;
							_tmp76_ = rank;
							if (((_tmp75_ + _tmp76_) % 2) == 0) {
								glColor3f ((GLfloat) (0xee / 255.f), (GLfloat) (0xee / 255.f), (GLfloat) (0xec / 255.f));
							} else {
								glColor3f ((GLfloat) (0xba / 255.f), (GLfloat) (0xbd / 255.f), (GLfloat) (0xb6 / 255.f));
							}
							glBegin (GL_QUADS);
							_tmp77_ = self->priv->BOARD_BORDER;
							_tmp78_ = file;
							_tmp79_ = self->priv->SQUARE_WIDTH;
							x0 = _tmp77_ + (_tmp78_ * _tmp79_);
							_tmp80_ = x0;
							_tmp81_ = self->priv->SQUARE_WIDTH;
							x1 = _tmp80_ + _tmp81_;
							_tmp82_ = self->priv->BOARD_BORDER;
							_tmp83_ = rank;
							_tmp84_ = self->priv->SQUARE_WIDTH;
							z0 = _tmp82_ + (_tmp83_ * _tmp84_);
							_tmp85_ = z0;
							_tmp86_ = self->priv->SQUARE_WIDTH;
							z1 = _tmp85_ + _tmp86_;
							glTexCoord2f ((GLfloat) 0.0f, (GLfloat) 0.0f);
							_tmp87_ = x0;
							_tmp88_ = z0;
							glVertex3f (_tmp87_, (GLfloat) 0.0f, -_tmp88_);
							glTexCoord2f ((GLfloat) 1.0f, (GLfloat) 0.0f);
							_tmp89_ = x1;
							_tmp90_ = z0;
							glVertex3f (_tmp89_, (GLfloat) 0.0f, -_tmp90_);
							glTexCoord2f ((GLfloat) 1.0f, (GLfloat) 1.0f);
							_tmp91_ = x1;
							_tmp92_ = z1;
							glVertex3f (_tmp91_, (GLfloat) 0.0f, -_tmp92_);
							glTexCoord2f ((GLfloat) 0.0f, (GLfloat) 1.0f);
							_tmp93_ = x0;
							_tmp94_ = z1;
							glVertex3f (_tmp93_, (GLfloat) 0.0f, -_tmp94_);
							glEnd ();
						}
					}
				}
			}
		}
	}
	glDisable (GL_TEXTURE_2D);
	glDisable (GL_COLOR_MATERIAL);
}


static void chess_view3_d_draw_numbering (ChessView3D* self) {
	GLfloat _tmp0_;
	GLfloat text_width;
	GLfloat _tmp1_;
	GLfloat _tmp2_;
	GLfloat text_offset;
	GLfloat _tmp3_;
	GLfloat _tmp4_;
	GLfloat offset;
	GLfloat _tmp5_;
	GLfloat white_z_offset;
	GLfloat _tmp6_;
	GLfloat _tmp7_;
	GLfloat black_z_offset;
	GLfloat _tmp8_;
	GLfloat left_offset;
	GLfloat _tmp9_;
	GLfloat _tmp10_;
	GLfloat right_offset;
	GLuint _tmp11_;
	GLuint _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->BOARD_BORDER;
	text_width = _tmp0_ * 0.8f;
	_tmp1_ = self->priv->BOARD_BORDER;
	_tmp2_ = self->priv->BOARD_CHAMFER;
	text_offset = (_tmp1_ + _tmp2_) * 0.5f;
	_tmp3_ = self->priv->BOARD_BORDER;
	_tmp4_ = self->priv->SQUARE_WIDTH;
	offset = _tmp3_ + (_tmp4_ * 0.5f);
	_tmp5_ = text_offset;
	white_z_offset = -_tmp5_;
	_tmp6_ = self->priv->BOARD_OUTER_WIDTH;
	_tmp7_ = text_offset;
	black_z_offset = (-_tmp6_) + _tmp7_;
	_tmp8_ = text_offset;
	left_offset = _tmp8_;
	_tmp9_ = self->priv->BOARD_OUTER_WIDTH;
	_tmp10_ = text_offset;
	right_offset = _tmp9_ - _tmp10_;
	glDisable (GL_DEPTH_TEST);
	glEnable (GL_TEXTURE_2D);
	glEnable (GL_COLOR_MATERIAL);
	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	_tmp11_ = chess_view3_d_get_numbering_texture (self);
	_tmp12_ = _tmp11_;
	glBindTexture (GL_TEXTURE_2D, _tmp12_);
	glColor3f ((GLfloat) 1, (GLfloat) 1, (GLfloat) 1);
	glNormal3f ((GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				GLfloat _tmp17_;
				GLfloat _tmp18_;
				GLfloat _tmp19_;
				gint _tmp20_;
				GLfloat _tmp21_;
				GLfloat _tmp22_;
				GLfloat _tmp23_;
				gint _tmp24_;
				GLfloat _tmp25_;
				GLfloat _tmp26_;
				GLfloat _tmp27_;
				gint _tmp28_;
				GLfloat _tmp29_;
				GLfloat _tmp30_;
				GLfloat _tmp31_;
				gint _tmp32_;
				GLfloat _tmp33_;
				GLfloat _tmp34_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < 8)) {
					break;
				}
				_tmp17_ = left_offset;
				_tmp18_ = offset;
				_tmp19_ = text_width;
				_tmp20_ = i;
				chess_view3_d_draw_label (self, _tmp17_, -_tmp18_, _tmp19_, _tmp20_ + 8);
				_tmp21_ = right_offset;
				_tmp22_ = offset;
				_tmp23_ = text_width;
				_tmp24_ = i;
				chess_view3_d_draw_label (self, _tmp21_, -_tmp22_, _tmp23_, _tmp24_ + 8);
				_tmp25_ = offset;
				_tmp26_ = white_z_offset;
				_tmp27_ = text_width;
				_tmp28_ = i;
				chess_view3_d_draw_label (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_);
				_tmp29_ = offset;
				_tmp30_ = black_z_offset;
				_tmp31_ = text_width;
				_tmp32_ = i;
				chess_view3_d_draw_label (self, _tmp29_, _tmp30_, _tmp31_, _tmp32_);
				_tmp33_ = offset;
				_tmp34_ = self->priv->SQUARE_WIDTH;
				offset = _tmp33_ + _tmp34_;
			}
		}
	}
	glDisable (GL_BLEND);
	glDisable (GL_COLOR_MATERIAL);
	glDisable (GL_TEXTURE_2D);
}


static void chess_view3_d_draw_label (ChessView3D* self, GLfloat x, GLfloat z, GLfloat width, gint cell) {
	GLfloat w;
	gint _tmp0_;
	GLfloat l;
	GLfloat _tmp1_;
	GLfloat _tmp2_;
	GLfloat _tmp3_;
	GLfloat _tmp4_;
	GLfloat _tmp5_;
	GLfloat _tmp6_;
	GLfloat _tmp7_;
	GLfloat _tmp8_;
	GLfloat _tmp9_;
	GLfloat _tmp10_;
	g_return_if_fail (self != NULL);
	w = (GLfloat) (1.0f / 16);
	_tmp0_ = cell;
	l = (GLfloat) (_tmp0_ / 16.0f);
	glPushMatrix ();
	_tmp1_ = x;
	_tmp2_ = z;
	glTranslatef (_tmp1_, (GLfloat) 0.0f, _tmp2_);
	glBegin (GL_QUADS);
	glTexCoord2f (l, (GLfloat) 0.0f);
	_tmp3_ = width;
	_tmp4_ = width;
	glVertex3f ((-_tmp3_) / 2, (GLfloat) 0.0f, (-_tmp4_) / 2);
	glTexCoord2f (l, (GLfloat) 1.0f);
	_tmp5_ = width;
	_tmp6_ = width;
	glVertex3f ((-_tmp5_) / 2, (GLfloat) 0.0f, _tmp6_ / 2);
	glTexCoord2f (l + w, (GLfloat) 1.0f);
	_tmp7_ = width;
	_tmp8_ = width;
	glVertex3f (_tmp7_ / 2, (GLfloat) 0.0f, _tmp8_ / 2);
	glTexCoord2f (l + w, (GLfloat) 0.0f);
	_tmp9_ = width;
	_tmp10_ = width;
	glVertex3f (_tmp9_ / 2, (GLfloat) 0.0f, (-_tmp10_) / 2);
	glEnd ();
	glPopMatrix ();
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static void chess_view3_d_draw_pieces (ChessView3D* self) {
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	GLuint _tmp4_;
	GLuint _tmp5_;
	ChessScene* _tmp6_;
	ChessScene* _tmp7_;
	GList* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_view_get_scene ((ChessView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	glEnable (GL_DEPTH_TEST);
	glEnable (GL_TEXTURE_2D);
	_tmp4_ = chess_view3_d_get_piece_texture (self);
	_tmp5_ = _tmp4_;
	glBindTexture (GL_TEXTURE_2D, _tmp5_);
	_tmp6_ = chess_view_get_scene ((ChessView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp8_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp9_;
			ChessModel* model = NULL;
			_tmp9_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp9_;
			{
				GLfloat _tmp10_;
				ChessModel* _tmp11_;
				gdouble _tmp12_;
				GLfloat _tmp13_;
				GLfloat _tmp14_;
				GLfloat _tmp15_;
				ChessModel* _tmp16_;
				gdouble _tmp17_;
				GLfloat _tmp18_;
				GLfloat _tmp19_;
				ChessModel* _tmp20_;
				gboolean _tmp21_;
				ChessModel* _tmp23_;
				ChessPiece* _tmp24_;
				glPushMatrix ();
				_tmp10_ = self->priv->BOARD_BORDER;
				_tmp11_ = model;
				_tmp12_ = _tmp11_->x;
				_tmp13_ = self->priv->SQUARE_WIDTH;
				_tmp14_ = self->priv->SQUARE_WIDTH;
				_tmp15_ = self->priv->BOARD_BORDER;
				_tmp16_ = model;
				_tmp17_ = _tmp16_->y;
				_tmp18_ = self->priv->SQUARE_WIDTH;
				_tmp19_ = self->priv->SQUARE_WIDTH;
				glTranslatef ((_tmp10_ + (((GLfloat) _tmp12_) * _tmp13_)) + (_tmp14_ / 2), (GLfloat) 0.0f, -((_tmp15_ + (((GLfloat) _tmp17_) * _tmp18_)) + (_tmp19_ / 2)));
				_tmp20_ = model;
				_tmp21_ = _tmp20_->is_selected;
				if (_tmp21_) {
					GLfloat _tmp22_;
					_tmp22_ = self->priv->SQUARE_WIDTH;
					glTranslatef ((GLfloat) 0.0f, _tmp22_ * 0.4f, (GLfloat) 0.0f);
				}
				_tmp23_ = model;
				_tmp24_ = _tmp23_->piece;
				chess_view3_d_render_piece (self, _tmp24_, (GLfloat) 1.0f);
				glPopMatrix ();
				_chess_model_unref0 (model);
			}
		}
	}
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_;
				gint _tmp28_;
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = rank;
					rank = _tmp27_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp28_ = rank;
				if (!(_tmp28_ < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp29_;
						_tmp29_ = TRUE;
						while (TRUE) {
							gboolean _tmp30_;
							gint _tmp32_;
							gboolean _tmp33_ = FALSE;
							ChessScene* _tmp34_;
							ChessScene* _tmp35_;
							gboolean _tmp36_;
							gboolean _tmp37_;
							gboolean _tmp43_;
							_tmp30_ = _tmp29_;
							if (!_tmp30_) {
								gint _tmp31_;
								_tmp31_ = file;
								file = _tmp31_ + 1;
							}
							_tmp29_ = FALSE;
							_tmp32_ = file;
							if (!(_tmp32_ < 8)) {
								break;
							}
							_tmp34_ = chess_view_get_scene ((ChessView*) self);
							_tmp35_ = _tmp34_;
							_tmp36_ = chess_scene_get_show_move_hints (_tmp35_);
							_tmp37_ = _tmp36_;
							if (_tmp37_) {
								ChessScene* _tmp38_;
								ChessScene* _tmp39_;
								gint _tmp40_;
								gint _tmp41_;
								gboolean _tmp42_ = FALSE;
								_tmp38_ = chess_view_get_scene ((ChessView*) self);
								_tmp39_ = _tmp38_;
								_tmp40_ = rank;
								_tmp41_ = file;
								_tmp42_ = chess_scene_can_move (_tmp39_, _tmp40_, _tmp41_);
								_tmp33_ = _tmp42_;
							} else {
								_tmp33_ = FALSE;
							}
							_tmp43_ = _tmp33_;
							if (_tmp43_) {
								GLfloat _tmp44_;
								gint _tmp45_;
								GLfloat _tmp46_;
								GLfloat _tmp47_;
								GLfloat _tmp48_;
								gint _tmp49_;
								GLfloat _tmp50_;
								GLfloat _tmp51_;
								ChessScene* _tmp52_;
								ChessScene* _tmp53_;
								ChessPiece* _tmp54_ = NULL;
								ChessPiece* _tmp55_;
								glPushMatrix ();
								_tmp44_ = self->priv->BOARD_BORDER;
								_tmp45_ = file;
								_tmp46_ = self->priv->SQUARE_WIDTH;
								_tmp47_ = self->priv->SQUARE_WIDTH;
								_tmp48_ = self->priv->BOARD_BORDER;
								_tmp49_ = rank;
								_tmp50_ = self->priv->SQUARE_WIDTH;
								_tmp51_ = self->priv->SQUARE_WIDTH;
								glTranslatef ((_tmp44_ + (_tmp45_ * _tmp46_)) + (_tmp47_ / 2), (GLfloat) 0.0f, -((_tmp48_ + (_tmp49_ * _tmp50_)) + (_tmp51_ / 2)));
								glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
								glEnable (GL_BLEND);
								glDisable (GL_DEPTH_TEST);
								_tmp52_ = chess_view_get_scene ((ChessView*) self);
								_tmp53_ = _tmp52_;
								_tmp54_ = chess_scene_get_selected_piece (_tmp53_);
								_tmp55_ = _tmp54_;
								chess_view3_d_render_piece (self, _tmp55_, (GLfloat) 0.1f);
								_chess_piece_unref0 (_tmp55_);
								glEnable (GL_DEPTH_TEST);
								glDisable (GL_BLEND);
								glPopMatrix ();
							}
						}
					}
				}
			}
		}
	}
	glDisable (GL_TEXTURE_2D);
}


static void chess_view3_d_render_piece (ChessView3D* self, ChessPiece* piece, GLfloat alpha) {
	GLfloat _tmp0_;
	GLfloat _tmp1_;
	GLfloat _tmp2_;
	GLfloat _tmp3_;
	ChessPiece* _tmp4_;
	ChessPlayer* _tmp5_;
	Color _tmp6_;
	static const GLfloat black[] = {(GLfloat) 0.0f, (GLfloat) 0.0f, (GLfloat) 0.0f, (GLfloat) 0.0f};
	ChessPiece* _tmp7_;
	ChessPlayer* _tmp8_;
	Color _tmp9_;
	ChessPiece* _tmp10_;
	PieceType _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (piece != NULL);
	_tmp0_ = alpha;
	self->priv->white_piece_color[3] = _tmp0_;
	_tmp1_ = self->priv->white_piece_color[3];
	_tmp2_ = alpha;
	self->priv->black_piece_color[3] = _tmp2_;
	_tmp3_ = self->priv->black_piece_color[3];
	_tmp4_ = piece;
	_tmp5_ = _tmp4_->player;
	_tmp6_ = _tmp5_->color;
	if (_tmp6_ == COLOR_WHITE) {
		glMaterialfv (GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, self->priv->white_piece_color);
		glMaterialfv (GL_FRONT_AND_BACK, GL_SPECULAR, self->priv->white_piece_specular);
	} else {
		glMaterialfv (GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, self->priv->black_piece_color);
		glMaterialfv (GL_FRONT_AND_BACK, GL_SPECULAR, self->priv->black_piece_specular);
	}
	glMaterialfv (GL_FRONT_AND_BACK, GL_EMISSION, black);
	glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, (GLfloat) 64.0f);
	_tmp7_ = piece;
	_tmp8_ = _tmp7_->player;
	_tmp9_ = _tmp8_->color;
	if (_tmp9_ == COLOR_BLACK) {
		glRotatef ((GLfloat) 180.0f, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	}
	_tmp10_ = piece;
	_tmp11_ = _tmp10_->type;
	switch (_tmp11_) {
		case PIECE_TYPE_PAWN:
		{
			TDSModel* _tmp12_;
			_tmp12_ = self->priv->pawn_model;
			tds_model_render (_tmp12_);
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			TDSModel* _tmp13_;
			_tmp13_ = self->priv->rook_model;
			tds_model_render (_tmp13_);
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			TDSModel* _tmp14_;
			_tmp14_ = self->priv->knight_model;
			tds_model_render (_tmp14_);
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			TDSModel* _tmp15_;
			_tmp15_ = self->priv->bishop_model;
			tds_model_render (_tmp15_);
			break;
		}
		case PIECE_TYPE_QUEEN:
		{
			TDSModel* _tmp16_;
			_tmp16_ = self->priv->queen_model;
			tds_model_render (_tmp16_);
			break;
		}
		case PIECE_TYPE_KING:
		{
			TDSModel* _tmp17_;
			_tmp17_ = self->priv->king_model;
			tds_model_render (_tmp17_);
			break;
		}
		default:
		break;
	}
}


static gboolean chess_view3_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView3D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	ChessGame* _tmp3_;
	ChessGame* _tmp4_;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	GLuint buffer[20] = {0};
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GLint* _tmp11_ = NULL;
	GLint* viewport;
	gint viewport_length1;
	gint _viewport_size_;
	GdkEventButton _tmp12_;
	gdouble _tmp13_;
	gint _tmp14_ = 0;
	GdkEventButton _tmp15_;
	gdouble _tmp16_;
	GLint* _tmp17_;
	gint _tmp17__length1;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	ChessScene* _tmp20_;
	ChessScene* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	GLfloat _tmp24_;
	GLfloat _tmp25_;
	GLint _tmp54_ = 0;
	GLint n_hits;
	GLint _tmp55_;
	self = (ChessView3D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_game (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp5_;
		guint _tmp6_;
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.button;
		_tmp0_ = _tmp6_ != ((guint) 1);
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = chess_view3_d_start_gl (self);
	if (!_tmp8_) {
		result = TRUE;
		return result;
	}
	glSelectBuffer ((GLsizei) 20, buffer);
	glRenderMode (GL_SELECT);
	glInitNames ();
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	_tmp9_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp10_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp11_ = g_new0 (GLint, 4);
	_tmp11_[0] = (GLint) 0;
	_tmp11_[1] = (GLint) 0;
	_tmp11_[2] = (GLint) _tmp9_;
	_tmp11_[3] = (GLint) _tmp10_;
	viewport = _tmp11_;
	viewport_length1 = 4;
	_viewport_size_ = viewport_length1;
	_tmp12_ = *event;
	_tmp13_ = _tmp12_.x;
	_tmp14_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp15_ = *event;
	_tmp16_ = _tmp15_.y;
	_tmp17_ = viewport;
	_tmp17__length1 = viewport_length1;
	gluPickMatrix ((GLdouble) _tmp13_, (GLdouble) (((gfloat) _tmp14_) - _tmp16_), (GLdouble) 1.0, (GLdouble) 1.0, _tmp17_);
	_tmp18_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp19_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	gluPerspective ((GLdouble) 60.0, (GLdouble) (((gfloat) _tmp18_) / ((gfloat) _tmp19_)), (GLdouble) 0, (GLdouble) 1);
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	chess_view3_d_transform_camera (self);
	_tmp20_ = chess_view_get_scene ((ChessView*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = chess_scene_get_board_angle (_tmp21_);
	_tmp23_ = _tmp22_;
	glRotatef ((GLfloat) _tmp23_, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	_tmp24_ = self->priv->OFFSET;
	_tmp25_ = self->priv->OFFSET;
	glTranslatef (-_tmp24_, (GLfloat) 0.0f, _tmp25_);
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp26_;
			_tmp26_ = TRUE;
			while (TRUE) {
				gboolean _tmp27_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp27_ = _tmp26_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = rank;
					rank = _tmp28_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp29_ = rank;
				if (!(_tmp29_ < 8)) {
					break;
				}
				_tmp30_ = rank;
				glPushName ((GLuint) _tmp30_);
				{
					gint file;
					file = 0;
					{
						gboolean _tmp31_;
						_tmp31_ = TRUE;
						while (TRUE) {
							gboolean _tmp32_;
							gint _tmp34_;
							gint _tmp35_;
							GLfloat _tmp36_;
							gint _tmp37_;
							GLfloat _tmp38_;
							GLfloat x0;
							GLfloat _tmp39_;
							GLfloat _tmp40_;
							GLfloat x1;
							GLfloat _tmp41_;
							gint _tmp42_;
							GLfloat _tmp43_;
							GLfloat z0;
							GLfloat _tmp44_;
							GLfloat _tmp45_;
							GLfloat z1;
							GLfloat _tmp46_;
							GLfloat _tmp47_;
							GLfloat _tmp48_;
							GLfloat _tmp49_;
							GLfloat _tmp50_;
							GLfloat _tmp51_;
							GLfloat _tmp52_;
							GLfloat _tmp53_;
							_tmp32_ = _tmp31_;
							if (!_tmp32_) {
								gint _tmp33_;
								_tmp33_ = file;
								file = _tmp33_ + 1;
							}
							_tmp31_ = FALSE;
							_tmp34_ = file;
							if (!(_tmp34_ < 8)) {
								break;
							}
							_tmp35_ = file;
							glPushName ((GLuint) _tmp35_);
							glBegin (GL_QUADS);
							_tmp36_ = self->priv->BOARD_BORDER;
							_tmp37_ = file;
							_tmp38_ = self->priv->SQUARE_WIDTH;
							x0 = _tmp36_ + (_tmp37_ * _tmp38_);
							_tmp39_ = x0;
							_tmp40_ = self->priv->SQUARE_WIDTH;
							x1 = _tmp39_ + _tmp40_;
							_tmp41_ = self->priv->BOARD_BORDER;
							_tmp42_ = rank;
							_tmp43_ = self->priv->SQUARE_WIDTH;
							z0 = _tmp41_ + (_tmp42_ * _tmp43_);
							_tmp44_ = z0;
							_tmp45_ = self->priv->SQUARE_WIDTH;
							z1 = _tmp44_ + _tmp45_;
							_tmp46_ = x0;
							_tmp47_ = z0;
							glVertex3f (_tmp46_, (GLfloat) 0.0f, -_tmp47_);
							_tmp48_ = x1;
							_tmp49_ = z0;
							glVertex3f (_tmp48_, (GLfloat) 0.0f, -_tmp49_);
							_tmp50_ = x1;
							_tmp51_ = z1;
							glVertex3f (_tmp50_, (GLfloat) 0.0f, -_tmp51_);
							_tmp52_ = x0;
							_tmp53_ = z1;
							glVertex3f (_tmp52_, (GLfloat) 0.0f, -_tmp53_);
							glEnd ();
							glPopName ();
						}
					}
				}
				glPopName ();
			}
		}
	}
	glFlush ();
	_tmp54_ = glRenderMode (GL_RENDER);
	n_hits = _tmp54_;
	_tmp55_ = n_hits;
	if (_tmp55_ > ((GLint) 0)) {
		GLuint _tmp56_;
		gint rank;
		GLuint _tmp57_;
		gint file;
		ChessScene* _tmp58_;
		ChessScene* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		_tmp56_ = buffer[3];
		rank = (gint) _tmp56_;
		_tmp57_ = buffer[4];
		file = (gint) _tmp57_;
		_tmp58_ = chess_view_get_scene ((ChessView*) self);
		_tmp59_ = _tmp58_;
		_tmp60_ = file;
		_tmp61_ = rank;
		chess_scene_select_square (_tmp59_, _tmp60_, _tmp61_);
	}
	result = TRUE;
	viewport = (g_free (viewport), NULL);
	return result;
}


static void chess_view3_d_transform_camera (ChessView3D* self) {
	g_return_if_fail (self != NULL);
	glLoadIdentity ();
	gluLookAt ((GLdouble) 0.0, (GLdouble) 80.0, (GLdouble) 40.0, (GLdouble) 0.0, (GLdouble) 0.0, (GLdouble) 5.0, (GLdouble) 0.0, (GLdouble) 1.0, (GLdouble) 0.0);
}


static GLuint chess_view3_d_load_texture (ChessView3D* self, const gchar* filename) {
	GLuint result = 0U;
	GdkPixbuf* pixbuf = NULL;
	GLenum format = 0U;
	GdkPixbuf* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GLuint textures[1] = {0};
	GLuint _tmp15_;
	GLuint t;
	GLuint _tmp16_;
	GdkPixbuf* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GdkPixbuf* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GdkPixbuf* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GLenum _tmp26_;
	GdkPixbuf* _tmp27_;
	void* _tmp28_;
	void* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (filename != NULL, 0U);
	{
		const gchar* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp0_ = filename;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp2_;
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = filename;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("chess-view-3d.vala:579: Error loading texture %s: %s", _tmp3_, _tmp5_);
		result = (GLuint) 0;
		_g_error_free0 (e);
		_g_object_unref0 (pixbuf);
		return result;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	_tmp6_ = pixbuf;
	_tmp7_ = gdk_pixbuf_get_n_channels (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 1) {
		format = GL_LUMINANCE;
	} else {
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = pixbuf;
		_tmp10_ = gdk_pixbuf_get_n_channels (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == 3) {
			format = GL_RGB;
		} else {
			GdkPixbuf* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp12_ = pixbuf;
			_tmp13_ = gdk_pixbuf_get_n_channels (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == 4) {
				format = GL_RGBA;
			} else {
				g_warning ("chess-view-3d.vala:592: Unknown format image");
				result = (GLuint) 0;
				_g_object_unref0 (pixbuf);
				return result;
			}
		}
	}
	glGenTextures ((GLsizei) 1, textures);
	_tmp15_ = textures[0];
	t = _tmp15_;
	_tmp16_ = t;
	glBindTexture (GL_TEXTURE_2D, _tmp16_);
	glPixelStorei (GL_UNPACK_ALIGNMENT, (GLint) 1);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (GLint) GL_LINEAR);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (GLint) GL_LINEAR);
	_tmp17_ = pixbuf;
	_tmp18_ = gdk_pixbuf_get_n_channels (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = pixbuf;
	_tmp21_ = gdk_pixbuf_get_width (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = pixbuf;
	_tmp24_ = gdk_pixbuf_get_height (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = format;
	_tmp27_ = pixbuf;
	_tmp28_ = gdk_pixbuf_get_pixels (_tmp27_);
	_tmp29_ = _tmp28_;
	gluBuild2DMipmaps (GL_TEXTURE_2D, (GLint) _tmp19_, (GLsizei) _tmp22_, (GLsizei) _tmp25_, _tmp26_, GL_UNSIGNED_BYTE, _tmp29_);
	result = t;
	_g_object_unref0 (pixbuf);
	return result;
}


static GLuint chess_view3_d_make_numbering_texture (ChessView3D* self) {
	GLuint result = 0U;
	gint width;
	gint height;
	gint _tmp0_;
	gint texture_width;
	gint _tmp1_;
	gint texture_height;
	gint _tmp2_;
	gint _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* surface;
	cairo_surface_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* c;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	gint _tmp10_;
	cairo_font_extents_t extents = {0};
	cairo_t* _tmp11_;
	cairo_font_extents_t _tmp12_ = {0};
	gint _tmp13_;
	cairo_font_extents_t _tmp14_;
	gdouble _tmp15_;
	cairo_font_extents_t _tmp16_;
	gdouble _tmp17_;
	gdouble scale;
	gint _tmp18_;
	gdouble yoffset;
	gint _tmp19_;
	gdouble xoffset;
	GLuint textures[1] = {0};
	GLuint _tmp41_;
	GLuint t;
	gint _tmp42_;
	gint _tmp43_;
	cairo_surface_t* _tmp44_;
	guchar* _tmp45_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	width = 64;
	height = 64;
	_tmp0_ = width;
	texture_width = _tmp0_ * 16;
	_tmp1_ = height;
	texture_height = _tmp1_;
	_tmp2_ = texture_width;
	_tmp3_ = texture_height;
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_A8, _tmp2_, _tmp3_);
	surface = _tmp4_;
	_tmp5_ = surface;
	_tmp6_ = cairo_create (_tmp5_);
	c = _tmp6_;
	_tmp7_ = c;
	cairo_set_source_rgba (_tmp7_, 1.0, 1.0, 1.0, 1.0);
	_tmp8_ = c;
	cairo_select_font_face (_tmp8_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp9_ = c;
	_tmp10_ = width;
	cairo_set_font_size (_tmp9_, (gdouble) _tmp10_);
	_tmp11_ = c;
	cairo_font_extents (_tmp11_, &_tmp12_);
	extents = _tmp12_;
	_tmp13_ = width;
	_tmp14_ = extents;
	_tmp15_ = _tmp14_.ascent;
	_tmp16_ = extents;
	_tmp17_ = _tmp16_.descent;
	scale = _tmp13_ / (_tmp15_ + _tmp17_);
	_tmp18_ = height;
	yoffset = _tmp18_ * 0.5;
	_tmp19_ = width;
	xoffset = _tmp19_ * 0.5;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp20_;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_;
				gint _tmp23_;
				gint _tmp24_;
				gchar* _tmp25_ = NULL;
				gchar* f;
				gint _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* r;
				cairo_t* _tmp28_;
				gdouble _tmp29_;
				gdouble _tmp30_;
				gdouble _tmp31_;
				const gchar* _tmp32_;
				cairo_t* _tmp33_;
				gdouble _tmp34_;
				gint _tmp35_;
				gdouble _tmp36_;
				gdouble _tmp37_;
				const gchar* _tmp38_;
				gdouble _tmp39_;
				gint _tmp40_;
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp23_ = i;
				if (!(_tmp23_ < 8)) {
					break;
				}
				_tmp24_ = i;
				_tmp25_ = g_strdup_printf ("%c", 'a' + _tmp24_);
				f = _tmp25_;
				_tmp26_ = i;
				_tmp27_ = g_strdup_printf ("%c", '1' + _tmp26_);
				r = _tmp27_;
				_tmp28_ = c;
				_tmp29_ = xoffset;
				_tmp30_ = yoffset;
				_tmp31_ = scale;
				_tmp32_ = f;
				chess_view3_d_draw_centered_text (self, _tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_);
				_tmp33_ = c;
				_tmp34_ = xoffset;
				_tmp35_ = width;
				_tmp36_ = yoffset;
				_tmp37_ = scale;
				_tmp38_ = r;
				chess_view3_d_draw_centered_text (self, _tmp33_, _tmp34_ + (_tmp35_ * 8), _tmp36_, _tmp37_, _tmp38_);
				_tmp39_ = xoffset;
				_tmp40_ = width;
				xoffset = _tmp39_ + _tmp40_;
				_g_free0 (r);
				_g_free0 (f);
			}
		}
	}
	glGenTextures ((GLsizei) 1, textures);
	_tmp41_ = textures[0];
	t = _tmp41_;
	glBindTexture (GL_TEXTURE_2D, t);
	glPixelStorei (GL_UNPACK_ALIGNMENT, (GLint) 1);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (GLint) GL_LINEAR);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (GLint) GL_LINEAR);
	_tmp42_ = texture_width;
	_tmp43_ = texture_height;
	_tmp44_ = surface;
	_tmp45_ = cairo_image_surface_get_data (_tmp44_);
	gluBuild2DMipmaps (GL_TEXTURE_2D, (GLint) GL_ALPHA, (GLsizei) _tmp42_, (GLsizei) _tmp43_, GL_ALPHA, GL_UNSIGNED_BYTE, _tmp45_);
	result = t;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


static void chess_view3_d_draw_centered_text (ChessView3D* self, cairo_t* c, gdouble x, gdouble y, gdouble scale, const gchar* text) {
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp0_;
	const gchar* _tmp1_;
	cairo_text_extents_t _tmp2_ = {0};
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	cairo_t* _tmp7_;
	cairo_text_extents_t _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	cairo_text_extents_t _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	cairo_t* _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	cairo_t* _tmp17_;
	const gchar* _tmp18_;
	cairo_t* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = c;
	_tmp1_ = text;
	cairo_text_extents (_tmp0_, _tmp1_, &_tmp2_);
	extents = _tmp2_;
	_tmp3_ = c;
	cairo_save (_tmp3_);
	_tmp4_ = c;
	_tmp5_ = x;
	_tmp6_ = y;
	cairo_translate (_tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = c;
	_tmp8_ = extents;
	_tmp9_ = _tmp8_.width;
	_tmp10_ = scale;
	_tmp11_ = extents;
	_tmp12_ = _tmp11_.height;
	_tmp13_ = scale;
	cairo_move_to (_tmp7_, ((-_tmp9_) * _tmp10_) / 2, (_tmp12_ * _tmp13_) / 2);
	_tmp14_ = c;
	_tmp15_ = scale;
	_tmp16_ = scale;
	cairo_scale (_tmp14_, _tmp15_, _tmp16_);
	_tmp17_ = c;
	_tmp18_ = text;
	cairo_show_text (_tmp17_, _tmp18_);
	_tmp19_ = c;
	cairo_restore (_tmp19_);
}


static GLuint chess_view3_d_get_board_texture (ChessView3D* self) {
	GLuint result;
	GLuint _tmp0_;
	GLuint _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_board_texture;
	if (_tmp0_ == ((GLuint) 0)) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GLuint _tmp3_ = 0U;
		_tmp1_ = g_build_filename (PKGDATADIR, "textures", "board.png", NULL, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = chess_view3_d_load_texture (self, _tmp2_);
		self->priv->_board_texture = _tmp3_;
		_g_free0 (_tmp2_);
	}
	_tmp4_ = self->priv->_board_texture;
	result = _tmp4_;
	return result;
}


static GLuint chess_view3_d_get_numbering_texture (ChessView3D* self) {
	GLuint result;
	GLuint _tmp0_;
	GLuint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_numbering_texture;
	if (_tmp0_ == ((GLuint) 0)) {
		GLuint _tmp1_ = 0U;
		_tmp1_ = chess_view3_d_make_numbering_texture (self);
		self->priv->_numbering_texture = _tmp1_;
	}
	_tmp2_ = self->priv->_numbering_texture;
	result = _tmp2_;
	return result;
}


static GLuint chess_view3_d_get_piece_texture (ChessView3D* self) {
	GLuint result;
	GLuint _tmp0_;
	GLuint _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_piece_texture;
	if (_tmp0_ == ((GLuint) 0)) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GLuint _tmp3_ = 0U;
		_tmp1_ = g_build_filename (PKGDATADIR, "textures", "piece.png", NULL, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = chess_view3_d_load_texture (self, _tmp2_);
		self->priv->_piece_texture = _tmp3_;
		_g_free0 (_tmp2_);
	}
	_tmp4_ = self->priv->_piece_texture;
	result = _tmp4_;
	return result;
}


static void chess_view3_d_class_init (ChessView3DClass * klass) {
	chess_view3_d_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessView3DPrivate));
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view3_d_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = chess_view3_d_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view3_d_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view3_d_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view3_d_finalize;
}


static void chess_view3_d_instance_init (ChessView3D * self) {
	self->priv = CHESS_VIEW3_D_GET_PRIVATE (self);
	self->priv->context = (GLXContext) NULL;
	self->priv->border = 6;
	self->priv->_board_texture = (GLuint) 0;
	self->priv->_numbering_texture = (GLuint) 0;
	self->priv->_piece_texture = (GLuint) 0;
}


static void chess_view3_d_finalize (GObject* obj) {
	ChessView3D * self;
	self = CHESS_VIEW3_D (obj);
	_tds_model_unref0 (self->priv->pawn_model);
	_tds_model_unref0 (self->priv->knight_model);
	_tds_model_unref0 (self->priv->bishop_model);
	_tds_model_unref0 (self->priv->rook_model);
	_tds_model_unref0 (self->priv->queen_model);
	_tds_model_unref0 (self->priv->king_model);
	self->priv->board_vertices = (g_free (self->priv->board_vertices), NULL);
	self->priv->board_normals = (g_free (self->priv->board_normals), NULL);
	self->priv->board_quads = (g_free (self->priv->board_quads), NULL);
	G_OBJECT_CLASS (chess_view3_d_parent_class)->finalize (obj);
}


GType chess_view3_d_get_type (void) {
	static volatile gsize chess_view3_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view3_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView3DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view3_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView3D), 0, (GInstanceInitFunc) chess_view3_d_instance_init, NULL };
		GType chess_view3_d_type_id;
		chess_view3_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView3D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view3_d_type_id__volatile, chess_view3_d_type_id);
	}
	return chess_view3_d_type_id__volatile;
}


static void _vala_chess_view3_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView3D * self;
	self = CHESS_VIEW3_D (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



