/* game-view.c generated by valac 0.15.0, the Vala compiler
 * generated from game-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <games-preimage.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SlotPrivate SlotPrivate;

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkColor background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	cairo_pattern_t* tile_pattern;
	gint tile_pattern_width;
	gint tile_pattern_height;
	gint x_offset;
	gint y_offset;
	gint tile_width;
	gint tile_height;
	gint tile_layer_offset_x;
	gint tile_layer_offset_y;
	Game* _game;
	GamesPreimage* _theme;
	gboolean _paused;
};

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};

struct _Tile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TilePrivate * priv;
	gint number;
	Slot* slot;
	gboolean visible;
	gint move_number;
};

struct _TileClass {
	GTypeClass parent_class;
	void (*finalize) (Tile *self);
};

struct _Slot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GTypeClass parent_class;
	void (*finalize) (Slot *self);
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME,
	GAME_VIEW_PAUSED
};
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_background (GameView* self, const gchar* colour);
static void game_view_draw_game (GameView* self, cairo_t* cr, gboolean render_indexes);
GamesPreimage* game_view_get_theme (GameView* self);
static void game_view_update_dimensions (GameView* self);
Game* game_view_get_game (GameView* self);
gpointer map_ref (gpointer instance);
void map_unref (gpointer instance);
GParamSpec* param_spec_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_map (GValue* value, gpointer v_object);
void value_take_map (GValue* value, gpointer v_object);
gpointer value_get_map (const GValue* value);
GType map_get_type (void) G_GNUC_CONST;
gpointer tile_ref (gpointer instance);
void tile_unref (gpointer instance);
GParamSpec* param_spec_tile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tile (GValue* value, gpointer v_object);
void value_take_tile (GValue* value, gpointer v_object);
gpointer value_get_tile (const GValue* value);
GType tile_get_type (void) G_GNUC_CONST;
gpointer slot_ref (gpointer instance);
void slot_unref (gpointer instance);
GParamSpec* param_spec_slot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_slot (GValue* value, gpointer v_object);
void value_take_slot (GValue* value, gpointer v_object);
gpointer value_get_slot (const GValue* value);
GType slot_get_type (void) G_GNUC_CONST;
static void game_view_get_tile_position (GameView* self, Tile* tile, gint* x, gint* y);
static gint game_view_get_image_offset (GameView* self, gint number);
gboolean game_view_get_paused (GameView* self);
Tile* game_get_selected_tile (Game* self);
guint map_get_width (Map* self);
guint map_get_height (Map* self);
static void game_view_redraw_tile_cb (GameView* self, Tile* tile);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static Tile* game_view_find_tile (GameView* self, guint x, guint y);
gboolean game_tile_can_move (Game* self, Tile* tile);
void game_set_selected_tile (Game* self, Tile* value);
gboolean tile_matches (Tile* self, Tile* tile);
gboolean game_remove_pair (Game* self, Tile* tile0, Tile* tile1);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender, Tile* tile, gpointer self);
void game_view_set_theme (GameView* self, GamesPreimage* value);
void game_view_set_paused (GameView* self, gboolean value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


void game_view_set_background (GameView* self, const gchar* colour) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = colour;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		GdkColor _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		_tmp2_ = colour;
		_tmp4_ = gdk_color_parse (_tmp2_, &_tmp3_);
		self->background_color = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		guint16 _tmp6_;
		guint16 _tmp7_;
		self->background_color.blue = (guint16) 0;
		_tmp6_ = self->background_color.blue;
		self->background_color.green = _tmp6_;
		_tmp7_ = self->background_color.green;
		self->background_color.red = _tmp7_;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gpointer _tile_ref0 (gpointer self) {
	return self ? tile_ref (self) : NULL;
}


static void game_view_draw_game (GameView* self, cairo_t* cr, gboolean render_indexes) {
	GamesPreimage* _tmp0_;
	GamesPreimage* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint image_width;
	gint _tmp4_;
	gint _tmp5_;
	gint image_height;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp17_;
	Game* _tmp38_;
	Game* _tmp39_;
	GList* _tmp40_;
	gboolean _tmp99_;
	gboolean _tmp100_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = game_view_get_theme (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	game_view_update_dimensions (self);
	_tmp2_ = self->priv->tile_width;
	_tmp3_ = self->priv->tile_layer_offset_x;
	image_width = _tmp2_ + _tmp3_;
	_tmp4_ = self->priv->tile_height;
	_tmp5_ = self->priv->tile_layer_offset_y;
	image_height = _tmp4_ + _tmp5_;
	_tmp7_ = render_indexes;
	if (!_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		cairo_pattern_t* _tmp10_;
		gboolean _tmp13_;
		gboolean _tmp16_;
		_tmp10_ = self->priv->tile_pattern;
		if (_tmp10_ == NULL) {
			_tmp9_ = TRUE;
		} else {
			gint _tmp11_;
			gint _tmp12_;
			_tmp11_ = self->priv->tile_pattern_width;
			_tmp12_ = image_width;
			_tmp9_ = _tmp11_ != _tmp12_;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			_tmp8_ = TRUE;
		} else {
			gint _tmp14_;
			gint _tmp15_;
			_tmp14_ = self->priv->tile_pattern_height;
			_tmp15_ = image_height;
			_tmp8_ = _tmp14_ != _tmp15_;
		}
		_tmp16_ = _tmp8_;
		_tmp6_ = _tmp16_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp17_ = _tmp6_;
	if (_tmp17_) {
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint width;
		gint _tmp21_;
		gint height;
		gint _tmp22_;
		gint _tmp23_;
		cairo_surface_t* _tmp24_;
		cairo_surface_t* surface;
		cairo_surface_t* _tmp25_;
		cairo_t* _tmp26_;
		cairo_t* c;
		GamesPreimage* _tmp27_;
		GamesPreimage* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		GdkPixbuf* _tmp31_ = NULL;
		GdkPixbuf* pixbuf;
		GdkPixbuf* _tmp32_;
		cairo_t* _tmp33_;
		GdkPixbuf* _tmp34_;
		cairo_t* _tmp35_;
		cairo_surface_t* _tmp36_;
		cairo_pattern_t* _tmp37_;
		_tmp18_ = image_width;
		self->priv->tile_pattern_width = _tmp18_;
		_tmp19_ = image_height;
		self->priv->tile_pattern_height = _tmp19_;
		_tmp20_ = image_width;
		width = _tmp20_ * 43;
		_tmp21_ = image_height;
		height = _tmp21_ * 2;
		_tmp22_ = width;
		_tmp23_ = height;
		_tmp24_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp22_, _tmp23_);
		surface = _tmp24_;
		_tmp25_ = surface;
		_tmp26_ = cairo_create (_tmp25_);
		c = _tmp26_;
		_tmp27_ = game_view_get_theme (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = width;
		_tmp30_ = height;
		_tmp31_ = games_preimage_render (_tmp28_, _tmp29_, _tmp30_);
		pixbuf = _tmp31_;
		_tmp32_ = pixbuf;
		if (_tmp32_ == NULL) {
			_g_object_unref0 (pixbuf);
			_cairo_destroy0 (c);
			_cairo_surface_destroy0 (surface);
			return;
		}
		_tmp33_ = c;
		_tmp34_ = pixbuf;
		gdk_cairo_set_source_pixbuf (_tmp33_, _tmp34_, (gdouble) 0, (gdouble) 0);
		_tmp35_ = c;
		cairo_paint (_tmp35_);
		_tmp36_ = surface;
		_tmp37_ = cairo_pattern_create_for_surface (_tmp36_);
		_cairo_pattern_destroy0 (self->priv->tile_pattern);
		self->priv->tile_pattern = _tmp37_;
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp38_ = game_view_get_game (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp40_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp41_;
			Tile* tile = NULL;
			_tmp41_ = _tile_ref0 ((Tile*) tile_it->data);
			tile = _tmp41_;
			{
				Tile* _tmp42_;
				gboolean _tmp43_;
				gint x = 0;
				gint y = 0;
				Tile* _tmp44_;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				Tile* _tmp47_;
				gint _tmp48_;
				gint _tmp49_ = 0;
				gint _tmp50_;
				gint texture_x;
				gint texture_y;
				gboolean _tmp51_;
				gboolean _tmp52_;
				gboolean _tmp77_;
				cairo_t* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				gint _tmp97_;
				cairo_t* _tmp98_;
				_tmp42_ = tile;
				_tmp43_ = _tmp42_->visible;
				if (!_tmp43_) {
					_tile_unref0 (tile);
					continue;
				}
				_tmp44_ = tile;
				game_view_get_tile_position (self, _tmp44_, &_tmp45_, &_tmp46_);
				x = _tmp45_;
				y = _tmp46_;
				_tmp47_ = tile;
				_tmp48_ = _tmp47_->number;
				_tmp49_ = game_view_get_image_offset (self, _tmp48_);
				_tmp50_ = image_width;
				texture_x = _tmp49_ * _tmp50_;
				texture_y = 0;
				_tmp51_ = game_view_get_paused (self);
				_tmp52_ = _tmp51_;
				if (_tmp52_) {
					gint _tmp53_ = 0;
					gint _tmp54_;
					_tmp53_ = game_view_get_image_offset (self, -1);
					_tmp54_ = image_width;
					texture_x = _tmp53_ * _tmp54_;
					texture_y = 0;
				} else {
					Tile* _tmp55_;
					Game* _tmp56_;
					Game* _tmp57_;
					Tile* _tmp58_;
					Tile* _tmp59_;
					_tmp55_ = tile;
					_tmp56_ = game_view_get_game (self);
					_tmp57_ = _tmp56_;
					_tmp58_ = game_get_selected_tile (_tmp57_);
					_tmp59_ = _tmp58_;
					if (_tmp55_ == _tmp59_) {
						gint _tmp60_;
						_tmp60_ = image_height;
						texture_y = _tmp60_;
					} else {
						gboolean _tmp61_ = FALSE;
						Game* _tmp62_;
						Game* _tmp63_;
						guint _tmp64_;
						gboolean _tmp75_;
						_tmp62_ = game_view_get_game (self);
						_tmp63_ = _tmp62_;
						_tmp64_ = _tmp63_->hint_blink_counter;
						if ((_tmp64_ % 2) == ((guint) 1)) {
							gboolean _tmp65_ = FALSE;
							Tile* _tmp66_;
							Game* _tmp67_;
							Game* _tmp68_;
							Tile* _tmp69_;
							gboolean _tmp74_;
							_tmp66_ = tile;
							_tmp67_ = game_view_get_game (self);
							_tmp68_ = _tmp67_;
							_tmp69_ = _tmp68_->hint_tiles[0];
							if (_tmp66_ == _tmp69_) {
								_tmp65_ = TRUE;
							} else {
								Tile* _tmp70_;
								Game* _tmp71_;
								Game* _tmp72_;
								Tile* _tmp73_;
								_tmp70_ = tile;
								_tmp71_ = game_view_get_game (self);
								_tmp72_ = _tmp71_;
								_tmp73_ = _tmp72_->hint_tiles[1];
								_tmp65_ = _tmp70_ == _tmp73_;
							}
							_tmp74_ = _tmp65_;
							_tmp61_ = _tmp74_;
						} else {
							_tmp61_ = FALSE;
						}
						_tmp75_ = _tmp61_;
						if (_tmp75_) {
							gint _tmp76_;
							_tmp76_ = image_height;
							texture_y = _tmp76_;
						}
					}
				}
				_tmp77_ = render_indexes;
				if (_tmp77_) {
					cairo_t* _tmp78_;
					Tile* _tmp79_;
					gint _tmp80_;
					Tile* _tmp81_;
					gint _tmp82_;
					Tile* _tmp83_;
					gint _tmp84_;
					_tmp78_ = cr;
					_tmp79_ = tile;
					_tmp80_ = _tmp79_->number;
					_tmp81_ = tile;
					_tmp82_ = _tmp81_->number;
					_tmp83_ = tile;
					_tmp84_ = _tmp83_->number;
					cairo_set_source_rgb (_tmp78_, _tmp80_ / 255.0, _tmp82_ / 255.0, _tmp84_ / 255.0);
				} else {
					cairo_matrix_t matrix = {0};
					gint _tmp85_;
					gint _tmp86_;
					gint _tmp87_;
					gint _tmp88_;
					cairo_pattern_t* _tmp89_;
					cairo_matrix_t _tmp90_;
					cairo_t* _tmp91_;
					cairo_pattern_t* _tmp92_;
					cairo_matrix_init_identity (&matrix);
					_tmp85_ = texture_x;
					_tmp86_ = x;
					_tmp87_ = texture_y;
					_tmp88_ = y;
					cairo_matrix_translate (&matrix, (gdouble) (_tmp85_ - _tmp86_), (gdouble) (_tmp87_ - _tmp88_));
					_tmp89_ = self->priv->tile_pattern;
					_tmp90_ = matrix;
					cairo_pattern_set_matrix (_tmp89_, &_tmp90_);
					_tmp91_ = cr;
					_tmp92_ = self->priv->tile_pattern;
					cairo_set_source (_tmp91_, _tmp92_);
				}
				_tmp93_ = cr;
				_tmp94_ = x;
				_tmp95_ = y;
				_tmp96_ = image_width;
				_tmp97_ = image_height;
				cairo_rectangle (_tmp93_, (gdouble) _tmp94_, (gdouble) _tmp95_, (gdouble) _tmp96_, (gdouble) _tmp97_);
				_tmp98_ = cr;
				cairo_fill (_tmp98_);
				_tile_unref0 (tile);
			}
		}
	}
	_tmp99_ = game_view_get_paused (self);
	_tmp100_ = _tmp99_;
	if (_tmp100_) {
		cairo_t* _tmp101_;
		cairo_t* _tmp102_;
		cairo_t* _tmp103_;
		cairo_t* _tmp104_;
		gint _tmp105_ = 0;
		const gchar* _tmp106_ = NULL;
		gchar* _tmp107_;
		gchar* text;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp108_;
		const gchar* _tmp109_;
		cairo_text_extents_t _tmp110_ = {0};
		cairo_t* _tmp111_;
		gint _tmp112_ = 0;
		cairo_text_extents_t _tmp113_;
		gdouble _tmp114_;
		gint _tmp115_ = 0;
		cairo_text_extents_t _tmp116_;
		gdouble _tmp117_;
		cairo_t* _tmp118_;
		cairo_t* _tmp119_;
		const gchar* _tmp120_;
		_tmp101_ = cr;
		cairo_set_source_rgba (_tmp101_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp102_ = cr;
		cairo_paint (_tmp102_);
		_tmp103_ = cr;
		cairo_select_font_face (_tmp103_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp104_ = cr;
		_tmp105_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp104_, _tmp105_ * 0.125);
		_tmp106_ = _ ("Paused");
		_tmp107_ = g_strdup (_tmp106_);
		text = _tmp107_;
		_tmp108_ = cr;
		_tmp109_ = text;
		cairo_text_extents (_tmp108_, _tmp109_, &_tmp110_);
		extents = _tmp110_;
		_tmp111_ = cr;
		_tmp112_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp113_ = extents;
		_tmp114_ = _tmp113_.width;
		_tmp115_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp116_ = extents;
		_tmp117_ = _tmp116_.height;
		cairo_move_to (_tmp111_, (_tmp112_ - _tmp114_) / 2.0, (_tmp115_ + _tmp117_) / 2.0);
		_tmp118_ = cr;
		cairo_set_source_rgb (_tmp118_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp119_ = cr;
		_tmp120_ = text;
		cairo_show_text (_tmp119_, _tmp120_);
		_g_free0 (text);
	}
}


static void game_view_update_dimensions (GameView* self) {
	gint _tmp0_ = 0;
	gint width;
	gint _tmp1_ = 0;
	gint height;
	GamesPreimage* _tmp2_;
	GamesPreimage* _tmp3_;
	GamesPreimage* _tmp4_;
	GamesPreimage* _tmp5_;
	gint _tmp6_ = 0;
	GamesPreimage* _tmp7_;
	GamesPreimage* _tmp8_;
	gint _tmp9_ = 0;
	gdouble aspect;
	Game* _tmp10_;
	Game* _tmp11_;
	Map* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	gdouble map_width;
	Game* _tmp15_;
	Game* _tmp16_;
	Map* _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	gdouble _tmp20_;
	gdouble map_height;
	gint _tmp21_;
	gdouble _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_ = 0.0;
	gdouble unit_width;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble unit_height;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	Game* _tmp33_;
	Game* _tmp34_;
	Map* _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	gdouble _tmp38_;
	gint _tmp39_;
	Game* _tmp40_;
	Game* _tmp41_;
	Map* _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	gdouble _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	height = _tmp1_;
	_tmp2_ = game_view_get_theme (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = game_view_get_theme (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = games_preimage_get_height (_tmp5_);
	_tmp7_ = game_view_get_theme (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = games_preimage_get_width (_tmp8_);
	aspect = (((gdouble) _tmp6_) / 2) / (((gdouble) _tmp9_) / 43);
	_tmp10_ = game_view_get_game (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->map;
	_tmp13_ = map_get_width (_tmp12_);
	_tmp14_ = _tmp13_;
	map_width = _tmp14_ + 2.0;
	_tmp15_ = game_view_get_game (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_->map;
	_tmp18_ = map_get_height (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = aspect;
	map_height = (_tmp19_ + 2.0) * _tmp20_;
	_tmp21_ = width;
	_tmp22_ = map_width;
	_tmp23_ = height;
	_tmp24_ = map_height;
	_tmp25_ = MIN (_tmp21_ / _tmp22_, _tmp23_ / _tmp24_);
	unit_width = _tmp25_;
	_tmp26_ = unit_width;
	_tmp27_ = aspect;
	unit_height = _tmp26_ * _tmp27_;
	_tmp28_ = unit_width;
	self->priv->tile_width = (gint) (_tmp28_ * 2);
	_tmp29_ = unit_height;
	self->priv->tile_height = (gint) (_tmp29_ * 2);
	_tmp30_ = self->priv->tile_width;
	self->priv->tile_layer_offset_x = _tmp30_ / 7;
	_tmp31_ = self->priv->tile_height;
	self->priv->tile_layer_offset_y = _tmp31_ / 10;
	_tmp32_ = width;
	_tmp33_ = game_view_get_game (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_->map;
	_tmp36_ = map_get_width (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = unit_width;
	self->priv->x_offset = ((gint) (_tmp32_ - (_tmp37_ * _tmp38_))) / 2;
	_tmp39_ = height;
	_tmp40_ = game_view_get_game (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_->map;
	_tmp43_ = map_get_height (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = unit_height;
	self->priv->y_offset = ((gint) (_tmp39_ - (_tmp44_ * _tmp45_))) / 2;
}


static void game_view_get_tile_position (GameView* self, Tile* tile, gint* x, gint* y) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _tmp0_;
	Tile* _tmp1_;
	Slot* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Tile* _tmp5_;
	Slot* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Tile* _tmp10_;
	Slot* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	Tile* _tmp14_;
	Slot* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = self->priv->x_offset;
	_tmp1_ = tile;
	_tmp2_ = _tmp1_->slot;
	_tmp3_ = _tmp2_->x;
	_tmp4_ = self->priv->tile_width;
	_tmp5_ = tile;
	_tmp6_ = _tmp5_->slot;
	_tmp7_ = _tmp6_->layer;
	_tmp8_ = self->priv->tile_layer_offset_x;
	_vala_x = (_tmp0_ + ((_tmp3_ * _tmp4_) / 2)) + (_tmp7_ * _tmp8_);
	_tmp9_ = self->priv->y_offset;
	_tmp10_ = tile;
	_tmp11_ = _tmp10_->slot;
	_tmp12_ = _tmp11_->y;
	_tmp13_ = self->priv->tile_height;
	_tmp14_ = tile;
	_tmp15_ = _tmp14_->slot;
	_tmp16_ = _tmp15_->layer;
	_tmp17_ = self->priv->tile_layer_offset_y;
	_vala_y = (_tmp9_ + ((_tmp12_ * _tmp13_) / 2)) - (_tmp16_ * _tmp17_);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}


static gint game_view_get_image_offset (GameView* self, gint number) {
	gint result = 0;
	gint _tmp0_;
	gint set;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp4_;
	gint _tmp5_;
	gint _tmp7_;
	gint _tmp9_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = number;
	set = _tmp0_ / 4;
	_tmp2_ = number;
	if (_tmp2_ < 0) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = set;
		_tmp1_ = _tmp3_ >= 36;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		result = 42;
		return result;
	}
	_tmp5_ = set;
	if (_tmp5_ == 33) {
		gint _tmp6_;
		_tmp6_ = number;
		result = 33 + (_tmp6_ % 4);
		return result;
	}
	_tmp7_ = set;
	if (_tmp7_ == 35) {
		gint _tmp8_;
		_tmp8_ = number;
		result = 38 + (_tmp8_ % 4);
		return result;
	}
	_tmp9_ = set;
	if (_tmp9_ == 34) {
		result = 37;
		return result;
	}
	result = set;
	return result;
}


static void game_view_redraw_tile_cb (GameView* self, Tile* tile) {
	gint x = 0;
	gint y = 0;
	Tile* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	game_view_update_dimensions (self);
	_tmp0_ = tile;
	game_view_get_tile_position (self, _tmp0_, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	_tmp3_ = self->priv->tile_pattern_width;
	_tmp4_ = self->priv->tile_pattern_height;
	gtk_widget_queue_draw_area ((GtkWidget*) self, x, y, _tmp3_, _tmp4_);
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_;
	Game* _tmp1_;
	cairo_t* _tmp2_;
	GdkColor _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	self = (GameView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = cr;
	_tmp3_ = self->background_color;
	gdk_cairo_set_source_color (_tmp2_, &_tmp3_);
	_tmp4_ = cr;
	cairo_paint (_tmp4_);
	_tmp5_ = cr;
	game_view_draw_game (self, _tmp5_, FALSE);
	result = TRUE;
	return result;
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	Game* _tmp2_;
	gboolean _tmp5_;
	GdkEventButton _tmp6_;
	GdkEventType _tmp7_;
	GdkEventButton _tmp8_;
	gdouble _tmp9_;
	GdkEventButton _tmp10_;
	gdouble _tmp11_;
	Tile* _tmp12_ = NULL;
	Tile* tile;
	gboolean _tmp13_ = FALSE;
	Tile* _tmp14_;
	gboolean _tmp19_;
	GdkEventButton _tmp20_;
	guint _tmp21_;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = game_view_get_paused (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = *event;
	_tmp7_ = _tmp6_.type;
	if (_tmp7_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp8_ = *event;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = *event;
	_tmp11_ = _tmp10_.y;
	_tmp12_ = game_view_find_tile (self, (guint) _tmp9_, (guint) _tmp11_);
	tile = _tmp12_;
	_tmp14_ = tile;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		Game* _tmp15_;
		Game* _tmp16_;
		Tile* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp15_ = game_view_get_game (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = tile;
		_tmp18_ = game_tile_can_move (_tmp16_, _tmp17_);
		_tmp13_ = !_tmp18_;
	}
	_tmp19_ = _tmp13_;
	if (_tmp19_) {
		result = TRUE;
		_tile_unref0 (tile);
		return result;
	}
	_tmp20_ = *event;
	_tmp21_ = _tmp20_.button;
	if (_tmp21_ == ((guint) 1)) {
		Game* _tmp22_;
		Game* _tmp23_;
		Tile* _tmp24_;
		Tile* _tmp25_;
		Tile* _tmp29_;
		Game* _tmp30_;
		Game* _tmp31_;
		Tile* _tmp32_;
		Tile* _tmp33_;
		Game* _tmp36_;
		Game* _tmp37_;
		Tile* _tmp38_;
		Tile* _tmp39_;
		Tile* _tmp40_;
		gboolean _tmp41_ = FALSE;
		_tmp22_ = game_view_get_game (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = game_get_selected_tile (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == NULL) {
			Game* _tmp26_;
			Game* _tmp27_;
			Tile* _tmp28_;
			_tmp26_ = game_view_get_game (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = tile;
			game_set_selected_tile (_tmp27_, _tmp28_);
			result = TRUE;
			_tile_unref0 (tile);
			return result;
		}
		_tmp29_ = tile;
		_tmp30_ = game_view_get_game (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = game_get_selected_tile (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp29_ == _tmp33_) {
			Game* _tmp34_;
			Game* _tmp35_;
			_tmp34_ = game_view_get_game (self);
			_tmp35_ = _tmp34_;
			game_set_selected_tile (_tmp35_, NULL);
			result = TRUE;
			_tile_unref0 (tile);
			return result;
		}
		_tmp36_ = game_view_get_game (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = game_get_selected_tile (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = tile;
		_tmp41_ = tile_matches (_tmp39_, _tmp40_);
		if (_tmp41_) {
			Game* _tmp42_;
			Game* _tmp43_;
			Game* _tmp44_;
			Game* _tmp45_;
			Tile* _tmp46_;
			Tile* _tmp47_;
			Tile* _tmp48_;
			_tmp42_ = game_view_get_game (self);
			_tmp43_ = _tmp42_;
			_tmp44_ = game_view_get_game (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = game_get_selected_tile (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = tile;
			game_remove_pair (_tmp43_, _tmp47_, _tmp48_);
			result = TRUE;
			_tile_unref0 (tile);
			return result;
		}
	}
	result = FALSE;
	_tile_unref0 (tile);
	return result;
}


static Tile* game_view_find_tile (GameView* self, guint x, guint y) {
	Tile* result = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* surface;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* cr;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	cairo_t* _tmp8_;
	cairo_surface_t* _tmp9_;
	guchar* _tmp10_ = NULL;
	guchar* data;
	gint data_length1;
	gint _data_size_;
	guchar* _tmp11_;
	gint _tmp11__length1;
	guchar _tmp12_;
	guchar number;
	Game* _tmp13_;
	Game* _tmp14_;
	GList* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, 1, 1);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = cr;
	cairo_set_source_rgba (_tmp3_, (gdouble) 255, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp4_ = cr;
	cairo_paint (_tmp4_);
	_tmp5_ = cr;
	_tmp6_ = x;
	_tmp7_ = y;
	cairo_translate (_tmp5_, (gdouble) (-_tmp6_), (gdouble) (-_tmp7_));
	_tmp8_ = cr;
	game_view_draw_game (self, _tmp8_, TRUE);
	_tmp9_ = surface;
	_tmp10_ = cairo_image_surface_get_data (_tmp9_);
	data = _tmp10_;
	data_length1 = -1;
	_data_size_ = data_length1;
	_tmp11_ = data;
	_tmp11__length1 = data_length1;
	_tmp12_ = _tmp11_[0];
	number = _tmp12_;
	_tmp13_ = game_view_get_game (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp15_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp16_;
			Tile* tile = NULL;
			_tmp16_ = _tile_ref0 ((Tile*) tile_it->data);
			tile = _tmp16_;
			{
				Tile* _tmp17_;
				gint _tmp18_;
				guchar _tmp19_;
				_tmp17_ = tile;
				_tmp18_ = _tmp17_->number;
				_tmp19_ = number;
				if (_tmp18_ == ((gint) _tmp19_)) {
					result = tile;
					_cairo_destroy0 (cr);
					_cairo_surface_destroy0 (surface);
					return result;
				}
				_tile_unref0 (tile);
			}
		}
	}
	result = NULL;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	return result;
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static gpointer _game_ref0 (gpointer self) {
	return self ? game_ref (self) : NULL;
}


static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender, Tile* tile, gpointer self) {
	game_view_redraw_tile_cb (self, tile);
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _game_ref0 (_tmp0_);
	_game_unref0 (self->priv->_game);
	self->priv->_game = _tmp1_;
	_tmp2_ = self->priv->_game;
	g_signal_connect_object (_tmp2_, "redraw-tile", (GCallback) _game_view_redraw_tile_cb_game_redraw_tile, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "game");
}


GamesPreimage* game_view_get_theme (GameView* self) {
	GamesPreimage* result;
	GamesPreimage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void game_view_set_theme (GameView* self, GamesPreimage* value) {
	GamesPreimage* _tmp0_;
	GamesPreimage* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
	self->priv->tile_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "theme");
}


gboolean game_view_get_paused (GameView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void game_view_set_paused (GameView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paused = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "paused");
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	GTK_WIDGET_CLASS (klass)->draw = game_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = game_view_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, param_spec_game ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_object ("theme", "theme", "theme", GAMES_TYPE_PREIMAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->tile_pattern = NULL;
	self->priv->tile_pattern_width = 0;
	self->priv->tile_pattern_height = 0;
	self->priv->_theme = NULL;
	self->priv->_paused = FALSE;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = GAME_VIEW (obj);
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
	_game_unref0 (self->priv->_game);
	_g_object_unref0 (self->priv->_theme);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = GAME_VIEW (object);
	switch (property_id) {
		case GAME_VIEW_GAME:
		value_set_game (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME:
		g_value_set_object (value, game_view_get_theme (self));
		break;
		case GAME_VIEW_PAUSED:
		g_value_set_boolean (value, game_view_get_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = GAME_VIEW (object);
	switch (property_id) {
		case GAME_VIEW_GAME:
		game_view_set_game (self, value_get_game (value));
		break;
		case GAME_VIEW_THEME:
		game_view_set_theme (self, g_value_get_object (value));
		break;
		case GAME_VIEW_PAUSED:
		game_view_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



