/* game-view.c generated by valac 0.16.0, the Vala compiler
 * generated from game-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_TEXT_OVERLAY (text_overlay_get_type ())
#define TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_OVERLAY, TextOverlay))
#define TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_OVERLAY, TextOverlayClass))
#define IS_TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_OVERLAY))
#define IS_TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_OVERLAY))
#define TEXT_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_OVERLAY, TextOverlayClass))

typedef struct _TextOverlay TextOverlay;
typedef struct _TextOverlayClass TextOverlayClass;

#define TYPE_BLOCK_TEXTURE (block_texture_get_type ())
#define BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_TEXTURE, BlockTexture))
#define BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_TEXTURE, BlockTextureClass))
#define IS_BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_TEXTURE))
#define IS_BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_TEXTURE))
#define BLOCK_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_TEXTURE, BlockTextureClass))

typedef struct _BlockTexture BlockTexture;
typedef struct _BlockTextureClass BlockTextureClass;

#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;

#define TYPE_BLOCK_ACTOR (block_actor_get_type ())
#define BLOCK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_ACTOR, BlockActor))
#define BLOCK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_ACTOR, BlockActorClass))
#define IS_BLOCK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_ACTOR))
#define IS_BLOCK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_ACTOR))
#define BLOCK_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_ACTOR, BlockActorClass))

typedef struct _BlockActor BlockActor;
typedef struct _BlockActorClass BlockActorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamePrivate GamePrivate;

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
typedef struct _BlockPrivate BlockPrivate;
#define _block_unref0(var) ((var == NULL) ? NULL : (var = (block_unref (var), NULL)))
typedef struct _BlockActorPrivate BlockActorPrivate;
typedef struct _TextOverlayPrivate TextOverlayPrivate;
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
typedef struct _BlockTexturePrivate BlockTexturePrivate;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _GameView {
	GtkClutterEmbed parent_instance;
	GameViewPrivate * priv;
	gboolean mute;
};

struct _GameViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _GameViewPrivate {
	Game* _game;
	ClutterGroup* playing_field;
	ClutterGroup* shape;
	ClutterClone* shape_shadow;
	gboolean _show_shadow;
	TextOverlay* text_overlay;
	BlockTexture** block_textures;
	gint block_textures_length1;
	gint _block_textures_size_;
	GHashTable* blocks;
	GHashTable* shape_blocks;
	gint n_lines_destroyed;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Shape {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GTypeClass parent_class;
	void (*finalize) (Shape *self);
};

struct _Block {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GTypeClass parent_class;
	void (*finalize) (Block *self);
};

struct _BlockActor {
	ClutterClone parent_instance;
	BlockActorPrivate * priv;
	Block* block;
};

struct _BlockActorClass {
	ClutterCloneClass parent_class;
};

struct _TextOverlay {
	ClutterCairoTexture parent_instance;
	TextOverlayPrivate * priv;
};

struct _TextOverlayClass {
	ClutterCairoTextureClass parent_class;
};

struct _TextOverlayPrivate {
	gchar* _text;
};

struct _BlockTexture {
	ClutterCairoTexture parent_instance;
	BlockTexturePrivate * priv;
};

struct _BlockTextureClass {
	ClutterCairoTextureClass parent_class;
};

struct _BlockTexturePrivate {
	gint color;
	gchar* _theme;
};


static gpointer game_view_parent_class = NULL;
static gpointer block_actor_parent_class = NULL;
static gpointer text_overlay_parent_class = NULL;
static gpointer block_texture_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
GType text_overlay_get_type (void) G_GNUC_CONST;
GType block_texture_get_type (void) G_GNUC_CONST;
gpointer block_ref (gpointer instance);
void block_unref (gpointer instance);
GParamSpec* param_spec_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_block (GValue* value, gpointer v_object);
void value_take_block (GValue* value, gpointer v_object);
gpointer value_get_block (const GValue* value);
GType block_get_type (void) G_GNUC_CONST;
GType block_actor_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME,
	GAME_VIEW_SHOW_SHADOW
};
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void _block_unref0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void game_view_size_allocate_cb (GameView* self, GtkWidget* widget, GtkAllocation* allocation);
static void _game_view_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
TextOverlay* text_overlay_new (void);
TextOverlay* text_overlay_construct (GType object_type);
#define NCOLORS 7
BlockTexture* block_texture_new (gint color);
BlockTexture* block_texture_construct (GType object_type, gint color);
static void game_view_play_sound (GameView* self, const gchar* name);
static void game_view_shape_added_cb (GameView* self);
Game* game_view_get_game (GameView* self);
gpointer shape_ref (gpointer instance);
void shape_unref (gpointer instance);
GParamSpec* param_spec_shape (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_shape (GValue* value, gpointer v_object);
void value_take_shape (GValue* value, gpointer v_object);
gpointer value_get_shape (const GValue* value);
GType shape_get_type (void) G_GNUC_CONST;
static gint game_view_get_cell_size (GameView* self);
static void game_view_update_shadow (GameView* self);
BlockActor* block_actor_new (Block* block, ClutterActor* texture);
BlockActor* block_actor_construct (GType object_type, Block* block, ClutterActor* texture);
static void game_view_shape_moved_cb (GameView* self);
gint game_get_shadow_y (Game* self);
gboolean game_view_get_show_shadow (GameView* self);
static void game_view_shape_dropped_cb (GameView* self);
static void game_view_shape_rotated_cb (GameView* self);
static void game_view_shape_landed_cb (GameView* self, gint* lines, int lines_length1, GList* line_blocks);
void block_actor_explode (BlockActor* self);
static void game_view_fall_completed_cb (GameView* self, ClutterTimeline* timeline);
static void _game_view_fall_completed_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
gint game_get_width (Game* self);
gint game_get_height (Game* self);
static void game_view_pause_changed_cb (GameView* self);
static void game_view_update_message (GameView* self);
static void game_view_game_complete_cb (GameView* self);
gboolean game_get_paused (Game* self);
void text_overlay_set_text (TextOverlay* self, const gchar* value);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_shape_added_cb_game_shape_added (Game* _sender, gpointer self);
static void _game_view_shape_moved_cb_game_shape_moved (Game* _sender, gpointer self);
static void _game_view_shape_dropped_cb_game_shape_dropped (Game* _sender, gpointer self);
static void _game_view_shape_rotated_cb_game_shape_rotated (Game* _sender, gpointer self);
static void _game_view_shape_landed_cb_game_shape_landed (Game* _sender, gint* lines, int lines_length1, GList* line_blocks, gpointer self);
static void _game_view_pause_changed_cb_game_pause_changed (Game* _sender, gpointer self);
static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
void block_texture_set_theme (BlockTexture* self, const gchar* value);
void game_view_set_show_shadow (GameView* self, gboolean value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	BLOCK_ACTOR_DUMMY_PROPERTY
};
static void block_actor_explode_complete_cb (BlockActor* self);
static void _block_actor_explode_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void block_actor_finalize (GObject* obj);
#define TEXT_OVERLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEXT_OVERLAY, TextOverlayPrivate))
enum  {
	TEXT_OVERLAY_DUMMY_PROPERTY,
	TEXT_OVERLAY_TEXT
};
static gboolean text_overlay_real_draw (ClutterCairoTexture* base, cairo_t* cr);
const gchar* text_overlay_get_text (TextOverlay* self);
static void text_overlay_finalize (GObject* obj);
static void _vala_text_overlay_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_text_overlay_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define BLOCK_TEXTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BLOCK_TEXTURE, BlockTexturePrivate))
enum  {
	BLOCK_TEXTURE_DUMMY_PROPERTY,
	BLOCK_TEXTURE_THEME
};
static gboolean block_texture_real_draw (ClutterCairoTexture* base, cairo_t* cr);
const gchar* block_texture_get_theme (BlockTexture* self);
static void block_texture_draw_clean (BlockTexture* self, cairo_t* cr);
static void block_texture_draw_tango (BlockTexture* self, cairo_t* cr, gboolean use_gradients);
static void block_texture_draw_plain (BlockTexture* self, cairo_t* cr);
static void block_texture_draw_rounded_rectangle (BlockTexture* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, gdouble r);
static void block_texture_finalize (GObject* obj);
static void _vala_block_texture_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_block_texture_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _block_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (block_unref (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _game_view_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	game_view_size_allocate_cb (self, _sender, allocation);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	ClutterActor* _tmp6_ = NULL;
	ClutterStage* _tmp7_;
	ClutterStage* stage;
	ClutterColor _tmp8_ = {0};
	ClutterColor stage_color;
	ClutterStage* _tmp9_;
	ClutterColor _tmp10_;
	ClutterGroup* _tmp11_;
	ClutterGroup* _tmp12_;
	ClutterStage* _tmp13_;
	ClutterGroup* _tmp14_;
	TextOverlay* _tmp15_;
	TextOverlay* _tmp16_;
	TextOverlay* _tmp17_;
	ClutterStage* _tmp18_;
	TextOverlay* _tmp19_;
	BlockTexture** _tmp20_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _block_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->blocks);
	self->priv->blocks = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _block_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->shape_blocks);
	self->priv->shape_blocks = _tmp5_;
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _game_view_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp6_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
	_tmp7_ = _g_object_ref0 (CLUTTER_STAGE (_tmp6_));
	stage = _tmp7_;
	_tmp8_.red = (guint8) 0x0;
	_tmp8_.green = (guint8) 0x0;
	_tmp8_.blue = (guint8) 0x0;
	_tmp8_.alpha = (guint8) 0xff;
	stage_color = _tmp8_;
	_tmp9_ = stage;
	_tmp10_ = stage_color;
	clutter_stage_set_color (_tmp9_, &_tmp10_);
	_tmp11_ = (ClutterGroup*) clutter_group_new ();
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->playing_field);
	self->priv->playing_field = _tmp12_;
	_tmp13_ = stage;
	_tmp14_ = self->priv->playing_field;
	clutter_container_add_actor ((ClutterContainer*) _tmp13_, (ClutterActor*) _tmp14_);
	_tmp15_ = text_overlay_new ();
	_tmp16_ = g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->text_overlay);
	self->priv->text_overlay = _tmp16_;
	_tmp17_ = self->priv->text_overlay;
	clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) _tmp17_, (guint) 1, (guint) 1);
	_tmp18_ = stage;
	_tmp19_ = self->priv->text_overlay;
	clutter_container_add ((ClutterContainer*) _tmp18_, (ClutterActor*) _tmp19_, NULL);
	_tmp20_ = g_new0 (BlockTexture*, NCOLORS + 1);
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->block_textures = _tmp20_;
	self->priv->block_textures_length1 = NCOLORS;
	self->priv->_block_textures_size_ = self->priv->block_textures_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_;
				gint _tmp24_;
				BlockTexture** _tmp25_;
				gint _tmp25__length1;
				BlockTexture** _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gint _tmp28_;
				BlockTexture* _tmp29_;
				BlockTexture* _tmp30_;
				BlockTexture* _tmp31_;
				BlockTexture** _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_;
				BlockTexture* _tmp34_;
				BlockTexture** _tmp35_;
				gint _tmp35__length1;
				gint _tmp36_;
				BlockTexture* _tmp37_;
				ClutterStage* _tmp38_;
				BlockTexture** _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_;
				BlockTexture* _tmp41_;
				_tmp22_ = _tmp21_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = self->priv->block_textures;
				_tmp25__length1 = self->priv->block_textures_length1;
				if (!(_tmp24_ < _tmp25__length1)) {
					break;
				}
				_tmp26_ = self->priv->block_textures;
				_tmp26__length1 = self->priv->block_textures_length1;
				_tmp27_ = i;
				_tmp28_ = i;
				_tmp29_ = block_texture_new (_tmp28_);
				_tmp30_ = g_object_ref_sink (_tmp29_);
				_g_object_unref0 (_tmp26_[_tmp27_]);
				_tmp26_[_tmp27_] = _tmp30_;
				_tmp31_ = _tmp26_[_tmp27_];
				_tmp32_ = self->priv->block_textures;
				_tmp32__length1 = self->priv->block_textures_length1;
				_tmp33_ = i;
				_tmp34_ = _tmp32_[_tmp33_];
				clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) _tmp34_, (guint) 1, (guint) 1);
				_tmp35_ = self->priv->block_textures;
				_tmp35__length1 = self->priv->block_textures_length1;
				_tmp36_ = i;
				_tmp37_ = _tmp35_[_tmp36_];
				clutter_actor_hide ((ClutterActor*) _tmp37_);
				_tmp38_ = stage;
				_tmp39_ = self->priv->block_textures;
				_tmp39__length1 = self->priv->block_textures_length1;
				_tmp40_ = i;
				_tmp41_ = _tmp39_[_tmp40_];
				clutter_container_add_actor ((ClutterContainer*) _tmp38_, (ClutterActor*) _tmp41_);
			}
		}
	}
	_g_object_unref0 (stage);
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


static void game_view_play_sound (GameView* self, const gchar* name) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->mute;
	if (!_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp1_ = name;
		_tmp2_ = name;
		_tmp3_ = g_strdup_printf ("%s.ogg", _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_build_filename (SOUND_DIRECTORY, _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		ca_gtk_play_for_widget ((GtkWidget*) self, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp1_, CA_PROP_MEDIA_FILENAME, _tmp6_, NULL);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	}
}


static gpointer _block_ref0 (gpointer self) {
	return self ? block_ref (self) : NULL;
}


static void game_view_shape_added_cb (GameView* self) {
	ClutterGroup* _tmp0_;
	ClutterGroup* _tmp1_;
	ClutterGroup* _tmp2_;
	ClutterGroup* _tmp3_;
	ClutterGroup* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	Shape* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	Game* _tmp11_;
	Game* _tmp12_;
	Shape* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	Game* _tmp17_;
	Game* _tmp18_;
	Shape* _tmp19_;
	GList* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (ClutterGroup*) clutter_group_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->shape);
	self->priv->shape = _tmp1_;
	_tmp2_ = self->priv->playing_field;
	_tmp3_ = self->priv->shape;
	clutter_container_add ((ClutterContainer*) _tmp2_, (ClutterActor*) _tmp3_, NULL);
	_tmp4_ = self->priv->shape;
	_tmp5_ = game_view_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->shape;
	_tmp8_ = _tmp7_->x;
	_tmp9_ = game_view_get_cell_size (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = game_view_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_->shape;
	_tmp14_ = _tmp13_->y;
	_tmp15_ = game_view_get_cell_size (self);
	_tmp16_ = _tmp15_;
	clutter_actor_set_position ((ClutterActor*) _tmp4_, (gfloat) (_tmp8_ * _tmp10_), (gfloat) (_tmp14_ * _tmp16_));
	game_view_update_shadow (self);
	_tmp17_ = game_view_get_game (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_->shape;
	_tmp20_ = _tmp19_->blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp20_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp21_;
			Block* block = NULL;
			_tmp21_ = _block_ref0 ((Block*) block_it->data);
			block = _tmp21_;
			{
				Block* _tmp22_;
				BlockTexture** _tmp23_;
				gint _tmp23__length1;
				Block* _tmp24_;
				gint _tmp25_;
				BlockTexture* _tmp26_;
				BlockActor* _tmp27_;
				BlockActor* _tmp28_;
				BlockActor* actor;
				GHashTable* _tmp29_;
				Block* _tmp30_;
				Block* _tmp31_;
				BlockActor* _tmp32_;
				BlockActor* _tmp33_;
				ClutterGroup* _tmp34_;
				BlockActor* _tmp35_;
				BlockActor* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				BlockActor* _tmp41_;
				Block* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				Block* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				_tmp22_ = block;
				_tmp23_ = self->priv->block_textures;
				_tmp23__length1 = self->priv->block_textures_length1;
				_tmp24_ = block;
				_tmp25_ = _tmp24_->color;
				_tmp26_ = _tmp23_[_tmp25_];
				_tmp27_ = block_actor_new (_tmp22_, (ClutterActor*) _tmp26_);
				_tmp28_ = g_object_ref_sink (_tmp27_);
				actor = _tmp28_;
				_tmp29_ = self->priv->shape_blocks;
				_tmp30_ = block;
				_tmp31_ = _block_ref0 (_tmp30_);
				_tmp32_ = actor;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				g_hash_table_insert (_tmp29_, _tmp31_, _tmp33_);
				_tmp34_ = self->priv->shape;
				_tmp35_ = actor;
				clutter_container_add ((ClutterContainer*) _tmp34_, (ClutterActor*) _tmp35_, NULL);
				_tmp36_ = actor;
				_tmp37_ = game_view_get_cell_size (self);
				_tmp38_ = _tmp37_;
				_tmp39_ = game_view_get_cell_size (self);
				_tmp40_ = _tmp39_;
				clutter_actor_set_size ((ClutterActor*) _tmp36_, (gfloat) _tmp38_, (gfloat) _tmp40_);
				_tmp41_ = actor;
				_tmp42_ = block;
				_tmp43_ = _tmp42_->x;
				_tmp44_ = game_view_get_cell_size (self);
				_tmp45_ = _tmp44_;
				_tmp46_ = block;
				_tmp47_ = _tmp46_->y;
				_tmp48_ = game_view_get_cell_size (self);
				_tmp49_ = _tmp48_;
				clutter_actor_set_position ((ClutterActor*) _tmp41_, (gfloat) (_tmp43_ * _tmp45_), (gfloat) (_tmp47_ * _tmp49_));
				_g_object_unref0 (actor);
				_block_unref0 (block);
			}
		}
	}
}


static void game_view_shape_moved_cb (GameView* self) {
	ClutterGroup* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	Shape* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ClutterClone* _tmp7_;
	g_return_if_fail (self != NULL);
	game_view_play_sound (self, "slide");
	_tmp0_ = self->priv->shape;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->shape;
	_tmp4_ = _tmp3_->x;
	_tmp5_ = game_view_get_cell_size (self);
	_tmp6_ = _tmp5_;
	clutter_actor_animate ((ClutterActor*) _tmp0_, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 30, "x", ((gfloat) _tmp4_) * _tmp6_, NULL);
	_tmp7_ = self->priv->shape_shadow;
	if (_tmp7_ != NULL) {
		ClutterClone* _tmp8_;
		Game* _tmp9_;
		Game* _tmp10_;
		Shape* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		Game* _tmp15_;
		Game* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp8_ = self->priv->shape_shadow;
		_tmp9_ = game_view_get_game (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->shape;
		_tmp12_ = _tmp11_->x;
		_tmp13_ = game_view_get_cell_size (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = game_view_get_game (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = game_get_shadow_y (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = game_view_get_cell_size (self);
		_tmp20_ = _tmp19_;
		clutter_actor_set_position ((ClutterActor*) _tmp8_, (gfloat) (_tmp12_ * _tmp14_), (gfloat) (_tmp18_ * _tmp20_));
	}
}


static void game_view_update_shadow (GameView* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	Game* _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp2_ = game_view_get_game (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		Game* _tmp4_;
		Game* _tmp5_;
		Shape* _tmp6_;
		_tmp4_ = game_view_get_game (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->shape;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = game_view_get_show_shadow (self);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		ClutterClone* _tmp11_;
		ClutterClone* _tmp18_;
		Game* _tmp19_;
		Game* _tmp20_;
		Shape* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		Game* _tmp25_;
		Game* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp11_ = self->priv->shape_shadow;
		if (_tmp11_ == NULL) {
			ClutterGroup* _tmp12_;
			ClutterClone* _tmp13_;
			ClutterClone* _tmp14_;
			ClutterClone* _tmp15_;
			ClutterGroup* _tmp16_;
			ClutterClone* _tmp17_;
			_tmp12_ = self->priv->shape;
			_tmp13_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp12_);
			_tmp14_ = g_object_ref_sink (_tmp13_);
			_g_object_unref0 (self->priv->shape_shadow);
			self->priv->shape_shadow = _tmp14_;
			_tmp15_ = self->priv->shape_shadow;
			clutter_actor_set_opacity ((ClutterActor*) _tmp15_, (guint8) 32);
			_tmp16_ = self->priv->playing_field;
			_tmp17_ = self->priv->shape_shadow;
			clutter_container_add ((ClutterContainer*) _tmp16_, (ClutterActor*) _tmp17_, NULL);
		}
		_tmp18_ = self->priv->shape_shadow;
		_tmp19_ = game_view_get_game (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_->shape;
		_tmp22_ = _tmp21_->x;
		_tmp23_ = game_view_get_cell_size (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = game_view_get_game (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = game_get_shadow_y (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = game_view_get_cell_size (self);
		_tmp30_ = _tmp29_;
		clutter_actor_set_position ((ClutterActor*) _tmp18_, (gfloat) (_tmp22_ * _tmp24_), (gfloat) (_tmp28_ * _tmp30_));
	} else {
		ClutterClone* _tmp31_;
		_tmp31_ = self->priv->shape_shadow;
		if (_tmp31_ != NULL) {
			ClutterClone* _tmp32_;
			_tmp32_ = self->priv->shape_shadow;
			clutter_actor_destroy ((ClutterActor*) _tmp32_);
		}
		_g_object_unref0 (self->priv->shape_shadow);
		self->priv->shape_shadow = NULL;
	}
}


static void game_view_shape_dropped_cb (GameView* self) {
	ClutterGroup* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	Shape* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shape;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->shape;
	_tmp4_ = _tmp3_->y;
	_tmp5_ = game_view_get_cell_size (self);
	_tmp6_ = _tmp5_;
	clutter_actor_animate ((ClutterActor*) _tmp0_, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 60, "y", ((gfloat) _tmp4_) * _tmp6_, NULL);
	game_view_update_shadow (self);
}


static void game_view_shape_rotated_cb (GameView* self) {
	Game* _tmp0_;
	Game* _tmp1_;
	Shape* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	game_view_play_sound (self, "turn");
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->shape;
	_tmp3_ = _tmp2_->blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp3_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp4_;
			Block* block = NULL;
			_tmp4_ = _block_ref0 ((Block*) block_it->data);
			block = _tmp4_;
			{
				GHashTable* _tmp5_;
				Block* _tmp6_;
				gconstpointer _tmp7_ = NULL;
				BlockActor* _tmp8_;
				BlockActor* actor;
				BlockActor* _tmp9_;
				Block* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				Block* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp5_ = self->priv->shape_blocks;
				_tmp6_ = block;
				_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
				_tmp8_ = _g_object_ref0 ((BlockActor*) _tmp7_);
				actor = _tmp8_;
				_tmp9_ = actor;
				_tmp10_ = block;
				_tmp11_ = _tmp10_->x;
				_tmp12_ = game_view_get_cell_size (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = block;
				_tmp15_ = _tmp14_->y;
				_tmp16_ = game_view_get_cell_size (self);
				_tmp17_ = _tmp16_;
				clutter_actor_set_position ((ClutterActor*) _tmp9_, (gfloat) (_tmp11_ * _tmp13_), (gfloat) (_tmp15_ * _tmp17_));
				_g_object_unref0 (actor);
				_block_unref0 (block);
			}
		}
	}
	game_view_update_shadow (self);
}


static void _game_view_fall_completed_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	game_view_fall_completed_cb (self, _sender);
}


static void game_view_shape_landed_cb (GameView* self, gint* lines, int lines_length1, GList* line_blocks) {
	gint* _tmp0_;
	gint _tmp0__length1;
	ClutterGroup* _tmp1_;
	ClutterClone* _tmp2_;
	GHashTable* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	Shape* _tmp7_;
	GList* _tmp8_;
	GList* _tmp38_;
	gint* _tmp47_;
	gint _tmp47__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = lines;
	_tmp0__length1 = lines_length1;
	switch (_tmp0__length1) {
		default:
		{
			game_view_play_sound (self, "land");
			break;
		}
		case 1:
		{
			game_view_play_sound (self, "lines1");
			break;
		}
		case 2:
		{
			game_view_play_sound (self, "lines2");
			break;
		}
		case 3:
		case 4:
		{
			game_view_play_sound (self, "lines3");
			break;
		}
	}
	_tmp1_ = self->priv->shape;
	clutter_actor_destroy ((ClutterActor*) _tmp1_);
	_g_object_unref0 (self->priv->shape);
	self->priv->shape = NULL;
	_tmp2_ = self->priv->shape_shadow;
	if (_tmp2_ != NULL) {
		ClutterClone* _tmp3_;
		_tmp3_ = self->priv->shape_shadow;
		clutter_actor_destroy ((ClutterActor*) _tmp3_);
	}
	_g_object_unref0 (self->priv->shape_shadow);
	self->priv->shape_shadow = NULL;
	_tmp4_ = self->priv->shape_blocks;
	g_hash_table_remove_all (_tmp4_);
	_tmp5_ = game_view_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->shape;
	_tmp8_ = _tmp7_->blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp8_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp9_;
			Block* block = NULL;
			_tmp9_ = _block_ref0 ((Block*) block_it->data);
			block = _tmp9_;
			{
				Block* _tmp10_;
				BlockTexture** _tmp11_;
				gint _tmp11__length1;
				Block* _tmp12_;
				gint _tmp13_;
				BlockTexture* _tmp14_;
				BlockActor* _tmp15_;
				BlockActor* _tmp16_;
				BlockActor* actor;
				ClutterGroup* _tmp17_;
				BlockActor* _tmp18_;
				GHashTable* _tmp19_;
				Block* _tmp20_;
				Block* _tmp21_;
				BlockActor* _tmp22_;
				BlockActor* _tmp23_;
				BlockActor* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				BlockActor* _tmp29_;
				Block* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				Block* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				_tmp10_ = block;
				_tmp11_ = self->priv->block_textures;
				_tmp11__length1 = self->priv->block_textures_length1;
				_tmp12_ = block;
				_tmp13_ = _tmp12_->color;
				_tmp14_ = _tmp11_[_tmp13_];
				_tmp15_ = block_actor_new (_tmp10_, (ClutterActor*) _tmp14_);
				_tmp16_ = g_object_ref_sink (_tmp15_);
				actor = _tmp16_;
				_tmp17_ = self->priv->playing_field;
				_tmp18_ = actor;
				clutter_container_add ((ClutterContainer*) _tmp17_, (ClutterActor*) _tmp18_, NULL);
				_tmp19_ = self->priv->blocks;
				_tmp20_ = block;
				_tmp21_ = _block_ref0 (_tmp20_);
				_tmp22_ = actor;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				g_hash_table_insert (_tmp19_, _tmp21_, _tmp23_);
				_tmp24_ = actor;
				_tmp25_ = game_view_get_cell_size (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = game_view_get_cell_size (self);
				_tmp28_ = _tmp27_;
				clutter_actor_set_size ((ClutterActor*) _tmp24_, (gfloat) _tmp26_, (gfloat) _tmp28_);
				_tmp29_ = actor;
				_tmp30_ = block;
				_tmp31_ = _tmp30_->x;
				_tmp32_ = game_view_get_cell_size (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = block;
				_tmp35_ = _tmp34_->y;
				_tmp36_ = game_view_get_cell_size (self);
				_tmp37_ = _tmp36_;
				clutter_actor_set_position ((ClutterActor*) _tmp29_, (gfloat) (_tmp31_ * _tmp33_), (gfloat) (_tmp35_ * _tmp37_));
				_g_object_unref0 (actor);
				_block_unref0 (block);
			}
		}
	}
	_tmp38_ = line_blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp38_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp39_;
			Block* block = NULL;
			_tmp39_ = _block_ref0 ((Block*) block_it->data);
			block = _tmp39_;
			{
				GHashTable* _tmp40_;
				Block* _tmp41_;
				gconstpointer _tmp42_ = NULL;
				BlockActor* _tmp43_;
				BlockActor* actor;
				BlockActor* _tmp44_;
				GHashTable* _tmp45_;
				Block* _tmp46_;
				_tmp40_ = self->priv->blocks;
				_tmp41_ = block;
				_tmp42_ = g_hash_table_lookup (_tmp40_, _tmp41_);
				_tmp43_ = _g_object_ref0 ((BlockActor*) _tmp42_);
				actor = _tmp43_;
				_tmp44_ = actor;
				block_actor_explode (_tmp44_);
				_tmp45_ = self->priv->blocks;
				_tmp46_ = block;
				g_hash_table_remove (_tmp45_, _tmp46_);
				_g_object_unref0 (actor);
				_block_unref0 (block);
			}
		}
	}
	_tmp47_ = lines;
	_tmp47__length1 = lines_length1;
	if (_tmp47__length1 > 0) {
		ClutterTimeline* _tmp48_;
		ClutterTimeline* timeline;
		gint* _tmp49_;
		gint _tmp49__length1;
		ClutterTimeline* _tmp50_;
		_tmp48_ = clutter_timeline_new ((guint) 60);
		timeline = _tmp48_;
		_tmp49_ = lines;
		_tmp49__length1 = lines_length1;
		self->priv->n_lines_destroyed = _tmp49__length1;
		_tmp50_ = timeline;
		g_signal_connect_object (_tmp50_, "completed", (GCallback) _game_view_fall_completed_cb_clutter_timeline_completed, self, 0);
		{
			gint x;
			x = 0;
			{
				gboolean _tmp51_;
				_tmp51_ = TRUE;
				while (TRUE) {
					gboolean _tmp52_;
					gint _tmp54_;
					Game* _tmp55_;
					Game* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					_tmp52_ = _tmp51_;
					if (!_tmp52_) {
						gint _tmp53_;
						_tmp53_ = x;
						x = _tmp53_ + 1;
					}
					_tmp51_ = FALSE;
					_tmp54_ = x;
					_tmp55_ = game_view_get_game (self);
					_tmp56_ = _tmp55_;
					_tmp57_ = game_get_width (_tmp56_);
					_tmp58_ = _tmp57_;
					if (!(_tmp54_ < _tmp58_)) {
						break;
					}
					{
						gint y;
						y = 0;
						{
							gboolean _tmp59_;
							_tmp59_ = TRUE;
							while (TRUE) {
								gboolean _tmp60_;
								gint _tmp62_;
								Game* _tmp63_;
								Game* _tmp64_;
								gint _tmp65_;
								gint _tmp66_;
								Game* _tmp67_;
								Game* _tmp68_;
								Block** _tmp69_;
								gint _tmp69__length1;
								gint _tmp69__length2;
								gint _tmp70_;
								gint _tmp71_;
								Block* _tmp72_;
								Block* _tmp73_;
								Block* block;
								Block* _tmp74_;
								GHashTable* _tmp75_;
								Block* _tmp76_;
								gconstpointer _tmp77_ = NULL;
								BlockActor* _tmp78_;
								BlockActor* actor;
								BlockActor* _tmp79_;
								ClutterTimeline* _tmp80_;
								Block* _tmp81_;
								gint _tmp82_;
								gint _tmp83_;
								gint _tmp84_;
								Block* _tmp85_;
								gint _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								_tmp60_ = _tmp59_;
								if (!_tmp60_) {
									gint _tmp61_;
									_tmp61_ = y;
									y = _tmp61_ + 1;
								}
								_tmp59_ = FALSE;
								_tmp62_ = y;
								_tmp63_ = game_view_get_game (self);
								_tmp64_ = _tmp63_;
								_tmp65_ = game_get_height (_tmp64_);
								_tmp66_ = _tmp65_;
								if (!(_tmp62_ < _tmp66_)) {
									break;
								}
								_tmp67_ = game_view_get_game (self);
								_tmp68_ = _tmp67_;
								_tmp69_ = _tmp68_->blocks;
								_tmp69__length1 = _tmp68_->blocks_length1;
								_tmp69__length2 = _tmp68_->blocks_length2;
								_tmp70_ = x;
								_tmp71_ = y;
								_tmp72_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
								_tmp73_ = _block_ref0 (_tmp72_);
								block = _tmp73_;
								_tmp74_ = block;
								if (_tmp74_ == NULL) {
									_block_unref0 (block);
									continue;
								}
								_tmp75_ = self->priv->blocks;
								_tmp76_ = block;
								_tmp77_ = g_hash_table_lookup (_tmp75_, _tmp76_);
								_tmp78_ = _g_object_ref0 ((BlockActor*) _tmp77_);
								actor = _tmp78_;
								_tmp79_ = actor;
								_tmp80_ = timeline;
								_tmp81_ = block;
								_tmp82_ = _tmp81_->x;
								_tmp83_ = game_view_get_cell_size (self);
								_tmp84_ = _tmp83_;
								_tmp85_ = block;
								_tmp86_ = _tmp85_->y;
								_tmp87_ = game_view_get_cell_size (self);
								_tmp88_ = _tmp87_;
								clutter_actor_animate_with_timeline ((ClutterActor*) _tmp79_, (gulong) CLUTTER_EASE_IN_QUAD, _tmp80_, "x", ((gfloat) _tmp82_) * _tmp84_, "y", ((gfloat) _tmp86_) * _tmp88_, NULL);
								_g_object_unref0 (actor);
								_block_unref0 (block);
							}
						}
					}
				}
			}
		}
		_g_object_unref0 (timeline);
	}
}


static void game_view_fall_completed_cb (GameView* self, ClutterTimeline* timeline) {
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterGroup* _tmp0_;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	ClutterGroup* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ClutterGroup* _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	_tmp0_ = self->priv->playing_field;
	clutter_actor_get_position ((ClutterActor*) _tmp0_, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	_tmp3_ = self->priv->playing_field;
	_tmp4_ = game_view_get_cell_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->n_lines_destroyed;
	clutter_actor_set_position ((ClutterActor*) _tmp3_, x, y + ((_tmp5_ * _tmp6_) * 0.25f));
	_tmp7_ = self->priv->playing_field;
	_tmp8_ = self->priv->n_lines_destroyed;
	clutter_actor_animate ((ClutterActor*) _tmp7_, (gulong) CLUTTER_EASE_OUT_BOUNCE, (guint) (720 / (5 - _tmp8_)), "x", x, "y", y, NULL);
}


static void game_view_size_allocate_cb (GameView* self, GtkWidget* widget, GtkAllocation* allocation) {
	Game* _tmp0_;
	Game* _tmp1_;
	BlockTexture** _tmp2_;
	gint _tmp2__length1;
	GHashTable* _tmp9_;
	GHashTableIter iter = {0};
	GHashTable* _tmp29_;
	GHashTableIter shape_iter = {0};
	ClutterGroup* _tmp49_;
	TextOverlay* _tmp63_;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	TextOverlay* _tmp66_;
	ClutterGroup* _tmp67_;
	Game* _tmp68_;
	Game* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	Game* _tmp74_;
	Game* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	ClutterGroup* _tmp80_;
	gint _tmp81_ = 0;
	ClutterGroup* _tmp82_;
	gfloat _tmp83_ = 0.0F;
	gint _tmp84_ = 0;
	ClutterGroup* _tmp85_;
	gfloat _tmp86_ = 0.0F;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->block_textures;
	_tmp2__length1 = self->priv->block_textures_length1;
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
		texture_collection = _tmp2_;
		texture_collection_length1 = _tmp2__length1;
		for (texture_it = 0; texture_it < _tmp2__length1; texture_it = texture_it + 1) {
			BlockTexture* _tmp3_;
			BlockTexture* texture = NULL;
			_tmp3_ = _g_object_ref0 (texture_collection[texture_it]);
			texture = _tmp3_;
			{
				BlockTexture* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp4_ = texture;
				_tmp5_ = game_view_get_cell_size (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = game_view_get_cell_size (self);
				_tmp8_ = _tmp7_;
				clutter_actor_set_size ((ClutterActor*) _tmp4_, (gfloat) _tmp6_, (gfloat) _tmp8_);
				_g_object_unref0 (texture);
			}
		}
	}
	_tmp9_ = self->priv->blocks;
	g_hash_table_iter_init (&iter, _tmp9_);
	while (TRUE) {
		Block* block = NULL;
		BlockActor* actor = NULL;
		gconstpointer _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		Block* _tmp13_;
		BlockActor* _tmp14_;
		BlockActor* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		BlockActor* _tmp20_;
		Block* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		Block* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp12_ = g_hash_table_iter_next (&iter, &_tmp10_, &_tmp11_);
		_block_unref0 (block);
		_tmp13_ = _block_ref0 (_tmp10_);
		block = _tmp13_;
		_g_object_unref0 (actor);
		_tmp14_ = _g_object_ref0 (_tmp11_);
		actor = _tmp14_;
		if (!_tmp12_) {
			_g_object_unref0 (actor);
			_block_unref0 (block);
			break;
		}
		_tmp15_ = actor;
		_tmp16_ = game_view_get_cell_size (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = game_view_get_cell_size (self);
		_tmp19_ = _tmp18_;
		clutter_actor_set_size ((ClutterActor*) _tmp15_, (gfloat) _tmp17_, (gfloat) _tmp19_);
		_tmp20_ = actor;
		_tmp21_ = block;
		_tmp22_ = _tmp21_->x;
		_tmp23_ = game_view_get_cell_size (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = block;
		_tmp26_ = _tmp25_->y;
		_tmp27_ = game_view_get_cell_size (self);
		_tmp28_ = _tmp27_;
		clutter_actor_set_position ((ClutterActor*) _tmp20_, (gfloat) (_tmp22_ * _tmp24_), (gfloat) (_tmp26_ * _tmp28_));
		_g_object_unref0 (actor);
		_block_unref0 (block);
	}
	_tmp29_ = self->priv->shape_blocks;
	g_hash_table_iter_init (&shape_iter, _tmp29_);
	while (TRUE) {
		Block* block = NULL;
		BlockActor* actor = NULL;
		gconstpointer _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		Block* _tmp33_;
		BlockActor* _tmp34_;
		BlockActor* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		BlockActor* _tmp40_;
		Block* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		Block* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		_tmp32_ = g_hash_table_iter_next (&shape_iter, &_tmp30_, &_tmp31_);
		_block_unref0 (block);
		_tmp33_ = _block_ref0 (_tmp30_);
		block = _tmp33_;
		_g_object_unref0 (actor);
		_tmp34_ = _g_object_ref0 (_tmp31_);
		actor = _tmp34_;
		if (!_tmp32_) {
			_g_object_unref0 (actor);
			_block_unref0 (block);
			break;
		}
		_tmp35_ = actor;
		_tmp36_ = game_view_get_cell_size (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = game_view_get_cell_size (self);
		_tmp39_ = _tmp38_;
		clutter_actor_set_size ((ClutterActor*) _tmp35_, (gfloat) _tmp37_, (gfloat) _tmp39_);
		_tmp40_ = actor;
		_tmp41_ = block;
		_tmp42_ = _tmp41_->x;
		_tmp43_ = game_view_get_cell_size (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = block;
		_tmp46_ = _tmp45_->y;
		_tmp47_ = game_view_get_cell_size (self);
		_tmp48_ = _tmp47_;
		clutter_actor_set_position ((ClutterActor*) _tmp40_, (gfloat) (_tmp42_ * _tmp44_), (gfloat) (_tmp46_ * _tmp48_));
		_g_object_unref0 (actor);
		_block_unref0 (block);
	}
	_tmp49_ = self->priv->shape;
	if (_tmp49_ != NULL) {
		ClutterGroup* _tmp50_;
		Game* _tmp51_;
		Game* _tmp52_;
		Shape* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		Game* _tmp57_;
		Game* _tmp58_;
		Shape* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		_tmp50_ = self->priv->shape;
		_tmp51_ = game_view_get_game (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = _tmp52_->shape;
		_tmp54_ = _tmp53_->x;
		_tmp55_ = game_view_get_cell_size (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = game_view_get_game (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_->shape;
		_tmp60_ = _tmp59_->y;
		_tmp61_ = game_view_get_cell_size (self);
		_tmp62_ = _tmp61_;
		clutter_actor_set_position ((ClutterActor*) _tmp50_, (gfloat) (_tmp54_ * _tmp56_), (gfloat) (_tmp60_ * _tmp62_));
	}
	game_view_update_shadow (self);
	_tmp63_ = self->priv->text_overlay;
	_tmp64_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp65_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	clutter_actor_set_size ((ClutterActor*) _tmp63_, (gfloat) _tmp64_, (gfloat) _tmp65_);
	_tmp66_ = self->priv->text_overlay;
	clutter_actor_raise_top ((ClutterActor*) _tmp66_);
	_tmp67_ = self->priv->playing_field;
	_tmp68_ = game_view_get_game (self);
	_tmp69_ = _tmp68_;
	_tmp70_ = game_get_width (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = game_view_get_cell_size (self);
	_tmp73_ = _tmp72_;
	_tmp74_ = game_view_get_game (self);
	_tmp75_ = _tmp74_;
	_tmp76_ = game_get_height (_tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = game_view_get_cell_size (self);
	_tmp79_ = _tmp78_;
	clutter_actor_set_size ((ClutterActor*) _tmp67_, (gfloat) (_tmp71_ * _tmp73_), (gfloat) (_tmp77_ * _tmp79_));
	_tmp80_ = self->priv->playing_field;
	_tmp81_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp82_ = self->priv->playing_field;
	_tmp83_ = clutter_actor_get_width ((ClutterActor*) _tmp82_);
	_tmp84_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp85_ = self->priv->playing_field;
	_tmp86_ = clutter_actor_get_height ((ClutterActor*) _tmp85_);
	clutter_actor_set_position ((ClutterActor*) _tmp80_, (_tmp81_ - _tmp83_) * 0.5f, _tmp84_ - _tmp86_);
}


static void game_view_pause_changed_cb (GameView* self) {
	g_return_if_fail (self != NULL);
	game_view_update_message (self);
}


static void game_view_game_complete_cb (GameView* self) {
	g_return_if_fail (self != NULL);
	game_view_play_sound (self, "gameover");
	game_view_update_message (self);
}


static void game_view_update_message (GameView* self) {
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		TextOverlay* _tmp4_;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->text_overlay;
		_tmp5_ = _ ("Paused");
		text_overlay_set_text (_tmp4_, _tmp5_);
	} else {
		Game* _tmp6_;
		Game* _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = game_view_get_game (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->game_over;
		if (_tmp8_) {
			TextOverlay* _tmp9_;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = self->priv->text_overlay;
			_tmp10_ = _ ("Game Over");
			text_overlay_set_text (_tmp9_, _tmp10_);
		} else {
			TextOverlay* _tmp11_;
			_tmp11_ = self->priv->text_overlay;
			text_overlay_set_text (_tmp11_, NULL);
		}
	}
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void _game_view_shape_added_cb_game_shape_added (Game* _sender, gpointer self) {
	game_view_shape_added_cb (self);
}


static void _game_view_shape_moved_cb_game_shape_moved (Game* _sender, gpointer self) {
	game_view_shape_moved_cb (self);
}


static void _game_view_shape_dropped_cb_game_shape_dropped (Game* _sender, gpointer self) {
	game_view_shape_dropped_cb (self);
}


static void _game_view_shape_rotated_cb_game_shape_rotated (Game* _sender, gpointer self) {
	game_view_shape_rotated_cb (self);
}


static void _game_view_shape_landed_cb_game_shape_landed (Game* _sender, gint* lines, int lines_length1, GList* line_blocks, gpointer self) {
	game_view_shape_landed_cb (self, lines, lines_length1, line_blocks);
}


static void _game_view_pause_changed_cb_game_pause_changed (Game* _sender, gpointer self) {
	game_view_pause_changed_cb (self);
}


static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	game_view_game_complete_cb (self);
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	Game* _tmp10_;
	GHashTable* _tmp11_;
	ClutterGroup* _tmp12_;
	Game* _tmp13_;
	Game* _tmp14_;
	Shape* _tmp15_;
	Game* _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	Game* _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "shape-added", (GCallback) _game_view_shape_added_cb_game_shape_added, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "shape-moved", (GCallback) _game_view_shape_moved_cb_game_shape_moved, self, 0);
	_tmp6_ = self->priv->_game;
	g_signal_connect_object (_tmp6_, "shape-dropped", (GCallback) _game_view_shape_dropped_cb_game_shape_dropped, self, 0);
	_tmp7_ = self->priv->_game;
	g_signal_connect_object (_tmp7_, "shape-rotated", (GCallback) _game_view_shape_rotated_cb_game_shape_rotated, self, 0);
	_tmp8_ = self->priv->_game;
	g_signal_connect_object (_tmp8_, "shape-landed", (GCallback) _game_view_shape_landed_cb_game_shape_landed, self, 0);
	_tmp9_ = self->priv->_game;
	g_signal_connect_object (_tmp9_, "pause-changed", (GCallback) _game_view_pause_changed_cb_game_pause_changed, self, 0);
	_tmp10_ = self->priv->_game;
	g_signal_connect_object (_tmp10_, "complete", (GCallback) _game_view_game_complete_cb_game_complete, self, 0);
	_tmp11_ = self->priv->blocks;
	g_hash_table_remove_all (_tmp11_);
	_tmp12_ = self->priv->playing_field;
	clutter_group_remove_all (_tmp12_);
	_tmp13_ = game_view_get_game (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->shape;
	if (_tmp15_ != NULL) {
		game_view_shape_added_cb (self);
	}
	{
		gint x;
		x = 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				Game* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = x;
					x = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = x;
				_tmp20_ = self->priv->_game;
				_tmp21_ = game_get_width (_tmp20_);
				_tmp22_ = _tmp21_;
				if (!(_tmp19_ < _tmp22_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp23_;
						_tmp23_ = TRUE;
						while (TRUE) {
							gboolean _tmp24_;
							gint _tmp26_;
							Game* _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							Game* _tmp30_;
							Block** _tmp31_;
							gint _tmp31__length1;
							gint _tmp31__length2;
							gint _tmp32_;
							gint _tmp33_;
							Block* _tmp34_;
							Block* _tmp35_;
							Block* block;
							Block* _tmp36_;
							_tmp24_ = _tmp23_;
							if (!_tmp24_) {
								gint _tmp25_;
								_tmp25_ = y;
								y = _tmp25_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp26_ = y;
							_tmp27_ = self->priv->_game;
							_tmp28_ = game_get_height (_tmp27_);
							_tmp29_ = _tmp28_;
							if (!(_tmp26_ < _tmp29_)) {
								break;
							}
							_tmp30_ = self->priv->_game;
							_tmp31_ = _tmp30_->blocks;
							_tmp31__length1 = _tmp30_->blocks_length1;
							_tmp31__length2 = _tmp30_->blocks_length2;
							_tmp32_ = x;
							_tmp33_ = y;
							_tmp34_ = _tmp31_[(_tmp32_ * _tmp31__length2) + _tmp33_];
							_tmp35_ = _block_ref0 (_tmp34_);
							block = _tmp35_;
							_tmp36_ = block;
							if (_tmp36_ != NULL) {
								Block* _tmp37_;
								BlockTexture** _tmp38_;
								gint _tmp38__length1;
								Block* _tmp39_;
								gint _tmp40_;
								BlockTexture* _tmp41_;
								BlockActor* _tmp42_;
								BlockActor* _tmp43_;
								BlockActor* actor;
								GHashTable* _tmp44_;
								Block* _tmp45_;
								Block* _tmp46_;
								BlockActor* _tmp47_;
								BlockActor* _tmp48_;
								BlockActor* _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
								gint _tmp52_;
								gint _tmp53_;
								BlockActor* _tmp54_;
								Block* _tmp55_;
								gint _tmp56_;
								gint _tmp57_;
								gint _tmp58_;
								Block* _tmp59_;
								gint _tmp60_;
								gint _tmp61_;
								gint _tmp62_;
								ClutterGroup* _tmp63_;
								BlockActor* _tmp64_;
								_tmp37_ = block;
								_tmp38_ = self->priv->block_textures;
								_tmp38__length1 = self->priv->block_textures_length1;
								_tmp39_ = block;
								_tmp40_ = _tmp39_->color;
								_tmp41_ = _tmp38_[_tmp40_];
								_tmp42_ = block_actor_new (_tmp37_, (ClutterActor*) _tmp41_);
								_tmp43_ = g_object_ref_sink (_tmp42_);
								actor = _tmp43_;
								_tmp44_ = self->priv->blocks;
								_tmp45_ = block;
								_tmp46_ = _block_ref0 (_tmp45_);
								_tmp47_ = actor;
								_tmp48_ = _g_object_ref0 (_tmp47_);
								g_hash_table_insert (_tmp44_, _tmp46_, _tmp48_);
								_tmp49_ = actor;
								_tmp50_ = game_view_get_cell_size (self);
								_tmp51_ = _tmp50_;
								_tmp52_ = game_view_get_cell_size (self);
								_tmp53_ = _tmp52_;
								clutter_actor_set_size ((ClutterActor*) _tmp49_, (gfloat) _tmp51_, (gfloat) _tmp53_);
								_tmp54_ = actor;
								_tmp55_ = block;
								_tmp56_ = _tmp55_->x;
								_tmp57_ = game_view_get_cell_size (self);
								_tmp58_ = _tmp57_;
								_tmp59_ = block;
								_tmp60_ = _tmp59_->y;
								_tmp61_ = game_view_get_cell_size (self);
								_tmp62_ = _tmp61_;
								clutter_actor_set_position ((ClutterActor*) _tmp54_, (gfloat) (_tmp56_ * _tmp58_), (gfloat) (_tmp60_ * _tmp62_));
								_tmp63_ = self->priv->playing_field;
								_tmp64_ = actor;
								clutter_container_add ((ClutterContainer*) _tmp63_, (ClutterActor*) _tmp64_, NULL);
								_g_object_unref0 (actor);
							}
							_block_unref0 (block);
						}
					}
				}
			}
		}
	}
	_tmp65_ = self->priv->_game;
	_tmp66_ = game_get_width (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = self->priv->_game;
	_tmp69_ = game_get_height (_tmp68_);
	_tmp70_ = _tmp69_;
	gtk_widget_set_size_request ((GtkWidget*) self, (_tmp67_ * 190) / _tmp70_, 190);
	game_view_update_message (self);
	g_object_notify ((GObject *) self, "game");
}


void game_view_set_theme (GameView* self, const gchar* value) {
	BlockTexture** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->block_textures;
	_tmp0__length1 = self->priv->block_textures_length1;
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
		texture_collection = _tmp0_;
		texture_collection_length1 = _tmp0__length1;
		for (texture_it = 0; texture_it < _tmp0__length1; texture_it = texture_it + 1) {
			BlockTexture* _tmp1_;
			BlockTexture* texture = NULL;
			_tmp1_ = _g_object_ref0 (texture_collection[texture_it]);
			texture = _tmp1_;
			{
				BlockTexture* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = texture;
				_tmp3_ = value;
				block_texture_set_theme (_tmp2_, _tmp3_);
				_g_object_unref0 (texture);
			}
		}
	}
	g_object_notify ((GObject *) self, "theme");
}


gboolean game_view_get_show_shadow (GameView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_shadow;
	result = _tmp0_;
	return result;
}


void game_view_set_show_shadow (GameView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_shadow = _tmp0_;
	game_view_update_shadow (self);
	g_object_notify ((GObject *) self, "show-shadow");
}


static gint game_view_get_cell_size (GameView* self) {
	gint result;
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gint _tmp2_ = 0;
		Game* _tmp3_;
		Game* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_ = 0;
		Game* _tmp8_;
		Game* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_ = 0;
		_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp3_ = game_view_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = game_get_width (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp8_ = game_view_get_game (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = game_get_height (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = MIN (_tmp2_ / _tmp6_, _tmp7_ / _tmp11_);
		result = _tmp12_;
		return result;
	} else {
		result = 0;
		return result;
	}
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SHOW_SHADOW, g_param_spec_boolean ("show-shadow", "show-shadow", "show-shadow", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->_game = NULL;
	self->priv->shape = NULL;
	self->priv->shape_shadow = NULL;
	self->priv->_show_shadow = FALSE;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = GAME_VIEW (obj);
	_g_object_unref0 (self->priv->_game);
	_g_object_unref0 (self->priv->playing_field);
	_g_object_unref0 (self->priv->shape);
	_g_object_unref0 (self->priv->shape_shadow);
	_g_object_unref0 (self->priv->text_overlay);
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->blocks);
	_g_hash_table_unref0 (self->priv->shape_blocks);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = GAME_VIEW (object);
	switch (property_id) {
		case GAME_VIEW_GAME:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_SHOW_SHADOW:
		g_value_set_boolean (value, game_view_get_show_shadow (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = GAME_VIEW (object);
	switch (property_id) {
		case GAME_VIEW_GAME:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		case GAME_VIEW_SHOW_SHADOW:
		game_view_set_show_shadow (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


BlockActor* block_actor_construct (GType object_type, Block* block, ClutterActor* texture) {
	BlockActor * self = NULL;
	ClutterActor* _tmp0_;
	Block* _tmp1_;
	Block* _tmp2_;
	g_return_val_if_fail (block != NULL, NULL);
	g_return_val_if_fail (texture != NULL, NULL);
	_tmp0_ = texture;
	self = (BlockActor*) g_object_new (object_type, "source", _tmp0_, NULL);
	_tmp1_ = block;
	_tmp2_ = _block_ref0 (_tmp1_);
	_block_unref0 (self->block);
	self->block = _tmp2_;
	return self;
}


BlockActor* block_actor_new (Block* block, ClutterActor* texture) {
	return block_actor_construct (TYPE_BLOCK_ACTOR, block, texture);
}


static void _block_actor_explode_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	block_actor_explode_complete_cb (self);
}


void block_actor_explode (BlockActor* self) {
	ClutterTimeline* _tmp0_;
	ClutterTimeline* timeline;
	g_return_if_fail (self != NULL);
	clutter_actor_raise_top ((ClutterActor*) self);
	_tmp0_ = clutter_timeline_new ((guint) 720);
	timeline = _tmp0_;
	g_signal_connect_object (timeline, "completed", (GCallback) _block_actor_explode_complete_cb_clutter_timeline_completed, self, 0);
	clutter_actor_animate_with_timeline ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_QUINT, timeline, "opacity", 0, "scale-x", 2.f, "scale-y", 2.f, NULL);
	_g_object_unref0 (timeline);
}


static void block_actor_explode_complete_cb (BlockActor* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_destroy ((ClutterActor*) self);
}


static void block_actor_class_init (BlockActorClass * klass) {
	block_actor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = block_actor_finalize;
}


static void block_actor_instance_init (BlockActor * self) {
}


static void block_actor_finalize (GObject* obj) {
	BlockActor * self;
	self = BLOCK_ACTOR (obj);
	_block_unref0 (self->block);
	G_OBJECT_CLASS (block_actor_parent_class)->finalize (obj);
}


GType block_actor_get_type (void) {
	static volatile gsize block_actor_type_id__volatile = 0;
	if (g_once_init_enter (&block_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockActor), 0, (GInstanceInitFunc) block_actor_instance_init, NULL };
		GType block_actor_type_id;
		block_actor_type_id = g_type_register_static (clutter_clone_get_type (), "BlockActor", &g_define_type_info, 0);
		g_once_init_leave (&block_actor_type_id__volatile, block_actor_type_id);
	}
	return block_actor_type_id__volatile;
}


TextOverlay* text_overlay_construct (GType object_type) {
	TextOverlay * self = NULL;
	self = (TextOverlay*) g_object_new (object_type, NULL);
	clutter_cairo_texture_set_auto_resize ((ClutterCairoTexture*) self, TRUE);
	return self;
}


TextOverlay* text_overlay_new (void) {
	return text_overlay_construct (TYPE_TEXT_OVERLAY);
}


static gboolean text_overlay_real_draw (ClutterCairoTexture* base, cairo_t* cr) {
	TextOverlay * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint w = 0U;
	guint h = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	cairo_t* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	PangoFontDescription* _tmp7_ = NULL;
	PangoFontDescription* desc;
	cairo_t* _tmp8_;
	PangoLayout* _tmp9_ = NULL;
	PangoLayout* layout;
	PangoLayout* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_ = NULL;
	PangoLayout* dummy_layout;
	PangoLayout* _tmp15_;
	const PangoFontDescription* _tmp16_;
	gint lw = 0;
	gint lh = 0;
	PangoLayout* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	const PangoFontDescription* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	guint _tmp23_;
	PangoLayout* _tmp24_;
	const PangoFontDescription* _tmp25_;
	PangoLayout* _tmp26_;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	cairo_t* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	cairo_t* _tmp32_;
	PangoLayout* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	gfloat _tmp36_;
	gfloat _tmp37_;
	cairo_t* _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	self = (TextOverlay*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	clutter_cairo_texture_clear ((ClutterCairoTexture*) self);
	_tmp0_ = text_overlay_get_text (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	clutter_cairo_texture_get_surface_size ((ClutterCairoTexture*) self, &_tmp2_, &_tmp3_);
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = cr;
	_tmp5_ = w;
	_tmp6_ = h;
	cairo_translate (_tmp4_, (gdouble) (_tmp5_ / 2), (gdouble) (_tmp6_ / 2));
	_tmp7_ = pango_font_description_from_string ("Sans");
	desc = _tmp7_;
	_tmp8_ = cr;
	_tmp9_ = pango_cairo_create_layout (_tmp8_);
	layout = _tmp9_;
	_tmp10_ = layout;
	_tmp11_ = text_overlay_get_text (self);
	_tmp12_ = _tmp11_;
	pango_layout_set_text (_tmp10_, _tmp12_, -1);
	_tmp13_ = layout;
	_tmp14_ = pango_layout_copy (_tmp13_);
	dummy_layout = _tmp14_;
	_tmp15_ = dummy_layout;
	_tmp16_ = desc;
	pango_layout_set_font_description (_tmp15_, _tmp16_);
	_tmp17_ = dummy_layout;
	pango_layout_get_size (_tmp17_, &_tmp18_, &_tmp19_);
	lw = _tmp18_;
	lh = _tmp19_;
	_tmp20_ = desc;
	_tmp21_ = lh;
	_tmp22_ = lw;
	_tmp23_ = w;
	pango_font_description_set_absolute_size (_tmp20_, (((((gfloat) _tmp21_) / _tmp22_) * PANGO_SCALE) * _tmp23_) * 0.7);
	_tmp24_ = layout;
	_tmp25_ = desc;
	pango_layout_set_font_description (_tmp24_, _tmp25_);
	_tmp26_ = layout;
	pango_layout_get_size (_tmp26_, &_tmp27_, &_tmp28_);
	lw = _tmp27_;
	lh = _tmp28_;
	_tmp29_ = cr;
	_tmp30_ = lw;
	_tmp31_ = lh;
	cairo_move_to (_tmp29_, (-(((gdouble) _tmp30_) / PANGO_SCALE)) / 2, (-(((gdouble) _tmp31_) / PANGO_SCALE)) / 2);
	_tmp32_ = cr;
	_tmp33_ = layout;
	pango_cairo_layout_path (_tmp32_, _tmp33_);
	_tmp34_ = cr;
	cairo_set_source_rgb (_tmp34_, 0.333333333333, 0.341176470588, 0.32549019607);
	_tmp35_ = cr;
	_tmp36_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp37_ = _tmp36_;
	cairo_set_line_width (_tmp35_, _tmp37_ / 100.0);
	_tmp38_ = cr;
	cairo_stroke_preserve (_tmp38_);
	_tmp39_ = cr;
	cairo_set_source_rgb (_tmp39_, 1.0, 1.0, 1.0);
	_tmp40_ = cr;
	cairo_fill (_tmp40_);
	result = FALSE;
	_g_object_unref0 (dummy_layout);
	_g_object_unref0 (layout);
	_pango_font_description_free0 (desc);
	return result;
}


const gchar* text_overlay_get_text (TextOverlay* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}


void text_overlay_set_text (TextOverlay* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
	g_object_notify ((GObject *) self, "text");
}


static void text_overlay_class_init (TextOverlayClass * klass) {
	text_overlay_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TextOverlayPrivate));
	CLUTTER_CAIRO_TEXTURE_CLASS (klass)->draw = text_overlay_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_text_overlay_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_text_overlay_set_property;
	G_OBJECT_CLASS (klass)->finalize = text_overlay_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_OVERLAY_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void text_overlay_instance_init (TextOverlay * self) {
	self->priv = TEXT_OVERLAY_GET_PRIVATE (self);
	self->priv->_text = NULL;
}


static void text_overlay_finalize (GObject* obj) {
	TextOverlay * self;
	self = TEXT_OVERLAY (obj);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (text_overlay_parent_class)->finalize (obj);
}


GType text_overlay_get_type (void) {
	static volatile gsize text_overlay_type_id__volatile = 0;
	if (g_once_init_enter (&text_overlay_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TextOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextOverlay), 0, (GInstanceInitFunc) text_overlay_instance_init, NULL };
		GType text_overlay_type_id;
		text_overlay_type_id = g_type_register_static (clutter_cairo_texture_get_type (), "TextOverlay", &g_define_type_info, 0);
		g_once_init_leave (&text_overlay_type_id__volatile, text_overlay_type_id);
	}
	return text_overlay_type_id__volatile;
}


static void _vala_text_overlay_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TextOverlay * self;
	self = TEXT_OVERLAY (object);
	switch (property_id) {
		case TEXT_OVERLAY_TEXT:
		g_value_set_string (value, text_overlay_get_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_text_overlay_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TextOverlay * self;
	self = TEXT_OVERLAY (object);
	switch (property_id) {
		case TEXT_OVERLAY_TEXT:
		text_overlay_set_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


BlockTexture* block_texture_construct (GType object_type, gint color) {
	BlockTexture * self = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	self = (BlockTexture*) g_object_new (object_type, NULL);
	clutter_cairo_texture_set_auto_resize ((ClutterCairoTexture*) self, TRUE);
	_tmp0_ = color;
	_tmp1_ = CLAMP (_tmp0_, 0, 6);
	self->priv->color = _tmp1_;
	return self;
}


BlockTexture* block_texture_new (gint color) {
	return block_texture_construct (TYPE_BLOCK_TEXTURE, color);
}


static gboolean block_texture_real_draw (ClutterCairoTexture* base, cairo_t* cr) {
	BlockTexture * self;
	gboolean result = FALSE;
	guint w = 0U;
	guint h = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	cairo_t* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
	static GQuark _tmp8_label0 = 0;
	static GQuark _tmp8_label1 = 0;
	static GQuark _tmp8_label2 = 0;
	self = (BlockTexture*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	clutter_cairo_texture_clear ((ClutterCairoTexture*) self);
	clutter_cairo_texture_get_surface_size ((ClutterCairoTexture*) self, &_tmp0_, &_tmp1_);
	w = _tmp0_;
	h = _tmp1_;
	_tmp2_ = cr;
	_tmp3_ = w;
	_tmp4_ = h;
	cairo_scale (_tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
	_tmp5_ = block_texture_get_theme (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("clean")))) {
		switch (0) {
			default:
			{
				cairo_t* _tmp10_;
				_tmp10_ = cr;
				block_texture_draw_clean (self, _tmp10_);
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("tangoflat")))) {
		switch (0) {
			default:
			{
				cairo_t* _tmp11_;
				_tmp11_ = cr;
				block_texture_draw_tango (self, _tmp11_, FALSE);
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("tangoshaded")))) {
		switch (0) {
			default:
			{
				cairo_t* _tmp12_;
				_tmp12_ = cr;
				block_texture_draw_tango (self, _tmp12_, TRUE);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				cairo_t* _tmp13_;
				_tmp13_ = cr;
				block_texture_draw_plain (self, _tmp13_);
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void block_texture_draw_plain (BlockTexture* self, cairo_t* cr) {
	static const gdouble colors[] = {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0};
	cairo_t* _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gint _tmp5_;
	gdouble _tmp6_;
	cairo_t* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	_tmp1_ = self->priv->color;
	_tmp2_ = colors[_tmp1_ * 3];
	_tmp3_ = self->priv->color;
	_tmp4_ = colors[(_tmp3_ * 3) + 1];
	_tmp5_ = self->priv->color;
	_tmp6_ = colors[(_tmp5_ * 3) + 2];
	cairo_set_source_rgb (_tmp0_, _tmp2_, _tmp4_, _tmp6_);
	_tmp7_ = cr;
	cairo_paint (_tmp7_);
}


static void block_texture_draw_rounded_rectangle (BlockTexture* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, gdouble r) {
	cairo_t* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	cairo_t* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	cairo_t* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	cairo_t* _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	cairo_t* _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	cairo_t* _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	cairo_t* _tmp49_;
	gdouble _tmp50_;
	gdouble _tmp51_;
	gdouble _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gdouble _tmp61_;
	cairo_t* _tmp62_;
	gdouble _tmp63_;
	gdouble _tmp64_;
	gdouble _tmp65_;
	cairo_t* _tmp66_;
	gdouble _tmp67_;
	gdouble _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	gdouble _tmp71_;
	gdouble _tmp72_;
	gdouble _tmp73_;
	gdouble _tmp74_;
	gdouble _tmp75_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	_tmp1_ = x;
	_tmp2_ = r;
	_tmp3_ = y;
	cairo_move_to (_tmp0_, _tmp1_ + _tmp2_, _tmp3_);
	_tmp4_ = cr;
	_tmp5_ = x;
	_tmp6_ = w;
	_tmp7_ = r;
	_tmp8_ = y;
	cairo_line_to (_tmp4_, (_tmp5_ + _tmp6_) - _tmp7_, _tmp8_);
	_tmp9_ = cr;
	_tmp10_ = x;
	_tmp11_ = w;
	_tmp12_ = r;
	_tmp13_ = y;
	_tmp14_ = x;
	_tmp15_ = w;
	_tmp16_ = y;
	_tmp17_ = r;
	_tmp18_ = x;
	_tmp19_ = w;
	_tmp20_ = y;
	_tmp21_ = r;
	cairo_curve_to (_tmp9_, (_tmp10_ + _tmp11_) - (_tmp12_ / 2), _tmp13_, _tmp14_ + _tmp15_, _tmp16_ + (_tmp17_ / 2), _tmp18_ + _tmp19_, _tmp20_ + _tmp21_);
	_tmp22_ = cr;
	_tmp23_ = x;
	_tmp24_ = w;
	_tmp25_ = y;
	_tmp26_ = h;
	_tmp27_ = r;
	cairo_line_to (_tmp22_, _tmp23_ + _tmp24_, (_tmp25_ + _tmp26_) - _tmp27_);
	_tmp28_ = cr;
	_tmp29_ = x;
	_tmp30_ = w;
	_tmp31_ = y;
	_tmp32_ = h;
	_tmp33_ = r;
	_tmp34_ = x;
	_tmp35_ = w;
	_tmp36_ = r;
	_tmp37_ = y;
	_tmp38_ = h;
	_tmp39_ = x;
	_tmp40_ = w;
	_tmp41_ = r;
	_tmp42_ = y;
	_tmp43_ = h;
	cairo_curve_to (_tmp28_, _tmp29_ + _tmp30_, (_tmp31_ + _tmp32_) - (_tmp33_ / 2), (_tmp34_ + _tmp35_) - (_tmp36_ / 2), _tmp37_ + _tmp38_, (_tmp39_ + _tmp40_) - _tmp41_, _tmp42_ + _tmp43_);
	_tmp44_ = cr;
	_tmp45_ = x;
	_tmp46_ = r;
	_tmp47_ = y;
	_tmp48_ = h;
	cairo_line_to (_tmp44_, _tmp45_ + _tmp46_, _tmp47_ + _tmp48_);
	_tmp49_ = cr;
	_tmp50_ = x;
	_tmp51_ = r;
	_tmp52_ = y;
	_tmp53_ = h;
	_tmp54_ = x;
	_tmp55_ = y;
	_tmp56_ = h;
	_tmp57_ = r;
	_tmp58_ = x;
	_tmp59_ = y;
	_tmp60_ = h;
	_tmp61_ = r;
	cairo_curve_to (_tmp49_, _tmp50_ + (_tmp51_ / 2), _tmp52_ + _tmp53_, _tmp54_, (_tmp55_ + _tmp56_) - (_tmp57_ / 2), _tmp58_, (_tmp59_ + _tmp60_) - _tmp61_);
	_tmp62_ = cr;
	_tmp63_ = x;
	_tmp64_ = y;
	_tmp65_ = r;
	cairo_line_to (_tmp62_, _tmp63_, _tmp64_ + _tmp65_);
	_tmp66_ = cr;
	_tmp67_ = x;
	_tmp68_ = y;
	_tmp69_ = r;
	_tmp70_ = x;
	_tmp71_ = r;
	_tmp72_ = y;
	_tmp73_ = x;
	_tmp74_ = r;
	_tmp75_ = y;
	cairo_curve_to (_tmp66_, _tmp67_, _tmp68_ + (_tmp69_ / 2), _tmp70_ + (_tmp71_ / 2), _tmp72_, _tmp73_ + _tmp74_, _tmp75_);
}


static void block_texture_draw_clean (BlockTexture* self, cairo_t* cr) {
	static const gdouble colors[] = {0.780392156863, 0.247058823529, 0.247058823529, 0.713725490196, 0.192156862745, 0.192156862745, 0.61568627451, 0.164705882353, 0.164705882353, 0.552941176471, 0.788235294118, 0.32549019607, 0.474509803922, 0.713725490196, 0.243137254902, 0.388235294118, 0.596078431373, 0.18431372549, 0.313725490196, 0.450980392157, 0.623529411765, 0.239215686275, 0.345098039216, 0.474509803922, 0.21568627451, 0.313725490196, 0.435294117647, 1.0, 1.0, 1.0, 0.909803921569, 0.909803921569, 0.898039215686, 0.701960784314, 0.701960784314, 0.670588235294, 0.945098039216, 0.878431372549, 0.321568627451, 0.929411764706, 0.839215686275, 0.113725490196, 0.760784313725, 0.682352941176, 0.0274509803922, 0.576470588235, 0.364705882353, 0.607843137255, 0.443137254902, 0.282352941176, 0.46666666666, 0.439215686275, 0.266666666667, 0.46666666666, 0.890196078431, 0.572549019608, 0.258823529412, 0.803921568627, 0.450980392157, 0.101960784314, 0.690196078431, 0.388235294118, 0.0901960784314, 0.392156862745, 0.392156862745, 0.392156862745, 0.262745098039, 0.262745098039, 0.262745098039, 0.21568627451, 0.235294117647, 0.23921568627};
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gint _tmp6_;
	gdouble _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_pattern_t* _tmp10_;
	cairo_pattern_t* pat;
	gint _tmp11_;
	gdouble _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_;
	gint _tmp15_;
	gdouble _tmp16_;
	gint _tmp17_;
	gdouble _tmp18_;
	gint _tmp19_;
	gdouble _tmp20_;
	gint _tmp21_;
	gdouble _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	block_texture_draw_rounded_rectangle (self, _tmp0_, 0.05, 0.05, 0.9, 0.9, 0.05);
	_tmp1_ = cr;
	_tmp2_ = self->priv->color;
	_tmp3_ = colors[(_tmp2_ * 9) + 6];
	_tmp4_ = self->priv->color;
	_tmp5_ = colors[(_tmp4_ * 9) + 7];
	_tmp6_ = self->priv->color;
	_tmp7_ = colors[(_tmp6_ * 9) + 8];
	cairo_set_source_rgb (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
	_tmp8_ = cr;
	cairo_set_line_width (_tmp8_, 0.1);
	_tmp9_ = cr;
	cairo_stroke_preserve (_tmp9_);
	_tmp10_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
	pat = _tmp10_;
	_tmp11_ = self->priv->color;
	_tmp12_ = colors[_tmp11_ * 9];
	_tmp13_ = self->priv->color;
	_tmp14_ = colors[(_tmp13_ * 9) + 1];
	_tmp15_ = self->priv->color;
	_tmp16_ = colors[(_tmp15_ * 9) + 2];
	cairo_pattern_add_color_stop_rgb (pat, 0.0, _tmp12_, _tmp14_, _tmp16_);
	_tmp17_ = self->priv->color;
	_tmp18_ = colors[(_tmp17_ * 9) + 3];
	_tmp19_ = self->priv->color;
	_tmp20_ = colors[(_tmp19_ * 9) + 4];
	_tmp21_ = self->priv->color;
	_tmp22_ = colors[(_tmp21_ * 9) + 5];
	cairo_pattern_add_color_stop_rgb (pat, 1.0, _tmp18_, _tmp20_, _tmp22_);
	_tmp23_ = cr;
	cairo_set_source (_tmp23_, pat);
	_tmp24_ = cr;
	cairo_fill (_tmp24_);
	_cairo_pattern_destroy0 (pat);
}


static void block_texture_draw_tango (BlockTexture* self, cairo_t* cr, gboolean use_gradients) {
	static const gdouble colors[] = {0.93725490196078431, 0.16078431372549021, 0.16078431372549021, 0.8, 0.0, 0.0, 0.64313725490196083, 0.0, 0.0, 0.54117647058823526, 0.88627450980392153, 0.20392156862745098, 0.45098039215686275, 0.82352941176470584, 0.086274509803921567, 0.30588235294117649, 0.60392156862745094, 0.023529411764705882, 0.44705882352941179, 0.62352941176470589, 0.81176470588235294, 0.20392156862745098, 0.396078431372549, 0.64313725490196083, 0.12549019607843137, 0.29019607843137257, 0.52941176470588236, 0.93333333333333335, 0.93333333333333335, 0.92549019607843142, 0.82745098039215681, 0.84313725490196079, 0.81176470588235294, 0.72941176470588232, 0.74117647058823533, 0.71372549019607845, 0.9882352941176471, 0.9137254901960784, 0.30980392156862746, 0.92941176470588238, 0.83137254901960789, 0.0, 0.7686274509803922, 0.62745098039215685, 0.0, 0.67843137254901964, 0.49803921568627452, 0.6588235294117647, 0.45882352941176469, 0.31372549019607843, 0.4823529411764706, 0.36078431372549019, 0.20784313725490197, 0.4, 0.9882352941176471, 0.68627450980392157, 0.24313725490196078, 0.96078431372549022, 0.47450980392156861, 0.0, 0.80784313725490198, 0.36078431372549019, 0.0, 0.33, 0.34, 0.32, 0.18, 0.2, 0.21, 0.10, 0.12, 0.13};
	gboolean _tmp0_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	gint _tmp28_;
	gdouble _tmp29_;
	gint _tmp30_;
	gdouble _tmp31_;
	gint _tmp32_;
	gdouble _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	gboolean _tmp37_;
	cairo_t* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = use_gradients;
	if (_tmp0_) {
		cairo_pattern_t* _tmp1_;
		cairo_pattern_t* pat;
		cairo_pattern_t* _tmp2_;
		gint _tmp3_;
		gdouble _tmp4_;
		gint _tmp5_;
		gdouble _tmp6_;
		gint _tmp7_;
		gdouble _tmp8_;
		cairo_pattern_t* _tmp9_;
		gint _tmp10_;
		gdouble _tmp11_;
		gint _tmp12_;
		gdouble _tmp13_;
		gint _tmp14_;
		gdouble _tmp15_;
		cairo_t* _tmp16_;
		cairo_pattern_t* _tmp17_;
		_tmp1_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
		pat = _tmp1_;
		_tmp2_ = pat;
		_tmp3_ = self->priv->color;
		_tmp4_ = colors[_tmp3_ * 9];
		_tmp5_ = self->priv->color;
		_tmp6_ = colors[(_tmp5_ * 9) + 1];
		_tmp7_ = self->priv->color;
		_tmp8_ = colors[(_tmp7_ * 9) + 2];
		cairo_pattern_add_color_stop_rgb (_tmp2_, 0.0, _tmp4_, _tmp6_, _tmp8_);
		_tmp9_ = pat;
		_tmp10_ = self->priv->color;
		_tmp11_ = colors[(_tmp10_ * 9) + 3];
		_tmp12_ = self->priv->color;
		_tmp13_ = colors[(_tmp12_ * 9) + 4];
		_tmp14_ = self->priv->color;
		_tmp15_ = colors[(_tmp14_ * 9) + 5];
		cairo_pattern_add_color_stop_rgb (_tmp9_, 1.0, _tmp11_, _tmp13_, _tmp15_);
		_tmp16_ = cr;
		_tmp17_ = pat;
		cairo_set_source (_tmp16_, _tmp17_);
		_cairo_pattern_destroy0 (pat);
	} else {
		cairo_t* _tmp18_;
		gint _tmp19_;
		gdouble _tmp20_;
		gint _tmp21_;
		gdouble _tmp22_;
		gint _tmp23_;
		gdouble _tmp24_;
		_tmp18_ = cr;
		_tmp19_ = self->priv->color;
		_tmp20_ = colors[_tmp19_ * 9];
		_tmp21_ = self->priv->color;
		_tmp22_ = colors[(_tmp21_ * 9) + 1];
		_tmp23_ = self->priv->color;
		_tmp24_ = colors[(_tmp23_ * 9) + 2];
		cairo_set_source_rgb (_tmp18_, _tmp20_, _tmp22_, _tmp24_);
	}
	_tmp25_ = cr;
	block_texture_draw_rounded_rectangle (self, _tmp25_, 0.05, 0.05, 0.9, 0.9, 0.2);
	_tmp26_ = cr;
	cairo_fill_preserve (_tmp26_);
	_tmp27_ = cr;
	_tmp28_ = self->priv->color;
	_tmp29_ = colors[(_tmp28_ * 9) + 6];
	_tmp30_ = self->priv->color;
	_tmp31_ = colors[(_tmp30_ * 9) + 7];
	_tmp32_ = self->priv->color;
	_tmp33_ = colors[(_tmp32_ * 9) + 8];
	cairo_set_source_rgb (_tmp27_, _tmp29_, _tmp31_, _tmp33_);
	_tmp34_ = cr;
	cairo_set_line_width (_tmp34_, 0.1);
	_tmp35_ = cr;
	cairo_stroke (_tmp35_);
	_tmp36_ = cr;
	block_texture_draw_rounded_rectangle (self, _tmp36_, 0.15, 0.15, 0.7, 0.7, 0.08);
	_tmp37_ = use_gradients;
	if (_tmp37_) {
		cairo_pattern_t* _tmp38_;
		cairo_pattern_t* pat;
		gint _tmp39_;
		cairo_t* _tmp44_;
		cairo_pattern_t* _tmp45_;
		_tmp38_ = cairo_pattern_create_linear (-0.3, -0.3, 0.8, 0.8);
		pat = _tmp38_;
		_tmp39_ = self->priv->color;
		switch (_tmp39_) {
			case 3:
			case 4:
			{
				cairo_pattern_t* _tmp40_;
				cairo_pattern_t* _tmp41_;
				_tmp40_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp40_, 0.0, 1.0, 1.0, 1.0, 1.0);
				_tmp41_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp41_, 1.0, 1.0, 1.0, 1.0, 0.0);
				break;
			}
			default:
			{
				cairo_pattern_t* _tmp42_;
				cairo_pattern_t* _tmp43_;
				_tmp42_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp42_, 0.0, 0.9295, 0.9295, 0.9295, 1.0);
				_tmp43_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp43_, 1.0, 0.9295, 0.9295, 0.9295, 0.0);
				break;
			}
		}
		_tmp44_ = cr;
		_tmp45_ = pat;
		cairo_set_source (_tmp44_, _tmp45_);
		_cairo_pattern_destroy0 (pat);
	} else {
		cairo_t* _tmp46_;
		_tmp46_ = cr;
		cairo_set_source_rgba (_tmp46_, 1.0, 1.0, 1.0, 0.35);
	}
	_tmp47_ = cr;
	cairo_stroke (_tmp47_);
}


const gchar* block_texture_get_theme (BlockTexture* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void block_texture_set_theme (BlockTexture* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp3_;
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
	g_object_notify ((GObject *) self, "theme");
}


static void block_texture_class_init (BlockTextureClass * klass) {
	block_texture_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BlockTexturePrivate));
	CLUTTER_CAIRO_TEXTURE_CLASS (klass)->draw = block_texture_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_block_texture_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_block_texture_set_property;
	G_OBJECT_CLASS (klass)->finalize = block_texture_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLOCK_TEXTURE_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void block_texture_instance_init (BlockTexture * self) {
	self->priv = BLOCK_TEXTURE_GET_PRIVATE (self);
	self->priv->_theme = NULL;
}


static void block_texture_finalize (GObject* obj) {
	BlockTexture * self;
	self = BLOCK_TEXTURE (obj);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (block_texture_parent_class)->finalize (obj);
}


GType block_texture_get_type (void) {
	static volatile gsize block_texture_type_id__volatile = 0;
	if (g_once_init_enter (&block_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockTexture), 0, (GInstanceInitFunc) block_texture_instance_init, NULL };
		GType block_texture_type_id;
		block_texture_type_id = g_type_register_static (clutter_cairo_texture_get_type (), "BlockTexture", &g_define_type_info, 0);
		g_once_init_leave (&block_texture_type_id__volatile, block_texture_type_id);
	}
	return block_texture_type_id__volatile;
}


static void _vala_block_texture_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BlockTexture * self;
	self = BLOCK_TEXTURE (object);
	switch (property_id) {
		case BLOCK_TEXTURE_THEME:
		g_value_set_string (value, block_texture_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_block_texture_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BlockTexture * self;
	self = BLOCK_TEXTURE (object);
	switch (property_id) {
		case BLOCK_TEXTURE_THEME:
		block_texture_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



