/* finance.c generated by valac 0.39.2.21-6056, the Vala compiler
 * generated from finance.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2015 - Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <latexila.h>
#include <gdk/gdk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



void finance_show_dialog (GtkWindow* parent_window, 
                          gboolean startup);
gboolean finance_should_show_dialog_on_startup (void);
void finance_open_donate_page (GtkWidget* widget);
void finance_save_date (void);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void
finance_show_dialog (GtkWindow* parent_window, 
                     gboolean startup)
{
	gboolean _tmp0_ = FALSE;
	gchar* title = NULL;
	GtkDialog* dialog = NULL;
	const gchar* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkImage* image = NULL;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkBox* _tmp14_;
	GtkImage* _tmp15_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkBox* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkBox* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkBox* _tmp38_;
	GtkLabel* _tmp39_;
	GtkCheckButton* remind_later_checkbutton = NULL;
	GtkCheckButton* _tmp40_;
	GtkCheckButton* _tmp41_;
	GtkCheckButton* _tmp42_;
	GtkCheckButton* _tmp43_;
	GtkBox* _tmp44_;
	GtkCheckButton* _tmp45_;
	GtkBox* _tmp46_;
	GtkDialog* _tmp53_;
	g_return_if_fail (parent_window != NULL);
	if (startup) {
		_tmp0_ = !finance_should_show_dialog_on_startup ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (startup) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("Welcome in GNOME LaTeX!");
		_g_free0 (title);
		title = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("GNOME LaTeX Finance");
		_g_free0 (title);
		title = _tmp2_;
	}
	_tmp3_ = title;
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp3_, parent_window, GTK_DIALOG_DESTROY_WITH_PARENT, "_Close", GTK_RESPONSE_CLOSE, "GNOME LaTeX _Fundraising", GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	_tmp5_ = dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp5_, FALSE);
	_tmp6_ = dialog;
	gtk_dialog_set_default_response (_tmp6_, (gint) GTK_RESPONSE_ACCEPT);
	_tmp7_ = dialog;
	_tmp8_ = gtk_dialog_get_content_area (_tmp7_);
	content_area = _tmp8_;
	_tmp9_ = content_area;
	gtk_box_set_spacing (_tmp9_, 6);
	_tmp10_ = content_area;
	g_object_set ((GtkWidget*) _tmp10_, "margin", 12, NULL);
	_tmp11_ = content_area;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 6);
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("gnome-latex", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp12_);
	image = _tmp12_;
	_tmp13_ = image;
	gtk_image_set_pixel_size (_tmp13_, 128);
	_tmp14_ = content_area;
	_tmp15_ = image;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp16_);
	label = _tmp16_;
	_tmp17_ = label;
	gtk_label_set_markup (_tmp17_, "<big>Did you know...</big>");
	_tmp18_ = content_area;
	_tmp19_ = label;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = (GtkLabel*) gtk_label_new ("...that you can support GNOME LaTeX financially?");
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (label);
	label = _tmp20_;
	_tmp21_ = content_area;
	_tmp22_ = label;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (label);
	label = _tmp23_;
	_tmp24_ = label;
	gtk_label_set_markup (_tmp24_, "GNOME LaTeX is a Free/<i>Libre</i> LaTeX editor and comes" " free of charge. But if you appreciate this software, you are encourag" \
"ed" " to make a donation to help its future development.");
	_tmp25_ = label;
	gtk_label_set_max_width_chars (_tmp25_, 60);
	_tmp26_ = label;
	gtk_label_set_line_wrap (_tmp26_, TRUE);
	_tmp27_ = label;
	gtk_label_set_xalign (_tmp27_, (gfloat) 0);
	_tmp28_ = content_area;
	_tmp29_ = label;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	if (startup) {
		GtkLabel* _tmp30_;
		GtkLabel* _tmp31_;
		GtkLabel* _tmp32_;
		GtkLabel* _tmp33_;
		GtkBox* _tmp34_;
		GtkLabel* _tmp35_;
		_tmp30_ = (GtkLabel*) gtk_label_new ("You can see again this information at any time by going to the Help me" \
"nu.");
		g_object_ref_sink (_tmp30_);
		_g_object_unref0 (label);
		label = _tmp30_;
		_tmp31_ = label;
		gtk_label_set_max_width_chars (_tmp31_, 60);
		_tmp32_ = label;
		gtk_label_set_line_wrap (_tmp32_, TRUE);
		_tmp33_ = label;
		gtk_label_set_xalign (_tmp33_, (gfloat) 0);
		_tmp34_ = content_area;
		_tmp35_ = label;
		gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	}
	_tmp36_ = (GtkLabel*) gtk_label_new ("Thanks!");
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (label);
	label = _tmp36_;
	_tmp37_ = label;
	gtk_label_set_xalign (_tmp37_, (gfloat) 0);
	_tmp38_ = content_area;
	_tmp39_ = label;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic ("_Remind me later (in one month)");
	g_object_ref_sink (_tmp40_);
	remind_later_checkbutton = _tmp40_;
	_tmp41_ = remind_later_checkbutton;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp41_, FALSE);
	_tmp42_ = remind_later_checkbutton;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp42_, 12);
	_tmp43_ = remind_later_checkbutton;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp43_, 6);
	_tmp44_ = content_area;
	_tmp45_ = remind_later_checkbutton;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp46_);
	while (TRUE) {
		gint response = 0;
		GtkDialog* _tmp47_;
		gint _tmp48_;
		GSettings* settings = NULL;
		GSettings* _tmp50_;
		GSettings* _tmp51_;
		GtkCheckButton* _tmp52_;
		_tmp47_ = dialog;
		response = gtk_dialog_run (_tmp47_);
		_tmp48_ = response;
		if (_tmp48_ == ((gint) GTK_RESPONSE_ACCEPT)) {
			GtkDialog* _tmp49_;
			_tmp49_ = dialog;
			finance_open_donate_page ((GtkWidget*) _tmp49_);
			continue;
		}
		_tmp50_ = g_settings_new ("org.gnome.gnome-latex.state.dialogs.finance");
		settings = _tmp50_;
		_tmp51_ = settings;
		_tmp52_ = remind_later_checkbutton;
		g_settings_set_boolean (_tmp51_, "remind-later", gtk_toggle_button_get_active ((GtkToggleButton*) _tmp52_));
		_g_object_unref0 (settings);
		break;
	}
	_tmp53_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp53_);
	finance_save_date ();
	_g_object_unref0 (remind_later_checkbutton);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (dialog);
	_g_free0 (title);
}


gboolean
finance_should_show_dialog_on_startup (void)
{
	gboolean result = FALSE;
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gchar* date = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GSettings* _tmp4_;
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.dialogs.finance");
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "last-shown-date");
	date = _tmp2_;
	_tmp3_ = date;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		result = TRUE;
		_g_free0 (date);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp4_ = settings;
	if (g_settings_get_boolean (_tmp4_, "remind-later")) {
		gchar** ymd = NULL;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint ymd_length1;
		gint _ymd_size_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint year = 0;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gint month = 0;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gint day = 0;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		GDateTime* last_time = NULL;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		GDateTime* _tmp18_;
		GDateTime* cur_time = NULL;
		GDateTime* _tmp19_;
		GDateTime* time_limit = NULL;
		GDateTime* _tmp20_;
		GDateTime* _tmp21_;
		GDateTime* _tmp22_;
		GDateTime* _tmp23_;
		_tmp5_ = date;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "-", 0);
		ymd = _tmp7_;
		ymd_length1 = _vala_array_length (_tmp6_);
		_ymd_size_ = ymd_length1;
		_tmp8_ = ymd;
		_tmp8__length1 = ymd_length1;
		if (_tmp8__length1 != 3) {
			result = FALSE;
			ymd = (_vala_array_free (ymd, ymd_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (date);
			_g_object_unref0 (settings);
			return result;
		}
		_tmp9_ = ymd;
		_tmp9__length1 = ymd_length1;
		_tmp10_ = _tmp9_[0];
		year = atoi (_tmp10_);
		_tmp11_ = ymd;
		_tmp11__length1 = ymd_length1;
		_tmp12_ = _tmp11_[1];
		month = atoi (_tmp12_);
		_tmp13_ = ymd;
		_tmp13__length1 = ymd_length1;
		_tmp14_ = _tmp13_[2];
		day = atoi (_tmp14_);
		_tmp15_ = year;
		_tmp16_ = month;
		_tmp17_ = day;
		_tmp18_ = g_date_time_new_utc (_tmp15_, _tmp16_, _tmp17_, 0, 0, (gdouble) 0);
		last_time = _tmp18_;
		_tmp19_ = g_date_time_new_now_utc ();
		cur_time = _tmp19_;
		_tmp20_ = last_time;
		_tmp21_ = g_date_time_add_months (_tmp20_, 1);
		time_limit = _tmp21_;
		_tmp22_ = time_limit;
		_tmp23_ = cur_time;
		if (g_date_time_compare (_tmp22_, _tmp23_) <= 0) {
			result = TRUE;
			_g_date_time_unref0 (time_limit);
			_g_date_time_unref0 (cur_time);
			_g_date_time_unref0 (last_time);
			ymd = (_vala_array_free (ymd, ymd_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (date);
			_g_object_unref0 (settings);
			return result;
		}
		_g_date_time_unref0 (time_limit);
		_g_date_time_unref0 (cur_time);
		_g_date_time_unref0 (last_time);
		ymd = (_vala_array_free (ymd, ymd_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	_g_free0 (date);
	_g_object_unref0 (settings);
	return result;
}


void
finance_save_date (void)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GDateTime* time = NULL;
	GDateTime* _tmp1_;
	gchar* date = NULL;
	gchar* _tmp2_;
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.dialogs.finance");
	settings = _tmp0_;
	_tmp1_ = g_date_time_new_now_utc ();
	time = _tmp1_;
	_tmp2_ = g_strdup_printf ("%d-%d-%d", g_date_time_get_year (time), g_date_time_get_month (time), g_date_time_get_day_of_month (time));
	date = _tmp2_;
	g_settings_set_string (settings, "last-shown-date", date);
	_g_free0 (date);
	_g_date_time_unref0 (time);
	_g_object_unref0 (settings);
}


void
finance_open_donate_page (GtkWidget* widget)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (widget != NULL);
	{
		gchar* uri = NULL;
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("https://liberapay.com/GNOME-LaTeX/");
		uri = _tmp0_;
		latexila_utils_show_uri (widget, uri, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (uri);
			goto __catch25_g_error;
		}
		_g_free0 (uri);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("finance.vala:168: Impossible to open the donate page: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



