/* main_window_build_tools.c generated by valac 0.39.2.21-6056, the Vala compiler
 * generated from main_window_build_tools.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012, 2014 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <amtk/amtk.h>
#include <tepl/tepl.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;
typedef struct _MainWindowBuildToolsPrivate MainWindowBuildToolsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;
enum  {
	MAIN_WINDOW_BUILD_TOOLS_0_PROPERTY,
	MAIN_WINDOW_BUILD_TOOLS_NUM_PROPERTIES
};
static GParamSpec* main_window_build_tools_properties[MAIN_WINDOW_BUILD_TOOLS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block22Data Block22Data;
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _ParamSpecMainWindowBuildTools ParamSpecMainWindowBuildTools;

struct _MainWindowBuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowBuildToolsPrivate * priv;
};

struct _MainWindowBuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowBuildTools *self);
};

struct _MainWindowBuildToolsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	LatexilaBuildView* _build_view;
	BottomPanel* _bottom_panel;
	GCancellable* _cancellable;
	GAsyncResult* _build_tool_result;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _dynamic_action_group;
	guint _menu_ui_id;
};

struct _Block22Data {
	int _ref_count_;
	MainWindowBuildTools* self;
	LatexilaBuildTool* tool;
};

struct _ParamSpecMainWindowBuildTools {
	GParamSpec parent_instance;
};


static gpointer main_window_build_tools_parent_class = NULL;

gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name, 
                                                const gchar* nick, 
                                                const gchar* blurb, 
                                                GType object_type, 
                                                GParamFlags flags);
void value_set_main_window_build_tools (GValue* value, 
                                        gpointer v_object);
void value_take_main_window_build_tools (GValue* value, 
                                         gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType bottom_panel_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsPrivate))
void main_window_build_tools_on_clean (MainWindowBuildTools* self);
static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, 
                                                            gpointer self);
void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self);
static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, 
                                                                     gpointer self);
void main_window_build_tools_on_view_log (MainWindowBuildTools* self);
static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, 
                                                               gpointer self);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, 
                                                   GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type, 
                                                         MainWindow* main_window, 
                                                         GtkUIManager* ui_manager);
GType latexila_app_get_type (void) G_GNUC_CONST;
LatexilaApp* latexila_app_get_instance (void);
static void main_window_build_tools_update_menu (MainWindowBuildTools* self);
static void __lambda29_ (MainWindowBuildTools* self);
static void ___lambda29__latexila_build_tools_modified (LatexilaBuildTools* _sender, 
                                                 gpointer self);
static void __lambda30_ (MainWindowBuildTools* self);
static void ___lambda30__latexila_build_tools_loaded (LatexilaBuildTools* _sender, 
                                               gpointer self);
static void __lambda31_ (MainWindowBuildTools* self);
static void ___lambda31__latexila_build_tools_modified (LatexilaBuildTools* _sender, 
                                                 gpointer self);
static void __lambda32_ (MainWindowBuildTools* self);
static void ___lambda32__latexila_build_tools_loaded (LatexilaBuildTools* _sender, 
                                               gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self, 
                                             LatexilaBuildView* build_view);
static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self);
static void __lambda33_ (MainWindowBuildTools* self, 
                  GFile* file, 
                  gint start_line, 
                  gint end_line);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, 
                                        GFile* location, 
                                        gboolean jump_to);
void main_window_jump_to_file_position (MainWindow* self, 
                                        GFile* file, 
                                        gint start_line, 
                                        gint end_line);
static void ___lambda33__latexila_build_view_jump_to_file (LatexilaBuildView* _sender, 
                                                    GFile* file, 
                                                    gint start_line, 
                                                    gint end_line, 
                                                    gpointer self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self, 
                                               BottomPanel* bottom_panel);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_is_main_file_a_tex_file (Document* self);
static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, 
                                                            gint tool_num);
static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, 
                                                            LatexilaBuildTool* tool, 
                                                            const gchar* action_name);
static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, 
                                                             gint tool_num);
static LatexilaBuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, 
                                                                     const gchar* action_name);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static gboolean _vala_string_array_contains (gchar* * stack, 
                                      int stack_length, 
                                      gchar* needle);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, 
                                                      GtkAction* action);
static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, 
                                                                           gpointer self);
static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, 
                                                 LatexilaBuildTool* build_tool, 
                                                 const gchar* action_name, 
                                                 gint* accel_num);
static void main_window_build_tools_add_separator (MainWindowBuildTools* self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
gboolean document_set_tmp_location (Document* self);
gint document_get_project_id (Document* self);
void document_save (Document* self, 
                    gboolean check_file_changed_on_disk, 
                    gboolean force);
GeeList* latexila_app_get_documents (LatexilaApp* self);
void utils_flush_queue (void);
static void __lambda28_ (Block22Data* _data22_, 
                  GObject* obj, 
                  GAsyncResult* _result_);
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name, 
                                              const gchar* nick, 
                                              const gchar* blurb, 
                                              GType object_type, 
                                              GParamFlags flags);
void value_set_main_window_structure (GValue* value, 
                                      gpointer v_object);
void value_take_main_window_structure (GValue* value, 
                                       gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
void main_window_structure_refresh (MainWindowStructure* self);
static void ___lambda28__gasync_ready_callback (GObject* source_object, 
                                         GAsyncResult* res, 
                                         gpointer self);
GType clean_build_files_get_type (void) G_GNUC_CONST;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, 
                                        Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, 
                                              MainWindow* main_window, 
                                              Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
Document* document_tab_get_document (DocumentTab* self);
void document_set_readonly (Document* self, 
                            gboolean value);
static void main_window_build_tools_finalize (MainWindowBuildTools * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW_BUILD_TOOLS__action_entries[5] = {{"Build", NULL, N_ ("_Build")}, {"BuildClean", "edit-clear-all", N_ ("Cleanup Build _Files"), NULL, N_ ("Clean-up build files (*.aux, *.log, *.out, *.toc, etc)"), (GCallback) _main_window_build_tools_on_clean_gtk_action_callback}, {"BuildStopExecution", "process-stop", N_ ("_Stop Execution"), NULL, N_ ("Stop Execution"), (GCallback) _main_window_build_tools_on_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", N_ ("View _Log"), NULL, N_ ("View Log"), (GCallback) _main_window_build_tools_on_view_log_gtk_action_callback}, {"BuildToolsPreferences", "preferences-system", N_ ("_Manage Build Tools"), NULL, N_ ("Manage Build Tools")}};
static const GtkToggleActionEntry MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries[3] = {{"BuildShowDetails", "zoom-in", N_ ("Show _Details"), NULL, N_ ("Show Details"), (GCallback) NULL}, {"BuildShowWarnings", "dialog-warning", N_ ("Show _Warnings"), NULL, N_ ("Show Warnings"), (GCallback) NULL}, {"BuildShowBadBoxes", "badbox", N_ ("Show _Bad Boxes"), NULL, N_ ("Show Bad Boxes"), (GCallback) NULL}};

static void
_main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, 
                                                       gpointer self)
{
	main_window_build_tools_on_clean ((MainWindowBuildTools*) self);
}


static void
_main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, 
                                                                gpointer self)
{
	main_window_build_tools_on_stop_execution ((MainWindowBuildTools*) self);
}


static void
_main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, 
                                                          gpointer self)
{
	main_window_build_tools_on_view_log ((MainWindowBuildTools*) self);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda29_ (MainWindowBuildTools* self)
{
	main_window_build_tools_update_menu (self);
}


static void
___lambda29__latexila_build_tools_modified (LatexilaBuildTools* _sender, 
                                            gpointer self)
{
	__lambda29_ ((MainWindowBuildTools*) self);
}


static void
__lambda30_ (MainWindowBuildTools* self)
{
	main_window_build_tools_update_menu (self);
}


static void
___lambda30__latexila_build_tools_loaded (LatexilaBuildTools* _sender, 
                                          gpointer self)
{
	__lambda30_ ((MainWindowBuildTools*) self);
}


static void
__lambda31_ (MainWindowBuildTools* self)
{
	main_window_build_tools_update_menu (self);
}


static void
___lambda31__latexila_build_tools_modified (LatexilaBuildTools* _sender, 
                                            gpointer self)
{
	__lambda31_ ((MainWindowBuildTools*) self);
}


static void
__lambda32_ (MainWindowBuildTools* self)
{
	main_window_build_tools_update_menu (self);
}


static void
___lambda32__latexila_build_tools_loaded (LatexilaBuildTools* _sender, 
                                          gpointer self)
{
	__lambda32_ ((MainWindowBuildTools*) self);
}


MainWindowBuildTools*
main_window_build_tools_construct (GType object_type, 
                                   MainWindow* main_window, 
                                   GtkUIManager* ui_manager)
{
	MainWindowBuildTools* self = NULL;
	GtkUIManager* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkAction* stop_exec = NULL;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkAction* _tmp7_;
	GtkActionGroup* _tmp8_;
	LatexilaApp* app = NULL;
	LatexilaApp* _tmp9_;
	GtkActionGroup* _tmp10_;
	GtkActionGroup* _tmp11_;
	GtkActionGroup* _tmp12_;
	LatexilaBuildToolsPersonal* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_;
	LatexilaBuildToolsPersonal* _tmp14_;
	LatexilaBuildToolsDefault* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp15_;
	LatexilaBuildToolsDefault* _tmp16_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (MainWindowBuildTools*) g_type_create_instance (object_type);
	self->priv->_main_window = main_window;
	_tmp0_ = _g_object_ref0 (ui_manager);
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp0_;
	_tmp1_ = gtk_action_group_new ("BuildMenuActionGroup");
	_g_object_unref0 (self->priv->_static_action_group);
	self->priv->_static_action_group = _tmp1_;
	_tmp2_ = self->priv->_static_action_group;
	gtk_action_group_set_translation_domain (_tmp2_, GETTEXT_PACKAGE);
	_tmp3_ = self->priv->_static_action_group;
	gtk_action_group_add_actions (_tmp3_, MAIN_WINDOW_BUILD_TOOLS__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__action_entries), self);
	_tmp4_ = self->priv->_static_action_group;
	gtk_action_group_add_toggle_actions (_tmp4_, MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries), self);
	_tmp5_ = self->priv->_static_action_group;
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "BuildStopExecution");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	stop_exec = _tmp7_;
	gtk_action_set_sensitive (stop_exec, FALSE);
	_tmp8_ = self->priv->_static_action_group;
	gtk_ui_manager_insert_action_group (ui_manager, _tmp8_, 0);
	_tmp9_ = latexila_app_get_instance ();
	app = _tmp9_;
	_tmp10_ = self->priv->_static_action_group;
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "manage-build-tools", _tmp10_, "BuildToolsPreferences");
	_tmp11_ = gtk_action_group_new ("BuildToolsActions");
	_g_object_unref0 (self->priv->_dynamic_action_group);
	self->priv->_dynamic_action_group = _tmp11_;
	_tmp12_ = self->priv->_dynamic_action_group;
	gtk_ui_manager_insert_action_group (ui_manager, _tmp12_, 0);
	main_window_build_tools_update_menu (self);
	_tmp13_ = latexila_build_tools_personal_get_instance ();
	_tmp14_ = _g_object_ref0 (_tmp13_);
	personal_build_tools = _tmp14_;
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "modified", (GCallback) ___lambda29__latexila_build_tools_modified, self);
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "loaded", (GCallback) ___lambda30__latexila_build_tools_loaded, self);
	_tmp15_ = latexila_build_tools_default_get_instance ();
	_tmp16_ = _g_object_ref0 (_tmp15_);
	default_build_tools = _tmp16_;
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "modified", (GCallback) ___lambda31__latexila_build_tools_modified, self);
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "loaded", (GCallback) ___lambda32__latexila_build_tools_loaded, self);
	_g_object_unref0 (default_build_tools);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (app);
	_g_object_unref0 (stop_exec);
	return self;
}


MainWindowBuildTools*
main_window_build_tools_new (MainWindow* main_window, 
                             GtkUIManager* ui_manager)
{
	return main_window_build_tools_construct (TYPE_MAIN_WINDOW_BUILD_TOOLS, main_window, ui_manager);
}


static void
__lambda33_ (MainWindowBuildTools* self, 
             GFile* file, 
             gint start_line, 
             gint end_line)
{
	g_return_if_fail (file != NULL);
	if (start_line == -1) {
		MainWindow* _tmp0_;
		DocumentTab* _tmp1_;
		DocumentTab* _tmp2_;
		_tmp0_ = self->priv->_main_window;
		_tmp1_ = main_window_open_document (_tmp0_, file, TRUE);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
	} else {
		MainWindow* _tmp3_;
		_tmp3_ = self->priv->_main_window;
		main_window_jump_to_file_position (_tmp3_, file, start_line, end_line);
	}
}


static void
___lambda33__latexila_build_view_jump_to_file (LatexilaBuildView* _sender, 
                                               GFile* file, 
                                               gint start_line, 
                                               gint end_line, 
                                               gpointer self)
{
	__lambda33_ ((MainWindowBuildTools*) self, file, start_line, end_line);
}


void
main_window_build_tools_set_build_view (MainWindowBuildTools* self, 
                                        LatexilaBuildView* build_view)
{
	LatexilaBuildView* _tmp0_;
	LatexilaBuildView* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_view != NULL);
	_tmp0_ = _g_object_ref0 (build_view);
	_g_object_unref0 (self->priv->_build_view);
	self->priv->_build_view = _tmp0_;
	main_window_build_tools_connect_toggle_actions (self);
	_tmp1_ = self->priv->_build_view;
	g_signal_connect (_tmp1_, "jump-to-file", (GCallback) ___lambda33__latexila_build_view_jump_to_file, self);
}


void
main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self, 
                                          BottomPanel* bottom_panel)
{
	BottomPanel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bottom_panel != NULL);
	_tmp0_ = _g_object_ref0 (bottom_panel);
	_g_object_unref0 (self->priv->_bottom_panel);
	self->priv->_bottom_panel = _tmp0_;
}


void
main_window_build_tools_update_sensitivity (MainWindowBuildTools* self)
{
	gboolean build_tool_is_running = FALSE;
	GCancellable* _tmp0_;
	GtkAction* stop_exec_action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	gboolean _tmp5_;
	LatexilaApp* app = NULL;
	LatexilaApp* _tmp6_;
	GSimpleAction* preferences_action = NULL;
	LatexilaApp* _tmp7_;
	GAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	gboolean _tmp11_;
	GtkAction* clean_action = NULL;
	GtkActionGroup* _tmp12_;
	GtkAction* _tmp13_;
	GtkAction* _tmp14_;
	GtkAction* view_log_action = NULL;
	GtkActionGroup* _tmp15_;
	GtkAction* _tmp16_;
	GtkAction* _tmp17_;
	MainWindow* _tmp18_;
	DocumentTab* _tmp19_;
	DocumentTab* _tmp20_;
	gboolean is_tex = FALSE;
	MainWindow* _tmp24_;
	Document* _tmp25_;
	Document* _tmp26_;
	GtkAction* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GtkActionGroup* _tmp32_;
	GtkAction* _tmp33_;
	gboolean _tmp34_;
	LatexilaBuildTools* build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp35_;
	LatexilaBuildTools* _tmp36_;
	gint tool_num = 0;
	LatexilaBuildTools* _tmp37_;
	GList* _tmp38_;
	LatexilaBuildToolsPersonal* _tmp45_;
	LatexilaBuildTools* _tmp46_;
	LatexilaBuildTools* _tmp47_;
	GList* _tmp48_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cancellable;
	build_tool_is_running = _tmp0_ != NULL;
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildStopExecution");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	stop_exec_action = _tmp3_;
	_tmp4_ = stop_exec_action;
	_tmp5_ = build_tool_is_running;
	gtk_action_set_sensitive (_tmp4_, _tmp5_);
	_tmp6_ = latexila_app_get_instance ();
	app = _tmp6_;
	_tmp7_ = app;
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) _tmp7_, "manage-build-tools");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
	preferences_action = _tmp9_;
	_tmp10_ = preferences_action;
	_tmp11_ = build_tool_is_running;
	g_simple_action_set_enabled (_tmp10_, !_tmp11_);
	_tmp12_ = self->priv->_static_action_group;
	_tmp13_ = gtk_action_group_get_action (_tmp12_, "BuildClean");
	_tmp14_ = _g_object_ref0 (_tmp13_);
	clean_action = _tmp14_;
	_tmp15_ = self->priv->_static_action_group;
	_tmp16_ = gtk_action_group_get_action (_tmp15_, "BuildViewLog");
	_tmp17_ = _g_object_ref0 (_tmp16_);
	view_log_action = _tmp17_;
	_tmp18_ = self->priv->_main_window;
	_tmp19_ = main_window_get_active_tab (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		GtkActionGroup* _tmp21_;
		GtkAction* _tmp22_;
		GtkAction* _tmp23_;
		_tmp21_ = self->priv->_dynamic_action_group;
		gtk_action_group_set_sensitive (_tmp21_, FALSE);
		_tmp22_ = clean_action;
		gtk_action_set_sensitive (_tmp22_, FALSE);
		_tmp23_ = view_log_action;
		gtk_action_set_sensitive (_tmp23_, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		_g_object_unref0 (preferences_action);
		_g_object_unref0 (app);
		_g_object_unref0 (stop_exec_action);
		return;
	}
	_tmp24_ = self->priv->_main_window;
	_tmp25_ = main_window_get_active_document (_tmp24_);
	_tmp26_ = _tmp25_;
	is_tex = document_is_main_file_a_tex_file (_tmp26_);
	_tmp27_ = view_log_action;
	_tmp28_ = is_tex;
	gtk_action_set_sensitive (_tmp27_, _tmp28_);
	_tmp29_ = build_tool_is_running;
	if (_tmp29_) {
		GtkActionGroup* _tmp30_;
		GtkAction* _tmp31_;
		_tmp30_ = self->priv->_dynamic_action_group;
		gtk_action_group_set_sensitive (_tmp30_, FALSE);
		_tmp31_ = clean_action;
		gtk_action_set_sensitive (_tmp31_, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		_g_object_unref0 (preferences_action);
		_g_object_unref0 (app);
		_g_object_unref0 (stop_exec_action);
		return;
	}
	_tmp32_ = self->priv->_dynamic_action_group;
	gtk_action_group_set_sensitive (_tmp32_, TRUE);
	_tmp33_ = clean_action;
	_tmp34_ = is_tex;
	gtk_action_set_sensitive (_tmp33_, _tmp34_);
	_tmp35_ = latexila_build_tools_default_get_instance ();
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp35_) : NULL);
	build_tools = _tmp36_;
	tool_num = 0;
	_tmp37_ = build_tools;
	_tmp38_ = _tmp37_->build_tools;
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
		tool_collection = _tmp38_;
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
			LatexilaBuildTool* _tmp39_;
			LatexilaBuildTool* tool = NULL;
			_tmp39_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
			tool = _tmp39_;
			{
				gchar* action_name = NULL;
				gint _tmp40_;
				gchar* _tmp41_;
				LatexilaBuildTool* _tmp42_;
				const gchar* _tmp43_;
				gint _tmp44_;
				_tmp40_ = tool_num;
				_tmp41_ = main_window_build_tools_get_default_build_tool_name (self, _tmp40_);
				action_name = _tmp41_;
				_tmp42_ = tool;
				_tmp43_ = action_name;
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp42_, _tmp43_);
				_tmp44_ = tool_num;
				tool_num = _tmp44_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (tool);
			}
		}
	}
	_tmp45_ = latexila_build_tools_personal_get_instance ();
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp45_) : NULL);
	_g_object_unref0 (build_tools);
	build_tools = _tmp46_;
	tool_num = 0;
	_tmp47_ = build_tools;
	_tmp48_ = _tmp47_->build_tools;
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
		tool_collection = _tmp48_;
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
			LatexilaBuildTool* _tmp49_;
			LatexilaBuildTool* tool = NULL;
			_tmp49_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
			tool = _tmp49_;
			{
				gchar* action_name = NULL;
				gint _tmp50_;
				gchar* _tmp51_;
				LatexilaBuildTool* _tmp52_;
				const gchar* _tmp53_;
				gint _tmp54_;
				_tmp50_ = tool_num;
				_tmp51_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp50_);
				action_name = _tmp51_;
				_tmp52_ = tool;
				_tmp53_ = action_name;
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp52_, _tmp53_);
				_tmp54_ = tool_num;
				tool_num = _tmp54_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (tool);
			}
		}
	}
	_g_object_unref0 (build_tools);
	_g_object_unref0 (view_log_action);
	_g_object_unref0 (clean_action);
	_g_object_unref0 (preferences_action);
	_g_object_unref0 (app);
	_g_object_unref0 (stop_exec_action);
}


static gchar*
main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, 
                                                     gint tool_num)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", tool_num);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("DefaultBuildTool_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static gchar*
main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, 
                                                      gint tool_num)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", tool_num);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("PersonalBuildTool_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static LatexilaBuildTool*
main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, 
                                                  const gchar* action_name)
{
	LatexilaBuildTool* result = NULL;
	LatexilaBuildTools* build_tools = NULL;
	gchar** name = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint name_length1;
	gint _name_size_;
	gint tool_num = 0;
	const gchar* _tmp6_;
	LatexilaBuildTools* _tmp7_;
	LatexilaBuildTool* _tmp8_;
	LatexilaBuildTool* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	if (g_str_has_prefix (action_name, "DefaultBuildTool_")) {
		LatexilaBuildToolsDefault* _tmp0_;
		LatexilaBuildTools* _tmp1_;
		_tmp0_ = latexila_build_tools_default_get_instance ();
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
		_g_object_unref0 (build_tools);
		build_tools = _tmp1_;
	} else {
		if (g_str_has_prefix (action_name, "PersonalBuildTool_")) {
			LatexilaBuildToolsPersonal* _tmp2_;
			LatexilaBuildTools* _tmp3_;
			_tmp2_ = latexila_build_tools_personal_get_instance ();
			_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp2_) : NULL);
			_g_object_unref0 (build_tools);
			build_tools = _tmp3_;
		} else {
			g_return_val_if_reached (NULL);
		}
	}
	_tmp5_ = _tmp4_ = g_strsplit (action_name, "_", 0);
	name = _tmp5_;
	name_length1 = _vala_array_length (_tmp4_);
	_name_size_ = name_length1;
	g_return_val_if_fail (name_length1 == 2, NULL);
	_tmp6_ = name[1];
	tool_num = atoi (_tmp6_);
	_tmp7_ = build_tools;
	_tmp8_ = latexila_build_tools_nth (_tmp7_, (guint) tool_num);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	result = _tmp9_;
	name = (_vala_array_free (name, name_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (build_tools);
	return result;
}


static gboolean
_vala_string_array_contains (gchar* * stack, 
                             int stack_length, 
                             gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void
main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, 
                                                       LatexilaBuildTool* tool, 
                                                       const gchar* action_name)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	Document* active_doc = NULL;
	MainWindow* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	gboolean unsaved_doc = FALSE;
	Document* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gboolean _tmp12_;
	gchar* path = NULL;
	Document* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* ext = NULL;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** extensions = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gint extensions_length1;
	gint _extensions_size_;
	gboolean _tmp28_ = FALSE;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	gboolean sensitive = FALSE;
	GtkAction* _tmp37_;
	gboolean _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	g_return_if_fail (action_name != NULL);
	g_object_get (tool, "enabled", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->_dynamic_action_group;
	_tmp3_ = gtk_action_group_get_action (_tmp2_, action_name);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	action = _tmp4_;
	_tmp5_ = self->priv->_main_window;
	_tmp6_ = main_window_get_active_document (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	active_doc = _tmp8_;
	_tmp9_ = active_doc;
	_tmp10_ = document_get_location (_tmp9_);
	_tmp11_ = _tmp10_;
	unsaved_doc = _tmp11_ == NULL;
	_tmp12_ = unsaved_doc;
	if (_tmp12_) {
		GtkAction* _tmp13_;
		GList* _tmp14_;
		_tmp13_ = action;
		_tmp14_ = latexila_build_tool_get_jobs (tool);
		gtk_action_set_sensitive (_tmp13_, _tmp14_ != NULL);
		_g_object_unref0 (active_doc);
		_g_object_unref0 (action);
		return;
	}
	_tmp15_ = active_doc;
	_tmp16_ = document_get_main_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_get_parse_name (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp17_);
	path = _tmp19_;
	_tmp20_ = path;
	_tmp21_ = latexila_utils_get_extension (_tmp20_);
	ext = _tmp21_;
	g_object_get (tool, "extensions", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, " ", 0);
	_tmp27_ = _tmp26_;
	_tmp27__length1 = _vala_array_length (_tmp25_);
	_g_free0 (_tmp24_);
	extensions = _tmp27_;
	extensions_length1 = _tmp27__length1;
	_extensions_size_ = extensions_length1;
	g_object_get (tool, "extensions", &_tmp29_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp32_ = strlen (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_ == 0;
	_g_free0 (_tmp31_);
	if (_tmp34_) {
		_tmp28_ = TRUE;
	} else {
		const gchar* _tmp35_;
		gchar** _tmp36_;
		gint _tmp36__length1;
		_tmp35_ = ext;
		_tmp36_ = extensions;
		_tmp36__length1 = extensions_length1;
		_tmp28_ = _vala_string_array_contains (_tmp36_, _tmp36__length1, _tmp35_);
	}
	sensitive = _tmp28_;
	_tmp37_ = action;
	_tmp38_ = sensitive;
	gtk_action_set_sensitive (_tmp37_, _tmp38_);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ext);
	_g_free0 (path);
	_g_object_unref0 (active_doc);
	_g_object_unref0 (action);
}


void
main_window_build_tools_save_state (MainWindowBuildTools* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildShowWarnings");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action = _tmp3_;
	_tmp4_ = action;
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (settings, "show-build-warnings", _tmp6_);
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowBadBoxes");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	_tmp11_ = gtk_toggle_action_get_active (_tmp10_);
	_tmp12_ = _tmp11_;
	g_settings_set_boolean (settings, "show-build-badboxes", _tmp12_);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


static void
_main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, 
                                                                      gpointer self)
{
	main_window_build_tools_activate_dynamic_action ((MainWindowBuildTools*) self, _sender);
}


static void
main_window_build_tools_update_menu (MainWindowBuildTools* self)
{
	GtkActionGroup* _tmp0_;
	guint _tmp1_;
	GtkActionGroup* _tmp4_;
	GList* _tmp5_;
	LatexilaBuildTools* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp11_;
	LatexilaBuildTools* _tmp12_;
	LatexilaBuildTools* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_;
	LatexilaBuildTools* _tmp14_;
	gboolean _tmp15_ = FALSE;
	LatexilaBuildTools* _tmp16_;
	GList* _tmp17_;
	GtkUIManager* _tmp20_;
	gint tool_num = 0;
	gint accel_num = 0;
	LatexilaBuildTools* _tmp21_;
	GList* _tmp22_;
	LatexilaBuildTools* _tmp29_;
	GList* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dynamic_action_group;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_menu_ui_id;
	if (_tmp1_ != ((guint) 0)) {
		GtkUIManager* _tmp2_;
		guint _tmp3_;
		_tmp2_ = self->priv->_ui_manager;
		_tmp3_ = self->priv->_menu_ui_id;
		gtk_ui_manager_remove_ui (_tmp2_, _tmp3_);
	}
	_tmp4_ = self->priv->_dynamic_action_group;
	_tmp5_ = gtk_action_group_list_actions (_tmp4_);
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp5_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp6_;
			GtkAction* action = NULL;
			_tmp6_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp6_;
			{
				GtkAction* _tmp7_;
				guint _tmp8_;
				GtkActionGroup* _tmp9_;
				GtkAction* _tmp10_;
				_tmp7_ = action;
				g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp8_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
				_tmp9_ = self->priv->_dynamic_action_group;
				_tmp10_ = action;
				gtk_action_group_remove_action (_tmp9_, _tmp10_);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	_tmp11_ = latexila_build_tools_default_get_instance ();
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp11_) : NULL);
	default_build_tools = _tmp12_;
	_tmp13_ = latexila_build_tools_personal_get_instance ();
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp13_) : NULL);
	personal_build_tools = _tmp14_;
	_tmp16_ = default_build_tools;
	_tmp17_ = _tmp16_->build_tools;
	if (_tmp17_ == NULL) {
		LatexilaBuildTools* _tmp18_;
		GList* _tmp19_;
		_tmp18_ = personal_build_tools;
		_tmp19_ = _tmp18_->build_tools;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		self->priv->_menu_ui_id = (guint) 0;
		_g_object_unref0 (personal_build_tools);
		_g_object_unref0 (default_build_tools);
		return;
	}
	_tmp20_ = self->priv->_ui_manager;
	self->priv->_menu_ui_id = gtk_ui_manager_new_merge_id (_tmp20_);
	tool_num = 0;
	accel_num = 2;
	_tmp21_ = default_build_tools;
	_tmp22_ = _tmp21_->build_tools;
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
		build_tool_collection = _tmp22_;
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
			LatexilaBuildTool* _tmp23_;
			LatexilaBuildTool* build_tool = NULL;
			_tmp23_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
			build_tool = _tmp23_;
			{
				gchar* action_name = NULL;
				gint _tmp24_;
				gchar* _tmp25_;
				LatexilaBuildTool* _tmp26_;
				const gchar* _tmp27_;
				gint _tmp28_;
				_tmp24_ = tool_num;
				_tmp25_ = main_window_build_tools_get_default_build_tool_name (self, _tmp24_);
				action_name = _tmp25_;
				_tmp26_ = build_tool;
				_tmp27_ = action_name;
				main_window_build_tools_add_dynamic_action (self, _tmp26_, _tmp27_, &accel_num);
				_tmp28_ = tool_num;
				tool_num = _tmp28_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (build_tool);
			}
		}
	}
	main_window_build_tools_add_separator (self);
	tool_num = 0;
	_tmp29_ = personal_build_tools;
	_tmp30_ = _tmp29_->build_tools;
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
		build_tool_collection = _tmp30_;
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
			LatexilaBuildTool* _tmp31_;
			LatexilaBuildTool* build_tool = NULL;
			_tmp31_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
			build_tool = _tmp31_;
			{
				gchar* action_name = NULL;
				gint _tmp32_;
				gchar* _tmp33_;
				LatexilaBuildTool* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				_tmp32_ = tool_num;
				_tmp33_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp32_);
				action_name = _tmp33_;
				_tmp34_ = build_tool;
				_tmp35_ = action_name;
				main_window_build_tools_add_dynamic_action (self, _tmp34_, _tmp35_, &accel_num);
				_tmp36_ = tool_num;
				tool_num = _tmp36_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (build_tool);
			}
		}
	}
	main_window_build_tools_update_sensitivity (self);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (default_build_tools);
}


static void
main_window_build_tools_add_separator (MainWindowBuildTools* self)
{
	GtkUIManager* _tmp0_;
	guint _tmp1_;
	GtkUIManager* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp0_, _tmp1_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp2_, _tmp3_, "/MainToolbar/BuildToolsPlaceholderToolbar", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
}


static void
main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, 
                                            LatexilaBuildTool* build_tool, 
                                            const gchar* action_name, 
                                            gint* accel_num)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkAction* action = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkAction* _tmp6_;
	GtkAction* _tmp7_;
	GtkAction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkAction* _tmp12_;
	gchar* accel = NULL;
	GtkActionGroup* _tmp16_;
	GtkAction* _tmp17_;
	const gchar* _tmp18_;
	GtkAction* _tmp19_;
	GtkUIManager* _tmp20_;
	guint _tmp21_;
	GtkUIManager* _tmp22_;
	guint _tmp23_;
	gint _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tool != NULL);
	g_return_if_fail (action_name != NULL);
	g_object_get (build_tool, "enabled", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	g_object_get (build_tool, "label", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = latexila_build_tool_get_description (build_tool);
	_tmp6_ = gtk_action_new (action_name, _tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	action = _tmp7_;
	_tmp8_ = action;
	g_object_get (build_tool, "icon", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	gtk_action_set_icon_name (_tmp8_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = action;
	gtk_action_set_always_show_image (_tmp12_, TRUE);
	accel = NULL;
	if ((*accel_num) <= 11) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = g_strdup_printf ("%i", *accel_num);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("<Release>F", _tmp14_, NULL);
		_g_free0 (accel);
		accel = _tmp15_;
		_g_free0 (_tmp14_);
	}
	_tmp16_ = self->priv->_dynamic_action_group;
	_tmp17_ = action;
	_tmp18_ = accel;
	gtk_action_group_add_action_with_accel (_tmp16_, _tmp17_, _tmp18_);
	_tmp19_ = action;
	g_signal_connect (_tmp19_, "activate", (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
	_tmp20_ = self->priv->_ui_manager;
	_tmp21_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp20_, _tmp21_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", action_name, action_name, GTK_UI_MANAGER_MENUITEM, FALSE);
	_tmp22_ = self->priv->_ui_manager;
	_tmp23_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp22_, _tmp23_, "/MainToolbar/BuildToolsPlaceholderToolbar", action_name, action_name, GTK_UI_MANAGER_TOOLITEM, FALSE);
	_tmp24_ = *accel_num;
	*accel_num = _tmp24_ + 1;
	_g_free0 (accel);
	_g_object_unref0 (action);
}


static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		MainWindowBuildTools* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->tool);
		_main_window_build_tools_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}


static void
__lambda28_ (Block22Data* _data22_, 
             GObject* obj, 
             GAsyncResult* _result_)
{
	MainWindowBuildTools* self;
	GAsyncResult* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	MainWindow* _tmp2_;
	MainWindowStructure* _tmp3_;
	MainWindowStructure* _tmp4_;
	self = _data22_->self;
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = _g_object_ref0 (_result_);
	_g_object_unref0 (self->priv->_build_tool_result);
	self->priv->_build_tool_result = _tmp0_;
	_tmp1_ = _data22_->tool;
	latexila_build_tool_run_finish (_tmp1_, _result_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = NULL;
	main_window_build_tools_update_sensitivity (self);
	_tmp2_ = self->priv->_main_window;
	_tmp3_ = main_window_get_main_window_structure (_tmp2_);
	_tmp4_ = _tmp3_;
	main_window_structure_refresh (_tmp4_);
	_main_window_structure_unref0 (_tmp4_);
}


static void
___lambda28__gasync_ready_callback (GObject* source_object, 
                                    GAsyncResult* res, 
                                    gpointer self)
{
	__lambda28_ (self, source_object, res);
	block22_data_unref (self);
}


static void
main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, 
                                                 GtkAction* action)
{
	Block22Data* _data22_;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	LatexilaBuildView* _tmp3_;
	BottomPanel* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	LatexilaBuildTool* _tmp8_;
	Document* active_doc = NULL;
	MainWindow* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	LatexilaBuildTool* _tmp13_;
	GList* _tmp14_;
	LatexilaBuildTool* _tmp18_;
	GList* _tmp19_;
	GFile* main_file = NULL;
	Document* _tmp50_;
	GFile* _tmp51_;
	GCancellable* _tmp52_;
	LatexilaBuildTool* _tmp53_;
	LatexilaBuildView* _tmp54_;
	GCancellable* _tmp55_;
	BottomPanel* _tmp56_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = main_window_build_tools_ref (self);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_build_view;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = self->priv->_bottom_panel;
	g_return_if_fail (_tmp4_ != NULL);
	_tmp5_ = gtk_action_get_name (action);
	_tmp6_ = _tmp5_;
	_tmp7_ = main_window_build_tools_get_build_tool_from_name (self, _tmp6_);
	_data22_->tool = _tmp7_;
	_tmp8_ = _data22_->tool;
	g_return_if_fail (_tmp8_ != NULL);
	_tmp9_ = self->priv->_main_window;
	_tmp10_ = main_window_get_active_document (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	active_doc = _tmp12_;
	_tmp13_ = _data22_->tool;
	_tmp14_ = latexila_build_tool_get_jobs (_tmp13_);
	if (_tmp14_ == NULL) {
		Document* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp15_ = active_doc;
		_tmp16_ = document_get_location (_tmp15_);
		_tmp17_ = _tmp16_;
		g_return_if_fail (_tmp17_ != NULL);
	}
	_tmp18_ = _data22_->tool;
	_tmp19_ = latexila_build_tool_get_jobs (_tmp18_);
	if (_tmp19_ != NULL) {
		Document* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		gint project_id = 0;
		Document* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp20_ = active_doc;
		_tmp21_ = document_get_location (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_ == NULL) {
			gboolean tmp_location_set = FALSE;
			Document* _tmp23_;
			gboolean _tmp24_;
			_tmp23_ = active_doc;
			tmp_location_set = document_set_tmp_location (_tmp23_);
			_tmp24_ = tmp_location_set;
			g_return_if_fail (_tmp24_);
		}
		_tmp25_ = active_doc;
		_tmp26_ = document_get_project_id (_tmp25_);
		_tmp27_ = _tmp26_;
		project_id = _tmp27_;
		_tmp28_ = project_id;
		if (_tmp28_ == -1) {
			Document* _tmp29_;
			_tmp29_ = active_doc;
			document_save (_tmp29_, TRUE, FALSE);
		} else {
			GeeList* docs = NULL;
			LatexilaApp* _tmp30_;
			LatexilaApp* _tmp31_;
			GeeList* _tmp32_;
			GeeList* _tmp33_;
			_tmp30_ = latexila_app_get_instance ();
			_tmp31_ = _tmp30_;
			_tmp32_ = latexila_app_get_documents (_tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (_tmp31_);
			docs = _tmp33_;
			{
				GeeList* _doc_list = NULL;
				GeeList* _tmp34_;
				GeeList* _tmp35_;
				gint _doc_size = 0;
				GeeList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _doc_index = 0;
				_tmp34_ = docs;
				_tmp35_ = _g_object_ref0 (_tmp34_);
				_doc_list = _tmp35_;
				_tmp36_ = _doc_list;
				_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
				_tmp38_ = _tmp37_;
				_doc_size = _tmp38_;
				_doc_index = -1;
				while (TRUE) {
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					Document* doc = NULL;
					GeeList* _tmp42_;
					gint _tmp43_;
					gpointer _tmp44_;
					Document* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					_tmp39_ = _doc_index;
					_doc_index = _tmp39_ + 1;
					_tmp40_ = _doc_index;
					_tmp41_ = _doc_size;
					if (!(_tmp40_ < _tmp41_)) {
						break;
					}
					_tmp42_ = _doc_list;
					_tmp43_ = _doc_index;
					_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
					doc = (Document*) _tmp44_;
					_tmp45_ = doc;
					_tmp46_ = document_get_project_id (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = project_id;
					if (_tmp47_ == _tmp48_) {
						Document* _tmp49_;
						_tmp49_ = doc;
						document_save (_tmp49_, TRUE, FALSE);
					}
					_g_object_unref0 (doc);
				}
				_g_object_unref0 (_doc_list);
			}
			_g_object_unref0 (docs);
		}
		utils_flush_queue ();
	}
	_tmp50_ = active_doc;
	_tmp51_ = document_get_main_file (_tmp50_);
	main_file = _tmp51_;
	_tmp52_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp52_;
	_g_object_unref0 (self->priv->_build_tool_result);
	self->priv->_build_tool_result = NULL;
	main_window_build_tools_update_sensitivity (self);
	_tmp53_ = _data22_->tool;
	_tmp54_ = self->priv->_build_view;
	_tmp55_ = self->priv->_cancellable;
	latexila_build_tool_run_async (_tmp53_, main_file, _tmp54_, _tmp55_, ___lambda28__gasync_ready_callback, block22_data_ref (_data22_));
	_tmp56_ = self->priv->_bottom_panel;
	gtk_widget_show ((GtkWidget*) _tmp56_);
	_g_object_unref0 (main_file);
	_g_object_unref0 (active_doc);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}


static void
main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self)
{
	LatexilaBuildView* _tmp0_;
	GSettings* settings = NULL;
	GSettings* _tmp1_;
	GtkToggleAction* action_details = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	LatexilaBuildView* _tmp5_;
	LatexilaBuildView* _tmp6_;
	GtkToggleAction* action_warnings = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	LatexilaBuildView* _tmp10_;
	GtkToggleAction* action_badboxes = NULL;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_;
	GtkToggleAction* _tmp13_;
	LatexilaBuildView* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_view;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
	settings = _tmp1_;
	_tmp2_ = self->priv->_static_action_group;
	_tmp3_ = gtk_action_group_get_action (_tmp2_, "BuildShowDetails");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp3_) : NULL);
	action_details = _tmp4_;
	gtk_toggle_action_set_active (action_details, FALSE);
	_tmp5_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_details, "active", (GObject*) _tmp5_, "show-details", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "has-details", (GObject*) action_details, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowWarnings");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
	action_warnings = _tmp9_;
	gtk_toggle_action_set_active (action_warnings, g_settings_get_boolean (settings, "show-build-warnings"));
	_tmp10_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_warnings, "active", (GObject*) _tmp10_, "show-warnings", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = self->priv->_static_action_group;
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "BuildShowBadBoxes");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp12_) : NULL);
	action_badboxes = _tmp13_;
	gtk_toggle_action_set_active (action_badboxes, g_settings_get_boolean (settings, "show-build-badboxes"));
	_tmp14_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_badboxes, "active", (GObject*) _tmp14_, "show-badboxes", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (action_badboxes);
	_g_object_unref0 (action_warnings);
	_g_object_unref0 (action_details);
	_g_object_unref0 (settings);
}


void
main_window_build_tools_on_stop_execution (MainWindowBuildTools* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cancellable;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_cancellable;
	g_cancellable_cancel (_tmp1_);
}


void
main_window_build_tools_on_clean (MainWindowBuildTools* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	CleanBuildFiles* build_files = NULL;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	CleanBuildFiles* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = clean_build_files_new (_tmp3_, _tmp6_);
	build_files = _tmp7_;
	clean_build_files_clean (build_files);
	_g_object_unref0 (build_files);
}


void
main_window_build_tools_on_view_log (MainWindowBuildTools* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GFile* mainfile = NULL;
	MainWindow* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	GFile* _tmp9_;
	GFile* directory = NULL;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* basename = NULL;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFile* file = NULL;
	GFile* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	DocumentTab* tab = NULL;
	MainWindow* _tmp22_;
	GFile* _tmp23_;
	DocumentTab* _tmp24_;
	DocumentTab* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	g_return_if_fail (document_is_main_file_a_tex_file (_tmp5_));
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_document (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = document_get_main_file (_tmp8_);
	mainfile = _tmp9_;
	_tmp10_ = mainfile;
	_tmp11_ = g_file_get_parent (_tmp10_);
	directory = _tmp11_;
	_tmp12_ = mainfile;
	_tmp13_ = g_file_get_basename (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = latexila_utils_get_shortname (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, ".log", NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	basename = _tmp18_;
	_tmp19_ = directory;
	_tmp20_ = basename;
	_tmp21_ = g_file_get_child (_tmp19_, _tmp20_);
	file = _tmp21_;
	_tmp22_ = self->priv->_main_window;
	_tmp23_ = file;
	_tmp24_ = main_window_open_document (_tmp22_, _tmp23_, TRUE);
	tab = _tmp24_;
	_tmp25_ = tab;
	if (_tmp25_ == NULL) {
		g_warning ("main_window_build_tools.vala:483: Impossible to view log");
	} else {
		DocumentTab* _tmp26_;
		Document* _tmp27_;
		Document* _tmp28_;
		_tmp26_ = tab;
		_tmp27_ = document_tab_get_document (_tmp26_);
		_tmp28_ = _tmp27_;
		document_set_readonly (_tmp28_, TRUE);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (mainfile);
}


static void
value_main_window_build_tools_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
value_main_window_build_tools_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		main_window_build_tools_unref (value->data[0].v_pointer);
	}
}


static void
value_main_window_build_tools_copy_value (const GValue* src_value, 
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_build_tools_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
value_main_window_build_tools_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
value_main_window_build_tools_collect_value (GValue* value, 
                                             guint n_collect_values, 
                                             GTypeCValue* collect_values, 
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MainWindowBuildTools * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_build_tools_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
value_main_window_build_tools_lcopy_value (const GValue* value, 
                                           guint n_collect_values, 
                                           GTypeCValue* collect_values, 
                                           guint collect_flags)
{
	MainWindowBuildTools ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_build_tools_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
param_spec_main_window_build_tools (const gchar* name, 
                                    const gchar* nick, 
                                    const gchar* blurb, 
                                    GType object_type, 
                                    GParamFlags flags)
{
	ParamSpecMainWindowBuildTools* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
value_get_main_window_build_tools (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	return value->data[0].v_pointer;
}


void
value_set_main_window_build_tools (GValue* value, 
                                   gpointer v_object)
{
	MainWindowBuildTools * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_build_tools_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


void
value_take_main_window_build_tools (GValue* value, 
                                    gpointer v_object)
{
	MainWindowBuildTools * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


static void
main_window_build_tools_class_init (MainWindowBuildToolsClass * klass)
{
	main_window_build_tools_parent_class = g_type_class_peek_parent (klass);
	((MainWindowBuildToolsClass *) klass)->finalize = main_window_build_tools_finalize;
	g_type_class_add_private (klass, sizeof (MainWindowBuildToolsPrivate));
}


static void
main_window_build_tools_instance_init (MainWindowBuildTools * self)
{
	self->priv = MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
main_window_build_tools_finalize (MainWindowBuildTools * obj)
{
	MainWindowBuildTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_build_view);
	_g_object_unref0 (self->priv->_bottom_panel);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->_build_tool_result);
	_g_object_unref0 (self->priv->_static_action_group);
	_g_object_unref0 (self->priv->_dynamic_action_group);
}


GType
main_window_build_tools_get_type (void)
{
	static volatile gsize main_window_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_build_tools_init, value_main_window_build_tools_free_value, value_main_window_build_tools_copy_value, value_main_window_build_tools_peek_pointer, "p", value_main_window_build_tools_collect_value, "p", value_main_window_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowBuildTools), 0, (GInstanceInitFunc) main_window_build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_build_tools_type_id;
		main_window_build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowBuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_build_tools_type_id__volatile, main_window_build_tools_type_id);
	}
	return main_window_build_tools_type_id__volatile;
}


gpointer
main_window_build_tools_ref (gpointer instance)
{
	MainWindowBuildTools * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
main_window_build_tools_unref (gpointer instance)
{
	MainWindowBuildTools * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_BUILD_TOOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



