/* main_window_build_tools.c generated by valac 0.40.10, the Vala compiler
 * generated from main_window_build_tools.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012, 2014 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <amtk/amtk.h>
#include <tepl/tepl.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;
typedef struct _MainWindowBuildToolsPrivate MainWindowBuildToolsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block22Data Block22Data;
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _ParamSpecMainWindowBuildTools ParamSpecMainWindowBuildTools;

struct _MainWindowBuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowBuildToolsPrivate * priv;
};

struct _MainWindowBuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowBuildTools *self);
};

struct _MainWindowBuildToolsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	LatexilaBuildView* _build_view;
	BottomPanel* _bottom_panel;
	GCancellable* _cancellable;
	GAsyncResult* _build_tool_result;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _dynamic_action_group;
	guint _menu_ui_id;
};

struct _Block22Data {
	int _ref_count_;
	MainWindowBuildTools* self;
	LatexilaBuildTool* tool;
};

struct _ParamSpecMainWindowBuildTools {
	GParamSpec parent_instance;
};


static gpointer main_window_build_tools_parent_class = NULL;

gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void value_set_main_window_build_tools (GValue* value,
                                        gpointer v_object);
void value_take_main_window_build_tools (GValue* value,
                                         gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType bottom_panel_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsPrivate))
void main_window_build_tools_on_clean (MainWindowBuildTools* self);
static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action,
                                                            gpointer self);
void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self);
static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action,
                                                                     gpointer self);
void main_window_build_tools_on_view_log (MainWindowBuildTools* self);
static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window,
                                                   GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type,
                                                         MainWindow* main_window,
                                                         GtkUIManager* ui_manager);
GType glatex_app_get_type (void) G_GNUC_CONST;
GlatexApp* glatex_app_get_instance (void);
static void main_window_build_tools_update_menu (MainWindowBuildTools* self);
static void __lambda29_ (MainWindowBuildTools* self);
static void ___lambda29__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                                 gpointer self);
static void __lambda30_ (MainWindowBuildTools* self);
static void ___lambda30__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                               gpointer self);
static void __lambda31_ (MainWindowBuildTools* self);
static void ___lambda31__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                                 gpointer self);
static void __lambda32_ (MainWindowBuildTools* self);
static void ___lambda32__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                               gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                             LatexilaBuildView* build_view);
static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self);
static void __lambda33_ (MainWindowBuildTools* self,
                  GFile* file,
                  gint start_line,
                  gint end_line);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
static void ___lambda33__latexila_build_view_jump_to_file (LatexilaBuildView* _sender,
                                                    GFile* file,
                                                    gint start_line,
                                                    gint end_line,
                                                    gpointer self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                               BottomPanel* bottom_panel);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_is_main_file_a_tex_file (Document* self);
static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self,
                                                            gint tool_num);
static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self,
                                                            LatexilaBuildTool* tool,
                                                            const gchar* action_name);
static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self,
                                                             gint tool_num);
static LatexilaBuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self,
                                                                     const gchar* action_name);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      gchar* needle);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self,
                                                      GtkAction* action);
static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender,
                                                                           gpointer self);
static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self,
                                                 LatexilaBuildTool* build_tool,
                                                 const gchar* action_name,
                                                 gint* accel_num);
static void main_window_build_tools_add_separator (MainWindowBuildTools* self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
gboolean document_set_tmp_location (Document* self);
gint document_get_project_id (Document* self);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
GeeList* glatex_app_get_documents (GlatexApp* self);
void utils_flush_queue (void);
static void __lambda28_ (Block22Data* _data22_,
                  GObject* obj,
                  GAsyncResult* _result_);
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_structure (GValue* value,
                                      gpointer v_object);
void value_take_main_window_structure (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
void main_window_structure_refresh (MainWindowStructure* self);
static void ___lambda28__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
GType clean_build_files_get_type (void) G_GNUC_CONST;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window,
                                        Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type,
                                              MainWindow* main_window,
                                              Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
Document* document_tab_get_document (DocumentTab* self);
void document_set_readonly (Document* self,
                            gboolean value);
static void main_window_build_tools_finalize (MainWindowBuildTools * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW_BUILD_TOOLS__action_entries[5] = {{"Build", NULL, N_ ("_Build")}, {"BuildClean", "edit-clear-all", N_ ("Cleanup Build _Files"), NULL, N_ ("Clean-up build files (*.aux, *.log, *.out, *.toc, etc)"), (GCallback) _main_window_build_tools_on_clean_gtk_action_callback}, {"BuildStopExecution", "process-stop", N_ ("_Stop Execution"), NULL, N_ ("Stop Execution"), (GCallback) _main_window_build_tools_on_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", N_ ("View _Log"), NULL, N_ ("View Log"), (GCallback) _main_window_build_tools_on_view_log_gtk_action_callback}, {"BuildToolsPreferences", "preferences-system", N_ ("_Manage Build Tools"), NULL, N_ ("Manage Build Tools")}};
static const GtkToggleActionEntry MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries[3] = {{"BuildShowDetails", "zoom-in", N_ ("Show _Details"), NULL, N_ ("Show Details"), (GCallback) NULL}, {"BuildShowWarnings", "dialog-warning", N_ ("Show _Warnings"), NULL, N_ ("Show Warnings"), (GCallback) NULL}, {"BuildShowBadBoxes", "badbox", N_ ("Show _Bad Boxes"), NULL, N_ ("Show Bad Boxes"), (GCallback) NULL}};

static void
_main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action,
                                                       gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_on_clean ((MainWindowBuildTools*) self);
#line 319 "main_window_build_tools.c"
}


static void
_main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action,
                                                                gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_on_stop_execution ((MainWindowBuildTools*) self);
#line 329 "main_window_build_tools.c"
}


static void
_main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_on_view_log ((MainWindowBuildTools*) self);
#line 339 "main_window_build_tools.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 72 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return self ? g_object_ref (self) : NULL;
#line 348 "main_window_build_tools.c"
}


static void
__lambda29_ (MainWindowBuildTools* self)
{
#line 96 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 357 "main_window_build_tools.c"
}


static void
___lambda29__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                            gpointer self)
{
#line 96 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	__lambda29_ ((MainWindowBuildTools*) self);
#line 367 "main_window_build_tools.c"
}


static void
__lambda30_ (MainWindowBuildTools* self)
{
#line 97 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 376 "main_window_build_tools.c"
}


static void
___lambda30__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                          gpointer self)
{
#line 97 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	__lambda30_ ((MainWindowBuildTools*) self);
#line 386 "main_window_build_tools.c"
}


static void
__lambda31_ (MainWindowBuildTools* self)
{
#line 101 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 395 "main_window_build_tools.c"
}


static void
___lambda31__latexila_build_tools_modified (LatexilaBuildTools* _sender,
                                            gpointer self)
{
#line 101 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	__lambda31_ ((MainWindowBuildTools*) self);
#line 405 "main_window_build_tools.c"
}


static void
__lambda32_ (MainWindowBuildTools* self)
{
#line 102 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 414 "main_window_build_tools.c"
}


static void
___lambda32__latexila_build_tools_loaded (LatexilaBuildTools* _sender,
                                          gpointer self)
{
#line 102 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	__lambda32_ ((MainWindowBuildTools*) self);
#line 424 "main_window_build_tools.c"
}


MainWindowBuildTools*
main_window_build_tools_construct (GType object_type,
                                   MainWindow* main_window,
                                   GtkUIManager* ui_manager)
{
	MainWindowBuildTools* self = NULL;
	GtkUIManager* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkAction* stop_exec = NULL;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkAction* _tmp7_;
	GtkActionGroup* _tmp8_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp9_;
	GtkActionGroup* _tmp10_;
	GtkActionGroup* _tmp11_;
	GtkActionGroup* _tmp12_;
	LatexilaBuildToolsPersonal* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_;
	LatexilaBuildToolsPersonal* _tmp14_;
	LatexilaBuildToolsDefault* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp15_;
	LatexilaBuildToolsDefault* _tmp16_;
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (ui_manager != NULL, NULL);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self = (MainWindowBuildTools*) g_type_create_instance (object_type);
#line 71 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_main_window = main_window;
#line 72 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (ui_manager);
#line 72 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 72 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_ui_manager = _tmp0_;
#line 75 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = gtk_action_group_new ("BuildMenuActionGroup");
#line 75 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_static_action_group);
#line 75 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_static_action_group = _tmp1_;
#line 76 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = self->priv->_static_action_group;
#line 76 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_group_set_translation_domain (_tmp2_, GETTEXT_PACKAGE);
#line 77 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = self->priv->_static_action_group;
#line 77 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_group_add_actions (_tmp3_, MAIN_WINDOW_BUILD_TOOLS__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__action_entries), self);
#line 78 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = self->priv->_static_action_group;
#line 78 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_group_add_toggle_actions (_tmp4_, MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries), self);
#line 80 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = self->priv->_static_action_group;
#line 80 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "BuildStopExecution");
#line 80 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 80 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	stop_exec = _tmp7_;
#line 81 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_set_sensitive (stop_exec, FALSE);
#line 83 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = self->priv->_static_action_group;
#line 83 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_ui_manager_insert_action_group (ui_manager, _tmp8_, 0);
#line 85 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = glatex_app_get_instance ();
#line 85 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	app = _tmp9_;
#line 86 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = self->priv->_static_action_group;
#line 86 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "manage-build-tools", _tmp10_, "BuildToolsPreferences");
#line 90 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = gtk_action_group_new ("BuildToolsActions");
#line 90 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_dynamic_action_group);
#line 90 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_dynamic_action_group = _tmp11_;
#line 91 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = self->priv->_dynamic_action_group;
#line 91 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_ui_manager_insert_action_group (ui_manager, _tmp12_, 0);
#line 92 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_menu (self);
#line 94 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp13_ = latexila_build_tools_personal_get_instance ();
#line 94 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 94 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	personal_build_tools = _tmp14_;
#line 96 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "modified", (GCallback) ___lambda29__latexila_build_tools_modified, self);
#line 97 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "loaded", (GCallback) ___lambda30__latexila_build_tools_loaded, self);
#line 99 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp15_ = latexila_build_tools_default_get_instance ();
#line 99 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp16_ = _g_object_ref0 (_tmp15_);
#line 99 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	default_build_tools = _tmp16_;
#line 101 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "modified", (GCallback) ___lambda31__latexila_build_tools_modified, self);
#line 102 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "loaded", (GCallback) ___lambda32__latexila_build_tools_loaded, self);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (default_build_tools);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (personal_build_tools);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (app);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (stop_exec);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return self;
#line 551 "main_window_build_tools.c"
}


MainWindowBuildTools*
main_window_build_tools_new (MainWindow* main_window,
                             GtkUIManager* ui_manager)
{
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return main_window_build_tools_construct (TYPE_MAIN_WINDOW_BUILD_TOOLS, main_window, ui_manager);
#line 561 "main_window_build_tools.c"
}


static void
__lambda33_ (MainWindowBuildTools* self,
             GFile* file,
             gint start_line,
             gint end_line)
{
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (file != NULL);
#line 112 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (start_line == -1) {
#line 575 "main_window_build_tools.c"
		MainWindow* _tmp0_;
		DocumentTab* _tmp1_;
		DocumentTab* _tmp2_;
#line 113 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp0_ = self->priv->_main_window;
#line 113 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp1_ = main_window_open_document (_tmp0_, file, TRUE);
#line 113 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp2_ = _tmp1_;
#line 113 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (_tmp2_);
#line 587 "main_window_build_tools.c"
	} else {
		MainWindow* _tmp3_;
#line 115 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp3_ = self->priv->_main_window;
#line 115 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		main_window_jump_to_file_position (_tmp3_, file, start_line, end_line);
#line 594 "main_window_build_tools.c"
	}
}


static void
___lambda33__latexila_build_view_jump_to_file (LatexilaBuildView* _sender,
                                               GFile* file,
                                               gint start_line,
                                               gint end_line,
                                               gpointer self)
{
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	__lambda33_ ((MainWindowBuildTools*) self, file, start_line, end_line);
#line 608 "main_window_build_tools.c"
}


void
main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                        LatexilaBuildView* build_view)
{
	LatexilaBuildView* _tmp0_;
	LatexilaBuildView* _tmp1_;
#line 105 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (build_view != NULL);
#line 107 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (build_view);
#line 107 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_view);
#line 107 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_build_view = _tmp0_;
#line 108 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_connect_toggle_actions (self);
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = self->priv->_build_view;
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_signal_connect (_tmp1_, "jump-to-file", (GCallback) ___lambda33__latexila_build_view_jump_to_file, self);
#line 634 "main_window_build_tools.c"
}


void
main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                          BottomPanel* bottom_panel)
{
	BottomPanel* _tmp0_;
#line 119 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (bottom_panel != NULL);
#line 121 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (bottom_panel);
#line 121 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_bottom_panel);
#line 121 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_bottom_panel = _tmp0_;
#line 653 "main_window_build_tools.c"
}


void
main_window_build_tools_update_sensitivity (MainWindowBuildTools* self)
{
	gboolean build_tool_is_running = FALSE;
	GCancellable* _tmp0_;
	GtkAction* stop_exec_action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	gboolean _tmp5_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp6_;
	GSimpleAction* preferences_action = NULL;
	GlatexApp* _tmp7_;
	GAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	gboolean _tmp11_;
	GtkAction* clean_action = NULL;
	GtkActionGroup* _tmp12_;
	GtkAction* _tmp13_;
	GtkAction* _tmp14_;
	GtkAction* view_log_action = NULL;
	GtkActionGroup* _tmp15_;
	GtkAction* _tmp16_;
	GtkAction* _tmp17_;
	MainWindow* _tmp18_;
	DocumentTab* _tmp19_;
	DocumentTab* _tmp20_;
	gboolean is_tex = FALSE;
	MainWindow* _tmp24_;
	Document* _tmp25_;
	Document* _tmp26_;
	GtkAction* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GtkActionGroup* _tmp32_;
	GtkAction* _tmp33_;
	gboolean _tmp34_;
	LatexilaBuildTools* build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp35_;
	LatexilaBuildTools* _tmp36_;
	gint tool_num = 0;
	LatexilaBuildTools* _tmp37_;
	GList* _tmp38_;
	LatexilaBuildToolsPersonal* _tmp45_;
	LatexilaBuildTools* _tmp46_;
	LatexilaBuildTools* _tmp47_;
	GList* _tmp48_;
#line 124 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_cancellable;
#line 126 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	build_tool_is_running = _tmp0_ != NULL;
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = self->priv->_static_action_group;
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildStopExecution");
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	stop_exec_action = _tmp3_;
#line 129 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = stop_exec_action;
#line 129 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = build_tool_is_running;
#line 129 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp4_, _tmp5_);
#line 131 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = glatex_app_get_instance ();
#line 131 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	app = _tmp6_;
#line 132 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = app;
#line 132 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) _tmp7_, "manage-build-tools");
#line 132 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
#line 132 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	preferences_action = _tmp9_;
#line 136 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = preferences_action;
#line 136 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = build_tool_is_running;
#line 136 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_simple_action_set_enabled (_tmp10_, !_tmp11_);
#line 138 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = self->priv->_static_action_group;
#line 138 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp13_ = gtk_action_group_get_action (_tmp12_, "BuildClean");
#line 138 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 138 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	clean_action = _tmp14_;
#line 139 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp15_ = self->priv->_static_action_group;
#line 139 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp16_ = gtk_action_group_get_action (_tmp15_, "BuildViewLog");
#line 139 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 139 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	view_log_action = _tmp17_;
#line 141 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp18_ = self->priv->_main_window;
#line 141 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp19_ = main_window_get_active_tab (_tmp18_);
#line 141 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp20_ = _tmp19_;
#line 141 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp20_ == NULL) {
#line 769 "main_window_build_tools.c"
		GtkActionGroup* _tmp21_;
		GtkAction* _tmp22_;
		GtkAction* _tmp23_;
#line 143 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp21_ = self->priv->_dynamic_action_group;
#line 143 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		gtk_action_group_set_sensitive (_tmp21_, FALSE);
#line 144 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp22_ = clean_action;
#line 144 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp22_, FALSE);
#line 145 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp23_ = view_log_action;
#line 145 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp23_, FALSE);
#line 146 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (view_log_action);
#line 146 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (clean_action);
#line 146 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (preferences_action);
#line 146 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (app);
#line 146 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (stop_exec_action);
#line 146 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		return;
#line 797 "main_window_build_tools.c"
	}
#line 149 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp24_ = self->priv->_main_window;
#line 149 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp25_ = main_window_get_active_document (_tmp24_);
#line 149 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp26_ = _tmp25_;
#line 149 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	is_tex = document_is_main_file_a_tex_file (_tmp26_);
#line 150 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp27_ = view_log_action;
#line 150 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp28_ = is_tex;
#line 150 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp27_, _tmp28_);
#line 152 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp29_ = build_tool_is_running;
#line 152 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp29_) {
#line 817 "main_window_build_tools.c"
		GtkActionGroup* _tmp30_;
		GtkAction* _tmp31_;
#line 154 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp30_ = self->priv->_dynamic_action_group;
#line 154 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		gtk_action_group_set_sensitive (_tmp30_, FALSE);
#line 155 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp31_ = clean_action;
#line 155 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp31_, FALSE);
#line 156 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (view_log_action);
#line 156 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (clean_action);
#line 156 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (preferences_action);
#line 156 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (app);
#line 156 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (stop_exec_action);
#line 156 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		return;
#line 840 "main_window_build_tools.c"
	}
#line 159 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp32_ = self->priv->_dynamic_action_group;
#line 159 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_group_set_sensitive (_tmp32_, TRUE);
#line 160 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp33_ = clean_action;
#line 160 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp34_ = is_tex;
#line 160 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp33_, _tmp34_);
#line 162 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp35_ = latexila_build_tools_default_get_instance ();
#line 162 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp35_) : NULL);
#line 162 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	build_tools = _tmp36_;
#line 165 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	tool_num = 0;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp37_ = build_tools;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp38_ = _tmp37_->build_tools;
#line 864 "main_window_build_tools.c"
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		tool_collection = _tmp38_;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
#line 872 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp39_;
			LatexilaBuildTool* tool = NULL;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp39_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			tool = _tmp39_;
#line 879 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gint _tmp40_;
				gchar* _tmp41_;
				LatexilaBuildTool* _tmp42_;
				const gchar* _tmp43_;
				gint _tmp44_;
#line 168 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp40_ = tool_num;
#line 168 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp41_ = main_window_build_tools_get_default_build_tool_name (self, _tmp40_);
#line 168 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				action_name = _tmp41_;
#line 169 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp42_ = tool;
#line 169 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp43_ = action_name;
#line 169 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp42_, _tmp43_);
#line 170 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp44_ = tool_num;
#line 170 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				tool_num = _tmp44_ + 1;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_free0 (action_name);
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_object_unref0 (tool);
#line 907 "main_window_build_tools.c"
			}
		}
	}
#line 173 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp45_ = latexila_build_tools_personal_get_instance ();
#line 173 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp45_) : NULL);
#line 173 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (build_tools);
#line 173 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	build_tools = _tmp46_;
#line 174 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	tool_num = 0;
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp47_ = build_tools;
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp48_ = _tmp47_->build_tools;
#line 925 "main_window_build_tools.c"
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		tool_collection = _tmp48_;
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
#line 933 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp49_;
			LatexilaBuildTool* tool = NULL;
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp49_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			tool = _tmp49_;
#line 940 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gint _tmp50_;
				gchar* _tmp51_;
				LatexilaBuildTool* _tmp52_;
				const gchar* _tmp53_;
				gint _tmp54_;
#line 177 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp50_ = tool_num;
#line 177 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp51_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp50_);
#line 177 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				action_name = _tmp51_;
#line 178 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp52_ = tool;
#line 178 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp53_ = action_name;
#line 178 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp52_, _tmp53_);
#line 179 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp54_ = tool_num;
#line 179 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				tool_num = _tmp54_ + 1;
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_free0 (action_name);
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_object_unref0 (tool);
#line 968 "main_window_build_tools.c"
			}
		}
	}
#line 124 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (build_tools);
#line 124 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (view_log_action);
#line 124 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (clean_action);
#line 124 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (preferences_action);
#line 124 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (app);
#line 124 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (stop_exec_action);
#line 984 "main_window_build_tools.c"
}


static gchar*
main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self,
                                                     gint tool_num)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 183 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 185 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = g_strdup_printf ("%i", tool_num);
#line 185 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 185 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = g_strconcat ("DefaultBuildTool_", _tmp1_, NULL);
#line 185 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = _tmp2_;
#line 185 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp1_);
#line 185 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	result = _tmp3_;
#line 185 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return result;
#line 1013 "main_window_build_tools.c"
}


static gchar*
main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self,
                                                      gint tool_num)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 188 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = g_strdup_printf ("%i", tool_num);
#line 190 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 190 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = g_strconcat ("PersonalBuildTool_", _tmp1_, NULL);
#line 190 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = _tmp2_;
#line 190 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp1_);
#line 190 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	result = _tmp3_;
#line 190 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return result;
#line 1042 "main_window_build_tools.c"
}


static LatexilaBuildTool*
main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self,
                                                  const gchar* action_name)
{
	LatexilaBuildTool* result = NULL;
	LatexilaBuildTools* build_tools = NULL;
	gchar** name = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint name_length1;
	gint _name_size_;
	gint tool_num = 0;
	const gchar* _tmp6_;
	LatexilaBuildTools* _tmp7_;
	LatexilaBuildTool* _tmp8_;
	LatexilaBuildTool* _tmp9_;
#line 193 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 193 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (action_name != NULL, NULL);
#line 197 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (g_str_has_prefix (action_name, "DefaultBuildTool_")) {
#line 1068 "main_window_build_tools.c"
		LatexilaBuildToolsDefault* _tmp0_;
		LatexilaBuildTools* _tmp1_;
#line 198 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp0_ = latexila_build_tools_default_get_instance ();
#line 198 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
#line 198 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (build_tools);
#line 198 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		build_tools = _tmp1_;
#line 1079 "main_window_build_tools.c"
	} else {
#line 200 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		if (g_str_has_prefix (action_name, "PersonalBuildTool_")) {
#line 1083 "main_window_build_tools.c"
			LatexilaBuildToolsPersonal* _tmp2_;
			LatexilaBuildTools* _tmp3_;
#line 201 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp2_ = latexila_build_tools_personal_get_instance ();
#line 201 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp2_) : NULL);
#line 201 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_g_object_unref0 (build_tools);
#line 201 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			build_tools = _tmp3_;
#line 1094 "main_window_build_tools.c"
		} else {
#line 204 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			g_return_val_if_reached (NULL);
#line 1098 "main_window_build_tools.c"
		}
	}
#line 206 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = _tmp4_ = g_strsplit (action_name, "_", 0);
#line 206 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	name = _tmp5_;
#line 206 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	name_length1 = _vala_array_length (_tmp4_);
#line 206 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_name_size_ = name_length1;
#line 207 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (name_length1 == 2, NULL);
#line 209 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = name[1];
#line 209 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	tool_num = atoi (_tmp6_);
#line 211 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = build_tools;
#line 211 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = latexila_build_tools_nth (_tmp7_, (guint) tool_num);
#line 211 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 211 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	result = _tmp9_;
#line 211 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	name = (_vala_array_free (name, name_length1, (GDestroyNotify) g_free), NULL);
#line 211 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (build_tools);
#line 211 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return result;
#line 1129 "main_window_build_tools.c"
}


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             gchar* needle)
{
	int i;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	for (i = 0; i < stack_length; i++) {
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			return TRUE;
#line 1145 "main_window_build_tools.c"
		}
	}
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return FALSE;
#line 1150 "main_window_build_tools.c"
}


static void
main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self,
                                                       LatexilaBuildTool* tool,
                                                       const gchar* action_name)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	Document* active_doc = NULL;
	MainWindow* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	gboolean unsaved_doc = FALSE;
	Document* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gboolean _tmp12_;
	gchar* path = NULL;
	Document* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* ext = NULL;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** extensions = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gint extensions_length1;
	gint _extensions_size_;
	gboolean _tmp28_ = FALSE;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	gboolean sensitive = FALSE;
	GtkAction* _tmp37_;
	gboolean _tmp38_;
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (tool != NULL);
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (action_name != NULL);
#line 217 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_get (tool, "enabled", &_tmp0_, NULL);
#line 217 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 217 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (!_tmp1_) {
#line 218 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		return;
#line 1218 "main_window_build_tools.c"
	}
#line 220 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = self->priv->_dynamic_action_group;
#line 220 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = gtk_action_group_get_action (_tmp2_, action_name);
#line 220 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 220 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	action = _tmp4_;
#line 222 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = self->priv->_main_window;
#line 222 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = main_window_get_active_document (_tmp5_);
#line 222 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = _tmp6_;
#line 222 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 222 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	active_doc = _tmp8_;
#line 223 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = active_doc;
#line 223 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = document_get_location (_tmp9_);
#line 223 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = _tmp10_;
#line 223 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	unsaved_doc = _tmp11_ == NULL;
#line 225 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = unsaved_doc;
#line 225 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp12_) {
#line 1250 "main_window_build_tools.c"
		GtkAction* _tmp13_;
		GList* _tmp14_;
#line 227 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp13_ = action;
#line 227 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp14_ = latexila_build_tool_get_jobs (tool);
#line 227 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		gtk_action_set_sensitive (_tmp13_, _tmp14_ != NULL);
#line 228 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (active_doc);
#line 228 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (action);
#line 228 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		return;
#line 1265 "main_window_build_tools.c"
	}
#line 231 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp15_ = active_doc;
#line 231 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp16_ = document_get_main_file (_tmp15_);
#line 231 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp17_ = _tmp16_;
#line 231 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp18_ = g_file_get_parse_name (_tmp17_);
#line 231 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp19_ = _tmp18_;
#line 231 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (_tmp17_);
#line 231 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	path = _tmp19_;
#line 232 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp20_ = path;
#line 232 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp21_ = latexila_utils_get_extension (_tmp20_);
#line 232 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	ext = _tmp21_;
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_get (tool, "extensions", &_tmp22_, NULL);
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp23_ = _tmp22_;
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp24_ = _tmp23_;
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, " ", 0);
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp27_ = _tmp26_;
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp27__length1 = _vala_array_length (_tmp25_);
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp24_);
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	extensions = _tmp27_;
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	extensions_length1 = _tmp27__length1;
#line 234 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_extensions_size_ = extensions_length1;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_get (tool, "extensions", &_tmp29_, NULL);
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp30_ = _tmp29_;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp31_ = _tmp30_;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp32_ = strlen (_tmp31_);
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp33_ = _tmp32_;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp34_ = _tmp33_ == 0;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp31_);
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp34_) {
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp28_ = TRUE;
#line 1325 "main_window_build_tools.c"
	} else {
		const gchar* _tmp35_;
		gchar** _tmp36_;
		gint _tmp36__length1;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp35_ = ext;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp36_ = extensions;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp36__length1 = extensions_length1;
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp28_ = _vala_string_array_contains (_tmp36_, _tmp36__length1, _tmp35_);
#line 1338 "main_window_build_tools.c"
	}
#line 235 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	sensitive = _tmp28_;
#line 236 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp37_ = action;
#line 236 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp38_ = sensitive;
#line 236 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_set_sensitive (_tmp37_, _tmp38_);
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (ext);
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (path);
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (active_doc);
#line 214 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 1358 "main_window_build_tools.c"
}


void
main_window_build_tools_save_state (MainWindowBuildTools* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
#line 239 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 241 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 241 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	settings = _tmp0_;
#line 244 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = self->priv->_static_action_group;
#line 244 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildShowWarnings");
#line 244 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
#line 244 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	action = _tmp3_;
#line 246 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = action;
#line 246 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
#line 246 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = _tmp5_;
#line 246 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_settings_set_boolean (settings, "show-build-warnings", _tmp6_);
#line 248 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = self->priv->_static_action_group;
#line 248 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowBadBoxes");
#line 248 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
#line 248 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 248 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	action = _tmp9_;
#line 249 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = action;
#line 249 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = gtk_toggle_action_get_active (_tmp10_);
#line 249 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = _tmp11_;
#line 249 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_settings_set_boolean (settings, "show-build-badboxes", _tmp12_);
#line 239 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 239 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (settings);
#line 1424 "main_window_build_tools.c"
}


static void
_main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender,
                                                                      gpointer self)
{
#line 261 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_activate_dynamic_action ((MainWindowBuildTools*) self, _sender);
#line 1434 "main_window_build_tools.c"
}


static void
main_window_build_tools_update_menu (MainWindowBuildTools* self)
{
	GtkActionGroup* _tmp0_;
	guint _tmp1_;
	GtkActionGroup* _tmp4_;
	GList* _tmp5_;
	LatexilaBuildTools* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp11_;
	LatexilaBuildTools* _tmp12_;
	LatexilaBuildTools* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_;
	LatexilaBuildTools* _tmp14_;
	gboolean _tmp15_ = FALSE;
	LatexilaBuildTools* _tmp16_;
	GList* _tmp17_;
	GtkUIManager* _tmp20_;
	gint tool_num = 0;
	gint accel_num = 0;
	LatexilaBuildTools* _tmp21_;
	GList* _tmp22_;
	LatexilaBuildTools* _tmp29_;
	GList* _tmp30_;
#line 252 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_dynamic_action_group;
#line 254 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 256 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = self->priv->_menu_ui_id;
#line 256 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1471 "main_window_build_tools.c"
		GtkUIManager* _tmp2_;
		guint _tmp3_;
#line 257 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp2_ = self->priv->_ui_manager;
#line 257 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp3_ = self->priv->_menu_ui_id;
#line 257 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		gtk_ui_manager_remove_ui (_tmp2_, _tmp3_);
#line 1480 "main_window_build_tools.c"
	}
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = self->priv->_dynamic_action_group;
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = gtk_action_group_list_actions (_tmp4_);
#line 1486 "main_window_build_tools.c"
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		action_collection = _tmp5_;
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
#line 1494 "main_window_build_tools.c"
			GtkAction* _tmp6_;
			GtkAction* action = NULL;
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp6_ = _g_object_ref0 ((GtkAction*) action_it->data);
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			action = _tmp6_;
#line 1501 "main_window_build_tools.c"
			{
				GtkAction* _tmp7_;
				guint _tmp8_;
				GtkActionGroup* _tmp9_;
				GtkAction* _tmp10_;
#line 261 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp7_ = action;
#line 261 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp8_, NULL, FALSE);
#line 261 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
#line 262 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp9_ = self->priv->_dynamic_action_group;
#line 262 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp10_ = action;
#line 262 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				gtk_action_group_remove_action (_tmp9_, _tmp10_);
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_object_unref0 (action);
#line 1521 "main_window_build_tools.c"
			}
		}
#line 259 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
#line 1526 "main_window_build_tools.c"
	}
#line 265 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = latexila_build_tools_default_get_instance ();
#line 265 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp11_) : NULL);
#line 265 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	default_build_tools = _tmp12_;
#line 267 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp13_ = latexila_build_tools_personal_get_instance ();
#line 267 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp13_) : NULL);
#line 267 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	personal_build_tools = _tmp14_;
#line 271 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp16_ = default_build_tools;
#line 271 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp17_ = _tmp16_->build_tools;
#line 271 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp17_ == NULL) {
#line 1546 "main_window_build_tools.c"
		LatexilaBuildTools* _tmp18_;
		GList* _tmp19_;
#line 272 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp18_ = personal_build_tools;
#line 272 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp19_ = _tmp18_->build_tools;
#line 272 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp15_ = _tmp19_ == NULL;
#line 1555 "main_window_build_tools.c"
	} else {
#line 271 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp15_ = FALSE;
#line 1559 "main_window_build_tools.c"
	}
#line 271 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp15_) {
#line 274 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		self->priv->_menu_ui_id = (guint) 0;
#line 275 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (personal_build_tools);
#line 275 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (default_build_tools);
#line 275 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		return;
#line 1571 "main_window_build_tools.c"
	}
#line 278 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp20_ = self->priv->_ui_manager;
#line 278 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_menu_ui_id = gtk_ui_manager_new_merge_id (_tmp20_);
#line 281 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	tool_num = 0;
#line 282 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	accel_num = 2;
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp21_ = default_build_tools;
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp22_ = _tmp21_->build_tools;
#line 1585 "main_window_build_tools.c"
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		build_tool_collection = _tmp22_;
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
#line 1593 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp23_;
			LatexilaBuildTool* build_tool = NULL;
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp23_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			build_tool = _tmp23_;
#line 1600 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gint _tmp24_;
				gchar* _tmp25_;
				LatexilaBuildTool* _tmp26_;
				const gchar* _tmp27_;
				gint _tmp28_;
#line 285 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp24_ = tool_num;
#line 285 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp25_ = main_window_build_tools_get_default_build_tool_name (self, _tmp24_);
#line 285 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				action_name = _tmp25_;
#line 286 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp26_ = build_tool;
#line 286 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp27_ = action_name;
#line 286 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				main_window_build_tools_add_dynamic_action (self, _tmp26_, _tmp27_, &accel_num);
#line 287 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp28_ = tool_num;
#line 287 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				tool_num = _tmp28_ + 1;
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_free0 (action_name);
#line 283 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_object_unref0 (build_tool);
#line 1628 "main_window_build_tools.c"
			}
		}
	}
#line 290 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_add_separator (self);
#line 293 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	tool_num = 0;
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp29_ = personal_build_tools;
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp30_ = _tmp29_->build_tools;
#line 1640 "main_window_build_tools.c"
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		build_tool_collection = _tmp30_;
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
#line 1648 "main_window_build_tools.c"
			LatexilaBuildTool* _tmp31_;
			LatexilaBuildTool* build_tool = NULL;
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp31_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			build_tool = _tmp31_;
#line 1655 "main_window_build_tools.c"
			{
				gchar* action_name = NULL;
				gint _tmp32_;
				gchar* _tmp33_;
				LatexilaBuildTool* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
#line 296 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp32_ = tool_num;
#line 296 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp33_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp32_);
#line 296 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				action_name = _tmp33_;
#line 297 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp34_ = build_tool;
#line 297 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp35_ = action_name;
#line 297 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				main_window_build_tools_add_dynamic_action (self, _tmp34_, _tmp35_, &accel_num);
#line 298 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp36_ = tool_num;
#line 298 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				tool_num = _tmp36_ + 1;
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_free0 (action_name);
#line 294 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_object_unref0 (build_tool);
#line 1683 "main_window_build_tools.c"
			}
		}
	}
#line 301 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_sensitivity (self);
#line 252 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (personal_build_tools);
#line 252 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (default_build_tools);
#line 1693 "main_window_build_tools.c"
}


static void
main_window_build_tools_add_separator (MainWindowBuildTools* self)
{
	GtkUIManager* _tmp0_;
	guint _tmp1_;
	GtkUIManager* _tmp2_;
	guint _tmp3_;
#line 304 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 306 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 306 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = self->priv->_menu_ui_id;
#line 306 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp0_, _tmp1_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
#line 310 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 310 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = self->priv->_menu_ui_id;
#line 310 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp2_, _tmp3_, "/MainToolbar/BuildToolsPlaceholderToolbar", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
#line 1718 "main_window_build_tools.c"
}


static void
main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self,
                                            LatexilaBuildTool* build_tool,
                                            const gchar* action_name,
                                            gint* accel_num)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkAction* action = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkAction* _tmp6_;
	GtkAction* _tmp7_;
	GtkAction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkAction* _tmp12_;
	gchar* accel = NULL;
	GtkActionGroup* _tmp16_;
	GtkAction* _tmp17_;
	const gchar* _tmp18_;
	GtkAction* _tmp19_;
	GtkUIManager* _tmp20_;
	guint _tmp21_;
	GtkUIManager* _tmp22_;
	guint _tmp23_;
	gint _tmp24_;
#line 315 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 315 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (build_tool != NULL);
#line 315 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (action_name != NULL);
#line 318 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_get (build_tool, "enabled", &_tmp0_, NULL);
#line 318 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = _tmp0_;
#line 318 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (!_tmp1_) {
#line 319 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		return;
#line 1766 "main_window_build_tools.c"
	}
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_get (build_tool, "label", &_tmp2_, NULL);
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = _tmp2_;
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = _tmp3_;
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = latexila_build_tool_get_description (build_tool);
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = gtk_action_new (action_name, _tmp4_, _tmp5_, NULL);
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = _tmp6_;
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp4_);
#line 321 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	action = _tmp7_;
#line 323 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = action;
#line 323 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_get (build_tool, "icon", &_tmp9_, NULL);
#line 323 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = _tmp9_;
#line 323 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = _tmp10_;
#line 323 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_set_icon_name (_tmp8_, _tmp11_);
#line 323 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp11_);
#line 324 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = action;
#line 324 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_set_always_show_image (_tmp12_, TRUE);
#line 328 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	accel = NULL;
#line 329 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if ((*accel_num) <= 11) {
#line 1804 "main_window_build_tools.c"
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 330 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp13_ = g_strdup_printf ("%i", *accel_num);
#line 330 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp14_ = _tmp13_;
#line 330 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp15_ = g_strconcat ("<Release>F", _tmp14_, NULL);
#line 330 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_free0 (accel);
#line 330 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		accel = _tmp15_;
#line 330 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_free0 (_tmp14_);
#line 1820 "main_window_build_tools.c"
	}
#line 332 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp16_ = self->priv->_dynamic_action_group;
#line 332 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp17_ = action;
#line 332 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp18_ = accel;
#line 332 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_action_group_add_action_with_accel (_tmp16_, _tmp17_, _tmp18_);
#line 333 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp19_ = action;
#line 333 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_signal_connect (_tmp19_, "activate", (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
#line 335 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp20_ = self->priv->_ui_manager;
#line 335 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp21_ = self->priv->_menu_ui_id;
#line 335 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp20_, _tmp21_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", action_name, action_name, GTK_UI_MANAGER_MENUITEM, FALSE);
#line 339 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp22_ = self->priv->_ui_manager;
#line 339 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp23_ = self->priv->_menu_ui_id;
#line 339 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_ui_manager_add_ui (_tmp22_, _tmp23_, "/MainToolbar/BuildToolsPlaceholderToolbar", action_name, action_name, GTK_UI_MANAGER_TOOLITEM, FALSE);
#line 343 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp24_ = *accel_num;
#line 343 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	*accel_num = _tmp24_ + 1;
#line 315 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (accel);
#line 315 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (action);
#line 1854 "main_window_build_tools.c"
}


static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_atomic_int_inc (&_data22_->_ref_count_);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return _data22_;
#line 1865 "main_window_build_tools.c"
}


static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
#line 1876 "main_window_build_tools.c"
		MainWindowBuildTools* self;
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		self = _data22_->self;
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_g_object_unref0 (_data22_->tool);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_main_window_build_tools_unref0 (self);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_slice_free (Block22Data, _data22_);
#line 1886 "main_window_build_tools.c"
	}
}


static void
__lambda28_ (Block22Data* _data22_,
             GObject* obj,
             GAsyncResult* _result_)
{
	MainWindowBuildTools* self;
	GAsyncResult* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	MainWindow* _tmp2_;
	MainWindowStructure* _tmp3_;
	MainWindowStructure* _tmp4_;
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self = _data22_->self;
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_result_ != NULL);
#line 397 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = _g_object_ref0 (_result_);
#line 397 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_tool_result);
#line 397 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_build_tool_result = _tmp0_;
#line 398 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = _data22_->tool;
#line 398 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	latexila_build_tool_run_finish (_tmp1_, _result_);
#line 399 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 399 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_cancellable = NULL;
#line 400 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_sensitivity (self);
#line 406 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = self->priv->_main_window;
#line 406 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = main_window_get_main_window_structure (_tmp2_);
#line 406 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = _tmp3_;
#line 406 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_structure_refresh (_tmp4_);
#line 406 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_main_window_structure_unref0 (_tmp4_);
#line 1932 "main_window_build_tools.c"
}


static void
___lambda28__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	__lambda28_ (self, source_object, res);
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	block22_data_unref (self);
#line 1945 "main_window_build_tools.c"
}


static void
main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self,
                                                 GtkAction* action)
{
	Block22Data* _data22_;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	LatexilaBuildView* _tmp3_;
	BottomPanel* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	LatexilaBuildTool* _tmp8_;
	Document* active_doc = NULL;
	MainWindow* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	LatexilaBuildTool* _tmp13_;
	GList* _tmp14_;
	LatexilaBuildTool* _tmp18_;
	GList* _tmp19_;
	GFile* main_file = NULL;
	Document* _tmp50_;
	GFile* _tmp51_;
	GCancellable* _tmp52_;
	LatexilaBuildTool* _tmp53_;
	LatexilaBuildView* _tmp54_;
	GCancellable* _tmp55_;
	BottomPanel* _tmp56_;
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (action != NULL);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_data22_ = g_slice_new0 (Block22Data);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_data22_->_ref_count_ = 1;
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_data22_->self = main_window_build_tools_ref (self);
#line 348 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_main_window;
#line 348 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 348 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = _tmp1_;
#line 348 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 349 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = self->priv->_build_view;
#line 349 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp3_ != NULL);
#line 350 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = self->priv->_bottom_panel;
#line 350 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp4_ != NULL);
#line 352 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = gtk_action_get_name (action);
#line 352 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = _tmp5_;
#line 352 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = main_window_build_tools_get_build_tool_from_name (self, _tmp6_);
#line 352 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_data22_->tool = _tmp7_;
#line 353 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = _data22_->tool;
#line 353 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp8_ != NULL);
#line 355 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = self->priv->_main_window;
#line 355 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = main_window_get_active_document (_tmp9_);
#line 355 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = _tmp10_;
#line 355 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 355 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	active_doc = _tmp12_;
#line 357 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp13_ = _data22_->tool;
#line 357 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp14_ = latexila_build_tool_get_jobs (_tmp13_);
#line 357 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp14_ == NULL) {
#line 2034 "main_window_build_tools.c"
		Document* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
#line 358 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp15_ = active_doc;
#line 358 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp16_ = document_get_location (_tmp15_);
#line 358 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp17_ = _tmp16_;
#line 358 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_return_if_fail (_tmp17_ != NULL);
#line 2046 "main_window_build_tools.c"
	}
#line 361 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp18_ = _data22_->tool;
#line 361 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp19_ = latexila_build_tool_get_jobs (_tmp18_);
#line 361 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp19_ != NULL) {
#line 2054 "main_window_build_tools.c"
		Document* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		gint project_id = 0;
		Document* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
#line 363 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp20_ = active_doc;
#line 363 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp21_ = document_get_location (_tmp20_);
#line 363 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp22_ = _tmp21_;
#line 363 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		if (_tmp22_ == NULL) {
#line 2071 "main_window_build_tools.c"
			gboolean tmp_location_set = FALSE;
			Document* _tmp23_;
			gboolean _tmp24_;
#line 365 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp23_ = active_doc;
#line 365 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			tmp_location_set = document_set_tmp_location (_tmp23_);
#line 366 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp24_ = tmp_location_set;
#line 366 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			g_return_if_fail (_tmp24_);
#line 2083 "main_window_build_tools.c"
		}
#line 369 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp25_ = active_doc;
#line 369 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp26_ = document_get_project_id (_tmp25_);
#line 369 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp27_ = _tmp26_;
#line 369 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		project_id = _tmp27_;
#line 371 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp28_ = project_id;
#line 371 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		if (_tmp28_ == -1) {
#line 2097 "main_window_build_tools.c"
			Document* _tmp29_;
#line 372 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp29_ = active_doc;
#line 372 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			document_save (_tmp29_, TRUE, FALSE);
#line 2103 "main_window_build_tools.c"
		} else {
			GeeList* docs = NULL;
			GlatexApp* _tmp30_;
			GlatexApp* _tmp31_;
			GeeList* _tmp32_;
			GeeList* _tmp33_;
#line 377 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp30_ = glatex_app_get_instance ();
#line 377 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp31_ = _tmp30_;
#line 377 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp32_ = glatex_app_get_documents (_tmp31_);
#line 377 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_tmp33_ = _tmp32_;
#line 377 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_g_object_unref0 (_tmp31_);
#line 377 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			docs = _tmp33_;
#line 2122 "main_window_build_tools.c"
			{
				GeeList* _doc_list = NULL;
				GeeList* _tmp34_;
				GeeList* _tmp35_;
				gint _doc_size = 0;
				GeeList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _doc_index = 0;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp34_ = docs;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp35_ = _g_object_ref0 (_tmp34_);
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_doc_list = _tmp35_;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp36_ = _doc_list;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_tmp38_ = _tmp37_;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_doc_size = _tmp38_;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_doc_index = -1;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				while (TRUE) {
#line 2150 "main_window_build_tools.c"
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					Document* doc = NULL;
					GeeList* _tmp42_;
					gint _tmp43_;
					gpointer _tmp44_;
					Document* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp39_ = _doc_index;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_doc_index = _tmp39_ + 1;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp40_ = _doc_index;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp41_ = _doc_size;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					if (!(_tmp40_ < _tmp41_)) {
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
						break;
#line 2174 "main_window_build_tools.c"
					}
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp42_ = _doc_list;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp43_ = _doc_index;
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					doc = (Document*) _tmp44_;
#line 380 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp45_ = doc;
#line 380 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp46_ = document_get_project_id (_tmp45_);
#line 380 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp47_ = _tmp46_;
#line 380 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_tmp48_ = project_id;
#line 380 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					if (_tmp47_ == _tmp48_) {
#line 2194 "main_window_build_tools.c"
						Document* _tmp49_;
#line 381 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
						_tmp49_ = doc;
#line 381 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
						document_save (_tmp49_, TRUE, FALSE);
#line 2200 "main_window_build_tools.c"
					}
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
					_g_object_unref0 (doc);
#line 2204 "main_window_build_tools.c"
				}
#line 378 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
				_g_object_unref0 (_doc_list);
#line 2208 "main_window_build_tools.c"
			}
#line 371 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			_g_object_unref0 (docs);
#line 2212 "main_window_build_tools.c"
		}
#line 386 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		utils_flush_queue ();
#line 2216 "main_window_build_tools.c"
	}
#line 391 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp50_ = active_doc;
#line 391 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp51_ = document_get_main_file (_tmp50_);
#line 391 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_file = _tmp51_;
#line 392 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp52_ = g_cancellable_new ();
#line 392 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 392 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_cancellable = _tmp52_;
#line 393 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_tool_result);
#line 393 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv->_build_tool_result = NULL;
#line 394 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_update_sensitivity (self);
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp53_ = _data22_->tool;
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp54_ = self->priv->_build_view;
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp55_ = self->priv->_cancellable;
#line 395 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	latexila_build_tool_run_async (_tmp53_, main_file, _tmp54_, _tmp55_, ___lambda28__gasync_ready_callback, block22_data_ref (_data22_));
#line 409 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp56_ = self->priv->_bottom_panel;
#line 409 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_widget_show ((GtkWidget*) _tmp56_);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (main_file);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (active_doc);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	block22_data_unref (_data22_);
#line 346 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_data22_ = NULL;
#line 2256 "main_window_build_tools.c"
}


static void
main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self)
{
	LatexilaBuildView* _tmp0_;
	GSettings* settings = NULL;
	GSettings* _tmp1_;
	GtkToggleAction* action_details = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	LatexilaBuildView* _tmp5_;
	LatexilaBuildView* _tmp6_;
	GtkToggleAction* action_warnings = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	LatexilaBuildView* _tmp10_;
	GtkToggleAction* action_badboxes = NULL;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_;
	GtkToggleAction* _tmp13_;
	LatexilaBuildView* _tmp14_;
#line 412 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 414 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_build_view;
#line 414 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 416 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 416 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	settings = _tmp1_;
#line 420 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = self->priv->_static_action_group;
#line 420 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = gtk_action_group_get_action (_tmp2_, "BuildShowDetails");
#line 420 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp3_) : NULL);
#line 420 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	action_details = _tmp4_;
#line 423 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_toggle_action_set_active (action_details, FALSE);
#line 425 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = self->priv->_build_view;
#line 425 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) action_details, "active", (GObject*) _tmp5_, "show-details", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 428 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = self->priv->_build_view;
#line 428 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "has-details", (GObject*) action_details, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 433 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = self->priv->_static_action_group;
#line 433 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowWarnings");
#line 433 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
#line 433 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	action_warnings = _tmp9_;
#line 436 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_toggle_action_set_active (action_warnings, g_settings_get_boolean (settings, "show-build-warnings"));
#line 438 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = self->priv->_build_view;
#line 438 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) action_warnings, "active", (GObject*) _tmp10_, "show-warnings", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 443 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = self->priv->_static_action_group;
#line 443 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "BuildShowBadBoxes");
#line 443 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp12_) : NULL);
#line 443 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	action_badboxes = _tmp13_;
#line 446 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	gtk_toggle_action_set_active (action_badboxes, g_settings_get_boolean (settings, "show-build-badboxes"));
#line 448 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp14_ = self->priv->_build_view;
#line 448 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_object_bind_property_with_closures ((GObject*) action_badboxes, "active", (GObject*) _tmp14_, "show-badboxes", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 412 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (action_badboxes);
#line 412 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (action_warnings);
#line 412 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (action_details);
#line 412 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (settings);
#line 2346 "main_window_build_tools.c"
}


void
main_window_build_tools_on_stop_execution (MainWindowBuildTools* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 454 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 456 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_cancellable;
#line 456 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 457 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = self->priv->_cancellable;
#line 457 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_cancellable_cancel (_tmp1_);
#line 2365 "main_window_build_tools.c"
}


void
main_window_build_tools_on_clean (MainWindowBuildTools* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	CleanBuildFiles* build_files = NULL;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	CleanBuildFiles* _tmp7_;
#line 460 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 462 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_main_window;
#line 462 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 462 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = _tmp1_;
#line 462 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 464 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = self->priv->_main_window;
#line 464 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = self->priv->_main_window;
#line 464 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = main_window_get_active_document (_tmp4_);
#line 464 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = _tmp5_;
#line 464 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = clean_build_files_new (_tmp3_, _tmp6_);
#line 464 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	build_files = _tmp7_;
#line 467 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	clean_build_files_clean (build_files);
#line 460 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (build_files);
#line 2407 "main_window_build_tools.c"
}


void
main_window_build_tools_on_view_log (MainWindowBuildTools* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GFile* mainfile = NULL;
	MainWindow* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	GFile* _tmp9_;
	GFile* directory = NULL;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* basename = NULL;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFile* file = NULL;
	GFile* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	DocumentTab* tab = NULL;
	MainWindow* _tmp22_;
	GFile* _tmp23_;
	DocumentTab* _tmp24_;
	DocumentTab* _tmp25_;
#line 470 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (self != NULL);
#line 472 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp0_ = self->priv->_main_window;
#line 472 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 472 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp2_ = _tmp1_;
#line 472 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 473 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp3_ = self->priv->_main_window;
#line 473 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp4_ = main_window_get_active_document (_tmp3_);
#line 473 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp5_ = _tmp4_;
#line 473 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (document_is_main_file_a_tex_file (_tmp5_));
#line 475 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp6_ = self->priv->_main_window;
#line 475 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp7_ = main_window_get_active_document (_tmp6_);
#line 475 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp8_ = _tmp7_;
#line 475 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp9_ = document_get_main_file (_tmp8_);
#line 475 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	mainfile = _tmp9_;
#line 476 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp10_ = mainfile;
#line 476 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp11_ = g_file_get_parent (_tmp10_);
#line 476 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	directory = _tmp11_;
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp12_ = mainfile;
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp13_ = g_file_get_basename (_tmp12_);
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp14_ = _tmp13_;
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp15_ = latexila_utils_get_shortname (_tmp14_);
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp16_ = _tmp15_;
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp17_ = g_strconcat (_tmp16_, ".log", NULL);
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp18_ = _tmp17_;
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp16_);
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (_tmp14_);
#line 478 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	basename = _tmp18_;
#line 479 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp19_ = directory;
#line 479 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp20_ = basename;
#line 479 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp21_ = g_file_get_child (_tmp19_, _tmp20_);
#line 479 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	file = _tmp21_;
#line 480 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp22_ = self->priv->_main_window;
#line 480 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp23_ = file;
#line 480 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp24_ = main_window_open_document (_tmp22_, _tmp23_, TRUE);
#line 480 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	tab = _tmp24_;
#line 482 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_tmp25_ = tab;
#line 482 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (_tmp25_ == NULL) {
#line 483 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_warning ("main_window_build_tools.vala:483: Impossible to view log");
#line 2521 "main_window_build_tools.c"
	} else {
		DocumentTab* _tmp26_;
		Document* _tmp27_;
		Document* _tmp28_;
#line 485 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp26_ = tab;
#line 485 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp27_ = document_tab_get_document (_tmp26_);
#line 485 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		_tmp28_ = _tmp27_;
#line 485 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		document_set_readonly (_tmp28_, TRUE);
#line 2534 "main_window_build_tools.c"
	}
#line 470 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (tab);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (file);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_free0 (basename);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (directory);
#line 470 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (mainfile);
#line 2546 "main_window_build_tools.c"
}


static void
value_main_window_build_tools_init (GValue* value)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	value->data[0].v_pointer = NULL;
#line 2555 "main_window_build_tools.c"
}


static void
value_main_window_build_tools_free_value (GValue* value)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (value->data[0].v_pointer) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		main_window_build_tools_unref (value->data[0].v_pointer);
#line 2566 "main_window_build_tools.c"
	}
}


static void
value_main_window_build_tools_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		dest_value->data[0].v_pointer = main_window_build_tools_ref (src_value->data[0].v_pointer);
#line 2579 "main_window_build_tools.c"
	} else {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2583 "main_window_build_tools.c"
	}
}


static gpointer
value_main_window_build_tools_peek_pointer (const GValue* value)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return value->data[0].v_pointer;
#line 2593 "main_window_build_tools.c"
}


static gchar*
value_main_window_build_tools_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (collect_values[0].v_pointer) {
#line 2605 "main_window_build_tools.c"
		MainWindowBuildTools * object;
		object = collect_values[0].v_pointer;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2612 "main_window_build_tools.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2616 "main_window_build_tools.c"
		}
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		value->data[0].v_pointer = main_window_build_tools_ref (object);
#line 2620 "main_window_build_tools.c"
	} else {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		value->data[0].v_pointer = NULL;
#line 2624 "main_window_build_tools.c"
	}
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return NULL;
#line 2628 "main_window_build_tools.c"
}


static gchar*
value_main_window_build_tools_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	MainWindowBuildTools ** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (!object_p) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2644 "main_window_build_tools.c"
	}
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (!value->data[0].v_pointer) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		*object_p = NULL;
#line 2650 "main_window_build_tools.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		*object_p = value->data[0].v_pointer;
#line 2654 "main_window_build_tools.c"
	} else {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		*object_p = main_window_build_tools_ref (value->data[0].v_pointer);
#line 2658 "main_window_build_tools.c"
	}
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return NULL;
#line 2662 "main_window_build_tools.c"
}


GParamSpec*
param_spec_main_window_build_tools (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ParamSpecMainWindowBuildTools* spec;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return G_PARAM_SPEC (spec);
#line 2682 "main_window_build_tools.c"
}


gpointer
value_get_main_window_build_tools (const GValue* value)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return value->data[0].v_pointer;
#line 2693 "main_window_build_tools.c"
}


void
value_set_main_window_build_tools (GValue* value,
                                   gpointer v_object)
{
	MainWindowBuildTools * old;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (v_object) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		value->data[0].v_pointer = v_object;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		main_window_build_tools_ref (value->data[0].v_pointer);
#line 2716 "main_window_build_tools.c"
	} else {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		value->data[0].v_pointer = NULL;
#line 2720 "main_window_build_tools.c"
	}
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (old) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		main_window_build_tools_unref (old);
#line 2726 "main_window_build_tools.c"
	}
}


void
value_take_main_window_build_tools (GValue* value,
                                    gpointer v_object)
{
	MainWindowBuildTools * old;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (v_object) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		value->data[0].v_pointer = v_object;
#line 2748 "main_window_build_tools.c"
	} else {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		value->data[0].v_pointer = NULL;
#line 2752 "main_window_build_tools.c"
	}
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (old) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		main_window_build_tools_unref (old);
#line 2758 "main_window_build_tools.c"
	}
}


static void
main_window_build_tools_class_init (MainWindowBuildToolsClass * klass)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	main_window_build_tools_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	((MainWindowBuildToolsClass *) klass)->finalize = main_window_build_tools_finalize;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_type_class_add_private (klass, sizeof (MainWindowBuildToolsPrivate));
#line 2772 "main_window_build_tools.c"
}


static void
main_window_build_tools_instance_init (MainWindowBuildTools * self)
{
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->priv = MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE (self);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self->ref_count = 1;
#line 2783 "main_window_build_tools.c"
}


static void
main_window_build_tools_finalize (MainWindowBuildTools * obj)
{
	MainWindowBuildTools * self;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_signal_handlers_destroy (self);
#line 57 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 58 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_view);
#line 59 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_bottom_panel);
#line 62 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 63 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_build_tool_result);
#line 65 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_static_action_group);
#line 66 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	_g_object_unref0 (self->priv->_dynamic_action_group);
#line 2809 "main_window_build_tools.c"
}


GType
main_window_build_tools_get_type (void)
{
	static volatile gsize main_window_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_build_tools_init, value_main_window_build_tools_free_value, value_main_window_build_tools_copy_value, value_main_window_build_tools_peek_pointer, "p", value_main_window_build_tools_collect_value, "p", value_main_window_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowBuildTools), 0, (GInstanceInitFunc) main_window_build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_build_tools_type_id;
		main_window_build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowBuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_build_tools_type_id__volatile, main_window_build_tools_type_id);
	}
	return main_window_build_tools_type_id__volatile;
}


gpointer
main_window_build_tools_ref (gpointer instance)
{
	MainWindowBuildTools * self;
	self = instance;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	return instance;
#line 2838 "main_window_build_tools.c"
}


void
main_window_build_tools_unref (gpointer instance)
{
	MainWindowBuildTools * self;
	self = instance;
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		MAIN_WINDOW_BUILD_TOOLS_GET_CLASS (self)->finalize (self);
#line 24 "/home/seb/gnome/gnome-latex/src/main_window_build_tools.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2853 "main_window_build_tools.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 2865 "main_window_build_tools.c"
		int i;
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 2873 "main_window_build_tools.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	g_free (array);
#line 2889 "main_window_build_tools.c"
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	if (array) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
			length++;
#line 2904 "main_window_build_tools.c"
		}
	}
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	return length;
#line 2909 "main_window_build_tools.c"
}



