/* main_window_structure.c generated by valac 0.40.10, the Vala compiler
 * generated from main_window_structure.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;
typedef struct _MainWindowStructurePrivate MainWindowStructurePrivate;

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_STRUCT_TYPE (struct_type_get_type ())

#define TYPE_STRUCT_ACTION (struct_action_get_type ())
typedef struct _ParamSpecMainWindowStructure ParamSpecMainWindowStructure;

struct _MainWindowStructure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowStructurePrivate * priv;
};

struct _MainWindowStructureClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowStructure *self);
};

struct _MainWindowStructurePrivate {
	GtkUIManager* _ui_manager;
	Structure* _structure;
};

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

struct _ParamSpecMainWindowStructure {
	GParamSpec parent_instance;
};


static gpointer main_window_structure_parent_class = NULL;

gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_structure (GValue* value,
                                      gpointer v_object);
void value_take_main_window_structure (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
GType structure_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_STRUCTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructurePrivate))
void main_window_structure_on_cut (MainWindowStructure* self);
static void _main_window_structure_on_cut_gtk_action_callback (GtkAction* action,
                                                        gpointer self);
void main_window_structure_on_copy (MainWindowStructure* self);
static void _main_window_structure_on_copy_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_structure_on_delete (MainWindowStructure* self);
static void _main_window_structure_on_delete_gtk_action_callback (GtkAction* action,
                                                           gpointer self);
void main_window_structure_on_select (MainWindowStructure* self);
static void _main_window_structure_on_select_gtk_action_callback (GtkAction* action,
                                                           gpointer self);
void main_window_structure_on_comment (MainWindowStructure* self);
static void _main_window_structure_on_comment_gtk_action_callback (GtkAction* action,
                                                            gpointer self);
void main_window_structure_on_shift_left (MainWindowStructure* self);
static void _main_window_structure_on_shift_left_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
void main_window_structure_on_shift_right (MainWindowStructure* self);
static void _main_window_structure_on_shift_right_gtk_action_callback (GtkAction* action,
                                                                gpointer self);
void main_window_structure_on_open_file (MainWindowStructure* self);
static void _main_window_structure_on_open_file_gtk_action_callback (GtkAction* action,
                                                              gpointer self);
MainWindowStructure* main_window_structure_new (GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_construct (GType object_type,
                                                      GtkUIManager* ui_manager);
void main_window_structure_set_structure (MainWindowStructure* self,
                                          Structure* structure);
static void main_window_structure_show_popup_menu (MainWindowStructure* self,
                                            GdkEventButton* event);
static void _main_window_structure_show_popup_menu_structure_show_popup_menu (Structure* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self);
static void main_window_structure_set_menu_insensitive (MainWindowStructure* self);
static void _main_window_structure_set_menu_insensitive_gtk_widget_hide (GtkWidget* _sender,
                                                                  gpointer self);
static void _main_window_structure_set_menu_insensitive_structure_no_items_selected (Structure* _sender,
                                                                              gpointer self);
GType struct_type_get_type (void) G_GNUC_CONST;
static void main_window_structure_set_actions_sensitivity (MainWindowStructure* self,
                                                    StructType type);
static void _main_window_structure_set_actions_sensitivity_structure_item_selected (Structure* _sender,
                                                                             StructType type,
                                                                             gpointer self);
void main_window_structure_save_state (MainWindowStructure* self);
void structure_save_state (Structure* self);
void main_window_structure_refresh (MainWindowStructure* self);
void structure_refresh (Structure* self);
GType struct_action_get_type (void) G_GNUC_CONST;
void structure_do_action (Structure* self,
                          StructAction action_type);
static void main_window_structure_finalize (MainWindowStructure * obj);

static const GtkActionEntry MAIN_WINDOW_STRUCTURE__action_entries[9] = {{"Structure", NULL, N_ ("S_tructure")}, {"StructureCut", "edit-cut", N_ ("Cu_t"), "", N_ ("Cut the selected structure item"), (GCallback) _main_window_structure_on_cut_gtk_action_callback}, {"StructureCopy", "edit-copy", N_ ("_Copy"), "", N_ ("Copy the selected structure item"), (GCallback) _main_window_structure_on_copy_gtk_action_callback}, {"StructureDelete", "edit-delete", N_ ("_Delete"), "", N_ ("Delete the selected structure item"), (GCallback) _main_window_structure_on_delete_gtk_action_callback}, {"StructureSelect", "edit-select-all", N_ ("_Select"), "", N_ ("Select the contents of the selected structure item"), (GCallback) _main_window_structure_on_select_gtk_action_callback}, {"StructureComment", NULL, N_ ("_Comment"), NULL, N_ ("Comment the selected structure item"), (GCallback) _main_window_structure_on_comment_gtk_action_callback}, {"StructureShiftLeft", "go-previous", N_ ("Shift _Left"), "", N_ ("Shift the selected structure item to the left (e.g. section → chapter)"), (GCallback) _main_window_structure_on_shift_left_gtk_action_callback}, {"StructureShiftRight", "go-next", N_ ("Shift _Right"), "", N_ ("Shift the selected structure item to the right (e.g. chapter → section" \
")"), (GCallback) _main_window_structure_on_shift_right_gtk_action_callback}, {"StructureOpenFile", "document-open", N_ ("_Open File"), "", N_ ("Open the file referenced by the selected structure item"), (GCallback) _main_window_structure_on_open_file_gtk_action_callback}};

static void
_main_window_structure_on_cut_gtk_action_callback (GtkAction* action,
                                                   gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_cut ((MainWindowStructure*) self);
#line 207 "main_window_structure.c"
}


static void
_main_window_structure_on_copy_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_copy ((MainWindowStructure*) self);
#line 217 "main_window_structure.c"
}


static void
_main_window_structure_on_delete_gtk_action_callback (GtkAction* action,
                                                      gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_delete ((MainWindowStructure*) self);
#line 227 "main_window_structure.c"
}


static void
_main_window_structure_on_select_gtk_action_callback (GtkAction* action,
                                                      gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_select ((MainWindowStructure*) self);
#line 237 "main_window_structure.c"
}


static void
_main_window_structure_on_comment_gtk_action_callback (GtkAction* action,
                                                       gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_comment ((MainWindowStructure*) self);
#line 247 "main_window_structure.c"
}


static void
_main_window_structure_on_shift_left_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_shift_left ((MainWindowStructure*) self);
#line 257 "main_window_structure.c"
}


static void
_main_window_structure_on_shift_right_gtk_action_callback (GtkAction* action,
                                                           gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_shift_right ((MainWindowStructure*) self);
#line 267 "main_window_structure.c"
}


static void
_main_window_structure_on_open_file_gtk_action_callback (GtkAction* action,
                                                         gpointer self)
{
#line 28 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_on_open_file ((MainWindowStructure*) self);
#line 277 "main_window_structure.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 65 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return self ? g_object_ref (self) : NULL;
#line 286 "main_window_structure.c"
}


MainWindowStructure*
main_window_structure_construct (GType object_type,
                                 GtkUIManager* ui_manager)
{
	MainWindowStructure* self = NULL;
	GtkUIManager* _tmp0_;
	GtkActionGroup* action_group = NULL;
	GtkActionGroup* _tmp1_;
#line 63 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_val_if_fail (ui_manager != NULL, NULL);
#line 63 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	self = (MainWindowStructure*) g_type_create_instance (object_type);
#line 65 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = _g_object_ref0 (ui_manager);
#line 65 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 65 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	self->priv->_ui_manager = _tmp0_;
#line 67 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = gtk_action_group_new ("StructureActionGroup");
#line 67 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	action_group = _tmp1_;
#line 68 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_action_group_set_translation_domain (action_group, GETTEXT_PACKAGE);
#line 69 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_action_group_add_actions (action_group, MAIN_WINDOW_STRUCTURE__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_STRUCTURE__action_entries), self);
#line 71 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_ui_manager_insert_action_group (ui_manager, action_group, 0);
#line 63 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (action_group);
#line 63 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return self;
#line 322 "main_window_structure.c"
}


MainWindowStructure*
main_window_structure_new (GtkUIManager* ui_manager)
{
#line 63 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return main_window_structure_construct (TYPE_MAIN_WINDOW_STRUCTURE, ui_manager);
#line 331 "main_window_structure.c"
}


static void
_main_window_structure_show_popup_menu_structure_show_popup_menu (Structure* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
#line 78 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_show_popup_menu ((MainWindowStructure*) self, event);
#line 342 "main_window_structure.c"
}


static void
_main_window_structure_set_menu_insensitive_gtk_widget_hide (GtkWidget* _sender,
                                                             gpointer self)
{
#line 79 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_set_menu_insensitive ((MainWindowStructure*) self);
#line 352 "main_window_structure.c"
}


static void
_main_window_structure_set_menu_insensitive_structure_no_items_selected (Structure* _sender,
                                                                         gpointer self)
{
#line 80 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_set_menu_insensitive ((MainWindowStructure*) self);
#line 362 "main_window_structure.c"
}


static void
_main_window_structure_set_actions_sensitivity_structure_item_selected (Structure* _sender,
                                                                        StructType type,
                                                                        gpointer self)
{
#line 81 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_set_actions_sensitivity ((MainWindowStructure*) self, type);
#line 373 "main_window_structure.c"
}


void
main_window_structure_set_structure (MainWindowStructure* self,
                                     Structure* structure)
{
	Structure* _tmp0_;
#line 74 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (structure != NULL);
#line 76 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = _g_object_ref0 (structure);
#line 76 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (self->priv->_structure);
#line 76 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	self->priv->_structure = _tmp0_;
#line 78 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_signal_connect (structure, "show-popup-menu", (GCallback) _main_window_structure_show_popup_menu_structure_show_popup_menu, self);
#line 79 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_signal_connect ((GtkWidget*) structure, "hide", (GCallback) _main_window_structure_set_menu_insensitive_gtk_widget_hide, self);
#line 80 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_signal_connect (structure, "no-items-selected", (GCallback) _main_window_structure_set_menu_insensitive_structure_no_items_selected, self);
#line 81 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_signal_connect (structure, "item-selected", (GCallback) _main_window_structure_set_actions_sensitivity_structure_item_selected, self);
#line 400 "main_window_structure.c"
}


void
main_window_structure_save_state (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 84 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 86 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 87 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 87 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_save_state (_tmp1_);
#line 419 "main_window_structure.c"
}


void
main_window_structure_refresh (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 90 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 92 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 93 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 93 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_refresh (_tmp1_);
#line 438 "main_window_structure.c"
}


static void
main_window_structure_show_popup_menu (MainWindowStructure* self,
                                       GdkEventButton* event)
{
	GtkMenu* popup_menu = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkMenu* _tmp2_;
#line 96 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 98 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/StructurePopup");
#line 98 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_get_type ()) ? ((GtkMenu*) _tmp1_) : NULL);
#line 98 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	popup_menu = _tmp2_;
#line 99 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_menu_popup_at_pointer (popup_menu, (GdkEvent*) event);
#line 96 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (popup_menu);
#line 464 "main_window_structure.c"
}


static void
main_window_structure_set_menu_insensitive (MainWindowStructure* self)
{
	GtkUIManager* _tmp0_;
	GtkAction* menu = NULL;
	GtkUIManager* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
#line 102 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 104 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 106 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_ui_manager;
#line 106 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp2_ = gtk_ui_manager_get_action (_tmp1_, "/MainMenu/Structure");
#line 106 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 106 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	menu = _tmp3_;
#line 107 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_action_set_sensitive (menu, FALSE);
#line 102 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (menu);
#line 494 "main_window_structure.c"
}


static void
main_window_structure_set_actions_sensitivity (MainWindowStructure* self,
                                               StructType type)
{
	GtkAction* menu = NULL;
	GtkUIManager* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* shift_left = NULL;
	GtkUIManager* _tmp4_;
	GtkAction* _tmp5_;
	GtkAction* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GtkAction* _tmp8_;
	GtkAction* shift_right = NULL;
	GtkUIManager* _tmp9_;
	GtkAction* _tmp10_;
	GtkAction* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GtkAction* _tmp13_;
	GtkAction* open_file = NULL;
	GtkUIManager* _tmp14_;
	GtkAction* _tmp15_;
	GtkAction* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GtkAction* _tmp18_;
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 112 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = gtk_ui_manager_get_action (_tmp0_, "/MainMenu/Structure");
#line 112 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 112 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	menu = _tmp2_;
#line 113 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp3_ = menu;
#line 113 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_action_set_sensitive (_tmp3_, TRUE);
#line 115 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp4_ = self->priv->_ui_manager;
#line 115 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp5_ = gtk_ui_manager_get_action (_tmp4_, "/StructurePopup/StructureShiftLeft");
#line 115 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 115 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	shift_left = _tmp6_;
#line 118 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (STRUCT_TYPE_PART < type) {
#line 118 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		_tmp7_ = type <= STRUCT_TYPE_SUBPARAGRAPH;
#line 551 "main_window_structure.c"
	} else {
#line 118 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		_tmp7_ = FALSE;
#line 555 "main_window_structure.c"
	}
#line 118 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp8_ = shift_left;
#line 118 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_action_set_sensitive (_tmp8_, _tmp7_);
#line 120 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp9_ = self->priv->_ui_manager;
#line 120 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp10_ = gtk_ui_manager_get_action (_tmp9_, "/StructurePopup/StructureShiftRight");
#line 120 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 120 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	shift_right = _tmp11_;
#line 123 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (STRUCT_TYPE_PART <= type) {
#line 123 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		_tmp12_ = type < STRUCT_TYPE_SUBPARAGRAPH;
#line 573 "main_window_structure.c"
	} else {
#line 123 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		_tmp12_ = FALSE;
#line 577 "main_window_structure.c"
	}
#line 123 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp13_ = shift_right;
#line 123 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_action_set_sensitive (_tmp13_, _tmp12_);
#line 125 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp14_ = self->priv->_ui_manager;
#line 125 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp15_ = gtk_ui_manager_get_action (_tmp14_, "/StructurePopup/StructureOpenFile");
#line 125 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp16_ = _g_object_ref0 (_tmp15_);
#line 125 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	open_file = _tmp16_;
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (type == STRUCT_TYPE_INCLUDE) {
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		_tmp17_ = TRUE;
#line 595 "main_window_structure.c"
	} else {
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		_tmp17_ = type == STRUCT_TYPE_IMAGE;
#line 599 "main_window_structure.c"
	}
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp18_ = open_file;
#line 128 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	gtk_action_set_sensitive (_tmp18_, _tmp17_);
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (open_file);
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (shift_right);
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (shift_left);
#line 110 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (menu);
#line 613 "main_window_structure.c"
}


void
main_window_structure_on_cut (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 133 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 135 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 136 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 136 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_CUT);
#line 632 "main_window_structure.c"
}


void
main_window_structure_on_copy (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 139 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 141 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 142 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 142 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_COPY);
#line 651 "main_window_structure.c"
}


void
main_window_structure_on_delete (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 145 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 147 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 148 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 148 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_DELETE);
#line 670 "main_window_structure.c"
}


void
main_window_structure_on_select (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 151 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 153 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 153 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 154 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 154 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_SELECT);
#line 689 "main_window_structure.c"
}


void
main_window_structure_on_comment (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 157 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 159 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 160 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 160 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_COMMENT);
#line 708 "main_window_structure.c"
}


void
main_window_structure_on_shift_left (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 163 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 165 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 165 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 166 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_SHIFT_LEFT);
#line 727 "main_window_structure.c"
}


void
main_window_structure_on_shift_right (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 169 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 171 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 171 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 172 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 172 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_SHIFT_RIGHT);
#line 746 "main_window_structure.c"
}


void
main_window_structure_on_open_file (MainWindowStructure* self)
{
	Structure* _tmp0_;
	Structure* _tmp1_;
#line 175 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (self != NULL);
#line 177 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp0_ = self->priv->_structure;
#line 177 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 178 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_tmp1_ = self->priv->_structure;
#line 178 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	structure_do_action (_tmp1_, STRUCT_ACTION_OPEN_FILE);
#line 765 "main_window_structure.c"
}


static void
value_main_window_structure_init (GValue* value)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	value->data[0].v_pointer = NULL;
#line 774 "main_window_structure.c"
}


static void
value_main_window_structure_free_value (GValue* value)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (value->data[0].v_pointer) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		main_window_structure_unref (value->data[0].v_pointer);
#line 785 "main_window_structure.c"
	}
}


static void
value_main_window_structure_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		dest_value->data[0].v_pointer = main_window_structure_ref (src_value->data[0].v_pointer);
#line 798 "main_window_structure.c"
	} else {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		dest_value->data[0].v_pointer = NULL;
#line 802 "main_window_structure.c"
	}
}


static gpointer
value_main_window_structure_peek_pointer (const GValue* value)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return value->data[0].v_pointer;
#line 812 "main_window_structure.c"
}


static gchar*
value_main_window_structure_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (collect_values[0].v_pointer) {
#line 824 "main_window_structure.c"
		MainWindowStructure * object;
		object = collect_values[0].v_pointer;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 831 "main_window_structure.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 835 "main_window_structure.c"
		}
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		value->data[0].v_pointer = main_window_structure_ref (object);
#line 839 "main_window_structure.c"
	} else {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		value->data[0].v_pointer = NULL;
#line 843 "main_window_structure.c"
	}
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return NULL;
#line 847 "main_window_structure.c"
}


static gchar*
value_main_window_structure_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	MainWindowStructure ** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (!object_p) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 863 "main_window_structure.c"
	}
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (!value->data[0].v_pointer) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		*object_p = NULL;
#line 869 "main_window_structure.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		*object_p = value->data[0].v_pointer;
#line 873 "main_window_structure.c"
	} else {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		*object_p = main_window_structure_ref (value->data[0].v_pointer);
#line 877 "main_window_structure.c"
	}
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return NULL;
#line 881 "main_window_structure.c"
}


GParamSpec*
param_spec_main_window_structure (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ParamSpecMainWindowStructure* spec;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_STRUCTURE), NULL);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return G_PARAM_SPEC (spec);
#line 901 "main_window_structure.c"
}


gpointer
value_get_main_window_structure (const GValue* value)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_STRUCTURE), NULL);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return value->data[0].v_pointer;
#line 912 "main_window_structure.c"
}


void
value_set_main_window_structure (GValue* value,
                                 gpointer v_object)
{
	MainWindowStructure * old;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_STRUCTURE));
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (v_object) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_STRUCTURE));
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		value->data[0].v_pointer = v_object;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		main_window_structure_ref (value->data[0].v_pointer);
#line 935 "main_window_structure.c"
	} else {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		value->data[0].v_pointer = NULL;
#line 939 "main_window_structure.c"
	}
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (old) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		main_window_structure_unref (old);
#line 945 "main_window_structure.c"
	}
}


void
value_take_main_window_structure (GValue* value,
                                  gpointer v_object)
{
	MainWindowStructure * old;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_STRUCTURE));
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (v_object) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_STRUCTURE));
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		value->data[0].v_pointer = v_object;
#line 967 "main_window_structure.c"
	} else {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		value->data[0].v_pointer = NULL;
#line 971 "main_window_structure.c"
	}
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (old) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		main_window_structure_unref (old);
#line 977 "main_window_structure.c"
	}
}


static void
main_window_structure_class_init (MainWindowStructureClass * klass)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	main_window_structure_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	((MainWindowStructureClass *) klass)->finalize = main_window_structure_finalize;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_type_class_add_private (klass, sizeof (MainWindowStructurePrivate));
#line 991 "main_window_structure.c"
}


static void
main_window_structure_instance_init (MainWindowStructure * self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	self->priv = MAIN_WINDOW_STRUCTURE_GET_PRIVATE (self);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	self->ref_count = 1;
#line 1002 "main_window_structure.c"
}


static void
main_window_structure_finalize (MainWindowStructure * obj)
{
	MainWindowStructure * self;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_signal_handlers_destroy (self);
#line 60 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 61 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	_g_object_unref0 (self->priv->_structure);
#line 1018 "main_window_structure.c"
}


GType
main_window_structure_get_type (void)
{
	static volatile gsize main_window_structure_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_structure_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_structure_init, value_main_window_structure_free_value, value_main_window_structure_copy_value, value_main_window_structure_peek_pointer, "p", value_main_window_structure_collect_value, "p", value_main_window_structure_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowStructure), 0, (GInstanceInitFunc) main_window_structure_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_structure_type_id;
		main_window_structure_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowStructure", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_structure_type_id__volatile, main_window_structure_type_id);
	}
	return main_window_structure_type_id__volatile;
}


gpointer
main_window_structure_ref (gpointer instance)
{
	MainWindowStructure * self;
	self = instance;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	return instance;
#line 1047 "main_window_structure.c"
}


void
main_window_structure_unref (gpointer instance)
{
	MainWindowStructure * self;
	self = instance;
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		MAIN_WINDOW_STRUCTURE_GET_CLASS (self)->finalize (self);
#line 26 "/home/seb/gnome/gnome-latex/src/main_window_structure.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1062 "main_window_structure.c"
	}
}



