/* $Id: uicomponent.cc,v 1.4 2003/07/16 05:35:53 murrayc Exp $ */

/* uicomponent.cc
 *
 * Copyright (C) 2002 The libbonobouimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "bonobomm/servers/uicomponent.h"

namespace Gnome
{

namespace Bonobo
{

namespace Servers
{

UIComponent::UIComponent()
{
  m_name = "murrayctest";
}

UIComponent::~UIComponent()
{
}

void UIComponent::setContainer(::Bonobo::UIContainer_ptr container) throw (CORBA::SystemException)
{
  m_container = container;
  if(m_container)
  {
    ::Bonobo::UIComponent_var stubThis = ::Bonobo::UIComponent::_narrow( _this() );
    CORBA::String_var strName = name();
    m_container->registerComponent(strName, stubThis);
  }
}

void UIComponent::unsetContainer() throw (CORBA::SystemException)
{
  if(m_container)
  {
    CORBA::String_var strName = name();
    m_container->deregisterComponent(strName);
  }
}

char* UIComponent::name() throw (CORBA::SystemException)
{
  return CORBA::string_dup(m_name.c_str());
}

char* UIComponent::describeVerbs() throw (CORBA::SystemException)
{
  Glib::ustring strResult;
  for(type_mapSlots::iterator iter = m_mapSlots.begin(); iter != m_mapSlots.end(); iter++)
  {
    strResult += iter->first + "\n";
  }

  return g_strdup(strResult.c_str());
}

void UIComponent::execVerb(char const *cname) throw (CORBA::SystemException)
{
  if(cname)
  {
    //Call the appropriate callback:
    Glib::ustring strName = cname;

    //Get the slot for the verb name:
    type_mapSlots::iterator iterFind = m_mapSlots.find(strName);
    if( iterFind != m_mapSlots.end() )  //If it was found in the map:
    {
      (iterFind->second)(); //Calls the slot.
    }
  }
}

void UIComponent::uiEvent(char const *id,::Bonobo::UIComponent::EventType type, char const *state) throw (CORBA::SystemException)
{ }

void UIComponent::unImplemented() throw (CORBA::SystemException)
{ }

void UIComponent::unImplemented2() throw (CORBA::SystemException)
{ }

void UIComponent::unImplemented3() throw (CORBA::SystemException)
{ }

void UIComponent::unImplemented4() throw (CORBA::SystemException)
{ }

void UIComponent::add_verb_handler(const SlotVerbHandler& slot, const Glib::ustring& verb_name)
{
  m_mapSlots[verb_name] = slot;
}

} /* namespace Servers */
} /* namespace Bonobo */
} /* namespace Gnome */


