/********************************************************************\
 * guile-util.h -- utility functions for using guile for GnuCash    *
 * Copyright (C) 1999 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 59 Temple Place - Suite 330        Fax:    +1-617-542-2652       *
 * Boston, MA  02111-1307,  USA       gnu@gnu.org                   *
 *                                                                  *
\********************************************************************/

#ifndef __GUILE_UTIL_H__
#define __GUILE_UTIL_H__

#include <glib.h>
#include <guile/gh.h>

#include "date.h"
#include "gnc-book.h"
#include "gnc-numeric.h"
#include "Group.h"


/* Helpful functions for calling functions that return
 * specific kinds of values. These functions do error
 * checking to verify the result is of the correct type. */
char * gnc_guile_call1_to_string(SCM func, SCM arg);
char * gnc_guile_call1_symbol_to_string(SCM func, SCM arg);
SCM    gnc_guile_call1_to_procedure(SCM func, SCM arg);
SCM    gnc_guile_call1_to_list(SCM func, SCM arg);
SCM    gnc_guile_list_ref(SCM list, int index);
SCM    gnc_guile_call1_to_vector(SCM func, SCM arg);

/* Accessing the gnucash/guile dependency mechanism */
gboolean gnc_depend(const char *scm_file);

/* The next set of functions is for manipulating scheme
 * representations of splits and transactions. */
gboolean gnc_is_split_scm(SCM scm);
gboolean gnc_is_trans_scm(SCM scm);

SCM    gnc_copy_split(Split *split, gboolean use_cut_semantics);
void   gnc_copy_split_scm_onto_split(SCM split_scm, Split *split);

void   gnc_split_scm_set_account(SCM split_scm, Account *account);
void   gnc_split_scm_set_memo(SCM split_scm, const char *memo);
void   gnc_split_scm_set_action(SCM split_scm, const char *action);
void   gnc_split_scm_set_reconcile_state(SCM split_scm, char reconcile_state);
void   gnc_split_scm_set_quantity(SCM split_scm, gnc_numeric quantity);
void   gnc_split_scm_set_value(SCM split_scm, gnc_numeric value);

char * gnc_split_scm_get_memo(SCM split_scm);
char * gnc_split_scm_get_action(SCM split_scm);
gnc_numeric gnc_split_scm_get_quantity(SCM split_scm);
gnc_numeric gnc_split_scm_get_value(SCM split_scm);

SCM    gnc_copy_trans(Transaction *trans, gboolean use_cut_semantics);
void   gnc_copy_trans_scm_onto_trans(SCM trans_scm, Transaction *trans,
                                     gboolean do_commit);
void   gnc_copy_trans_scm_onto_trans_swap_accounts(SCM trans_scm,
                                                   Transaction *trans,
                                                   const GUID *guid_1,
                                                   const GUID *guid_2,
                                                   gboolean do_commit);

void   gnc_trans_scm_set_date(SCM trans_scm, Timespec *ts);
void   gnc_trans_scm_set_num(SCM trans_scm, const char *num);
void   gnc_trans_scm_set_description(SCM trans_scm, const char *description);
void   gnc_trans_scm_set_notes(SCM trans_scm, const char *notes);
void   gnc_trans_scm_append_split_scm(SCM trans_scm, SCM split_scm);

SCM    gnc_trans_scm_get_split_scm(SCM trans_scm, int index);
SCM    gnc_trans_scm_get_other_split_scm(SCM trans_scm, SCM split_scm);
int    gnc_trans_scm_get_num_splits(SCM trans_scm);

/* Two functions that return string synonyms for the terms 'debit' and
 * 'credit' as appropriate for the given account type and user preferences.
 * They should be g_freed when no longer needed. */
char * gnc_get_debit_string(GNCAccountType account_type);
char * gnc_get_credit_string(GNCAccountType account_type);

gnc_commodity *       gnc_scm_to_commodity (SCM scm);
SCM                   gnc_commodity_to_scm (const gnc_commodity *commodity);

SCM                   gnc_book_to_scm (GNCBook *book);

/* utilities for passing lists/GLists across */

/* The GList is freed */
SCM     gnc_glist_account_ptr_to_scm(GList *account_list);
/* The GList is not freed */
SCM     gnc_glist_account_ptr_to_scm_no_free (GList *account_list);
GList * gnc_scm_to_glist_account_ptr(SCM scm_list);
int     gnc_glist_account_ptr_p(SCM scm_list);

/* The GList is freed */
SCM     gnc_glist_string_to_scm(GList * list);
GList * gnc_scm_to_glist_string(SCM list);
int     gnc_glist_string_p(SCM list);

/* The GList is freed */
SCM     gnc_glist_commodity_ptr_to_scm(GList * list);
GList * gnc_scm_to_glist_commodity_ptr(SCM list);
int     gnc_glist_commodity_ptr_p(SCM list);

/* The GList is freed */
SCM     gnc_glist_price_ptr_to_scm(GList * list);
GList * gnc_scm_to_glist_price_ptr(SCM list);
int     gnc_glist_price_ptr_p(SCM list);

#endif
