/* keyboard.c generated by valac 0.36.4, the Vala compiler
 * generated from keyboard.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>


#define RETRO_TYPE_KEYBOARD_KEY (retro_keyboard_key_get_type ())

#define RETRO_TYPE_KEYBOARD_MODIFIER_KEY (retro_keyboard_modifier_key_get_type ())

#define RETRO_TYPE_KEYBOARD (retro_keyboard_get_type ())
#define RETRO_KEYBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_KEYBOARD, RetroKeyboard))
#define RETRO_KEYBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_KEYBOARD, RetroKeyboardClass))
#define RETRO_IS_KEYBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_KEYBOARD))
#define RETRO_IS_KEYBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_KEYBOARD))
#define RETRO_KEYBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_KEYBOARD, RetroKeyboardClass))

typedef struct _RetroKeyboard RetroKeyboard;
typedef struct _RetroKeyboardClass RetroKeyboardClass;
typedef struct _RetroKeyboardPrivate RetroKeyboardPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	RETRO_KEYBOARD_KEY_EVENT_SIGNAL,
	RETRO_KEYBOARD_LAST_SIGNAL
};
static guint retro_keyboard_signals[RETRO_KEYBOARD_LAST_SIGNAL] = {0};

typedef enum  {
	RETRO_KEYBOARD_KEY_UNKNOWN = 0,
	RETRO_KEYBOARD_KEY_FIRST = 0,
	RETRO_KEYBOARD_KEY_BACKSPACE = 8,
	RETRO_KEYBOARD_KEY_TAB = 9,
	RETRO_KEYBOARD_KEY_CLEAR = 12,
	RETRO_KEYBOARD_KEY_RETURN = 13,
	RETRO_KEYBOARD_KEY_PAUSE = 19,
	RETRO_KEYBOARD_KEY_ESCAPE = 27,
	RETRO_KEYBOARD_KEY_SPACE = 32,
	RETRO_KEYBOARD_KEY_EXCLAIM = 33,
	RETRO_KEYBOARD_KEY_QUOTEDBL = 34,
	RETRO_KEYBOARD_KEY_HASH = 35,
	RETRO_KEYBOARD_KEY_DOLLAR = 36,
	RETRO_KEYBOARD_KEY_AMPERSAND = 38,
	RETRO_KEYBOARD_KEY_QUOTE = 39,
	RETRO_KEYBOARD_KEY_LEFTPAREN = 40,
	RETRO_KEYBOARD_KEY_RIGHTPAREN = 41,
	RETRO_KEYBOARD_KEY_ASTERISK = 42,
	RETRO_KEYBOARD_KEY_PLUS = 43,
	RETRO_KEYBOARD_KEY_COMMA = 44,
	RETRO_KEYBOARD_KEY_MINUS = 45,
	RETRO_KEYBOARD_KEY_PERIOD = 46,
	RETRO_KEYBOARD_KEY_SLASH = 47,
	RETRO_KEYBOARD_KEY_ZERO = 48,
	RETRO_KEYBOARD_KEY_ONE = 49,
	RETRO_KEYBOARD_KEY_TWO = 50,
	RETRO_KEYBOARD_KEY_THREE = 51,
	RETRO_KEYBOARD_KEY_FOUR = 52,
	RETRO_KEYBOARD_KEY_FINE = 53,
	RETRO_KEYBOARD_KEY_SIX = 54,
	RETRO_KEYBOARD_KEY_SEVEN = 55,
	RETRO_KEYBOARD_KEY_HEIGHT = 56,
	RETRO_KEYBOARD_KEY_NINE = 57,
	RETRO_KEYBOARD_KEY_COLON = 58,
	RETRO_KEYBOARD_KEY_SEMICOLON = 59,
	RETRO_KEYBOARD_KEY_LESS = 60,
	RETRO_KEYBOARD_KEY_EQUALS = 61,
	RETRO_KEYBOARD_KEY_GREATER = 62,
	RETRO_KEYBOARD_KEY_QUESTION = 63,
	RETRO_KEYBOARD_KEY_AT = 64,
	RETRO_KEYBOARD_KEY_LEFTBRACKET = 91,
	RETRO_KEYBOARD_KEY_BACKSLASH = 92,
	RETRO_KEYBOARD_KEY_RIGHTBRACKET = 93,
	RETRO_KEYBOARD_KEY_CARET = 94,
	RETRO_KEYBOARD_KEY_UNDERSCORE = 95,
	RETRO_KEYBOARD_KEY_BACKQUOTE = 96,
	RETRO_KEYBOARD_KEY_a = 97,
	RETRO_KEYBOARD_KEY_b = 98,
	RETRO_KEYBOARD_KEY_c = 99,
	RETRO_KEYBOARD_KEY_d = 100,
	RETRO_KEYBOARD_KEY_e = 101,
	RETRO_KEYBOARD_KEY_f = 102,
	RETRO_KEYBOARD_KEY_g = 103,
	RETRO_KEYBOARD_KEY_h = 104,
	RETRO_KEYBOARD_KEY_i = 105,
	RETRO_KEYBOARD_KEY_j = 106,
	RETRO_KEYBOARD_KEY_k = 107,
	RETRO_KEYBOARD_KEY_l = 108,
	RETRO_KEYBOARD_KEY_m = 109,
	RETRO_KEYBOARD_KEY_n = 110,
	RETRO_KEYBOARD_KEY_o = 111,
	RETRO_KEYBOARD_KEY_p = 112,
	RETRO_KEYBOARD_KEY_q = 113,
	RETRO_KEYBOARD_KEY_r = 114,
	RETRO_KEYBOARD_KEY_s = 115,
	RETRO_KEYBOARD_KEY_t = 116,
	RETRO_KEYBOARD_KEY_u = 117,
	RETRO_KEYBOARD_KEY_v = 118,
	RETRO_KEYBOARD_KEY_w = 119,
	RETRO_KEYBOARD_KEY_x = 120,
	RETRO_KEYBOARD_KEY_y = 121,
	RETRO_KEYBOARD_KEY_z = 122,
	RETRO_KEYBOARD_KEY_DELETE = 127,
	RETRO_KEYBOARD_KEY_KP0 = 256,
	RETRO_KEYBOARD_KEY_KP1 = 257,
	RETRO_KEYBOARD_KEY_KP2 = 258,
	RETRO_KEYBOARD_KEY_KP3 = 259,
	RETRO_KEYBOARD_KEY_KP4 = 260,
	RETRO_KEYBOARD_KEY_KP5 = 261,
	RETRO_KEYBOARD_KEY_KP6 = 262,
	RETRO_KEYBOARD_KEY_KP7 = 263,
	RETRO_KEYBOARD_KEY_KP8 = 264,
	RETRO_KEYBOARD_KEY_KP9 = 265,
	RETRO_KEYBOARD_KEY_KP_PERIOD = 266,
	RETRO_KEYBOARD_KEY_KP_DIVIDE = 267,
	RETRO_KEYBOARD_KEY_KP_MULTIPLY = 268,
	RETRO_KEYBOARD_KEY_KP_MINUS = 269,
	RETRO_KEYBOARD_KEY_KP_PLUS = 270,
	RETRO_KEYBOARD_KEY_KP_ENTER = 271,
	RETRO_KEYBOARD_KEY_KP_EQUALS = 272,
	RETRO_KEYBOARD_KEY_UP = 273,
	RETRO_KEYBOARD_KEY_DOWN = 274,
	RETRO_KEYBOARD_KEY_RIGHT = 275,
	RETRO_KEYBOARD_KEY_LEFT = 276,
	RETRO_KEYBOARD_KEY_INSERT = 277,
	RETRO_KEYBOARD_KEY_HOME = 278,
	RETRO_KEYBOARD_KEY_END = 279,
	RETRO_KEYBOARD_KEY_PAGEUP = 280,
	RETRO_KEYBOARD_KEY_PAGEDOWN = 281,
	RETRO_KEYBOARD_KEY_F1 = 282,
	RETRO_KEYBOARD_KEY_F2 = 283,
	RETRO_KEYBOARD_KEY_F3 = 284,
	RETRO_KEYBOARD_KEY_F4 = 285,
	RETRO_KEYBOARD_KEY_F5 = 286,
	RETRO_KEYBOARD_KEY_F6 = 287,
	RETRO_KEYBOARD_KEY_F7 = 288,
	RETRO_KEYBOARD_KEY_F8 = 289,
	RETRO_KEYBOARD_KEY_F9 = 290,
	RETRO_KEYBOARD_KEY_F10 = 291,
	RETRO_KEYBOARD_KEY_F11 = 292,
	RETRO_KEYBOARD_KEY_F12 = 293,
	RETRO_KEYBOARD_KEY_F13 = 294,
	RETRO_KEYBOARD_KEY_F14 = 295,
	RETRO_KEYBOARD_KEY_F15 = 296,
	RETRO_KEYBOARD_KEY_NUMLOCK = 300,
	RETRO_KEYBOARD_KEY_CAPSLOCK = 301,
	RETRO_KEYBOARD_KEY_SCROLLOCK = 302,
	RETRO_KEYBOARD_KEY_RSHIFT = 303,
	RETRO_KEYBOARD_KEY_LSHIFT = 304,
	RETRO_KEYBOARD_KEY_RCTRL = 305,
	RETRO_KEYBOARD_KEY_LCTRL = 306,
	RETRO_KEYBOARD_KEY_RALT = 307,
	RETRO_KEYBOARD_KEY_LALT = 308,
	RETRO_KEYBOARD_KEY_RMETA = 309,
	RETRO_KEYBOARD_KEY_LMETA = 310,
	RETRO_KEYBOARD_KEY_LSUPER = 311,
	RETRO_KEYBOARD_KEY_RSUPER = 312,
	RETRO_KEYBOARD_KEY_MODE = 313,
	RETRO_KEYBOARD_KEY_COMPOSE = 314,
	RETRO_KEYBOARD_KEY_HELP = 315,
	RETRO_KEYBOARD_KEY_PRINT = 316,
	RETRO_KEYBOARD_KEY_SYSREQ = 317,
	RETRO_KEYBOARD_KEY_BREAK = 318,
	RETRO_KEYBOARD_KEY_MENU = 319,
	RETRO_KEYBOARD_KEY_POWER = 320,
	RETRO_KEYBOARD_KEY_EURO = 321,
	RETRO_KEYBOARD_KEY_UNDO = 322,
	RETRO_KEYBOARD_KEY_LAST
} RetroKeyboardKey;

typedef enum  {
	RETRO_KEYBOARD_MODIFIER_KEY_NONE = 0x0000,
	RETRO_KEYBOARD_MODIFIER_KEY_SHIFT = 0x01,
	RETRO_KEYBOARD_MODIFIER_KEY_CTRL = 0x02,
	RETRO_KEYBOARD_MODIFIER_KEY_ALT = 0x04,
	RETRO_KEYBOARD_MODIFIER_KEY_META = 0x08,
	RETRO_KEYBOARD_MODIFIER_KEY_NUMLOCK = 0x10,
	RETRO_KEYBOARD_MODIFIER_KEY_CAPSLOCK = 0x20,
	RETRO_KEYBOARD_MODIFIER_KEY_SCROLLOCK = 0x40
} RetroKeyboardModifierKey;

struct _RetroKeyboard {
	GObject parent_instance;
	RetroKeyboardPrivate * priv;
};

struct _RetroKeyboardClass {
	GObjectClass parent_class;
};

struct _RetroKeyboardPrivate {
	GtkWidget* _widget;
};


static gpointer retro_keyboard_parent_class = NULL;

GType retro_keyboard_key_get_type (void) G_GNUC_CONST;
GType retro_keyboard_modifier_key_get_type (void) G_GNUC_CONST;
GType retro_keyboard_get_type (void) G_GNUC_CONST;
#define RETRO_KEYBOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_KEYBOARD, RetroKeyboardPrivate))
enum  {
	RETRO_KEYBOARD_DUMMY_PROPERTY,
	RETRO_KEYBOARD_WIDGET
};
RetroKeyboard* retro_keyboard_new (GtkWidget* widget);
RetroKeyboard* retro_keyboard_construct (GType object_type, GtkWidget* widget);
static RetroKeyboardModifierKey retro_keyboard_modifier_key_converter (RetroKeyboard* self, guint keyval, GdkModifierType modifiers);
static RetroKeyboardKey retro_keyboard_key_converter (RetroKeyboard* self, guint keyval);
static gboolean retro_keyboard_on_key_event (RetroKeyboard* self, GdkEventKey* event, gboolean pressed);
GtkWidget* retro_keyboard_get_widget (RetroKeyboard* self);
static void retro_keyboard_set_widget (RetroKeyboard* self, GtkWidget* value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_ENUM_UINT_FLAGS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * retro_keyboard_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _retro_keyboard___lambda4_ (RetroKeyboard* self, GtkWidget* w, GdkEventKey* e);
static gboolean __retro_keyboard___lambda4__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _retro_keyboard___lambda5_ (RetroKeyboard* self, GtkWidget* w, GdkEventKey* e);
static gboolean __retro_keyboard___lambda5__gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void retro_keyboard_finalize (GObject * obj);
static void _vala_retro_keyboard_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_keyboard_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Key types to feed to a {@link Core} via {@link Input.key_event}.
 */
GType retro_keyboard_key_get_type (void) {
	static volatile gsize retro_keyboard_key_type_id__volatile = 0;
	if (g_once_init_enter (&retro_keyboard_key_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_KEYBOARD_KEY_UNKNOWN, "RETRO_KEYBOARD_KEY_UNKNOWN", "unknown"}, {RETRO_KEYBOARD_KEY_FIRST, "RETRO_KEYBOARD_KEY_FIRST", "first"}, {RETRO_KEYBOARD_KEY_BACKSPACE, "RETRO_KEYBOARD_KEY_BACKSPACE", "backspace"}, {RETRO_KEYBOARD_KEY_TAB, "RETRO_KEYBOARD_KEY_TAB", "tab"}, {RETRO_KEYBOARD_KEY_CLEAR, "RETRO_KEYBOARD_KEY_CLEAR", "clear"}, {RETRO_KEYBOARD_KEY_RETURN, "RETRO_KEYBOARD_KEY_RETURN", "return"}, {RETRO_KEYBOARD_KEY_PAUSE, "RETRO_KEYBOARD_KEY_PAUSE", "pause"}, {RETRO_KEYBOARD_KEY_ESCAPE, "RETRO_KEYBOARD_KEY_ESCAPE", "escape"}, {RETRO_KEYBOARD_KEY_SPACE, "RETRO_KEYBOARD_KEY_SPACE", "space"}, {RETRO_KEYBOARD_KEY_EXCLAIM, "RETRO_KEYBOARD_KEY_EXCLAIM", "exclaim"}, {RETRO_KEYBOARD_KEY_QUOTEDBL, "RETRO_KEYBOARD_KEY_QUOTEDBL", "quotedbl"}, {RETRO_KEYBOARD_KEY_HASH, "RETRO_KEYBOARD_KEY_HASH", "hash"}, {RETRO_KEYBOARD_KEY_DOLLAR, "RETRO_KEYBOARD_KEY_DOLLAR", "dollar"}, {RETRO_KEYBOARD_KEY_AMPERSAND, "RETRO_KEYBOARD_KEY_AMPERSAND", "ampersand"}, {RETRO_KEYBOARD_KEY_QUOTE, "RETRO_KEYBOARD_KEY_QUOTE", "quote"}, {RETRO_KEYBOARD_KEY_LEFTPAREN, "RETRO_KEYBOARD_KEY_LEFTPAREN", "leftparen"}, {RETRO_KEYBOARD_KEY_RIGHTPAREN, "RETRO_KEYBOARD_KEY_RIGHTPAREN", "rightparen"}, {RETRO_KEYBOARD_KEY_ASTERISK, "RETRO_KEYBOARD_KEY_ASTERISK", "asterisk"}, {RETRO_KEYBOARD_KEY_PLUS, "RETRO_KEYBOARD_KEY_PLUS", "plus"}, {RETRO_KEYBOARD_KEY_COMMA, "RETRO_KEYBOARD_KEY_COMMA", "comma"}, {RETRO_KEYBOARD_KEY_MINUS, "RETRO_KEYBOARD_KEY_MINUS", "minus"}, {RETRO_KEYBOARD_KEY_PERIOD, "RETRO_KEYBOARD_KEY_PERIOD", "period"}, {RETRO_KEYBOARD_KEY_SLASH, "RETRO_KEYBOARD_KEY_SLASH", "slash"}, {RETRO_KEYBOARD_KEY_ZERO, "RETRO_KEYBOARD_KEY_ZERO", "zero"}, {RETRO_KEYBOARD_KEY_ONE, "RETRO_KEYBOARD_KEY_ONE", "one"}, {RETRO_KEYBOARD_KEY_TWO, "RETRO_KEYBOARD_KEY_TWO", "two"}, {RETRO_KEYBOARD_KEY_THREE, "RETRO_KEYBOARD_KEY_THREE", "three"}, {RETRO_KEYBOARD_KEY_FOUR, "RETRO_KEYBOARD_KEY_FOUR", "four"}, {RETRO_KEYBOARD_KEY_FINE, "RETRO_KEYBOARD_KEY_FINE", "fine"}, {RETRO_KEYBOARD_KEY_SIX, "RETRO_KEYBOARD_KEY_SIX", "six"}, {RETRO_KEYBOARD_KEY_SEVEN, "RETRO_KEYBOARD_KEY_SEVEN", "seven"}, {RETRO_KEYBOARD_KEY_HEIGHT, "RETRO_KEYBOARD_KEY_HEIGHT", "height"}, {RETRO_KEYBOARD_KEY_NINE, "RETRO_KEYBOARD_KEY_NINE", "nine"}, {RETRO_KEYBOARD_KEY_COLON, "RETRO_KEYBOARD_KEY_COLON", "colon"}, {RETRO_KEYBOARD_KEY_SEMICOLON, "RETRO_KEYBOARD_KEY_SEMICOLON", "semicolon"}, {RETRO_KEYBOARD_KEY_LESS, "RETRO_KEYBOARD_KEY_LESS", "less"}, {RETRO_KEYBOARD_KEY_EQUALS, "RETRO_KEYBOARD_KEY_EQUALS", "equals"}, {RETRO_KEYBOARD_KEY_GREATER, "RETRO_KEYBOARD_KEY_GREATER", "greater"}, {RETRO_KEYBOARD_KEY_QUESTION, "RETRO_KEYBOARD_KEY_QUESTION", "question"}, {RETRO_KEYBOARD_KEY_AT, "RETRO_KEYBOARD_KEY_AT", "at"}, {RETRO_KEYBOARD_KEY_LEFTBRACKET, "RETRO_KEYBOARD_KEY_LEFTBRACKET", "leftbracket"}, {RETRO_KEYBOARD_KEY_BACKSLASH, "RETRO_KEYBOARD_KEY_BACKSLASH", "backslash"}, {RETRO_KEYBOARD_KEY_RIGHTBRACKET, "RETRO_KEYBOARD_KEY_RIGHTBRACKET", "rightbracket"}, {RETRO_KEYBOARD_KEY_CARET, "RETRO_KEYBOARD_KEY_CARET", "caret"}, {RETRO_KEYBOARD_KEY_UNDERSCORE, "RETRO_KEYBOARD_KEY_UNDERSCORE", "underscore"}, {RETRO_KEYBOARD_KEY_BACKQUOTE, "RETRO_KEYBOARD_KEY_BACKQUOTE", "backquote"}, {RETRO_KEYBOARD_KEY_a, "RETRO_KEYBOARD_KEY_a", "a"}, {RETRO_KEYBOARD_KEY_b, "RETRO_KEYBOARD_KEY_b", "b"}, {RETRO_KEYBOARD_KEY_c, "RETRO_KEYBOARD_KEY_c", "c"}, {RETRO_KEYBOARD_KEY_d, "RETRO_KEYBOARD_KEY_d", "d"}, {RETRO_KEYBOARD_KEY_e, "RETRO_KEYBOARD_KEY_e", "e"}, {RETRO_KEYBOARD_KEY_f, "RETRO_KEYBOARD_KEY_f", "f"}, {RETRO_KEYBOARD_KEY_g, "RETRO_KEYBOARD_KEY_g", "g"}, {RETRO_KEYBOARD_KEY_h, "RETRO_KEYBOARD_KEY_h", "h"}, {RETRO_KEYBOARD_KEY_i, "RETRO_KEYBOARD_KEY_i", "i"}, {RETRO_KEYBOARD_KEY_j, "RETRO_KEYBOARD_KEY_j", "j"}, {RETRO_KEYBOARD_KEY_k, "RETRO_KEYBOARD_KEY_k", "k"}, {RETRO_KEYBOARD_KEY_l, "RETRO_KEYBOARD_KEY_l", "l"}, {RETRO_KEYBOARD_KEY_m, "RETRO_KEYBOARD_KEY_m", "m"}, {RETRO_KEYBOARD_KEY_n, "RETRO_KEYBOARD_KEY_n", "n"}, {RETRO_KEYBOARD_KEY_o, "RETRO_KEYBOARD_KEY_o", "o"}, {RETRO_KEYBOARD_KEY_p, "RETRO_KEYBOARD_KEY_p", "p"}, {RETRO_KEYBOARD_KEY_q, "RETRO_KEYBOARD_KEY_q", "q"}, {RETRO_KEYBOARD_KEY_r, "RETRO_KEYBOARD_KEY_r", "r"}, {RETRO_KEYBOARD_KEY_s, "RETRO_KEYBOARD_KEY_s", "s"}, {RETRO_KEYBOARD_KEY_t, "RETRO_KEYBOARD_KEY_t", "t"}, {RETRO_KEYBOARD_KEY_u, "RETRO_KEYBOARD_KEY_u", "u"}, {RETRO_KEYBOARD_KEY_v, "RETRO_KEYBOARD_KEY_v", "v"}, {RETRO_KEYBOARD_KEY_w, "RETRO_KEYBOARD_KEY_w", "w"}, {RETRO_KEYBOARD_KEY_x, "RETRO_KEYBOARD_KEY_x", "x"}, {RETRO_KEYBOARD_KEY_y, "RETRO_KEYBOARD_KEY_y", "y"}, {RETRO_KEYBOARD_KEY_z, "RETRO_KEYBOARD_KEY_z", "z"}, {RETRO_KEYBOARD_KEY_DELETE, "RETRO_KEYBOARD_KEY_DELETE", "delete"}, {RETRO_KEYBOARD_KEY_KP0, "RETRO_KEYBOARD_KEY_KP0", "kp0"}, {RETRO_KEYBOARD_KEY_KP1, "RETRO_KEYBOARD_KEY_KP1", "kp1"}, {RETRO_KEYBOARD_KEY_KP2, "RETRO_KEYBOARD_KEY_KP2", "kp2"}, {RETRO_KEYBOARD_KEY_KP3, "RETRO_KEYBOARD_KEY_KP3", "kp3"}, {RETRO_KEYBOARD_KEY_KP4, "RETRO_KEYBOARD_KEY_KP4", "kp4"}, {RETRO_KEYBOARD_KEY_KP5, "RETRO_KEYBOARD_KEY_KP5", "kp5"}, {RETRO_KEYBOARD_KEY_KP6, "RETRO_KEYBOARD_KEY_KP6", "kp6"}, {RETRO_KEYBOARD_KEY_KP7, "RETRO_KEYBOARD_KEY_KP7", "kp7"}, {RETRO_KEYBOARD_KEY_KP8, "RETRO_KEYBOARD_KEY_KP8", "kp8"}, {RETRO_KEYBOARD_KEY_KP9, "RETRO_KEYBOARD_KEY_KP9", "kp9"}, {RETRO_KEYBOARD_KEY_KP_PERIOD, "RETRO_KEYBOARD_KEY_KP_PERIOD", "kp-period"}, {RETRO_KEYBOARD_KEY_KP_DIVIDE, "RETRO_KEYBOARD_KEY_KP_DIVIDE", "kp-divide"}, {RETRO_KEYBOARD_KEY_KP_MULTIPLY, "RETRO_KEYBOARD_KEY_KP_MULTIPLY", "kp-multiply"}, {RETRO_KEYBOARD_KEY_KP_MINUS, "RETRO_KEYBOARD_KEY_KP_MINUS", "kp-minus"}, {RETRO_KEYBOARD_KEY_KP_PLUS, "RETRO_KEYBOARD_KEY_KP_PLUS", "kp-plus"}, {RETRO_KEYBOARD_KEY_KP_ENTER, "RETRO_KEYBOARD_KEY_KP_ENTER", "kp-enter"}, {RETRO_KEYBOARD_KEY_KP_EQUALS, "RETRO_KEYBOARD_KEY_KP_EQUALS", "kp-equals"}, {RETRO_KEYBOARD_KEY_UP, "RETRO_KEYBOARD_KEY_UP", "up"}, {RETRO_KEYBOARD_KEY_DOWN, "RETRO_KEYBOARD_KEY_DOWN", "down"}, {RETRO_KEYBOARD_KEY_RIGHT, "RETRO_KEYBOARD_KEY_RIGHT", "right"}, {RETRO_KEYBOARD_KEY_LEFT, "RETRO_KEYBOARD_KEY_LEFT", "left"}, {RETRO_KEYBOARD_KEY_INSERT, "RETRO_KEYBOARD_KEY_INSERT", "insert"}, {RETRO_KEYBOARD_KEY_HOME, "RETRO_KEYBOARD_KEY_HOME", "home"}, {RETRO_KEYBOARD_KEY_END, "RETRO_KEYBOARD_KEY_END", "end"}, {RETRO_KEYBOARD_KEY_PAGEUP, "RETRO_KEYBOARD_KEY_PAGEUP", "pageup"}, {RETRO_KEYBOARD_KEY_PAGEDOWN, "RETRO_KEYBOARD_KEY_PAGEDOWN", "pagedown"}, {RETRO_KEYBOARD_KEY_F1, "RETRO_KEYBOARD_KEY_F1", "f1"}, {RETRO_KEYBOARD_KEY_F2, "RETRO_KEYBOARD_KEY_F2", "f2"}, {RETRO_KEYBOARD_KEY_F3, "RETRO_KEYBOARD_KEY_F3", "f3"}, {RETRO_KEYBOARD_KEY_F4, "RETRO_KEYBOARD_KEY_F4", "f4"}, {RETRO_KEYBOARD_KEY_F5, "RETRO_KEYBOARD_KEY_F5", "f5"}, {RETRO_KEYBOARD_KEY_F6, "RETRO_KEYBOARD_KEY_F6", "f6"}, {RETRO_KEYBOARD_KEY_F7, "RETRO_KEYBOARD_KEY_F7", "f7"}, {RETRO_KEYBOARD_KEY_F8, "RETRO_KEYBOARD_KEY_F8", "f8"}, {RETRO_KEYBOARD_KEY_F9, "RETRO_KEYBOARD_KEY_F9", "f9"}, {RETRO_KEYBOARD_KEY_F10, "RETRO_KEYBOARD_KEY_F10", "f10"}, {RETRO_KEYBOARD_KEY_F11, "RETRO_KEYBOARD_KEY_F11", "f11"}, {RETRO_KEYBOARD_KEY_F12, "RETRO_KEYBOARD_KEY_F12", "f12"}, {RETRO_KEYBOARD_KEY_F13, "RETRO_KEYBOARD_KEY_F13", "f13"}, {RETRO_KEYBOARD_KEY_F14, "RETRO_KEYBOARD_KEY_F14", "f14"}, {RETRO_KEYBOARD_KEY_F15, "RETRO_KEYBOARD_KEY_F15", "f15"}, {RETRO_KEYBOARD_KEY_NUMLOCK, "RETRO_KEYBOARD_KEY_NUMLOCK", "numlock"}, {RETRO_KEYBOARD_KEY_CAPSLOCK, "RETRO_KEYBOARD_KEY_CAPSLOCK", "capslock"}, {RETRO_KEYBOARD_KEY_SCROLLOCK, "RETRO_KEYBOARD_KEY_SCROLLOCK", "scrollock"}, {RETRO_KEYBOARD_KEY_RSHIFT, "RETRO_KEYBOARD_KEY_RSHIFT", "rshift"}, {RETRO_KEYBOARD_KEY_LSHIFT, "RETRO_KEYBOARD_KEY_LSHIFT", "lshift"}, {RETRO_KEYBOARD_KEY_RCTRL, "RETRO_KEYBOARD_KEY_RCTRL", "rctrl"}, {RETRO_KEYBOARD_KEY_LCTRL, "RETRO_KEYBOARD_KEY_LCTRL", "lctrl"}, {RETRO_KEYBOARD_KEY_RALT, "RETRO_KEYBOARD_KEY_RALT", "ralt"}, {RETRO_KEYBOARD_KEY_LALT, "RETRO_KEYBOARD_KEY_LALT", "lalt"}, {RETRO_KEYBOARD_KEY_RMETA, "RETRO_KEYBOARD_KEY_RMETA", "rmeta"}, {RETRO_KEYBOARD_KEY_LMETA, "RETRO_KEYBOARD_KEY_LMETA", "lmeta"}, {RETRO_KEYBOARD_KEY_LSUPER, "RETRO_KEYBOARD_KEY_LSUPER", "lsuper"}, {RETRO_KEYBOARD_KEY_RSUPER, "RETRO_KEYBOARD_KEY_RSUPER", "rsuper"}, {RETRO_KEYBOARD_KEY_MODE, "RETRO_KEYBOARD_KEY_MODE", "mode"}, {RETRO_KEYBOARD_KEY_COMPOSE, "RETRO_KEYBOARD_KEY_COMPOSE", "compose"}, {RETRO_KEYBOARD_KEY_HELP, "RETRO_KEYBOARD_KEY_HELP", "help"}, {RETRO_KEYBOARD_KEY_PRINT, "RETRO_KEYBOARD_KEY_PRINT", "print"}, {RETRO_KEYBOARD_KEY_SYSREQ, "RETRO_KEYBOARD_KEY_SYSREQ", "sysreq"}, {RETRO_KEYBOARD_KEY_BREAK, "RETRO_KEYBOARD_KEY_BREAK", "break"}, {RETRO_KEYBOARD_KEY_MENU, "RETRO_KEYBOARD_KEY_MENU", "menu"}, {RETRO_KEYBOARD_KEY_POWER, "RETRO_KEYBOARD_KEY_POWER", "power"}, {RETRO_KEYBOARD_KEY_EURO, "RETRO_KEYBOARD_KEY_EURO", "euro"}, {RETRO_KEYBOARD_KEY_UNDO, "RETRO_KEYBOARD_KEY_UNDO", "undo"}, {RETRO_KEYBOARD_KEY_LAST, "RETRO_KEYBOARD_KEY_LAST", "last"}, {0, NULL, NULL}};
		GType retro_keyboard_key_type_id;
		retro_keyboard_key_type_id = g_enum_register_static ("RetroKeyboardKey", values);
		g_once_init_leave (&retro_keyboard_key_type_id__volatile, retro_keyboard_key_type_id);
	}
	return retro_keyboard_key_type_id__volatile;
}


/**
 * Modifier key types to feed to a {@link Core} via {@link Input.key_event}.
 */
GType retro_keyboard_modifier_key_get_type (void) {
	static volatile gsize retro_keyboard_modifier_key_type_id__volatile = 0;
	if (g_once_init_enter (&retro_keyboard_modifier_key_type_id__volatile)) {
		static const GFlagsValue values[] = {{RETRO_KEYBOARD_MODIFIER_KEY_NONE, "RETRO_KEYBOARD_MODIFIER_KEY_NONE", "none"}, {RETRO_KEYBOARD_MODIFIER_KEY_SHIFT, "RETRO_KEYBOARD_MODIFIER_KEY_SHIFT", "shift"}, {RETRO_KEYBOARD_MODIFIER_KEY_CTRL, "RETRO_KEYBOARD_MODIFIER_KEY_CTRL", "ctrl"}, {RETRO_KEYBOARD_MODIFIER_KEY_ALT, "RETRO_KEYBOARD_MODIFIER_KEY_ALT", "alt"}, {RETRO_KEYBOARD_MODIFIER_KEY_META, "RETRO_KEYBOARD_MODIFIER_KEY_META", "meta"}, {RETRO_KEYBOARD_MODIFIER_KEY_NUMLOCK, "RETRO_KEYBOARD_MODIFIER_KEY_NUMLOCK", "numlock"}, {RETRO_KEYBOARD_MODIFIER_KEY_CAPSLOCK, "RETRO_KEYBOARD_MODIFIER_KEY_CAPSLOCK", "capslock"}, {RETRO_KEYBOARD_MODIFIER_KEY_SCROLLOCK, "RETRO_KEYBOARD_MODIFIER_KEY_SCROLLOCK", "scrollock"}, {0, NULL, NULL}};
		GType retro_keyboard_modifier_key_type_id;
		retro_keyboard_modifier_key_type_id = g_flags_register_static ("RetroKeyboardModifierKey", values);
		g_once_init_leave (&retro_keyboard_modifier_key_type_id__volatile, retro_keyboard_modifier_key_type_id);
	}
	return retro_keyboard_modifier_key_type_id__volatile;
}


RetroKeyboard* retro_keyboard_construct (GType object_type, GtkWidget* widget) {
	RetroKeyboard * self = NULL;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = widget;
	self = (RetroKeyboard*) g_object_new (object_type, "widget", _tmp0_, NULL);
	return self;
}


RetroKeyboard* retro_keyboard_new (GtkWidget* widget) {
	return retro_keyboard_construct (RETRO_TYPE_KEYBOARD, widget);
}


static RetroKeyboardModifierKey retro_keyboard_modifier_key_converter (RetroKeyboard* self, guint keyval, GdkModifierType modifiers) {
	RetroKeyboardModifierKey result = 0;
	RetroKeyboardModifierKey retro_modifiers = 0;
	GdkModifierType _tmp0_;
	GdkModifierType _tmp2_;
	GdkModifierType _tmp4_;
	GdkModifierType _tmp6_;
	guint _tmp8_;
	GdkModifierType _tmp10_;
	guint _tmp12_;
	g_return_val_if_fail (self != NULL, 0);
	retro_modifiers = RETRO_KEYBOARD_MODIFIER_KEY_NONE;
	_tmp0_ = modifiers;
	if ((gboolean) (_tmp0_ & GDK_SHIFT_MASK)) {
		RetroKeyboardModifierKey _tmp1_;
		_tmp1_ = retro_modifiers;
		retro_modifiers = _tmp1_ | RETRO_KEYBOARD_MODIFIER_KEY_SHIFT;
	}
	_tmp2_ = modifiers;
	if ((gboolean) (_tmp2_ & GDK_CONTROL_MASK)) {
		RetroKeyboardModifierKey _tmp3_;
		_tmp3_ = retro_modifiers;
		retro_modifiers = _tmp3_ | RETRO_KEYBOARD_MODIFIER_KEY_CTRL;
	}
	_tmp4_ = modifiers;
	if ((gboolean) (_tmp4_ & GDK_MOD1_MASK)) {
		RetroKeyboardModifierKey _tmp5_;
		_tmp5_ = retro_modifiers;
		retro_modifiers = _tmp5_ | RETRO_KEYBOARD_MODIFIER_KEY_ALT;
	}
	_tmp6_ = modifiers;
	if ((gboolean) (_tmp6_ & GDK_META_MASK)) {
		RetroKeyboardModifierKey _tmp7_;
		_tmp7_ = retro_modifiers;
		retro_modifiers = _tmp7_ | RETRO_KEYBOARD_MODIFIER_KEY_META;
	}
	_tmp8_ = keyval;
	if (_tmp8_ == ((guint) GDK_KEY_Num_Lock)) {
		RetroKeyboardModifierKey _tmp9_;
		_tmp9_ = retro_modifiers;
		retro_modifiers = _tmp9_ | RETRO_KEYBOARD_MODIFIER_KEY_NUMLOCK;
	}
	_tmp10_ = modifiers;
	if ((gboolean) (_tmp10_ & GDK_LOCK_MASK)) {
		RetroKeyboardModifierKey _tmp11_;
		_tmp11_ = retro_modifiers;
		retro_modifiers = _tmp11_ | RETRO_KEYBOARD_MODIFIER_KEY_CAPSLOCK;
	}
	_tmp12_ = keyval;
	if (_tmp12_ == ((guint) GDK_KEY_Scroll_Lock)) {
		RetroKeyboardModifierKey _tmp13_;
		_tmp13_ = retro_modifiers;
		retro_modifiers = _tmp13_ | RETRO_KEYBOARD_MODIFIER_KEY_SCROLLOCK;
	}
	result = retro_modifiers;
	return result;
}


static RetroKeyboardKey retro_keyboard_key_converter (RetroKeyboard* self, guint keyval) {
	RetroKeyboardKey result = 0;
	guint _tmp0_;
	guint fx = 0U;
	guint _tmp7_;
	guint _tmp8_;
	guint kp = 0U;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp13_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = keyval;
	if (_tmp0_ < ((guint) 0x80)) {
		gint key = 0;
		guint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		gint _tmp6_;
		_tmp1_ = keyval;
		key = 0x7f & _tmp1_;
		_tmp3_ = key;
		if (_tmp3_ >= ((gint) 'A')) {
			gint _tmp4_;
			_tmp4_ = key;
			_tmp2_ = _tmp4_ <= ((gint) 'Z');
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp5_;
			_tmp5_ = key;
			result = (RetroKeyboardKey) (_tmp5_ + 0x20);
			return result;
		}
		_tmp6_ = key;
		result = (RetroKeyboardKey) _tmp6_;
		return result;
	}
	_tmp7_ = keyval;
	fx = _tmp7_ - GDK_KEY_F1;
	_tmp8_ = fx;
	if (_tmp8_ < ((guint) 15)) {
		guint _tmp9_;
		_tmp9_ = fx;
		result = (RetroKeyboardKey) (((guint) RETRO_KEYBOARD_KEY_F1) + _tmp9_);
		return result;
	}
	_tmp10_ = keyval;
	kp = _tmp10_ - GDK_KEY_KP_0;
	_tmp11_ = kp;
	if (_tmp11_ < ((guint) 10)) {
		guint _tmp12_;
		_tmp12_ = kp;
		result = (RetroKeyboardKey) (((guint) RETRO_KEYBOARD_KEY_KP0) + _tmp12_);
		return result;
	}
	_tmp13_ = keyval;
	switch (_tmp13_) {
		case GDK_KEY_BackSpace:
		{
			result = RETRO_KEYBOARD_KEY_BACKSPACE;
			return result;
		}
		case GDK_KEY_Tab:
		{
			result = RETRO_KEYBOARD_KEY_TAB;
			return result;
		}
		case GDK_KEY_Clear:
		{
			result = RETRO_KEYBOARD_KEY_CLEAR;
			return result;
		}
		case GDK_KEY_Return:
		{
			result = RETRO_KEYBOARD_KEY_RETURN;
			return result;
		}
		case GDK_KEY_Pause:
		{
			result = RETRO_KEYBOARD_KEY_PAUSE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			result = RETRO_KEYBOARD_KEY_ESCAPE;
			return result;
		}
		case GDK_KEY_Delete:
		{
			result = RETRO_KEYBOARD_KEY_DELETE;
			return result;
		}
		case GDK_KEY_Up:
		{
			result = RETRO_KEYBOARD_KEY_UP;
			return result;
		}
		case GDK_KEY_Down:
		{
			result = RETRO_KEYBOARD_KEY_DOWN;
			return result;
		}
		case GDK_KEY_Left:
		{
			result = RETRO_KEYBOARD_KEY_LEFT;
			return result;
		}
		case GDK_KEY_Right:
		{
			result = RETRO_KEYBOARD_KEY_RIGHT;
			return result;
		}
		case GDK_KEY_Insert:
		{
			result = RETRO_KEYBOARD_KEY_INSERT;
			return result;
		}
		case GDK_KEY_Home:
		{
			result = RETRO_KEYBOARD_KEY_HOME;
			return result;
		}
		case GDK_KEY_End:
		{
			result = RETRO_KEYBOARD_KEY_END;
			return result;
		}
		case GDK_KEY_Page_Up:
		{
			result = RETRO_KEYBOARD_KEY_PAGEUP;
			return result;
		}
		case GDK_KEY_Page_Down:
		{
			result = RETRO_KEYBOARD_KEY_PAGEDOWN;
			return result;
		}
		case GDK_KEY_KP_Decimal:
		{
			result = RETRO_KEYBOARD_KEY_KP_PERIOD;
			return result;
		}
		case GDK_KEY_KP_Divide:
		{
			result = RETRO_KEYBOARD_KEY_KP_DIVIDE;
			return result;
		}
		case GDK_KEY_KP_Multiply:
		{
			result = RETRO_KEYBOARD_KEY_KP_MULTIPLY;
			return result;
		}
		case GDK_KEY_KP_Subtract:
		{
			result = RETRO_KEYBOARD_KEY_KP_MINUS;
			return result;
		}
		case GDK_KEY_KP_Add:
		{
			result = RETRO_KEYBOARD_KEY_KP_PLUS;
			return result;
		}
		case GDK_KEY_KP_Enter:
		{
			result = RETRO_KEYBOARD_KEY_KP_ENTER;
			return result;
		}
		case GDK_KEY_KP_Equal:
		{
			result = RETRO_KEYBOARD_KEY_KP_EQUALS;
			return result;
		}
		case GDK_KEY_Num_Lock:
		{
			result = RETRO_KEYBOARD_KEY_NUMLOCK;
			return result;
		}
		case GDK_KEY_Caps_Lock:
		{
			result = RETRO_KEYBOARD_KEY_CAPSLOCK;
			return result;
		}
		case GDK_KEY_Scroll_Lock:
		{
			result = RETRO_KEYBOARD_KEY_SCROLLOCK;
			return result;
		}
		case GDK_KEY_Shift_R:
		{
			result = RETRO_KEYBOARD_KEY_RSHIFT;
			return result;
		}
		case GDK_KEY_Shift_L:
		{
			result = RETRO_KEYBOARD_KEY_LSHIFT;
			return result;
		}
		case GDK_KEY_Control_R:
		{
			result = RETRO_KEYBOARD_KEY_RCTRL;
			return result;
		}
		case GDK_KEY_Control_L:
		{
			result = RETRO_KEYBOARD_KEY_LCTRL;
			return result;
		}
		case GDK_KEY_Alt_R:
		{
			result = RETRO_KEYBOARD_KEY_RALT;
			return result;
		}
		case GDK_KEY_Alt_L:
		{
			result = RETRO_KEYBOARD_KEY_LALT;
			return result;
		}
		case GDK_KEY_Meta_R:
		{
			result = RETRO_KEYBOARD_KEY_RMETA;
			return result;
		}
		case GDK_KEY_Meta_L:
		{
			result = RETRO_KEYBOARD_KEY_LMETA;
			return result;
		}
		case GDK_KEY_Super_R:
		{
			result = RETRO_KEYBOARD_KEY_RSUPER;
			return result;
		}
		case GDK_KEY_Super_L:
		{
			result = RETRO_KEYBOARD_KEY_LSUPER;
			return result;
		}
		case GDK_KEY_Help:
		{
			result = RETRO_KEYBOARD_KEY_HELP;
			return result;
		}
		case GDK_KEY_Print:
		{
			result = RETRO_KEYBOARD_KEY_PRINT;
			return result;
		}
		case GDK_KEY_Sys_Req:
		{
			result = RETRO_KEYBOARD_KEY_SYSREQ;
			return result;
		}
		case GDK_KEY_Break:
		{
			result = RETRO_KEYBOARD_KEY_BREAK;
			return result;
		}
		case GDK_KEY_Menu:
		{
			result = RETRO_KEYBOARD_KEY_MENU;
			return result;
		}
		case GDK_KEY_EuroSign:
		{
			result = RETRO_KEYBOARD_KEY_EURO;
			return result;
		}
		case GDK_KEY_Undo:
		{
			result = RETRO_KEYBOARD_KEY_UNDO;
			return result;
		}
		default:
		{
			result = RETRO_KEYBOARD_KEY_UNKNOWN;
			return result;
		}
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gboolean retro_keyboard_on_key_event (RetroKeyboard* self, GdkEventKey* event, gboolean pressed) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	RetroKeyboardKey _tmp3_;
	GdkEventKey* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp8__length1;
	gchar _tmp9_;
	GdkEventKey* _tmp10_;
	guint _tmp11_;
	GdkEventKey* _tmp12_;
	GdkModifierType _tmp13_;
	RetroKeyboardModifierKey _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = pressed;
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	_tmp3_ = retro_keyboard_key_converter (self, _tmp2_);
	_tmp4_ = event;
	_tmp5_ = _tmp4_->string;
	_tmp7_ = string_to_utf8 (_tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = event;
	_tmp11_ = _tmp10_->keyval;
	_tmp12_ = event;
	_tmp13_ = _tmp12_->state;
	_tmp14_ = retro_keyboard_modifier_key_converter (self, _tmp11_, _tmp13_);
	g_signal_emit (self, retro_keyboard_signals[RETRO_KEYBOARD_KEY_EVENT_SIGNAL], 0, _tmp0_, _tmp3_, (guint32) _tmp9_, _tmp14_);
	_tmp8_ = (g_free (_tmp8_), NULL);
	result = FALSE;
	return result;
}


GtkWidget* retro_keyboard_get_widget (RetroKeyboard* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void retro_keyboard_set_widget (RetroKeyboard* self, GtkWidget* value) {
	g_return_if_fail (self != NULL);
	if (retro_keyboard_get_widget (self) != value) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_widget);
		self->priv->_widget = _tmp1_;
		g_object_notify ((GObject *) self, "widget");
	}
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_ENUM_UINT_FLAGS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_ENUM_UINT_FLAGS) (gpointer data1, gboolean arg_1, gint arg_2, guint32 arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_ENUM_UINT_FLAGS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_ENUM_UINT_FLAGS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_enum (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_flags (param_values + 4), data2);
}


static gboolean _retro_keyboard___lambda4_ (RetroKeyboard* self, GtkWidget* w, GdkEventKey* e) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = retro_keyboard_on_key_event (self, _tmp0_, TRUE);
	result = _tmp1_;
	return result;
}


static gboolean __retro_keyboard___lambda4__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _retro_keyboard___lambda4_ ((RetroKeyboard*) self, _sender, event);
	return result;
}


static gboolean _retro_keyboard___lambda5_ (RetroKeyboard* self, GtkWidget* w, GdkEventKey* e) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = retro_keyboard_on_key_event (self, _tmp0_, FALSE);
	result = _tmp1_;
	return result;
}


static gboolean __retro_keyboard___lambda5__gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _retro_keyboard___lambda5_ ((RetroKeyboard*) self, _sender, event);
	return result;
}


static GObject * retro_keyboard_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroKeyboard * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	parent_class = G_OBJECT_CLASS (retro_keyboard_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_KEYBOARD, RetroKeyboard);
	_tmp0_ = self->priv->_widget;
	g_signal_connect_object (_tmp0_, "key-press-event", (GCallback) __retro_keyboard___lambda4__gtk_widget_key_press_event, self, 0);
	_tmp1_ = self->priv->_widget;
	g_signal_connect_object (_tmp1_, "key-release-event", (GCallback) __retro_keyboard___lambda5__gtk_widget_key_release_event, self, 0);
	return obj;
}


static void retro_keyboard_class_init (RetroKeyboardClass * klass) {
	retro_keyboard_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroKeyboardPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_keyboard_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_keyboard_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_keyboard_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_keyboard_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_KEYBOARD_WIDGET, g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	retro_keyboard_signals[RETRO_KEYBOARD_KEY_EVENT_SIGNAL] = g_signal_new ("key_event", RETRO_TYPE_KEYBOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_ENUM_UINT_FLAGS, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, RETRO_TYPE_KEYBOARD_KEY, G_TYPE_UINT, RETRO_TYPE_KEYBOARD_MODIFIER_KEY);
}


static void retro_keyboard_instance_init (RetroKeyboard * self) {
	self->priv = RETRO_KEYBOARD_GET_PRIVATE (self);
}


static void retro_keyboard_finalize (GObject * obj) {
	RetroKeyboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_KEYBOARD, RetroKeyboard);
	_g_object_unref0 (self->priv->_widget);
	G_OBJECT_CLASS (retro_keyboard_parent_class)->finalize (obj);
}


GType retro_keyboard_get_type (void) {
	static volatile gsize retro_keyboard_type_id__volatile = 0;
	if (g_once_init_enter (&retro_keyboard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroKeyboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_keyboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroKeyboard), 0, (GInstanceInitFunc) retro_keyboard_instance_init, NULL };
		GType retro_keyboard_type_id;
		retro_keyboard_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroKeyboard", &g_define_type_info, 0);
		g_once_init_leave (&retro_keyboard_type_id__volatile, retro_keyboard_type_id);
	}
	return retro_keyboard_type_id__volatile;
}


static void _vala_retro_keyboard_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroKeyboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_KEYBOARD, RetroKeyboard);
	switch (property_id) {
		case RETRO_KEYBOARD_WIDGET:
		g_value_set_object (value, retro_keyboard_get_widget (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_keyboard_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroKeyboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_KEYBOARD, RetroKeyboard);
	switch (property_id) {
		case RETRO_KEYBOARD_WIDGET:
		retro_keyboard_set_widget (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



