package com.fasterxml.jackson.dataformat.xml.deser;

import org.junit.jupiter.api.Test;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.XmlTestUtil;

import static org.junit.jupiter.api.Assertions.*;

public class XsiNilBasic714Test extends XmlTestUtil
{
    private final static String XSI_NS_DECL = "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'";

    // 30-Jan-2025, tatu: To tease out [dataformat-xml#714] let's do this:
    private final XmlMapper MAPPER = mapperBuilder()
            .enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)
            .build();

    // [dataformat-xml#714]: trailing END_OBJECT
    @Test
    public void testRootPojoAsNull() throws Exception
    {
        Point bean = MAPPER.readValue(
"<Point "+XSI_NS_DECL+" xsi:nil='true' />",
                Point.class);
        assertNull(bean);
    }

    // [dataformat-xml#468]: Allow disabling xsi:nil special handling

    // [dataformat-xml#714]: trailing END_OBJECT
    @Test
    public void testDisableXsiNilRootProcessing() throws Exception
    {
        final ObjectReader r = MAPPER.readerFor(JsonNode.class);
        final String DOC = "<Point "+XSI_NS_DECL+" xsi:nil='true'></Point>";

        // with default processing:
        assertEquals("null", r.readValue(DOC).toString());

        // 07-Jul-2021, tatu: Alas! 2.x sets format feature flags too late to
        //   affect root element (3.0 works correctly). Need a new mapper
        XmlMapper mapper2 = mapperBuilder()
                .enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)
                .disable(FromXmlParser.Feature.PROCESS_XSI_NIL)
                .build();
        assertEquals(a2q("{'nil':'true'}"),
                mapper2.readerFor(JsonNode.class).readValue(DOC).toString());
    }
}
