/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RFC3672SubentriesRequestControl
extends Control {
    @NotNull
    public static final String SUBENTRIES_REQUEST_OID = "1.3.6.1.4.1.4203.1.10.1";
    private static final long serialVersionUID = -3780729008801136950L;
    private final boolean returnOnlySubEntries;

    public RFC3672SubentriesRequestControl(boolean returnOnlySubEntries) {
        this(returnOnlySubEntries, false);
    }

    public RFC3672SubentriesRequestControl(boolean returnOnlySubEntries, boolean isCritical) {
        super(SUBENTRIES_REQUEST_OID, isCritical, new ASN1OctetString(new ASN1Boolean(returnOnlySubEntries).encode()));
        this.returnOnlySubEntries = returnOnlySubEntries;
    }

    public RFC3672SubentriesRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (!control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUBENTRIES_MISSING_VALUE.get());
        }
        try {
            this.returnOnlySubEntries = ASN1Boolean.decodeAsBoolean(control.getValue().getValue()).booleanValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUBENTRIES_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public boolean returnOnlySubEntries() {
        return this.returnOnlySubEntries;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SUBENTRIES_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("RFC3672SubentriesRequestControl(returnOnlySubEntries=");
        buffer.append(this.returnOnlySubEntries);
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

