import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
import fs from 'fs';
import path from 'path';
import { PersistentOverrideAdapter } from './PersistentOverrideAdapter';
/**
 * FileOverrideAdapter provides file system based persistence for feature gate, dynamic config,
 * experiment, and layer overrides. It is designed for local development and CLI environments,
 * where browser-specific storage mechanisms (like localStorage) are not available.
 */
export var FilePersistentOverrideAdapter = /*#__PURE__*/function (_PersistentOverrideAd) {
  function FilePersistentOverrideAdapter(filePath) {
    var _this;
    _classCallCheck(this, FilePersistentOverrideAdapter);
    // Provide a dummy key since file persistence is used instead of localStorage.
    _this = _callSuper(this, FilePersistentOverrideAdapter, ['unused']);
    _defineProperty(_this, "_browserWarningShown", false);
    _this._filePath = path.resolve(filePath);

    // Check if the path exists and is a directory
    if (fs.existsSync(_this._filePath)) {
      var stats = fs.statSync(_this._filePath);
      if (stats.isDirectory()) {
        throw new Error("Path ".concat(_this._filePath, " is a directory, but a file is expected"));
      }
    }
    var dir = path.dirname(_this._filePath);
    if (!fs.existsSync(dir)) {
      fs.mkdirSync(dir, {
        recursive: true
      });
    }
    _this.initFromStoredOverrides();
    return _this;
  }

  /**
   * Warns if the adapter is being used in a browser environment.
   * This is a non-blocking warning that will only be shown once.
   */
  _inherits(FilePersistentOverrideAdapter, _PersistentOverrideAd);
  return _createClass(FilePersistentOverrideAdapter, [{
    key: "warnIfBrowserEnvironment",
    value: function warnIfBrowserEnvironment() {
      // Check if we're in a browser environment
      if (typeof window !== 'undefined' && !this._browserWarningShown && window.console && window.console.warn) {
        this._browserWarningShown = true;

        // eslint-disable-next-line no-console
        window.console.warn('FilePersistentOverrideAdapter is being used in a browser environment. ' + 'This adapter is designed for local development and CLI environments. ' + 'For browser environments, use PersistentOverrideAdapter instead, which uses localStorage for persistence.');
      }
    }
  }, {
    key: "readStoredOverrides",
    value: function readStoredOverrides() {
      this.warnIfBrowserEnvironment();
      try {
        if (!fs.existsSync(this._filePath)) {
          return {};
        }
        var data = fs.readFileSync(this._filePath, 'utf8');
        return JSON.parse(data);
      } catch (_unused) {
        return {};
      }
    }
  }, {
    key: "saveOverridesToFile",
    value: function saveOverridesToFile(overrides) {
      this.warnIfBrowserEnvironment();
      try {
        fs.writeFileSync(this._filePath, JSON.stringify(overrides, null, 2));
      } catch (error) {
        throw new Error("Failed to save overrides to file: ".concat(error));
      }
    }
  }, {
    key: "initFromStoredOverrides",
    value: function initFromStoredOverrides() {
      var storedOverrides = this.readStoredOverrides();
      this.applyOverrides(storedOverrides);
    }
  }, {
    key: "saveOverrides",
    value: function saveOverrides() {
      // Instead of saving to localStorage, persist using the file system.
      var overrides = this.getOverrides();
      this.saveOverridesToFile(overrides);
    }
  }, {
    key: "removeAllOverrides",
    value: function removeAllOverrides() {
      this.applyOverrides({});
      try {
        if (fs.existsSync(this._filePath)) {
          fs.unlinkSync(this._filePath);
        }
      } catch (error) {
        throw new Error("Failed to remove overrides file: ".concat(this._filePath, ": ").concat(error));
      }
    }
  }]);
}(PersistentOverrideAdapter);