﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMeshRequest.h>
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/MeshSpec.h>
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppMesh {
namespace Model {

/**
 * <zonbook></zonbook><xhtml></xhtml><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateMeshInput">AWS
 * API Reference</a></p>
 */
class UpdateMeshRequest : public AppMeshRequest {
 public:
  AWS_APPMESH_API UpdateMeshRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateMesh"; }

  AWS_APPMESH_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency
   * of the request. Up to 36 letters, numbers, hyphens, and underscores are
   * allowed.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  UpdateMeshRequest& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the service mesh to update.</p>
   */
  inline const Aws::String& GetMeshName() const { return m_meshName; }
  inline bool MeshNameHasBeenSet() const { return m_meshNameHasBeenSet; }
  template <typename MeshNameT = Aws::String>
  void SetMeshName(MeshNameT&& value) {
    m_meshNameHasBeenSet = true;
    m_meshName = std::forward<MeshNameT>(value);
  }
  template <typename MeshNameT = Aws::String>
  UpdateMeshRequest& WithMeshName(MeshNameT&& value) {
    SetMeshName(std::forward<MeshNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The service mesh specification to apply.</p>
   */
  inline const MeshSpec& GetSpec() const { return m_spec; }
  inline bool SpecHasBeenSet() const { return m_specHasBeenSet; }
  template <typename SpecT = MeshSpec>
  void SetSpec(SpecT&& value) {
    m_specHasBeenSet = true;
    m_spec = std::forward<SpecT>(value);
  }
  template <typename SpecT = MeshSpec>
  UpdateMeshRequest& WithSpec(SpecT&& value) {
    SetSpec(std::forward<SpecT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clientToken{Aws::Utils::UUID::PseudoRandomUUID()};
  bool m_clientTokenHasBeenSet = true;

  Aws::String m_meshName;
  bool m_meshNameHasBeenSet = false;

  MeshSpec m_spec;
  bool m_specHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
