﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/awstransfer/model/DescribedWebApp.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Transfer {
namespace Model {
class DescribeWebAppResult {
 public:
  AWS_TRANSFER_API DescribeWebAppResult() = default;
  AWS_TRANSFER_API DescribeWebAppResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRANSFER_API DescribeWebAppResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns a structure that contains the details of the web app.</p>
   */
  inline const DescribedWebApp& GetWebApp() const { return m_webApp; }
  template <typename WebAppT = DescribedWebApp>
  void SetWebApp(WebAppT&& value) {
    m_webAppHasBeenSet = true;
    m_webApp = std::forward<WebAppT>(value);
  }
  template <typename WebAppT = DescribedWebApp>
  DescribeWebAppResult& WithWebApp(WebAppT&& value) {
    SetWebApp(std::forward<WebAppT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeWebAppResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  DescribedWebApp m_webApp;
  bool m_webAppHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Transfer
}  // namespace Aws
