/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.AuroraProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ReconnectDuringTransactionException;

public class AuroraListener
extends MastersSlavesListener {
    public AuroraListener(UrlParser urlParser) {
        super(urlParser);
        this.masterProtocol = null;
        this.secondaryProtocol = null;
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        if (!searchFilter.isInitialConnection() && (this.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail())) {
            return;
        }
        if (!searchFilter.isFailoverLoop()) {
            try {
                this.checkWaitingConnection();
                if (searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail()) {
                    return;
                }
            }
            catch (ReconnectDuringTransactionException e2) {
                return;
            }
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
        loopAddress.removeAll(this.getBlacklistKeys());
        Collections.shuffle(loopAddress);
        LinkedList<HostAddress> blacklistShuffle = new LinkedList<HostAddress>(this.getBlacklistKeys());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
            loopAddress.add(this.masterProtocol.getHostAddress());
        }
        if (!this.isSecondaryHostFail() && this.secondaryProtocol != null) {
            loopAddress.remove(this.secondaryProtocol.getHostAddress());
            loopAddress.add(this.secondaryProtocol.getHostAddress());
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            do {
                AuroraProtocol.loop(this, loopAddress, searchFilter);
                if (searchFilter.isFailoverLoop()) continue;
                try {
                    this.checkWaitingConnection();
                }
                catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {
                    // empty catch block
                }
            } while (searchFilter.isInitialConnection() && this.masterProtocol == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAddress searchByStartName(Protocol secondaryProtocol, List<HostAddress> loopAddress) {
        block9: {
            if (!this.isSecondaryHostFail()) {
                MariaSelectResultSet queryResult = null;
                try {
                    this.proxy.lock.lock();
                    try {
                        SingleExecutionResult executionResult = new SingleExecutionResult(null, 0, true, false);
                        secondaryProtocol.executeQuery(executionResult, "select server_id from information_schema.replica_host_status where session_id = 'MASTER_SESSION_ID'", 1003);
                        queryResult = executionResult.getResult();
                        queryResult.next();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    String masterHostName = queryResult.getString(1);
                    for (int i2 = 0; i2 < loopAddress.size(); ++i2) {
                        if (!loopAddress.get((int)i2).host.startsWith(masterHostName)) continue;
                        return loopAddress.get(i2);
                    }
                }
                catch (SQLException masterHostName) {
                }
                catch (QueryException qe) {
                    if (!this.proxy.hasToHandleFailover(qe) || !this.setSecondaryHostFail()) break block9;
                    this.addToBlacklist(secondaryProtocol.getHostAddress());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (!this.isMasterHostFail()) {
            try {
                if (this.masterProtocol != null && !this.masterProtocol.checkIfMaster()) {
                    this.setMasterHostFail();
                    if (this.isSecondaryHostFail()) {
                        this.foundActiveSecondary(this.masterProtocol);
                    }
                    return true;
                }
            }
            catch (QueryException e2) {
                block22: {
                    try {
                        this.masterProtocol.ping();
                    }
                    catch (QueryException ee) {
                        this.proxy.lock.lock();
                        try {
                            this.masterProtocol.close();
                        }
                        finally {
                            this.proxy.lock.unlock();
                        }
                        if (!this.setMasterHostFail()) break block22;
                        this.addToBlacklist(this.masterProtocol.getHostAddress());
                    }
                }
                return true;
            }
        }
        if (!this.isSecondaryHostFail()) {
            try {
                if (this.secondaryProtocol != null && this.secondaryProtocol.checkIfMaster()) {
                    this.setSecondaryHostFail();
                    if (this.isMasterHostFail()) {
                        this.foundActiveMaster(this.secondaryProtocol);
                    }
                    return true;
                }
            }
            catch (QueryException e3) {
                try {
                    this.secondaryProtocol.ping();
                }
                catch (Exception ee) {
                    this.proxy.lock.lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

