require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_HW_IRQ_H)) {
    eval 'sub _ASM_HW_IRQ_H () {1;}' unless defined(&_ASM_HW_IRQ_H);
    require 'linux/config.ph';
    require 'asm/atomic.ph';
    require 'asm/irq.ph';
    eval 'sub FIRST_EXTERNAL_VECTOR () {0x20;}' unless defined(&FIRST_EXTERNAL_VECTOR);
    eval 'sub SYSCALL_VECTOR () {0x80;}' unless defined(&SYSCALL_VECTOR);
    eval 'sub SPURIOUS_APIC_VECTOR () {0xff;}' unless defined(&SPURIOUS_APIC_VECTOR);
    eval 'sub ERROR_APIC_VECTOR () {0xfe;}' unless defined(&ERROR_APIC_VECTOR);
    eval 'sub INVALIDATE_TLB_VECTOR () {0xfd;}' unless defined(&INVALIDATE_TLB_VECTOR);
    eval 'sub RESCHEDULE_VECTOR () {0xfc;}' unless defined(&RESCHEDULE_VECTOR);
    eval 'sub CALL_FUNCTION_VECTOR () {0xfb;}' unless defined(&CALL_FUNCTION_VECTOR);
    eval 'sub LOCAL_TIMER_VECTOR () {0xef;}' unless defined(&LOCAL_TIMER_VECTOR);
    eval 'sub FIRST_DEVICE_VECTOR () {0x31;}' unless defined(&FIRST_DEVICE_VECTOR);
    eval 'sub FIRST_SYSTEM_VECTOR () {0xef;}' unless defined(&FIRST_SYSTEM_VECTOR);
    eval 'sub IO_APIC_VECTOR {
        my($irq) = @_;
	    eval q( $irq_vector[$irq]);
    }' unless defined(&IO_APIC_VECTOR);
    eval 'sub IO_APIC_IRQ {
        my($x) = @_;
	    eval q(((($x) >= 16) || ((1<<($x)) &  &io_apic_irqs)));
    }' unless defined(&IO_APIC_IRQ);
    eval 'sub __STR {
        my($x) = @_;
	    eval q($x);
    }' unless defined(&__STR);
    eval 'sub STR {
        my($x) = @_;
	    eval q( &__STR($x));
    }' unless defined(&STR);
    eval 'sub SAVE_ALL () {"cld\\n\\t" "pushl %es\\n\\t" "pushl %ds\\n\\t" "pushl %eax\\n\\t" "pushl %ebp\\n\\t" "pushl %edi\\n\\t" "pushl %esi\\n\\t" "pushl %edx\\n\\t" "pushl %ecx\\n\\t" "pushl %ebx\\n\\t" "movl $"  &STR( &__KERNEL_DS) ",%eax\\n\\t" "cmpl %eax,7*4(%esp)\\n\\t" "je 1f\\n\\t" "movl %eax,%ds\\n\\t" "1: cmpl %eax,8*4(%esp)\\n\\t" "je 2f\\n\\t" "movl %eax,%es\\n\\t" "2:\\n\\t";}' unless defined(&SAVE_ALL);
    eval 'sub IRQ_NAME2 {
        my($nr) = @_;
	    eval q($nr &_interrupt( &void));
    }' unless defined(&IRQ_NAME2);
    eval 'sub IRQ_NAME {
        my($nr) = @_;
	    eval q( &IRQ_NAME2( &IRQ$nr));
    }' unless defined(&IRQ_NAME);
    eval 'sub GET_CURRENT () {"movl %esp, %ebx\\n\\t" "andl $-8192, %ebx\\n\\t";}' unless defined(&GET_CURRENT);
    eval 'sub BUILD_SMP_INTERRUPT {
        my($x,$v) = @_;
	    eval q( &XBUILD_SMP_INTERRUPT($x,$v));
    }' unless defined(&BUILD_SMP_INTERRUPT);
    eval 'sub XBUILD_SMP_INTERRUPT {
        my($x,$v) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&XBUILD_SMP_INTERRUPT);
    eval 'sub BUILD_SMP_TIMER_INTERRUPT {
        my($x,$v) = @_;
	    eval q( &XBUILD_SMP_TIMER_INTERRUPT($x,$v));
    }' unless defined(&BUILD_SMP_TIMER_INTERRUPT);
    eval 'sub XBUILD_SMP_TIMER_INTERRUPT {
        my($x,$v) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&XBUILD_SMP_TIMER_INTERRUPT);
    eval 'sub BUILD_COMMON_IRQ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&BUILD_COMMON_IRQ);
    eval 'sub BUILD_IRQ {
        my($nr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&BUILD_IRQ);
    if(defined(&CONFIG_SMP)) {
	eval 'sub hw_resend_irq {
	    my($h,$i) = @_;
    	    eval q({  &if ( &IO_APIC_IRQ($i))  &send_IPI_self( &IO_APIC_VECTOR($i)); });
	}' unless defined(&hw_resend_irq);
    } else {
    }
    warn("Including\ kernel\ header\ in\ userspace\!");
}
1;
