require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&PAGE_FLAGS_H)) {
    eval 'sub PAGE_FLAGS_H () {1;}' unless defined(&PAGE_FLAGS_H);
    require 'linux/types.ph';
    eval 'sub PG_locked () {0;}' unless defined(&PG_locked);
    eval 'sub PG_error () {1;}' unless defined(&PG_error);
    eval 'sub PG_referenced () {2;}' unless defined(&PG_referenced);
    eval 'sub PG_uptodate () {3;}' unless defined(&PG_uptodate);
    eval 'sub PG_dirty () {4;}' unless defined(&PG_dirty);
    eval 'sub PG_lru () {5;}' unless defined(&PG_lru);
    eval 'sub PG_active () {6;}' unless defined(&PG_active);
    eval 'sub PG_slab () {7;}' unless defined(&PG_slab);
    eval 'sub PG_checked () {8;}' unless defined(&PG_checked);
    eval 'sub PG_arch_1 () {9;}' unless defined(&PG_arch_1);
    eval 'sub PG_reserved () {10;}' unless defined(&PG_reserved);
    eval 'sub PG_private () {11;}' unless defined(&PG_private);
    eval 'sub PG_writeback () {12;}' unless defined(&PG_writeback);
    eval 'sub PG_nosave () {13;}' unless defined(&PG_nosave);
    eval 'sub PG_compound () {14;}' unless defined(&PG_compound);
    eval 'sub PG_swapcache () {15;}' unless defined(&PG_swapcache);
    eval 'sub PG_mappedtodisk () {16;}' unless defined(&PG_mappedtodisk);
    eval 'sub PG_reclaim () {17;}' unless defined(&PG_reclaim);
    eval 'sub PG_nosave_free () {18;}' unless defined(&PG_nosave_free);
    eval 'sub PG_buddy () {19;}' unless defined(&PG_buddy);
    if(((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) > 32)) {
	eval 'sub PG_uncached () {31;}' unless defined(&PG_uncached);
    }
    eval 'sub PageLocked {
        my($page) = @_;
	    eval q( &test_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&PageLocked);
    eval 'sub SetPageLocked {
        my($page) = @_;
	    eval q( &set_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&SetPageLocked);
    eval 'sub TestSetPageLocked {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&TestSetPageLocked);
    eval 'sub ClearPageLocked {
        my($page) = @_;
	    eval q( &clear_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&ClearPageLocked);
    eval 'sub TestClearPageLocked {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&TestClearPageLocked);
    eval 'sub PageError {
        my($page) = @_;
	    eval q( &test_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&PageError);
    eval 'sub SetPageError {
        my($page) = @_;
	    eval q( &set_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&SetPageError);
    eval 'sub ClearPageError {
        my($page) = @_;
	    eval q( &clear_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&ClearPageError);
    eval 'sub PageReferenced {
        my($page) = @_;
	    eval q( &test_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&PageReferenced);
    eval 'sub SetPageReferenced {
        my($page) = @_;
	    eval q( &set_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&SetPageReferenced);
    eval 'sub ClearPageReferenced {
        my($page) = @_;
	    eval q( &clear_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&ClearPageReferenced);
    eval 'sub TestClearPageReferenced {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&TestClearPageReferenced);
    eval 'sub PageUptodate {
        my($page) = @_;
	    eval q( &test_bit( &PG_uptodate, ($page)-> &flags));
    }' unless defined(&PageUptodate);
    if(defined(&CONFIG_S390)) {
	eval 'sub SetPageUptodate {
	    my($_page) = @_;
    	    eval q( &do { 1;  &if (! &test_and_set_bit( &PG_uptodate, & ($_$_page->{flags})))  &page_test_and_clear_dirty($_page); }  &while (0));
	}' unless defined(&SetPageUptodate);
    } else {
	eval 'sub SetPageUptodate {
	    my($page) = @_;
    	    eval q( &set_bit( &PG_uptodate, ($page)-> &flags));
	}' unless defined(&SetPageUptodate);
    }
    eval 'sub ClearPageUptodate {
        my($page) = @_;
	    eval q( &clear_bit( &PG_uptodate, ($page)-> &flags));
    }' unless defined(&ClearPageUptodate);
    eval 'sub PageDirty {
        my($page) = @_;
	    eval q( &test_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&PageDirty);
    eval 'sub SetPageDirty {
        my($page) = @_;
	    eval q( &set_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&SetPageDirty);
    eval 'sub TestSetPageDirty {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&TestSetPageDirty);
    eval 'sub ClearPageDirty {
        my($page) = @_;
	    eval q( &clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&ClearPageDirty);
    eval 'sub __ClearPageDirty {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&__ClearPageDirty);
    eval 'sub TestClearPageDirty {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&TestClearPageDirty);
    eval 'sub PageLRU {
        my($page) = @_;
	    eval q( &test_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&PageLRU);
    eval 'sub SetPageLRU {
        my($page) = @_;
	    eval q( &set_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&SetPageLRU);
    eval 'sub ClearPageLRU {
        my($page) = @_;
	    eval q( &clear_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&ClearPageLRU);
    eval 'sub __ClearPageLRU {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&__ClearPageLRU);
    eval 'sub PageActive {
        my($page) = @_;
	    eval q( &test_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&PageActive);
    eval 'sub SetPageActive {
        my($page) = @_;
	    eval q( &set_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&SetPageActive);
    eval 'sub ClearPageActive {
        my($page) = @_;
	    eval q( &clear_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&ClearPageActive);
    eval 'sub __ClearPageActive {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&__ClearPageActive);
    eval 'sub PageSlab {
        my($page) = @_;
	    eval q( &test_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&PageSlab);
    eval 'sub __SetPageSlab {
        my($page) = @_;
	    eval q( &__set_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&__SetPageSlab);
    eval 'sub __ClearPageSlab {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&__ClearPageSlab);
    if(defined(&CONFIG_HIGHMEM)) {
	eval 'sub PageHighMem {
	    my($page) = @_;
    	    eval q( &is_highmem( &page_zone($page)));
	}' unless defined(&PageHighMem);
    } else {
	eval 'sub PageHighMem {
	    my($page) = @_;
    	    eval q(0);
	}' unless defined(&PageHighMem);
    }
    eval 'sub PageChecked {
        my($page) = @_;
	    eval q( &test_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&PageChecked);
    eval 'sub SetPageChecked {
        my($page) = @_;
	    eval q( &set_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&SetPageChecked);
    eval 'sub ClearPageChecked {
        my($page) = @_;
	    eval q( &clear_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&ClearPageChecked);
    eval 'sub PageReserved {
        my($page) = @_;
	    eval q( &test_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&PageReserved);
    eval 'sub SetPageReserved {
        my($page) = @_;
	    eval q( &set_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&SetPageReserved);
    eval 'sub ClearPageReserved {
        my($page) = @_;
	    eval q( &clear_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&ClearPageReserved);
    eval 'sub __ClearPageReserved {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&__ClearPageReserved);
    eval 'sub SetPagePrivate {
        my($page) = @_;
	    eval q( &set_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&SetPagePrivate);
    eval 'sub ClearPagePrivate {
        my($page) = @_;
	    eval q( &clear_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&ClearPagePrivate);
    eval 'sub PagePrivate {
        my($page) = @_;
	    eval q( &test_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&PagePrivate);
    eval 'sub __SetPagePrivate {
        my($page) = @_;
	    eval q( &__set_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&__SetPagePrivate);
    eval 'sub __ClearPagePrivate {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&__ClearPagePrivate);
    eval 'sub PageWriteback {
        my($page) = @_;
	    eval q( &test_bit( &PG_writeback, ($page)-> &flags));
    }' unless defined(&PageWriteback);
    eval 'sub SetPageWriteback {
        my($page) = @_;
	    eval q( &do {  &if (! &test_and_set_bit( &PG_writeback, ($page)-> &flags))  &inc_zone_page_state($page,  &NR_WRITEBACK); }  &while (0));
    }' unless defined(&SetPageWriteback);
    eval 'sub TestSetPageWriteback {
        my($page) = @_;
	    eval q(({ \'int\'  &ret;  &ret =  &test_and_set_bit( &PG_writeback, ($page)-> &flags);  &if (! &ret)  &inc_zone_page_state($page,  &NR_WRITEBACK);  &ret; }));
    }' unless defined(&TestSetPageWriteback);
    eval 'sub ClearPageWriteback {
        my($page) = @_;
	    eval q( &do {  &if ( &test_and_clear_bit( &PG_writeback, ($page)-> &flags))  &dec_zone_page_state($page,  &NR_WRITEBACK); }  &while (0));
    }' unless defined(&ClearPageWriteback);
    eval 'sub TestClearPageWriteback {
        my($page) = @_;
	    eval q(({ \'int\'  &ret;  &ret =  &test_and_clear_bit( &PG_writeback, ($page)-> &flags);  &if ( &ret)  &dec_zone_page_state($page,  &NR_WRITEBACK);  &ret; }));
    }' unless defined(&TestClearPageWriteback);
    eval 'sub PageNosave {
        my($page) = @_;
	    eval q( &test_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&PageNosave);
    eval 'sub SetPageNosave {
        my($page) = @_;
	    eval q( &set_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&SetPageNosave);
    eval 'sub TestSetPageNosave {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&TestSetPageNosave);
    eval 'sub ClearPageNosave {
        my($page) = @_;
	    eval q( &clear_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&ClearPageNosave);
    eval 'sub TestClearPageNosave {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&TestClearPageNosave);
    eval 'sub PageNosaveFree {
        my($page) = @_;
	    eval q( &test_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&PageNosaveFree);
    eval 'sub SetPageNosaveFree {
        my($page) = @_;
	    eval q( &set_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&SetPageNosaveFree);
    eval 'sub ClearPageNosaveFree {
        my($page) = @_;
	    eval q( &clear_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&ClearPageNosaveFree);
    eval 'sub PageBuddy {
        my($page) = @_;
	    eval q( &test_bit( &PG_buddy, ($page)-> &flags));
    }' unless defined(&PageBuddy);
    eval 'sub __SetPageBuddy {
        my($page) = @_;
	    eval q( &__set_bit( &PG_buddy, ($page)-> &flags));
    }' unless defined(&__SetPageBuddy);
    eval 'sub __ClearPageBuddy {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_buddy, ($page)-> &flags));
    }' unless defined(&__ClearPageBuddy);
    eval 'sub PageMappedToDisk {
        my($page) = @_;
	    eval q( &test_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&PageMappedToDisk);
    eval 'sub SetPageMappedToDisk {
        my($page) = @_;
	    eval q( &set_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&SetPageMappedToDisk);
    eval 'sub ClearPageMappedToDisk {
        my($page) = @_;
	    eval q( &clear_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&ClearPageMappedToDisk);
    eval 'sub PageReclaim {
        my($page) = @_;
	    eval q( &test_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&PageReclaim);
    eval 'sub SetPageReclaim {
        my($page) = @_;
	    eval q( &set_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&SetPageReclaim);
    eval 'sub ClearPageReclaim {
        my($page) = @_;
	    eval q( &clear_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&ClearPageReclaim);
    eval 'sub TestClearPageReclaim {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&TestClearPageReclaim);
    eval 'sub PageCompound {
        my($page) = @_;
	    eval q( &test_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&PageCompound);
    eval 'sub __SetPageCompound {
        my($page) = @_;
	    eval q( &__set_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&__SetPageCompound);
    eval 'sub __ClearPageCompound {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&__ClearPageCompound);
    if(defined(&CONFIG_SWAP)) {
	eval 'sub PageSwapCache {
	    my($page) = @_;
    	    eval q( &test_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&PageSwapCache);
	eval 'sub SetPageSwapCache {
	    my($page) = @_;
    	    eval q( &set_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&SetPageSwapCache);
	eval 'sub ClearPageSwapCache {
	    my($page) = @_;
    	    eval q( &clear_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&ClearPageSwapCache);
    } else {
	eval 'sub PageSwapCache {
	    my($page) = @_;
    	    eval q(0);
	}' unless defined(&PageSwapCache);
    }
    eval 'sub PageUncached {
        my($page) = @_;
	    eval q( &test_bit( &PG_uncached, ($page)-> &flags));
    }' unless defined(&PageUncached);
    eval 'sub SetPageUncached {
        my($page) = @_;
	    eval q( &set_bit( &PG_uncached, ($page)-> &flags));
    }' unless defined(&SetPageUncached);
    eval 'sub ClearPageUncached {
        my($page) = @_;
	    eval q( &clear_bit( &PG_uncached, ($page)-> &flags));
    }' unless defined(&ClearPageUncached);
    eval 'sub clear_page_dirty {
        my($page) = @_;
	    eval q({  &test_clear_page_dirty($page); });
    }' unless defined(&clear_page_dirty);
    eval 'sub set_page_writeback {
        my($page) = @_;
	    eval q({  &test_set_page_writeback($page); });
    }' unless defined(&set_page_writeback);
}
1;
