#! /usr/bin/python2.4
# -*- coding: utf-8 mode: python -*-
# kmdl.py - plugin for handling kmdls
# Copyright (C) 2006 A. Thimm
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
# by Troy Dawson <dawson@fnal.gov> for Scientific Linux
#
# This is a modification of A. Thimm's kmdl.py plugin
#  The modification is that is works with kernel-module-<module name>-<uname -r>
#  instead of <module name>-kmdl-<uname -r>
#  Another modification is that it also installs all kernel modules for all
#  of your installed kernels.
# $Id$

try:
    set = set
except:
    from sets import Set as set

import re
import rpm

from yum.plugins import TYPE_CORE

requires_api_version = '2.1'
plugin_type = (TYPE_CORE,)

KERNELS=["kernel", "kernel-smp", "kernel-bigmem", "kernel-hugemem", "kernel-largesmp", "kernel-xen0", "kernel-xenU", "kernel-kdump", "kernel-xen", "kernel-PAE"]

def uname_r(name, version, release):
    if name == 'kernel':
        return "%s-%s" % (version, release)
    else:
        (dummy, flavour) = name.split('-')
        return "%s-%s%s" % (version, release, flavour)

def old_kmdls(conduit):
    conduit.info(4, "---> WE ARE IN THE OLD_KMDLS FUNCTION")
    kmdls=[]
    for package in conduit.getRpmDB().returnPackages():
        m=re.match('(.*)-kmdl-.*', package.tagByName('name'))
        if m:
            conduit.info(6, '----> this is a kmdl package from getHdrList %s' % m.group(1))
            kmdls.append(m.group(1))
        else:
            mkm=re.match('kernel-module-.*', package.tagByName('name'))
            if mkm:
                conduit.info(6, '----> this is a kernel module from getHdrList %s' % mkm.group(0))
                tmp=mkm.group(0).split('-')
                if len(tmp) > 3:
                    km = tmp[2]
                    conduit.info(6, '----> this is the package from getHdrList %s' % km)
                    kmdls.append(km)
    conduit.info(4, '-----> old kmds are %s' % kmdls)
    return kmdls

def new_kmdls(conduit):
    conduit.info(4, "---> WE ARE IN THE NEW_KMDLS FUNCTION")
    kmdls=[]
    tsInfo=conduit.getTsInfo()
    for txmbr in tsInfo.getMembers():
        m=re.match('(.*)-kmdl-.*', txmbr.name)
        if m and txmbr.ts_state in ('i', 'u'):
            conduit.info(6, '----> this is a kmdl package from getMembers %s' % m.group(1))
            kmdls.append(m.group(1))
        else:
            mkm=re.match('kernel-module-.*', txmbr.name)
            if mkm and txmbr.ts_state in ('i', 'u'):
                conduit.info(6, '----> this is a kernel module from getMembers %s' % mkm.group(0))
                tmp=mkm.group(0).split('-')
                if len(tmp) > 3:
                    km = tmp[2]
                    conduit.info(6, '----> this is the package from getMembers %s' % km)
                    kmdls.append(km)
    conduit.info(4, '-----> new kmds are %s' % kmdls)
    return kmdls

def old_kernels(conduit):
    kernels=[]
    for package in conduit.getRpmDB().returnPackages():
        if package.tagByName('name') in KERNELS:
            kernels.append([uname_r(package.tagByName('name'),
                                    package.tagByName('version'),
                                    package.tagByName('release')),
                             package.tagByName('arch')])
    return kernels

def new_kernels(conduit):
    kernels=[]
    tsInfo=conduit.getTsInfo()
    for txmbr in tsInfo.getMembers():
        if txmbr.name in KERNELS and txmbr.ts_state in ('i', 'u'):
            kernels.append([uname_r(txmbr.name, txmbr.version, txmbr.release),
                             txmbr.arch])
    return kernels

def remove_kernels(conduit):
    kernels=[]
    tsInfo=conduit.getTsInfo()
    for txmbr in tsInfo.getMembers():
	if txmbr.name in KERNELS and txmbr.ts_state in ('e',):
            conduit.info(6, '---> Kernel %s : state %s' % (txmbr.name, txmbr.ts_state))
            kernels.append([uname_r(txmbr.name, txmbr.version, txmbr.release),
                             txmbr.arch])
    return kernels

def kmdl_install(conduit, kernels, kmdls):
    conduit.info(4, "---> WE ARE IN THE KMDL_INSTALL FUNCTION")
    conduit.info(4, '-----> we have these kernels %s' % kernels)
    conduit.info(4, '-----> we have these kmdls %s' % kmdls)
    tsInfo = conduit.getTsInfo()
    for kernel in kernels:
        conduit.info(6, '------> working on kernel %s' % kernel)
        for kmdl in kmdls:
            conduit.info(6, '--------> working on kernel_module for package %s' % kmdl)
            kmpkgname="kernel-module-%s-%s" % (kmdl, kernel[0])
            kmdlpkgname="%s-kmdl-%s" % (kmdl, kernel[0])
            pkgfound=None
            for pkg in conduit.getPackages():
                if pkg.name == kmpkgname and pkg.arch == kernel[1]:
                    if not pkgfound or pkgfound.returnEVR() < pkg.returnEVR():
                        pkgfound=pkg
                elif pkg.name == kmdlpkgname and pkg.arch == kernel[1]:
                    if not pkgfound or pkgfound.returnEVR() < pkg.returnEVR():
                        pkgfound=pkg
            if pkgfound and not conduit.getRpmDB().installed(pkgfound.name, pkgfound.arch, pkgfound.epoch, pkgfound.version, pkgfound.release):
                (n, a, e, v, r) = pkgfound.pkgtup
                conduit.info(2, '---> Package %s.%s %s:%s-%s set to be %s' % (n, a, e, v, r,'installed'))
                tsInfo.addInstall(pkgfound)

def kmdl_cleanup(conduit, kernels):
    conduit.info(4, "---> WE ARE IN THE KMDL_CLEANUP FUNCTION")
    conduit.info(4, '-----> we are checking against these kernels %s' % kernels)
    tsInfo = conduit.getTsInfo()
    for package in conduit.getRpmDB().returnPackages():
        kernelfound=None
	m=re.match('(.*)-kmdl-.*', package.name)
        if m:
            conduit.info(6, '----> this is a kmdl package from getHdrList %s' % m.group(0))
            tmp=m.group(0).split('-')
            if len(tmp) > 2:
              krn = tmp[2]+"-"+tmp[3]
              conduit.info(6, '------> this is the kernel for the module: %s' % krn)
	      for kernel in kernels:
	        conduit.info(6, '------> checking against kernel %s' % kernel)
		if krn == kernel[0] and package.arch == kernel[1]:
		  conduit.info(6, '---> Package %s matches kernel %s' % (m.group(0),kernel[0]))
		  kernelfound=kernel
		  if not kernelfound:
		    conduit.info(2, '---> Package %s being cleaned up and erased' % package.name)
		    tsInfo.addErase(package)
        else:
            mkm=re.match('kernel-module-.*', package.name)
            if mkm:
                conduit.info(6, '----> this is a kernel module from getHdrList %s' % mkm.group(0))
                tmp=mkm.group(0).split('-')
                if len(tmp) > 3:
                    krn = tmp[3]+"-"+tmp[4]
                    conduit.info(6, '------> this is the kernel for the module: %s' % krn)
		    for kernel in kernels:
		      conduit.info(6, '------> checking against kernel %s' % kernel[0])
		      if krn == kernel[0] and package.arch == kernel[1]:
		        conduit.info(6, '---> Package %s matches kernel %s' % (mkm.group(0),kernel[0]))
			kernelfound=kernel
		    if not kernelfound:
		      conduit.info(2, '---> Package %s being cleaned up and erased' % package.name)
		      tsInfo.addErase(package)
    for package in tsInfo.getMembers():
        conduit.info(6, '------> Package: %s State: %s' % (package.name,package.ts_state))
	if package.ts_state == 'e':
		conduit.info(6, '----> package %s is set to be erased, not doing anything with it' % package.name)
	else:
          kernelfound=None
	  m=re.match('(.*)-kmdl-.*', package.name)
          if m:
            conduit.info(6, '----> this is a kmdl package from getHdrList %s' % m.group(0))
            tmp=m.group(0).split('-')
            if len(tmp) > 2:
              krn = tmp[2]+"-"+tmp[3]
              conduit.info(6, '------> this is the kernel from the module %s' % krn)
	      for kernel in kernels:
	        conduit.info(6, '------> checking against kernel %s' % kernel)
		if krn == kernel[0] and package.arch == kernel[1]:
		  conduit.info(6, '---> Package %s matches kernel %s' % (m.group(0),kernel[0]))
		  kernelfound=kernel
		  if not kernelfound:
		    conduit.info(2, '---> Package %s being removed from install list' % package.name)
		    tsInfo.remove(package.pkgtup)
          else:
            mkm=re.match('kernel-module-.*', package.name)
            if mkm:
                conduit.info(6, '----> this is a kernel module from getHdrList %s' % mkm.group(0))
                tmp=mkm.group(0).split('-')
                if len(tmp) > 3:
                    krn = tmp[3]+"-"+tmp[4]
                    conduit.info(6, '------> this is the kernel from the module %s' % krn)
		    for kernel in kernels:
		      conduit.info(6, '------> this is the kernel from the kernel %s' % kernel[0])
		      if krn == kernel[0] and package.arch == kernel[1]:
		        conduit.info(6, '---> Package %s matches kernel %s' % (mkm.group(0),kernel[0]))
			kernelfound=kernel
		    if not kernelfound:
		      conduit.info(2, '---> Package %s being removed from install list' % package.name)
		      tsInfo.remove(package.pkgtup)

def kmdl_remove(conduit, kernels):
    conduit.info(4, "---> WE ARE IN THE KMDL_REMOVE FUNCTION")
    conduit.info(4, '-----> we are removing these kernels %s' % kernels)
    tsInfo = conduit.getTsInfo()
    for package in conduit.getRpmDB().returnPackages():
        m=re.match('(.*)-kmdl-.*', package.tagByName('name'))
        if m:
            conduit.info(6, '----> this is a kmdl package from getHdrList %s' % m.group(0))
            tmp=m.group(0).split('-')
            if len(tmp) > 2:
              krn = tmp[2]+"-"+tmp[3]
              conduit.info(6, '------> this is the kernel from the module %s' % krn)
	      for kernel in kernels:
	        conduit.info(6, '------> checking against kernel %s' % kernel)
		if krn == kernel[0] and package.arch == kernel[1]:
		  conduit.info(2, '---> Package %s set to be %s' % (m.group(0),'erased'))
		  tsInfo.addErase(package)
        else:
            mkm=re.match('kernel-module-.*', package.tagByName('name'))
            if mkm:
                conduit.info(6, '----> this is a kernel module from getHdrList %s' % mkm.group(0))
                tmp=mkm.group(0).split('-')
                if len(tmp) > 3:
                    krn = tmp[3]+"-"+tmp[4]
                    conduit.info(6, '------> this is the kernel from the module %s' % krn)
		    for kernel in kernels:
		      conduit.info(6, '------> this is the kernel from the kernel %s' % kernel[0])
		      if krn == kernel[0] and package.arch == kernel[1]:
		        conduit.info(2, '---> Package %s set to be %s' % (mkm.group(0),'erased'))
			tsInfo.addErase(package)
    for package in tsInfo.getMembers():
        conduit.info(6, '------> Package: %s State: %s' % (package.name,package.ts_state))
	if package.ts_state == 'e':
		conduit.info(6, '----> package %s is set to be erased, not doing anything with it' % package.name)
	else:
          kernelfound=None
	  m=re.match('(.*)-kmdl-.*', package.name)
          if m:
            conduit.info(6, '----> this is a kmdl package from getHdrList %s' % m.group(0))
            tmp=m.group(0).split('-')
            if len(tmp) > 2:
              krn = tmp[2]+"-"+tmp[3]
              conduit.info(6, '------> this is the kernel from the module %s' % krn)
	      for kernel in kernels:
	        conduit.info(6, '------> checking against kernel %s' % kernel)
		if krn == kernel[0] and package.arch == kernel[1]:
		  conduit.info(6, '---> Package %s matches kernel %s' % (m.group(0),kernel[0]))
		  kernelfound=kernel
		  if kernelfound:
		    conduit.info(2, '---> Package %s being removed from install list' % package.name)
		    tsInfo.remove(package.pkgtup)
          else:
            mkm=re.match('kernel-module-.*', package.name)
            if mkm:
                conduit.info(6, '----> this is a kernel module from getHdrList %s' % mkm.group(0))
                tmp=mkm.group(0).split('-')
                if len(tmp) > 3:
                    krn = tmp[3]+"-"+tmp[4]
                    conduit.info(6, '------> this is the kernel from the module %s' % krn)
		    for kernel in kernels:
		      conduit.info(6, '------> this is the kernel from the kernel %s' % kernel[0])
		      if krn == kernel[0] and package.arch == kernel[1]:
		        conduit.info(6, '---> Package %s matches kernel %s' % (mkm.group(0),kernel[0]))
			kernelfound=kernel
		    if kernelfound:
		      conduit.info(2, '---> Package %s being removed from install list' % package.name)
		      tsInfo.remove(package.pkgtup)

def postresolve_hook(conduit):
    conduit.info(2, 'Beginning Kernel Module Plugin')
    removekernels = remove_kernels(conduit)
    kernels = new_kernels(conduit)
    kmdls = new_kmdls(conduit)
    if kernels or kmdls:
    	kernels = kernels + old_kernels(conduit)
    	kmdls = kmdls + old_kmdls(conduit)
    	kmdls = set(kmdls)
    	kmdl_install(conduit, kernels, kmdls)
	kmdl_cleanup(conduit, kernels)
    if removekernels:
    	kmdl_remove(conduit, removekernels)
    conduit.info(2, 'Finished Kernel Module Plugin')
