/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/blind_test_run_result.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref ::diagnostics::unittest::testing::blind_test_run_result 
 *
 * @test none
 */

#ifndef DIAGNOSTICS__UTIL__BLIND_TEST_RUN_RESULT_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__BLIND_TEST_RUN_RESULT_TS_HPP__INCLUDE_GUARD

#include <diagnostics/unittest.hpp>

#include <string>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

/**
 * @brief takes a string which contains the output of zero or more
 * Test_Run_Result (generated with operator<<) and returns a string
 * which with the same content except that all system and exeuction
 * particularities are removed, i.e., no hostname, pid, tid, or timing
 * informaion is left.
 *
 * @attention this procedure is not intelligent. To help in case of
 * trouble, each cut-point is marked by an XX.
 *
 * @attention assumes that the Test_Run_Result contains only the @ref
 * TYPE_TESTCASE_ENTER and @ref TYPE_TESTCASE_EXIT @ref Record s.
 */ 
::std::string blind_test_run_result(::std::string const & in);

TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
