// Generated by gir (https://github.com/gtk-rs/gir @ d7c0763cacbc)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 4d1189172a70)
// DO NOT EDIT

#![cfg(unix)]

use sourceview5_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gtksourceview-5"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GtkSourceBackgroundPatternType",
        Layout {
            size: size_of::<GtkSourceBackgroundPatternType>(),
            alignment: align_of::<GtkSourceBackgroundPatternType>(),
        },
    ),
    (
        "GtkSourceBracketMatchType",
        Layout {
            size: size_of::<GtkSourceBracketMatchType>(),
            alignment: align_of::<GtkSourceBracketMatchType>(),
        },
    ),
    (
        "GtkSourceBuffer",
        Layout {
            size: size_of::<GtkSourceBuffer>(),
            alignment: align_of::<GtkSourceBuffer>(),
        },
    ),
    (
        "GtkSourceBufferClass",
        Layout {
            size: size_of::<GtkSourceBufferClass>(),
            alignment: align_of::<GtkSourceBufferClass>(),
        },
    ),
    (
        "GtkSourceChangeCaseType",
        Layout {
            size: size_of::<GtkSourceChangeCaseType>(),
            alignment: align_of::<GtkSourceChangeCaseType>(),
        },
    ),
    (
        "GtkSourceCompletionActivation",
        Layout {
            size: size_of::<GtkSourceCompletionActivation>(),
            alignment: align_of::<GtkSourceCompletionActivation>(),
        },
    ),
    (
        "GtkSourceCompletionCellClass",
        Layout {
            size: size_of::<GtkSourceCompletionCellClass>(),
            alignment: align_of::<GtkSourceCompletionCellClass>(),
        },
    ),
    (
        "GtkSourceCompletionClass",
        Layout {
            size: size_of::<GtkSourceCompletionClass>(),
            alignment: align_of::<GtkSourceCompletionClass>(),
        },
    ),
    (
        "GtkSourceCompletionColumn",
        Layout {
            size: size_of::<GtkSourceCompletionColumn>(),
            alignment: align_of::<GtkSourceCompletionColumn>(),
        },
    ),
    (
        "GtkSourceCompletionContextClass",
        Layout {
            size: size_of::<GtkSourceCompletionContextClass>(),
            alignment: align_of::<GtkSourceCompletionContextClass>(),
        },
    ),
    (
        "GtkSourceCompletionProposalInterface",
        Layout {
            size: size_of::<GtkSourceCompletionProposalInterface>(),
            alignment: align_of::<GtkSourceCompletionProposalInterface>(),
        },
    ),
    (
        "GtkSourceCompletionProviderInterface",
        Layout {
            size: size_of::<GtkSourceCompletionProviderInterface>(),
            alignment: align_of::<GtkSourceCompletionProviderInterface>(),
        },
    ),
    (
        "GtkSourceCompletionSnippets",
        Layout {
            size: size_of::<GtkSourceCompletionSnippets>(),
            alignment: align_of::<GtkSourceCompletionSnippets>(),
        },
    ),
    (
        "GtkSourceCompletionSnippetsClass",
        Layout {
            size: size_of::<GtkSourceCompletionSnippetsClass>(),
            alignment: align_of::<GtkSourceCompletionSnippetsClass>(),
        },
    ),
    (
        "GtkSourceCompletionWords",
        Layout {
            size: size_of::<GtkSourceCompletionWords>(),
            alignment: align_of::<GtkSourceCompletionWords>(),
        },
    ),
    (
        "GtkSourceCompletionWordsClass",
        Layout {
            size: size_of::<GtkSourceCompletionWordsClass>(),
            alignment: align_of::<GtkSourceCompletionWordsClass>(),
        },
    ),
    (
        "GtkSourceCompressionType",
        Layout {
            size: size_of::<GtkSourceCompressionType>(),
            alignment: align_of::<GtkSourceCompressionType>(),
        },
    ),
    (
        "GtkSourceFile",
        Layout {
            size: size_of::<GtkSourceFile>(),
            alignment: align_of::<GtkSourceFile>(),
        },
    ),
    (
        "GtkSourceFileClass",
        Layout {
            size: size_of::<GtkSourceFileClass>(),
            alignment: align_of::<GtkSourceFileClass>(),
        },
    ),
    (
        "GtkSourceFileLoaderClass",
        Layout {
            size: size_of::<GtkSourceFileLoaderClass>(),
            alignment: align_of::<GtkSourceFileLoaderClass>(),
        },
    ),
    (
        "GtkSourceFileLoaderError",
        Layout {
            size: size_of::<GtkSourceFileLoaderError>(),
            alignment: align_of::<GtkSourceFileLoaderError>(),
        },
    ),
    (
        "GtkSourceFileSaverClass",
        Layout {
            size: size_of::<GtkSourceFileSaverClass>(),
            alignment: align_of::<GtkSourceFileSaverClass>(),
        },
    ),
    (
        "GtkSourceFileSaverError",
        Layout {
            size: size_of::<GtkSourceFileSaverError>(),
            alignment: align_of::<GtkSourceFileSaverError>(),
        },
    ),
    (
        "GtkSourceFileSaverFlags",
        Layout {
            size: size_of::<GtkSourceFileSaverFlags>(),
            alignment: align_of::<GtkSourceFileSaverFlags>(),
        },
    ),
    (
        "GtkSourceGutterClass",
        Layout {
            size: size_of::<GtkSourceGutterClass>(),
            alignment: align_of::<GtkSourceGutterClass>(),
        },
    ),
    (
        "GtkSourceGutterLinesClass",
        Layout {
            size: size_of::<GtkSourceGutterLinesClass>(),
            alignment: align_of::<GtkSourceGutterLinesClass>(),
        },
    ),
    (
        "GtkSourceGutterRenderer",
        Layout {
            size: size_of::<GtkSourceGutterRenderer>(),
            alignment: align_of::<GtkSourceGutterRenderer>(),
        },
    ),
    (
        "GtkSourceGutterRendererAlignmentMode",
        Layout {
            size: size_of::<GtkSourceGutterRendererAlignmentMode>(),
            alignment: align_of::<GtkSourceGutterRendererAlignmentMode>(),
        },
    ),
    (
        "GtkSourceGutterRendererClass",
        Layout {
            size: size_of::<GtkSourceGutterRendererClass>(),
            alignment: align_of::<GtkSourceGutterRendererClass>(),
        },
    ),
    (
        "GtkSourceGutterRendererPixbuf",
        Layout {
            size: size_of::<GtkSourceGutterRendererPixbuf>(),
            alignment: align_of::<GtkSourceGutterRendererPixbuf>(),
        },
    ),
    (
        "GtkSourceGutterRendererPixbufClass",
        Layout {
            size: size_of::<GtkSourceGutterRendererPixbufClass>(),
            alignment: align_of::<GtkSourceGutterRendererPixbufClass>(),
        },
    ),
    (
        "GtkSourceGutterRendererText",
        Layout {
            size: size_of::<GtkSourceGutterRendererText>(),
            alignment: align_of::<GtkSourceGutterRendererText>(),
        },
    ),
    (
        "GtkSourceGutterRendererTextClass",
        Layout {
            size: size_of::<GtkSourceGutterRendererTextClass>(),
            alignment: align_of::<GtkSourceGutterRendererTextClass>(),
        },
    ),
    (
        "GtkSourceHoverClass",
        Layout {
            size: size_of::<GtkSourceHoverClass>(),
            alignment: align_of::<GtkSourceHoverClass>(),
        },
    ),
    (
        "GtkSourceHoverContextClass",
        Layout {
            size: size_of::<GtkSourceHoverContextClass>(),
            alignment: align_of::<GtkSourceHoverContextClass>(),
        },
    ),
    (
        "GtkSourceHoverDisplayClass",
        Layout {
            size: size_of::<GtkSourceHoverDisplayClass>(),
            alignment: align_of::<GtkSourceHoverDisplayClass>(),
        },
    ),
    (
        "GtkSourceHoverProviderInterface",
        Layout {
            size: size_of::<GtkSourceHoverProviderInterface>(),
            alignment: align_of::<GtkSourceHoverProviderInterface>(),
        },
    ),
    (
        "GtkSourceIndenterInterface",
        Layout {
            size: size_of::<GtkSourceIndenterInterface>(),
            alignment: align_of::<GtkSourceIndenterInterface>(),
        },
    ),
    (
        "GtkSourceLanguageClass",
        Layout {
            size: size_of::<GtkSourceLanguageClass>(),
            alignment: align_of::<GtkSourceLanguageClass>(),
        },
    ),
    (
        "GtkSourceLanguageManagerClass",
        Layout {
            size: size_of::<GtkSourceLanguageManagerClass>(),
            alignment: align_of::<GtkSourceLanguageManagerClass>(),
        },
    ),
    (
        "GtkSourceMap",
        Layout {
            size: size_of::<GtkSourceMap>(),
            alignment: align_of::<GtkSourceMap>(),
        },
    ),
    (
        "GtkSourceMapClass",
        Layout {
            size: size_of::<GtkSourceMapClass>(),
            alignment: align_of::<GtkSourceMapClass>(),
        },
    ),
    (
        "GtkSourceMark",
        Layout {
            size: size_of::<GtkSourceMark>(),
            alignment: align_of::<GtkSourceMark>(),
        },
    ),
    (
        "GtkSourceMarkAttributesClass",
        Layout {
            size: size_of::<GtkSourceMarkAttributesClass>(),
            alignment: align_of::<GtkSourceMarkAttributesClass>(),
        },
    ),
    (
        "GtkSourceMarkClass",
        Layout {
            size: size_of::<GtkSourceMarkClass>(),
            alignment: align_of::<GtkSourceMarkClass>(),
        },
    ),
    (
        "GtkSourceNewlineType",
        Layout {
            size: size_of::<GtkSourceNewlineType>(),
            alignment: align_of::<GtkSourceNewlineType>(),
        },
    ),
    (
        "GtkSourcePrintCompositor",
        Layout {
            size: size_of::<GtkSourcePrintCompositor>(),
            alignment: align_of::<GtkSourcePrintCompositor>(),
        },
    ),
    (
        "GtkSourcePrintCompositorClass",
        Layout {
            size: size_of::<GtkSourcePrintCompositorClass>(),
            alignment: align_of::<GtkSourcePrintCompositorClass>(),
        },
    ),
    (
        "GtkSourceRegion",
        Layout {
            size: size_of::<GtkSourceRegion>(),
            alignment: align_of::<GtkSourceRegion>(),
        },
    ),
    (
        "GtkSourceRegionClass",
        Layout {
            size: size_of::<GtkSourceRegionClass>(),
            alignment: align_of::<GtkSourceRegionClass>(),
        },
    ),
    (
        "GtkSourceRegionIter",
        Layout {
            size: size_of::<GtkSourceRegionIter>(),
            alignment: align_of::<GtkSourceRegionIter>(),
        },
    ),
    (
        "GtkSourceSearchContextClass",
        Layout {
            size: size_of::<GtkSourceSearchContextClass>(),
            alignment: align_of::<GtkSourceSearchContextClass>(),
        },
    ),
    (
        "GtkSourceSearchSettings",
        Layout {
            size: size_of::<GtkSourceSearchSettings>(),
            alignment: align_of::<GtkSourceSearchSettings>(),
        },
    ),
    (
        "GtkSourceSearchSettingsClass",
        Layout {
            size: size_of::<GtkSourceSearchSettingsClass>(),
            alignment: align_of::<GtkSourceSearchSettingsClass>(),
        },
    ),
    (
        "GtkSourceSmartHomeEndType",
        Layout {
            size: size_of::<GtkSourceSmartHomeEndType>(),
            alignment: align_of::<GtkSourceSmartHomeEndType>(),
        },
    ),
    (
        "GtkSourceSnippetChunkClass",
        Layout {
            size: size_of::<GtkSourceSnippetChunkClass>(),
            alignment: align_of::<GtkSourceSnippetChunkClass>(),
        },
    ),
    (
        "GtkSourceSnippetClass",
        Layout {
            size: size_of::<GtkSourceSnippetClass>(),
            alignment: align_of::<GtkSourceSnippetClass>(),
        },
    ),
    (
        "GtkSourceSnippetContextClass",
        Layout {
            size: size_of::<GtkSourceSnippetContextClass>(),
            alignment: align_of::<GtkSourceSnippetContextClass>(),
        },
    ),
    (
        "GtkSourceSnippetManagerClass",
        Layout {
            size: size_of::<GtkSourceSnippetManagerClass>(),
            alignment: align_of::<GtkSourceSnippetManagerClass>(),
        },
    ),
    (
        "GtkSourceSortFlags",
        Layout {
            size: size_of::<GtkSourceSortFlags>(),
            alignment: align_of::<GtkSourceSortFlags>(),
        },
    ),
    (
        "GtkSourceSpaceDrawerClass",
        Layout {
            size: size_of::<GtkSourceSpaceDrawerClass>(),
            alignment: align_of::<GtkSourceSpaceDrawerClass>(),
        },
    ),
    (
        "GtkSourceSpaceLocationFlags",
        Layout {
            size: size_of::<GtkSourceSpaceLocationFlags>(),
            alignment: align_of::<GtkSourceSpaceLocationFlags>(),
        },
    ),
    (
        "GtkSourceSpaceTypeFlags",
        Layout {
            size: size_of::<GtkSourceSpaceTypeFlags>(),
            alignment: align_of::<GtkSourceSpaceTypeFlags>(),
        },
    ),
    (
        "GtkSourceStyleClass",
        Layout {
            size: size_of::<GtkSourceStyleClass>(),
            alignment: align_of::<GtkSourceStyleClass>(),
        },
    ),
    (
        "GtkSourceStyleSchemeChooserButton",
        Layout {
            size: size_of::<GtkSourceStyleSchemeChooserButton>(),
            alignment: align_of::<GtkSourceStyleSchemeChooserButton>(),
        },
    ),
    (
        "GtkSourceStyleSchemeChooserButtonClass",
        Layout {
            size: size_of::<GtkSourceStyleSchemeChooserButtonClass>(),
            alignment: align_of::<GtkSourceStyleSchemeChooserButtonClass>(),
        },
    ),
    (
        "GtkSourceStyleSchemeChooserInterface",
        Layout {
            size: size_of::<GtkSourceStyleSchemeChooserInterface>(),
            alignment: align_of::<GtkSourceStyleSchemeChooserInterface>(),
        },
    ),
    (
        "GtkSourceStyleSchemeChooserWidget",
        Layout {
            size: size_of::<GtkSourceStyleSchemeChooserWidget>(),
            alignment: align_of::<GtkSourceStyleSchemeChooserWidget>(),
        },
    ),
    (
        "GtkSourceStyleSchemeChooserWidgetClass",
        Layout {
            size: size_of::<GtkSourceStyleSchemeChooserWidgetClass>(),
            alignment: align_of::<GtkSourceStyleSchemeChooserWidgetClass>(),
        },
    ),
    (
        "GtkSourceStyleSchemeClass",
        Layout {
            size: size_of::<GtkSourceStyleSchemeClass>(),
            alignment: align_of::<GtkSourceStyleSchemeClass>(),
        },
    ),
    (
        "GtkSourceStyleSchemeManagerClass",
        Layout {
            size: size_of::<GtkSourceStyleSchemeManagerClass>(),
            alignment: align_of::<GtkSourceStyleSchemeManagerClass>(),
        },
    ),
    (
        "GtkSourceStyleSchemePreviewClass",
        Layout {
            size: size_of::<GtkSourceStyleSchemePreviewClass>(),
            alignment: align_of::<GtkSourceStyleSchemePreviewClass>(),
        },
    ),
    (
        "GtkSourceTag",
        Layout {
            size: size_of::<GtkSourceTag>(),
            alignment: align_of::<GtkSourceTag>(),
        },
    ),
    (
        "GtkSourceTagClass",
        Layout {
            size: size_of::<GtkSourceTagClass>(),
            alignment: align_of::<GtkSourceTagClass>(),
        },
    ),
    (
        "GtkSourceView",
        Layout {
            size: size_of::<GtkSourceView>(),
            alignment: align_of::<GtkSourceView>(),
        },
    ),
    (
        "GtkSourceViewClass",
        Layout {
            size: size_of::<GtkSourceViewClass>(),
            alignment: align_of::<GtkSourceViewClass>(),
        },
    ),
    (
        "GtkSourceViewGutterPosition",
        Layout {
            size: size_of::<GtkSourceViewGutterPosition>(),
            alignment: align_of::<GtkSourceViewGutterPosition>(),
        },
    ),
    (
        "GtkSourceVimIMContextClass",
        Layout {
            size: size_of::<GtkSourceVimIMContextClass>(),
            alignment: align_of::<GtkSourceVimIMContextClass>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) GTK_SOURCE_BACKGROUND_PATTERN_TYPE_GRID", "1"),
    ("(gint) GTK_SOURCE_BACKGROUND_PATTERN_TYPE_NONE", "0"),
    ("(gint) GTK_SOURCE_BRACKET_MATCH_FOUND", "3"),
    ("(gint) GTK_SOURCE_BRACKET_MATCH_NONE", "0"),
    ("(gint) GTK_SOURCE_BRACKET_MATCH_NOT_FOUND", "2"),
    ("(gint) GTK_SOURCE_BRACKET_MATCH_OUT_OF_RANGE", "1"),
    ("(gint) GTK_SOURCE_CHANGE_CASE_LOWER", "0"),
    ("(gint) GTK_SOURCE_CHANGE_CASE_TITLE", "3"),
    ("(gint) GTK_SOURCE_CHANGE_CASE_TOGGLE", "2"),
    ("(gint) GTK_SOURCE_CHANGE_CASE_UPPER", "1"),
    ("(gint) GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE", "1"),
    ("(gint) GTK_SOURCE_COMPLETION_ACTIVATION_NONE", "0"),
    (
        "(gint) GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED",
        "2",
    ),
    ("(gint) GTK_SOURCE_COMPLETION_COLUMN_AFTER", "3"),
    ("(gint) GTK_SOURCE_COMPLETION_COLUMN_BEFORE", "1"),
    ("(gint) GTK_SOURCE_COMPLETION_COLUMN_COMMENT", "4"),
    ("(gint) GTK_SOURCE_COMPLETION_COLUMN_DETAILS", "5"),
    ("(gint) GTK_SOURCE_COMPLETION_COLUMN_ICON", "0"),
    ("(gint) GTK_SOURCE_COMPLETION_COLUMN_TYPED_TEXT", "2"),
    ("(gint) GTK_SOURCE_COMPRESSION_TYPE_GZIP", "1"),
    ("(gint) GTK_SOURCE_COMPRESSION_TYPE_NONE", "0"),
    (
        "(gint) GTK_SOURCE_FILE_LOADER_ERROR_CONVERSION_FALLBACK",
        "2",
    ),
    (
        "(gint) GTK_SOURCE_FILE_LOADER_ERROR_ENCODING_AUTO_DETECTION_FAILED",
        "1",
    ),
    ("(gint) GTK_SOURCE_FILE_LOADER_ERROR_TOO_BIG", "0"),
    (
        "(gint) GTK_SOURCE_FILE_SAVER_ERROR_EXTERNALLY_MODIFIED",
        "1",
    ),
    ("(gint) GTK_SOURCE_FILE_SAVER_ERROR_INVALID_CHARS", "0"),
    ("(guint) GTK_SOURCE_FILE_SAVER_FLAGS_CREATE_BACKUP", "4"),
    (
        "(guint) GTK_SOURCE_FILE_SAVER_FLAGS_IGNORE_INVALID_CHARS",
        "1",
    ),
    (
        "(guint) GTK_SOURCE_FILE_SAVER_FLAGS_IGNORE_MODIFICATION_TIME",
        "2",
    ),
    ("(guint) GTK_SOURCE_FILE_SAVER_FLAGS_NONE", "0"),
    ("(gint) GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_CELL", "0"),
    (
        "(gint) GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_FIRST",
        "1",
    ),
    ("(gint) GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_LAST", "2"),
    ("(gint) GTK_SOURCE_NEWLINE_TYPE_CR", "1"),
    ("(gint) GTK_SOURCE_NEWLINE_TYPE_CR_LF", "2"),
    ("(gint) GTK_SOURCE_NEWLINE_TYPE_LF", "0"),
    ("(gint) GTK_SOURCE_SMART_HOME_END_AFTER", "2"),
    ("(gint) GTK_SOURCE_SMART_HOME_END_ALWAYS", "3"),
    ("(gint) GTK_SOURCE_SMART_HOME_END_BEFORE", "1"),
    ("(gint) GTK_SOURCE_SMART_HOME_END_DISABLED", "0"),
    ("(guint) GTK_SOURCE_SORT_FLAGS_CASE_SENSITIVE", "1"),
    ("(guint) GTK_SOURCE_SORT_FLAGS_NONE", "0"),
    ("(guint) GTK_SOURCE_SORT_FLAGS_REMOVE_DUPLICATES", "4"),
    ("(guint) GTK_SOURCE_SORT_FLAGS_REVERSE_ORDER", "2"),
    ("(guint) GTK_SOURCE_SPACE_LOCATION_ALL", "7"),
    ("(guint) GTK_SOURCE_SPACE_LOCATION_INSIDE_TEXT", "2"),
    ("(guint) GTK_SOURCE_SPACE_LOCATION_LEADING", "1"),
    ("(guint) GTK_SOURCE_SPACE_LOCATION_NONE", "0"),
    ("(guint) GTK_SOURCE_SPACE_LOCATION_TRAILING", "4"),
    ("(guint) GTK_SOURCE_SPACE_TYPE_ALL", "15"),
    ("(guint) GTK_SOURCE_SPACE_TYPE_NBSP", "8"),
    ("(guint) GTK_SOURCE_SPACE_TYPE_NEWLINE", "4"),
    ("(guint) GTK_SOURCE_SPACE_TYPE_NONE", "0"),
    ("(guint) GTK_SOURCE_SPACE_TYPE_SPACE", "1"),
    ("(guint) GTK_SOURCE_SPACE_TYPE_TAB", "2"),
    ("(gint) GTK_SOURCE_VIEW_GUTTER_POSITION_LINES", "-30"),
    ("(gint) GTK_SOURCE_VIEW_GUTTER_POSITION_MARKS", "-20"),
];
