#!/usr/bin/perl

package eBay::API::XML::Call::GetMessagePreferences::GetMessagePreferencesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMessagePreferencesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMessagePreferences::GetMessagePreferencesRequestType

=head1 DESCRIPTION

Returns a seller's Ask Seller a Question (ASQ) subjects, each in
its own Subject node. If the seller has not customized the ASQ
subjects using SetMessagePreferences, the call will return the
current default values.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMessagePreferences::GetMessagePreferencesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::UserIDType;


my @gaProperties = ( [ 'IncludeASQPreferences', 'xs:boolean', '', '', '' ]
	, [ 'SellerID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setIncludeASQPreferences()

If true, indicates that the ASQ subjects for the
specified user should be returned.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeASQPreferences {
  my $self = shift;
  $self->{'IncludeASQPreferences'} = shift
}

=head2 isIncludeASQPreferences()

#    Returns: 'xs:boolean'

=cut

sub isIncludeASQPreferences {
  my $self = shift;
  return $self->{'IncludeASQPreferences'};
}


=head2 setSellerID()

The ID of the user to retrieve ASQ subjects for. This
value must be specified in the request, but does not
need to be the same user as the user making the
request.

  RequiredInput: Yes
#    Argument: 'ns:UserIDType'

=cut

sub setSellerID {
  my $self = shift;
  $self->{'SellerID'} = shift
}

=head2 getSellerID()

#    Returns: 'ns:UserIDType'

=cut

sub getSellerID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
