/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import javax.crypto.SecretKey;

public class SimpleSecretKey
implements SecretKey {
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final byte[] value;

    public SimpleSecretKey(String algorithm, byte[] value2) {
        this.algorithm = algorithm;
        this.value = value2;
    }

    public static SimpleSecretKey copy(String algorithm, byte[] value2) {
        return SimpleSecretKey.copy(algorithm, value2, 0, value2.length);
    }

    public static SimpleSecretKey copy(String algorithm, byte[] value2, int off, int len) {
        byte[] val = new byte[len];
        System.arraycopy(value2, off, val, 0, len);
        return new SimpleSecretKey(algorithm, val);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        return this.value;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleSecretKey) {
            byte[] ovalue = ((SimpleSecretKey)o).value;
            if (this.value.length != ovalue.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.value.length; ++i2) {
                if (this.value[i2] == ovalue[i2]) continue;
                return false;
            }
            return this.algorithm.equals(((SimpleSecretKey)o).algorithm);
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        for (int i2 = 0; i2 < this.value.length; ++i2) {
            code ^= (this.value[i2] & 0xFF) << (i2 << 3 & 0x1F);
        }
        return code ^ this.algorithm.hashCode();
    }
}

