/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.DestructorAnswer;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class ForwardMessage
extends Message {
    private final int level;

    public ForwardMessage(Lifeline caller, Lifeline callee, SequenceDiagram diagram, MessageData data) {
        super(caller, callee, diagram, data);
        this.level = 0;
    }

    public int getLevel() {
        return this.level;
    }

    public Answer getAnswerMessage() {
        if (this.getCallee().isAlwaysActive() || this.getData().isSpawnMessage()) {
            return null;
        }
        if (this.getCaller().isAlwaysActive() && this.getData().returnsInstantly()) {
            return null;
        }
        if (this.getText().equals("destroy") || this.getText().startsWith("destroy(")) {
            return new DestructorAnswer(this.getCallee(), this.getCaller(), this.getDiagram(), this.getData(), this);
        }
        return new Answer(this.getCallee(), this.getCaller(), this.getDiagram(), this.getData(), this);
    }

    protected final boolean isActivating() {
        return !this.getData().returnsInstantly() || !this.getData().isSpawnMessage() && !this.getCaller().isAlwaysActive();
    }

    @Override
    protected void execute() {
        if (!this.getCallee().isAlwaysActive()) {
            this.extendLifelines(this.getConfiguration().getSpaceBeforeActivation());
        }
        int ih = Arrow.getInnerHeight(this);
        this.getDiagram().getPaintDevice().announce(ih + this.diagram.arrowSize / 2);
        this.extendLifelines(ih);
        if (!this.getCallee().isAlwaysActive() && this.isActivating()) {
            this.getCallee().setActive(true);
        }
        Arrow arrow = this.getCaller().getPosition() < this.getCallee().getPosition() ? new Arrow(this, ArrowStroke.SOLID, Direction.RIGHT, this.v() - ih) : new Arrow(this, ArrowStroke.SOLID, Direction.LEFT, this.v() - ih);
        this.setArrow(arrow);
        this.getDiagram().getPaintDevice().append(arrow);
    }

    @Override
    public String getText() {
        return this.getData().getMessage();
    }
}

