/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server.system;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class Histogram19 {
    private static final String DIAGNOSTIC_COMMAND_MXBEAN_NAME = "com.sun.management:type=DiagnosticCommand";
    private static final String ALL_OBJECTS_OPTION = "-all";
    private static final String HISTOGRAM_COMMAND = "gcClassHistogram";
    private static MBeanServer mserver;
    private static ObjectName hotspotDiag;

    Histogram19() {
    }

    static boolean initialize() {
        boolean initok = false;
        try {
            mserver = ManagementFactory.getPlatformMBeanServer();
            hotspotDiag = new ObjectName(DIAGNOSTIC_COMMAND_MXBEAN_NAME);
            mserver.getObjectInstance(hotspotDiag);
            initok = true;
        }
        catch (MalformedObjectNameException ex) {
            ex.printStackTrace();
        }
        catch (InstanceNotFoundException ex) {
            System.err.println("Heap Histogram is not available");
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        return initok;
    }

    static InputStream getRawHistogram() {
        try {
            Object histo = mserver.invoke(hotspotDiag, HISTOGRAM_COMMAND, new Object[]{new String[]{ALL_OBJECTS_OPTION}}, new String[]{String[].class.getName()});
            if (histo instanceof String) {
                return new ByteArrayInputStream(((String)histo).getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (InstanceNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MBeanException ex) {
            ex.printStackTrace();
        }
        catch (ReflectionException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

