/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbCollections;
import org.openide.util.io.NbMarshalledObject;

public class Repository
implements Serializable {
    private static Repository repository;
    static final long serialVersionUID = -6344768369160069704L;
    private ArrayList<FileSystem> fileSystems;
    private transient List<FileSystem> fileSystemsClone = Collections.emptyList();
    private FileSystem system;
    private Hashtable<String, FileSystem> names;
    private transient FCLSupport fclSupport;
    private Hashtable<RepositoryListener, RepositoryListener> listeners = new Hashtable();
    private VetoableChangeListener vetoListener = new VetoableChangeListener(){

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (Repository.this.names.get(string2) != null) {
                    throw new PropertyVetoException("system name already exists: " + string + " -> " + string2, propertyChangeEvent);
                }
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                FileSystem fileSystem = (FileSystem)propertyChangeEvent.getSource();
                if (fileSystem.isValid()) {
                    Repository.this.names.remove(string);
                }
                Repository.this.names.put(string2, fileSystem);
                fileSystem.setValid(true);
            }
        }
    };
    private static Reference<Lookup> lastDefLookup;
    private static LocalProvider lastLocalProvider;
    private static final LocalProvider NO_PROVIDER;
    private static final ThreadLocal<FileSystem[]> ADD_FS;

    protected void refreshAdditionalLayers() {
        if (this.getDefaultFileSystem() instanceof MainFS) {
            ((MainFS)this.getDefaultFileSystem()).refreshLayers();
        }
    }

    protected final List<? extends URL> findLayers(LayerProvider layerProvider) {
        if (this != Repository.getDefault()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        layerProvider.registerLayers(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void provideLayers(ClassLoader classLoader, List<URL> list) throws IOException {
        Object object;
        if (classLoader == null) {
            classLoader = Repository.class.getClassLoader();
        }
        for (Object object2 : NbCollections.iterable(classLoader.getResources("META-INF/MANIFEST.MF"))) {
            object = ((URL)object2).openStream();
            try {
                Manifest manifest = new Manifest((InputStream)object);
                String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Layer");
                if (string == null) continue;
                URL uRL = classLoader.getResource(string);
                if (uRL != null) {
                    list.add(uRL);
                    continue;
                }
                FileSystem.LOG.warning("No such layer: " + string);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        for (Object object2 : NbCollections.iterable(classLoader.getResources("META-INF/generated-layer.xml"))) {
            list.add((URL)object2);
        }
        for (Object object2 : Lookup.getDefault().lookupAll(LayerProvider.class)) {
            object = new ArrayList();
            ((LayerProvider)object2).registerLayers((Collection<? super URL>)object);
            list.addAll((Collection<URL>)object);
        }
    }

    public Repository(FileSystem fileSystem) {
        this.system = fileSystem;
        this.init();
    }

    private void init() {
        this.fileSystems = new ArrayList();
        this.names = new Hashtable();
        if (Repository.addFileSystemDelayed(this.system)) {
            this.addFileSystem(this.system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Repository getDefault() {
        final Lookup lookup = Lookup.getDefault();
        Object object = Repository.class;
        synchronized (Repository.class) {
            if (repository != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return repository;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                object = Repository.delayFileSystemAttachImpl(new Callable<Repository>(){

                    @Override
                    public Repository call() throws Exception {
                        Repository repository = (Repository)lookup.lookup(Repository.class);
                        if (repository == null) {
                            repository = new Repository(new MainFS());
                        }
                        return repository;
                    }
                });
                Class<Repository> clazz = Repository.class;
                synchronized (Repository.class) {
                    if (repository == null) {
                        repository = object;
                    }
                    // ** MonitorExit[var2_4] (shouldn't be in output)
                    return repository;
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Repository getLocalRepository() {
        Lookup lookup = Lookup.getDefault();
        LocalProvider localProvider = null;
        Object object = Repository.class;
        synchronized (Repository.class) {
            Reference<Lookup> reference = lastDefLookup;
            Object object2 = reference.get();
            if (lookup == object2) {
                localProvider = lastLocalProvider;
            }
            LocalProvider localProvider2 = localProvider;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (localProvider == null && (localProvider2 = (LocalProvider)lookup.lookup(LocalProvider.class)) == null) {
                localProvider2 = NO_PROVIDER;
            }
            object = null;
            try {
                object = localProvider2.getRepository();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
            if (localProvider != null) return object;
            object2 = Repository.class;
            synchronized (Repository.class) {
                if (lastDefLookup != reference) return object;
                lastLocalProvider = localProvider2;
                lastDefLookup = new WeakReference<Lookup>(lookup);
                // ** MonitorExit[var5_4 /* !! */ ] (shouldn't be in output)
                return object;
            }
        }
    }

    static synchronized void reset() {
        repository = null;
        lastLocalProvider = null;
        lastDefLookup = new WeakReference<Object>(null);
    }

    private static boolean addFileSystemDelayed(FileSystem fileSystem) {
        FileSystem[] fileSystemArray = ADD_FS.get();
        if (fileSystemArray != null) {
            assert (fileSystemArray[0] == null);
            fileSystemArray[0] = fileSystem;
            return false;
        }
        return true;
    }

    private boolean addFileSystemImpl(FileSystem fileSystem) {
        Thread.holdsLock(this);
        if (!fileSystem.assigned && !this.fileSystems.contains(fileSystem)) {
            boolean bl;
            fileSystem.setRepository(this);
            this.fileSystems.add(fileSystem);
            this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
            String string = fileSystem.getSystemName();
            boolean bl2 = bl = this.names.get(string) == null;
            if (bl && !string.equals("")) {
                this.names.put(string, fileSystem);
                fileSystem.setValid(true);
            } else {
                fileSystem.setValid(false);
            }
            fileSystem.assigned = true;
            fileSystem.addPropertyChangeListener(this.propListener);
            fileSystem.addVetoableChangeListener(this.vetoListener);
            fileSystem.addNotify();
            return true;
        }
        return false;
    }

    @Deprecated
    public final FileSystem getDefaultFileSystem() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void addFileSystem(FileSystem fileSystem) {
        boolean bl;
        Repository repository = this;
        synchronized (repository) {
            bl = this.addFileSystemImpl(fileSystem);
        }
        if (bl) {
            this.fireFileSystem(fileSystem, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void removeFileSystem(FileSystem fileSystem) {
        boolean bl = false;
        Repository repository = this;
        synchronized (repository) {
            if (fileSystem.isDefault()) {
                return;
            }
            bl = this.fileSystems.remove(fileSystem);
            if (bl) {
                fileSystem.setRepository(null);
                this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
                if (fileSystem.isValid()) {
                    this.names.remove(fileSystem.getSystemName());
                    fileSystem.setValid(false);
                }
                fileSystem.removePropertyChangeListener(this.propListener);
                fileSystem.removeVetoableChangeListener(this.vetoListener);
                fileSystem.removeNotify();
            }
            fileSystem.assigned = false;
        }
        if (bl) {
            this.fireFileSystem(fileSystem, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void reorder(int[] nArray) {
        Repository repository = this;
        synchronized (repository) {
            if (nArray == null) {
                throw new IllegalArgumentException("null permutation");
            }
            if (nArray.length != this.fileSystems.size()) {
                throw new IllegalArgumentException("permutation is wrong size: " + nArray.length + " elements but should be " + this.fileSystems.size());
            }
            if (!Repository.isPermutation(nArray)) {
                StringBuffer stringBuffer = new StringBuffer("permutation is not really a permutation:");
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(nArray[i]);
                }
                throw new IllegalArgumentException(stringBuffer.toString());
            }
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(this.fileSystems.size());
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.fileSystems.get(nArray[i]));
            }
            this.fileSystems = arrayList;
            this.fileSystemsClone = new ArrayList<FileSystem>(this.fileSystems);
        }
        this.fireFileSystemReordered(nArray);
    }

    private static boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        try {
            for (int i = 0; i < n; ++i) {
                if (blArray[nArray[i]]) {
                    return false;
                }
                blArray[nArray[i]] = true;
            }
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> getFileSystems() {
        return Collections.enumeration(this.fileSystemsClone);
    }

    @Deprecated
    public final Enumeration<? extends FileSystem> fileSystems() {
        return this.getFileSystems();
    }

    @Deprecated
    public final FileSystem[] toArray() {
        List<FileSystem> list = this.fileSystemsClone;
        FileSystem[] fileSystemArray = new FileSystem[list.size()];
        list.toArray(fileSystemArray);
        return fileSystemArray;
    }

    @Deprecated
    public final FileSystem findFileSystem(String string) {
        FileSystem fileSystem = this.names.get(string);
        return fileSystem;
    }

    @Deprecated
    public final synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        for (FileSystem fileSystem : this.fileSystems) {
            if (fileSystem.isDefault()) continue;
            objectOutput.writeObject(new NbMarshalledObject((Object)fileSystem));
        }
        objectOutput.writeObject(null);
    }

    @Deprecated
    public final synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FileSystem fileSystem;
        Enumeration<? extends FileSystem> enumeration;
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(10);
        while ((enumeration = objectInput.readObject()) != null) {
            if (enumeration instanceof FileSystem) {
                fileSystem = (FileSystem)((Object)enumeration);
            } else {
                try {
                    NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)enumeration;
                    fileSystem = (FileSystem)nbMarshalledObject.get();
                }
                catch (IOException iOException) {
                    ExternalUtil.exception(iOException);
                    fileSystem = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.exception(classNotFoundException);
                    fileSystem = null;
                }
            }
            if (fileSystem == null) continue;
            arrayList.add(fileSystem);
        }
        enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            fileSystem = enumeration.nextElement();
            if (fileSystem.isDefault()) continue;
            this.removeFileSystem(fileSystem);
        }
        this.system.assigned = false;
        this.init();
        for (FileSystem fileSystem2 : arrayList) {
            this.addFileSystem(fileSystem2);
        }
    }

    @Deprecated
    public final FileObject find(String string, String string2, String string3) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    @Deprecated
    public final FileObject findResource(String string) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAllResources(String string) {
        assert (false) : "Deprecated.";
        Vector<FileObject> vector = new Vector<FileObject>(8);
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    @Deprecated
    public final Enumeration<? extends FileObject> findAll(String string, String string2, String string3) {
        assert (false) : "Deprecated.";
        Enumeration<? extends FileSystem> enumeration = this.getFileSystems();
        Vector<FileObject> vector = new Vector<FileObject>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    private void fireFileSystem(FileSystem fileSystem, boolean bl) {
        RepositoryEvent repositoryEvent = new RepositoryEvent(this, fileSystem, bl);
        for (RepositoryListener repositoryListener : new HashSet<RepositoryListener>(this.listeners.values())) {
            if (bl) {
                repositoryListener.fileSystemAdded(repositoryEvent);
                continue;
            }
            repositoryListener.fileSystemRemoved(repositoryEvent);
        }
    }

    private void fireFileSystemReordered(int[] nArray) {
        RepositoryReorderedEvent repositoryReorderedEvent = new RepositoryReorderedEvent(this, nArray);
        for (RepositoryListener repositoryListener : new HashSet<RepositoryListener>(this.listeners.values())) {
            repositoryListener.fileSystemPoolReordered(repositoryReorderedEvent);
        }
    }

    @Deprecated
    public final void addRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.put(repositoryListener, repositoryListener);
    }

    @Deprecated
    public final void removeRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.remove(repositoryListener);
    }

    private Object writeReplace() {
        return new Replacer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class<FCLSupport> clazz = FCLSupport.class;
        synchronized (FCLSupport.class) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fclSupport;
        }
    }

    @Deprecated
    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().addFileChangeListener(fileChangeListener);
    }

    @Deprecated
    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().removeFileChangeListener(fileChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Repository delayFileSystemAttachImpl(Callable<Repository> callable) throws IOException {
        FileSystem[] fileSystemArray = ADD_FS.get();
        try {
            FileSystem[] fileSystemArray2 = new FileSystem[1];
            ADD_FS.set(fileSystemArray2);
            Repository repository = callable.call();
            if (repository == null) {
                Repository repository2 = null;
                return repository2;
            }
            Repository repository3 = repository;
            synchronized (repository3) {
                if (fileSystemArray2[0] instanceof FileSystem) {
                    repository.addFileSystemImpl(fileSystemArray2[0]);
                }
            }
            repository3 = repository;
            return repository3;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            ADD_FS.set(fileSystemArray);
        }
    }

    static {
        lastDefLookup = new WeakReference<Object>(null);
        lastLocalProvider = null;
        NO_PROVIDER = new LocalProvider(){

            @Override
            public Repository getRepository() throws IOException {
                return Repository.getDefault();
            }
        };
        ADD_FS = new ThreadLocal();
    }

    public static abstract class LocalProvider {
        public abstract Repository getRepository() throws IOException;

        protected final Repository delayFilesystemAttach(Callable<Repository> callable) throws IOException {
            return Repository.delayFileSystemAttachImpl(callable);
        }
    }

    private static class Replacer
    implements Serializable {
        static final long serialVersionUID = -3814531276726840241L;

        Replacer() {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Repository.getDefault().writeExternal(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Repository.getDefault().readExternal(objectInputStream);
        }

        public Object readResolve() {
            return Repository.getDefault();
        }
    }

    private static final class MainFS
    extends MultiFileSystem
    implements LookupListener {
        private static final Lookup.Result<FileSystem> ALL = Lookup.getDefault().lookupResult(FileSystem.class);
        private static final FileSystem MEMORY = FileUtil.createMemoryFileSystem();
        private static final XMLFileSystem layers = new XMLFileSystem();

        public MainFS() {
            ALL.addLookupListener((LookupListener)this);
            this.refreshLayers();
        }

        final void refreshLayers() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            try {
                Repository.provideLayers(Thread.currentThread().getContextClassLoader(), arrayList);
                layers.setXmlUrls(arrayList.toArray(new URL[0]));
                LOG.log(Level.FINE, "Loading classpath layers: {0}", arrayList);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Setting layer URLs: " + arrayList, exception);
            }
            this.resultChanged(null);
        }

        private static FileSystem[] computeDelegates() {
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
            arrayList.add(MEMORY);
            for (FileSystem fileSystem : ALL.allInstances()) {
                if (Boolean.TRUE.equals(fileSystem.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(fileSystem);
            }
            arrayList.add(layers);
            for (FileSystem fileSystem : ALL.allInstances()) {
                if (!Boolean.TRUE.equals(fileSystem.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(fileSystem);
            }
            return arrayList.toArray(new FileSystem[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            Class<Repository> clazz = Repository.class;
            synchronized (Repository.class) {
                this.setDelegates(MainFS.computeDelegates());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static abstract class LayerProvider {
        protected abstract void registerLayers(Collection<? super URL> var1);

        protected final void refresh() {
            Repository.getDefault().refreshAdditionalLayers();
        }
    }
}

