---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# GitLab CLI - `glab`

![GLab](../assets/glab-logo.png)

GLab is an open source GitLab CLI tool. It brings GitLab to your terminal, next to where you are already working with `git` and your code, without switching between windows and browser tabs. While it's powerful for issues and merge requests, `glab` does even more:

- View, manage, and retry CI/CD pipelines directly from your CLI.
- Create changelogs.
- Create and manage releases.
- Ask GitLab Duo Chat questions about Git.
- Manage GitLab agents for Kubernetes.

`glab` is available for repositories hosted on GitLab.com, GitLab Dedicated, and GitLab Self-Managed. It supports multiple authenticated GitLab instances, and automatically detects the authenticated hostname from the remotes available in your working Git directory.

![command example](../assets/glabgettingstarted.gif)

## Install the CLI

Installation instructions are available in the GLab
[`README`](https://gitlab.com/gitlab-org/cli/#installation).

## Authenticate with GitLab

GLab supports multiple authentication methods including OAuth and personal access tokens.
To get started, run `glab auth login` and follow the interactive setup.

For detailed authentication instructions, see the [Authentication section](https://gitlab.com/gitlab-org/cli#authentication)
in the main README.

## Environment Variables

<!-- markdownlint-disable MD044 MD034 -->
| Variable | Description |
|----------|-------------|
| `BROWSER` | The web browser to use for opening links. Can be set in the config with 'glab config set browser mybrowser'. |
| `DEBUG` | Set to true to output more logging information, including underlying Git commands, expanded aliases and DNS error details. |
| `FORCE_HYPERLINKS` | Set to true to force hyperlinks in output, even when not outputting to a TTY. |
| `GITLAB_CLIENT_ID` | Provide custom 'client_id' generated by GitLab OAuth 2.0 application. Defaults to the 'client-id' for GitLab.com. |
| `GITLAB_HOST or GL_HOST` | If GitLab Self-Managed or GitLab Dedicated, specify the URL of the GitLab server. (Example: https://gitlab.example.com) Defaults to https://gitlab.com. |
| `GITLAB_TOKEN` | An authentication token for API requests. Set this variable to avoid prompts to authenticate. Overrides any previously-stored credentials. Can be set in the config with 'glab config set token xxxxxx'. |
| `GLAB_CHECK_UPDATE` | Set to true to force an update check. By default the cli tool checks for updates once a day. |
| `GLAB_CONFIG_DIR` | Set to a directory path to override the global configuration location. |
| `GLAB_DEBUG_HTTP` | Set to true to output HTTP transport information (request / response). |
| `GLAB_SEND_TELEMETRY` | Set to false to disable telemetry being sent to your GitLab instance. Can be set in the config with 'glab config set telemetry false'. See https://docs.gitlab.com/administration/settings/usage_statistics/ for more information |
| `GLAMOUR_STYLE` | The environment variable to set your desired Markdown renderer style. Available options: dark, light, notty. To set a custom style, read https://github.com/charmbracelet/glamour#styles |
| `NO_COLOR` | Set to any value to avoid printing ANSI escape sequences for color output. |
| `NO_PROMPT` | Set to true to disable prompts. |
| `REMOTE_ALIAS or GIT_REMOTE_URL_VAR` | A 'git remote' variable or alias that contains the GitLab URL. Can be set in the config with 'glab config set remote_alias origin'. |
| `VISUAL, EDITOR (in order of precedence)` | The editor tool to use for authoring text. Can be set in the config with 'glab config set editor vim'. |
<!-- markdownlint-enable MD044 MD034 -->

## Options

```plaintext
  -h, --help      Show help for this command.
  -v, --version   show glab version information
```

## Commands

- [`glab alias`](alias/index.md)
- [`glab api`](api/index.md)
- [`glab auth`](auth/index.md)
- [`glab changelog`](changelog/index.md)
- [`glab check-update`](check-update/index.md)
- [`glab ci`](ci/index.md)
- [`glab cluster`](cluster/index.md)
- [`glab completion`](completion/index.md)
- [`glab config`](config/index.md)
- [`glab deploy-key`](deploy-key/index.md)
- [`glab duo`](duo/index.md)
- [`glab incident`](incident/index.md)
- [`glab issue`](issue/index.md)
- [`glab iteration`](iteration/index.md)
- [`glab job`](job/index.md)
- [`glab label`](label/index.md)
- [`glab mcp`](mcp/index.md)
- [`glab mr`](mr/index.md)
- [`glab opentofu`](opentofu/index.md)
- [`glab release`](release/index.md)
- [`glab repo`](repo/index.md)
- [`glab schedule`](schedule/index.md)
- [`glab securefile`](securefile/index.md)
- [`glab snippet`](snippet/index.md)
- [`glab ssh-key`](ssh-key/index.md)
- [`glab stack`](stack/index.md)
- [`glab token`](token/index.md)
- [`glab user`](user/index.md)
- [`glab variable`](variable/index.md)
- [`glab version`](version/index.md)

## Report issues

Open an issue in the [`gitlab-org/cli` repository](https://gitlab.com/gitlab-org/cli/issues/new)
to send us feedback.
