/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.transaction.DummyTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCache210Wrapper
implements CacheWrapper {
    private Cache cache;
    private Log log = LogFactory.getLog(JBossCache210Wrapper.class);
    private boolean inLocalMode;

    @Override
    public void init(Map parameters) throws Exception {
        this.log.info((Object)("Creating cache with the following configuration: " + parameters));
        this.cache = DefaultCacheFactory.getInstance().createCache((String)parameters.get("config"));
        this.log.info((Object)("Running cache with following config: " + this.cache.getConfiguration()));
        this.log.info((Object)"Running follwing JBossCacheVersion: 2.1.1.GA");
        this.log.info((Object)"Running follwing JBossCacheCodeName: Alegrias");
        this.inLocalMode = parameters.containsKey("localOnly");
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    @Override
    public void put(List<String> path, Object key, Object value) throws Exception {
        this.cache.put(new Fqn(path, true), key, value);
    }

    @Override
    public Object get(List<String> path, Object key) throws Exception {
        return this.cache.get(new Fqn(path, true), key);
    }

    @Override
    public void empty() throws Exception {
        this.cache.removeNode(new Fqn(new Object[]{"test"}));
    }

    @Override
    public int getNumMembers() {
        return this.inLocalMode ? 0 : this.cache.getMembers().size();
    }

    @Override
    public String getInfo() {
        return "Num direct children: " + this.cache.getRoot().getChildren().size();
    }

    @Override
    public Object getReplicatedData(List<String> path, String key) throws Exception {
        CacheSPI cacheSpi = (CacheSPI)this.cache;
        GravitateResult result = cacheSpi.gravitateData(new Fqn(path, true), true);
        if (!result.isDataFound()) {
            return this.get(path, key);
        }
        NodeData nodeData = (NodeData)result.getNodeData().get(0);
        return nodeData.getAttributes().get(key);
    }

    public Transaction startTransaction() {
        try {
            DummyTransactionManager.getInstance().begin();
            return DummyTransactionManager.getInstance().getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endTransaction(boolean successful) {
        try {
            if (successful) {
                DummyTransactionManager.getInstance().commit();
            } else {
                DummyTransactionManager.getInstance().rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

