/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.cachebench.config.ClusterConfig;
import org.cachebench.reportgenerators.ReportGenerator;
import org.cachebench.tests.results.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportGenerator
implements ReportGenerator {
    protected File output;
    protected List<TestResult> results;
    protected Log log;
    protected ClusterConfig clusterConfig;
    protected Map<String, String> params;

    @Override
    public void setConfigParams(Map<String, String> params) {
        this.params = params;
    }

    @Override
    public void setOutputFile(String fileName) {
        this.output = new File(this.getFileName(fileName));
    }

    private String getFileName(String fileName) {
        if (fileName.indexOf("-generic-") >= 0) {
            return "data_" + this.params.get("cacheProductName") + "_" + this.params.get("config") + "_" + this.params.get("clusterSize") + ".csv";
        }
        this.log.info((Object)("Filename for report generation is: " + fileName));
        return fileName;
    }

    @Override
    public void setResults(List<TestResult> results) {
        this.results = new ArrayList<TestResult>(results);
    }

    @Override
    public void setClusterConfig(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }
}

