/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators.reportcentralizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class ReportData
implements Comparable {
    private String distribution;
    private String configuration;
    private int clusterSize;
    private long avgReqPerSec;

    public ReportData() {
    }

    public ReportData(File reportFile) throws Exception {
        this.readData(reportFile);
    }

    private void readData(File f) throws IOException {
        this.processFileName(f.getName());
        String line = null;
        BufferedReader br = new BufferedReader(new FileReader(f));
        int goodlinesCount = 0;
        while ((line = br.readLine()) != null) {
            double throughput = this.getThroughput(line);
            if (throughput == -1.0) continue;
            this.avgReqPerSec = (long)((double)this.avgReqPerSec + throughput);
            ++goodlinesCount;
        }
        if (goodlinesCount < this.clusterSize) {
            throw new IllegalStateException("Number of line is not good for file: " + f.getName());
        }
        this.avgReqPerSec /= (long)this.clusterSize;
    }

    private double getThroughput(String line) {
        StringTokenizer strTokenizer = new StringTokenizer(line, ",");
        if (strTokenizer.countTokens() < 2) {
            return -1.0;
        }
        strTokenizer.nextToken();
        strTokenizer.nextToken();
        String candidate = strTokenizer.nextToken();
        try {
            return Double.parseDouble(candidate);
        }
        catch (NumberFormatException nfe) {
            return -1.0;
        }
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public long getAvgReqPerSec() {
        return this.avgReqPerSec;
    }

    public void processFileName(String name) {
        StringTokenizer strtok = new StringTokenizer(name, "_");
        strtok.nextToken();
        this.distribution = strtok.nextToken();
        this.configuration = strtok.nextToken();
        String cS = strtok.nextToken();
        if (cS.toUpperCase().endsWith(".CSV")) {
            cS = cS.substring(0, cS.length() - 4);
        }
        this.clusterSize = Integer.parseInt(cS);
    }

    public int compareTo(Object o) {
        ReportData other = (ReportData)o;
        return this.clusterSize - other.getClusterSize();
    }
}

