// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/persistent_resource_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PERSISTENT_RESOURCE_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PERSISTENT_RESOURCE_CONNECTION_IMPL_H

#include "google/cloud/aiplatform/v1/internal/persistent_resource_retry_traits.h"
#include "google/cloud/aiplatform/v1/internal/persistent_resource_stub.h"
#include "google/cloud/aiplatform/v1/persistent_resource_connection.h"
#include "google/cloud/aiplatform/v1/persistent_resource_connection_idempotency_policy.h"
#include "google/cloud/aiplatform/v1/persistent_resource_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class PersistentResourceServiceConnectionImpl
    : public aiplatform_v1::PersistentResourceServiceConnection {
 public:
  ~PersistentResourceServiceConnectionImpl() override = default;

  PersistentResourceServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<aiplatform_v1_internal::PersistentResourceServiceStub>
          stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
  CreatePersistentResource(
      google::cloud::aiplatform::v1::CreatePersistentResourceRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreatePersistentResource(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreatePersistentResourceRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
  CreatePersistentResource(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::PersistentResource>
  GetPersistentResource(
      google::cloud::aiplatform::v1::GetPersistentResourceRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::PersistentResource>
  ListPersistentResources(
      google::cloud::aiplatform::v1::ListPersistentResourcesRequest request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeletePersistentResource(
      google::cloud::aiplatform::v1::DeletePersistentResourceRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeletePersistentResource(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeletePersistentResourceRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeletePersistentResource(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
  UpdatePersistentResource(
      google::cloud::aiplatform::v1::UpdatePersistentResourceRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdatePersistentResource(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdatePersistentResourceRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
  UpdatePersistentResource(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
  RebootPersistentResource(
      google::cloud::aiplatform::v1::RebootPersistentResourceRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> RebootPersistentResource(
      NoAwaitTag,
      google::cloud::aiplatform::v1::RebootPersistentResourceRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::PersistentResource>>
  RebootPersistentResource(
      google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<aiplatform_v1_internal::PersistentResourceServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_PERSISTENT_RESOURCE_CONNECTION_IMPL_H
