// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/tensorboard_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_TENSORBOARD_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_TENSORBOARD_CONNECTION_IMPL_H

#include "google/cloud/aiplatform/v1/internal/tensorboard_retry_traits.h"
#include "google/cloud/aiplatform/v1/internal/tensorboard_stub.h"
#include "google/cloud/aiplatform/v1/tensorboard_connection.h"
#include "google/cloud/aiplatform/v1/tensorboard_connection_idempotency_policy.h"
#include "google/cloud/aiplatform/v1/tensorboard_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

void TensorboardServiceReadTensorboardBlobDataStreamingUpdater(
    google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse const&
        response,
    google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest& request);

class TensorboardServiceConnectionImpl
    : public aiplatform_v1::TensorboardServiceConnection {
 public:
  ~TensorboardServiceConnectionImpl() override = default;

  TensorboardServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<aiplatform_v1_internal::TensorboardServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  CreateTensorboard(
      google::cloud::aiplatform::v1::CreateTensorboardRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateTensorboard(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateTensorboardRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  CreateTensorboard(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Tensorboard> GetTensorboard(
      google::cloud::aiplatform::v1::GetTensorboardRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  UpdateTensorboard(
      google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateTensorboard(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  UpdateTensorboard(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::aiplatform::v1::Tensorboard> ListTensorboards(
      google::cloud::aiplatform::v1::ListTensorboardsRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboard(
      google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteTensorboard(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboard(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
  ReadTensorboardUsage(
      google::cloud::aiplatform::v1::ReadTensorboardUsageRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
  ReadTensorboardSize(
      google::cloud::aiplatform::v1::ReadTensorboardSizeRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  CreateTensorboardExperiment(
      google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  GetTensorboardExperiment(
      google::cloud::aiplatform::v1::GetTensorboardExperimentRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  UpdateTensorboardExperiment(
      google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::TensorboardExperiment>
  ListTensorboardExperiments(
      google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardExperiment(
      google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteTensorboardExperiment(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardExperiment(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> CreateTensorboardRun(
      google::cloud::aiplatform::v1::CreateTensorboardRunRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
  BatchCreateTensorboardRuns(
      google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> GetTensorboardRun(
      google::cloud::aiplatform::v1::GetTensorboardRunRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> UpdateTensorboardRun(
      google::cloud::aiplatform::v1::UpdateTensorboardRunRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::TensorboardRun>
  ListTensorboardRuns(google::cloud::aiplatform::v1::ListTensorboardRunsRequest
                          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardRun(
      google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteTensorboardRun(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardRun(
      google::longrunning::Operation const& operation) override;

  StatusOr<
      google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
  BatchCreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::
          BatchCreateTensorboardTimeSeriesRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  CreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  GetTensorboardTimeSeries(
      google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  UpdateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  ListTensorboardTimeSeries(
      google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardTimeSeries(
      google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteTensorboardTimeSeries(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
          request) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardTimeSeries(
      google::longrunning::Operation const& operation) override;

  StatusOr<
      google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
  BatchReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::
          BatchReadTensorboardTimeSeriesDataRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
  ReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>
  ReadTensorboardBlobData(
      google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest const&
          request) override;

  StatusOr<
      google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
  WriteTensorboardExperimentData(
      google::cloud::aiplatform::v1::
          WriteTensorboardExperimentDataRequest const& request) override;

  StatusOr<google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
  WriteTensorboardRunData(
      google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest const&
          request) override;

  StreamRange<google::cloud::aiplatform::v1::TimeSeriesDataPoint>
  ExportTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest
          request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<aiplatform_v1_internal::TensorboardServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_TENSORBOARD_CONNECTION_IMPL_H
