// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/batch/v1/batch.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BATCH_V1_INTERNAL_BATCH_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BATCH_V1_INTERNAL_BATCH_TRACING_CONNECTION_H

#include "google/cloud/batch/v1/batch_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace batch_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class BatchServiceTracingConnection : public batch_v1::BatchServiceConnection {
 public:
  ~BatchServiceTracingConnection() override = default;

  explicit BatchServiceTracingConnection(
      std::shared_ptr<batch_v1::BatchServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::batch::v1::Job> CreateJob(
      google::cloud::batch::v1::CreateJobRequest const& request) override;

  StatusOr<google::cloud::batch::v1::Job> GetJob(
      google::cloud::batch::v1::GetJobRequest const& request) override;

  future<StatusOr<google::cloud::batch::v1::OperationMetadata>> DeleteJob(
      google::cloud::batch::v1::DeleteJobRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteJob(
      NoAwaitTag,
      google::cloud::batch::v1::DeleteJobRequest const& request) override;

  future<StatusOr<google::cloud::batch::v1::OperationMetadata>> DeleteJob(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::batch::v1::Job> ListJobs(
      google::cloud::batch::v1::ListJobsRequest request) override;

  StatusOr<google::cloud::batch::v1::Task> GetTask(
      google::cloud::batch::v1::GetTaskRequest const& request) override;

  StreamRange<google::cloud::batch::v1::Task> ListTasks(
      google::cloud::batch::v1::ListTasksRequest request) override;

 private:
  std::shared_ptr<batch_v1::BatchServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<batch_v1::BatchServiceConnection>
MakeBatchServiceTracingConnection(
    std::shared_ptr<batch_v1::BatchServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace batch_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BATCH_V1_INTERNAL_BATCH_TRACING_CONNECTION_H
