// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appconnectors/v1/app_connectors_service.proto

#include "google/cloud/beyondcorp/appconnectors/v1/internal/app_connectors_option_defaults.h"
#include "google/cloud/beyondcorp/appconnectors/v1/app_connectors_connection.h"
#include "google/cloud/beyondcorp/appconnectors/v1/app_connectors_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace beyondcorp_appconnectors_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options AppConnectorsServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_APP_CONNECTORS_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_APP_CONNECTORS_SERVICE_AUTHORITY",
      "beyondcorp.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<beyondcorp_appconnectors_v1::
                       AppConnectorsServiceRetryPolicyOption>()) {
    options.set<
        beyondcorp_appconnectors_v1::AppConnectorsServiceRetryPolicyOption>(
        beyondcorp_appconnectors_v1::AppConnectorsServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<beyondcorp_appconnectors_v1::
                       AppConnectorsServiceBackoffPolicyOption>()) {
    options.set<
        beyondcorp_appconnectors_v1::AppConnectorsServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<beyondcorp_appconnectors_v1::
                       AppConnectorsServicePollingPolicyOption>()) {
    options.set<
        beyondcorp_appconnectors_v1::AppConnectorsServicePollingPolicyOption>(
        GenericPollingPolicy<beyondcorp_appconnectors_v1::
                                 AppConnectorsServiceRetryPolicyOption::Type,
                             beyondcorp_appconnectors_v1::
                                 AppConnectorsServiceBackoffPolicyOption::Type>(
            options
                .get<beyondcorp_appconnectors_v1::
                         AppConnectorsServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<beyondcorp_appconnectors_v1::
                    AppConnectorsServiceConnectionIdempotencyPolicyOption>()) {
    options.set<beyondcorp_appconnectors_v1::
                    AppConnectorsServiceConnectionIdempotencyPolicyOption>(
        beyondcorp_appconnectors_v1::
            MakeDefaultAppConnectorsServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appconnectors_v1_internal
}  // namespace cloud
}  // namespace google
