// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appconnectors/v1/app_connectors_service.proto

#include "google/cloud/beyondcorp/appconnectors/v1/internal/app_connectors_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace beyondcorp_appconnectors_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AppConnectorsServiceTracingConnection::AppConnectorsServiceTracingConnection(
    std::shared_ptr<beyondcorp_appconnectors_v1::AppConnectorsServiceConnection>
        child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::beyondcorp::appconnectors::v1::AppConnector>
AppConnectorsServiceTracingConnection::ListAppConnectors(
    google::cloud::beyondcorp::appconnectors::v1::ListAppConnectorsRequest
        request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "ListAppConnectors");
  internal::OTelScope scope(span);
  auto sr = child_->ListAppConnectors(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::beyondcorp::appconnectors::v1::AppConnector>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>
AppConnectorsServiceTracingConnection::GetAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::GetAppConnectorRequest const&
        request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "GetAppConnector");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAppConnector(request));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>>
AppConnectorsServiceTracingConnection::CreateAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::
        CreateAppConnectorRequest const& request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "CreateAppConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateAppConnector(request));
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceTracingConnection::CreateAppConnector(
    NoAwaitTag, google::cloud::beyondcorp::appconnectors::v1::
                    CreateAppConnectorRequest const& request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "CreateAppConnector");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateAppConnector(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>>
AppConnectorsServiceTracingConnection::CreateAppConnector(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "CreateAppConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateAppConnector(operation));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>>
AppConnectorsServiceTracingConnection::UpdateAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::
        UpdateAppConnectorRequest const& request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "UpdateAppConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateAppConnector(request));
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceTracingConnection::UpdateAppConnector(
    NoAwaitTag, google::cloud::beyondcorp::appconnectors::v1::
                    UpdateAppConnectorRequest const& request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "UpdateAppConnector");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateAppConnector(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>>
AppConnectorsServiceTracingConnection::UpdateAppConnector(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "UpdateAppConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateAppConnector(operation));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::
                    AppConnectorOperationMetadata>>
AppConnectorsServiceTracingConnection::DeleteAppConnector(
    google::cloud::beyondcorp::appconnectors::v1::
        DeleteAppConnectorRequest const& request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "DeleteAppConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteAppConnector(request));
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceTracingConnection::DeleteAppConnector(
    NoAwaitTag, google::cloud::beyondcorp::appconnectors::v1::
                    DeleteAppConnectorRequest const& request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "DeleteAppConnector");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteAppConnector(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::
                    AppConnectorOperationMetadata>>
AppConnectorsServiceTracingConnection::DeleteAppConnector(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "DeleteAppConnector");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteAppConnector(operation));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>>
AppConnectorsServiceTracingConnection::ReportStatus(
    google::cloud::beyondcorp::appconnectors::v1::ReportStatusRequest const&
        request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "ReportStatus");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ReportStatus(request));
}

StatusOr<google::longrunning::Operation>
AppConnectorsServiceTracingConnection::ReportStatus(
    NoAwaitTag,
    google::cloud::beyondcorp::appconnectors::v1::ReportStatusRequest const&
        request) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "ReportStatus");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ReportStatus(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::beyondcorp::appconnectors::v1::AppConnector>>
AppConnectorsServiceTracingConnection::ReportStatus(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "beyondcorp_appconnectors_v1::AppConnectorsServiceConnection::"
      "ReportStatus");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ReportStatus(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<beyondcorp_appconnectors_v1::AppConnectorsServiceConnection>
MakeAppConnectorsServiceTracingConnection(
    std::shared_ptr<beyondcorp_appconnectors_v1::AppConnectorsServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<AppConnectorsServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appconnectors_v1_internal
}  // namespace cloud
}  // namespace google
