// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v2/repositories.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V2_INTERNAL_REPOSITORY_MANAGER_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V2_INTERNAL_REPOSITORY_MANAGER_CONNECTION_IMPL_H

#include "google/cloud/cloudbuild/v2/internal/repository_manager_retry_traits.h"
#include "google/cloud/cloudbuild/v2/internal/repository_manager_stub.h"
#include "google/cloud/cloudbuild/v2/repository_manager_connection.h"
#include "google/cloud/cloudbuild/v2/repository_manager_connection_idempotency_policy.h"
#include "google/cloud/cloudbuild/v2/repository_manager_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace cloudbuild_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RepositoryManagerConnectionImpl
    : public cloudbuild_v2::RepositoryManagerConnection {
 public:
  ~RepositoryManagerConnectionImpl() override = default;

  RepositoryManagerConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<cloudbuild_v2_internal::RepositoryManagerStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
  CreateConnection(
      google::devtools::cloudbuild::v2::CreateConnectionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateConnection(
      NoAwaitTag,
      google::devtools::cloudbuild::v2::CreateConnectionRequest const& request)
      override;

  future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
  CreateConnection(google::longrunning::Operation const& operation) override;

  StatusOr<google::devtools::cloudbuild::v2::Connection> GetConnection(
      google::devtools::cloudbuild::v2::GetConnectionRequest const& request)
      override;

  StreamRange<google::devtools::cloudbuild::v2::Connection> ListConnections(
      google::devtools::cloudbuild::v2::ListConnectionsRequest request)
      override;

  future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
  UpdateConnection(
      google::devtools::cloudbuild::v2::UpdateConnectionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateConnection(
      NoAwaitTag,
      google::devtools::cloudbuild::v2::UpdateConnectionRequest const& request)
      override;

  future<StatusOr<google::devtools::cloudbuild::v2::Connection>>
  UpdateConnection(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
  DeleteConnection(
      google::devtools::cloudbuild::v2::DeleteConnectionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteConnection(
      NoAwaitTag,
      google::devtools::cloudbuild::v2::DeleteConnectionRequest const& request)
      override;

  future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
  DeleteConnection(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::devtools::cloudbuild::v2::Repository>>
  CreateRepository(
      google::devtools::cloudbuild::v2::CreateRepositoryRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateRepository(
      NoAwaitTag,
      google::devtools::cloudbuild::v2::CreateRepositoryRequest const& request)
      override;

  future<StatusOr<google::devtools::cloudbuild::v2::Repository>>
  CreateRepository(google::longrunning::Operation const& operation) override;

  future<StatusOr<
      google::devtools::cloudbuild::v2::BatchCreateRepositoriesResponse>>
  BatchCreateRepositories(
      google::devtools::cloudbuild::v2::BatchCreateRepositoriesRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> BatchCreateRepositories(
      NoAwaitTag,
      google::devtools::cloudbuild::v2::BatchCreateRepositoriesRequest const&
          request) override;

  future<StatusOr<
      google::devtools::cloudbuild::v2::BatchCreateRepositoriesResponse>>
  BatchCreateRepositories(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::devtools::cloudbuild::v2::Repository> GetRepository(
      google::devtools::cloudbuild::v2::GetRepositoryRequest const& request)
      override;

  StreamRange<google::devtools::cloudbuild::v2::Repository> ListRepositories(
      google::devtools::cloudbuild::v2::ListRepositoriesRequest request)
      override;

  future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
  DeleteRepository(
      google::devtools::cloudbuild::v2::DeleteRepositoryRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteRepository(
      NoAwaitTag,
      google::devtools::cloudbuild::v2::DeleteRepositoryRequest const& request)
      override;

  future<StatusOr<google::devtools::cloudbuild::v2::OperationMetadata>>
  DeleteRepository(google::longrunning::Operation const& operation) override;

  StatusOr<google::devtools::cloudbuild::v2::FetchReadWriteTokenResponse>
  FetchReadWriteToken(
      google::devtools::cloudbuild::v2::FetchReadWriteTokenRequest const&
          request) override;

  StatusOr<google::devtools::cloudbuild::v2::FetchReadTokenResponse>
  FetchReadToken(google::devtools::cloudbuild::v2::FetchReadTokenRequest const&
                     request) override;

  StreamRange<google::devtools::cloudbuild::v2::Repository>
  FetchLinkableRepositories(
      google::devtools::cloudbuild::v2::FetchLinkableRepositoriesRequest
          request) override;

  StatusOr<google::devtools::cloudbuild::v2::FetchGitRefsResponse> FetchGitRefs(
      google::devtools::cloudbuild::v2::FetchGitRefsRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<cloudbuild_v2_internal::RepositoryManagerStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V2_INTERNAL_REPOSITORY_MANAGER_CONNECTION_IMPL_H
